
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * The information about the current build of the application.
 * 
 * <p>Java class for buildInformation complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="buildInformation"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="buildOs" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="buildUser" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="buildDate" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="buildNumber" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "buildInformation", propOrder = {

})
@XmlRootElement(name = "buildInformation")
public class BuildInformation implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String buildOs;
    @XmlElement(required = true)
    protected String buildUser;
    @XmlElement(required = true)
    protected String buildDate;
    @XmlElement(required = true)
    protected String buildNumber;

    /**
     * Default no-arg constructor
     * 
     */
    public BuildInformation() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BuildInformation(final String buildOs, final String buildUser, final String buildDate, final String buildNumber) {
        this.buildOs = buildOs;
        this.buildUser = buildUser;
        this.buildDate = buildDate;
        this.buildNumber = buildNumber;
    }

    /**
     * Gets the value of the buildOs property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBuildOs() {
        return buildOs;
    }

    /**
     * Sets the value of the buildOs property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBuildOs(String value) {
        this.buildOs = value;
    }

    /**
     * Gets the value of the buildUser property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBuildUser() {
        return buildUser;
    }

    /**
     * Sets the value of the buildUser property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBuildUser(String value) {
        this.buildUser = value;
    }

    /**
     * Gets the value of the buildDate property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBuildDate() {
        return buildDate;
    }

    /**
     * Sets the value of the buildDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBuildDate(String value) {
        this.buildDate = value;
    }

    /**
     * Gets the value of the buildNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBuildNumber() {
        return buildNumber;
    }

    /**
     * Sets the value of the buildNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBuildNumber(String value) {
        this.buildNumber = value;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theBuildOs;
            theBuildOs = this.getBuildOs();
            strategy.appendField(locator, this, "buildOs", buffer, theBuildOs);
        }
        {
            String theBuildUser;
            theBuildUser = this.getBuildUser();
            strategy.appendField(locator, this, "buildUser", buffer, theBuildUser);
        }
        {
            String theBuildDate;
            theBuildDate = this.getBuildDate();
            strategy.appendField(locator, this, "buildDate", buffer, theBuildDate);
        }
        {
            String theBuildNumber;
            theBuildNumber = this.getBuildNumber();
            strategy.appendField(locator, this, "buildNumber", buffer, theBuildNumber);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final BuildInformation that = ((BuildInformation) object);
        {
            String lhsBuildOs;
            lhsBuildOs = this.getBuildOs();
            String rhsBuildOs;
            rhsBuildOs = that.getBuildOs();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "buildOs", lhsBuildOs), LocatorUtils.property(thatLocator, "buildOs", rhsBuildOs), lhsBuildOs, rhsBuildOs)) {
                return false;
            }
        }
        {
            String lhsBuildUser;
            lhsBuildUser = this.getBuildUser();
            String rhsBuildUser;
            rhsBuildUser = that.getBuildUser();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "buildUser", lhsBuildUser), LocatorUtils.property(thatLocator, "buildUser", rhsBuildUser), lhsBuildUser, rhsBuildUser)) {
                return false;
            }
        }
        {
            String lhsBuildDate;
            lhsBuildDate = this.getBuildDate();
            String rhsBuildDate;
            rhsBuildDate = that.getBuildDate();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "buildDate", lhsBuildDate), LocatorUtils.property(thatLocator, "buildDate", rhsBuildDate), lhsBuildDate, rhsBuildDate)) {
                return false;
            }
        }
        {
            String lhsBuildNumber;
            lhsBuildNumber = this.getBuildNumber();
            String rhsBuildNumber;
            rhsBuildNumber = that.getBuildNumber();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "buildNumber", lhsBuildNumber), LocatorUtils.property(thatLocator, "buildNumber", rhsBuildNumber), lhsBuildNumber, rhsBuildNumber)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theBuildOs;
            theBuildOs = this.getBuildOs();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "buildOs", theBuildOs), currentHashCode, theBuildOs);
        }
        {
            String theBuildUser;
            theBuildUser = this.getBuildUser();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "buildUser", theBuildUser), currentHashCode, theBuildUser);
        }
        {
            String theBuildDate;
            theBuildDate = this.getBuildDate();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "buildDate", theBuildDate), currentHashCode, theBuildDate);
        }
        {
            String theBuildNumber;
            theBuildNumber = this.getBuildNumber();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "buildNumber", theBuildNumber), currentHashCode, theBuildNumber);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof BuildInformation) {
            final BuildInformation copy = ((BuildInformation) draftCopy);
            if (this.buildOs!= null) {
                String sourceBuildOs;
                sourceBuildOs = this.getBuildOs();
                String copyBuildOs = ((String) strategy.copy(LocatorUtils.property(locator, "buildOs", sourceBuildOs), sourceBuildOs));
                copy.setBuildOs(copyBuildOs);
            } else {
                copy.buildOs = null;
            }
            if (this.buildUser!= null) {
                String sourceBuildUser;
                sourceBuildUser = this.getBuildUser();
                String copyBuildUser = ((String) strategy.copy(LocatorUtils.property(locator, "buildUser", sourceBuildUser), sourceBuildUser));
                copy.setBuildUser(copyBuildUser);
            } else {
                copy.buildUser = null;
            }
            if (this.buildDate!= null) {
                String sourceBuildDate;
                sourceBuildDate = this.getBuildDate();
                String copyBuildDate = ((String) strategy.copy(LocatorUtils.property(locator, "buildDate", sourceBuildDate), sourceBuildDate));
                copy.setBuildDate(copyBuildDate);
            } else {
                copy.buildDate = null;
            }
            if (this.buildNumber!= null) {
                String sourceBuildNumber;
                sourceBuildNumber = this.getBuildNumber();
                String copyBuildNumber = ((String) strategy.copy(LocatorUtils.property(locator, "buildNumber", sourceBuildNumber), sourceBuildNumber));
                copy.setBuildNumber(copyBuildNumber);
            } else {
                copy.buildNumber = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new BuildInformation();
    }

}
