
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * The business object data
 * 
 * <p>Java class for businessObjectData complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="businessObjectData"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="id" type="{http://www.w3.org/2001/XMLSchema}int"/&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectDefinitionName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatUsage" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatFileType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatVersion" type="{http://www.w3.org/2001/XMLSchema}int"/&gt;
 *         &lt;element name="partitionKey" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="partitionValue" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="subPartitionValues" type="{}subPartitionValues" minOccurs="0"/&gt;
 *         &lt;element name="version" type="{http://www.w3.org/2001/XMLSchema}int"/&gt;
 *         &lt;element name="latestVersion" type="{http://www.w3.org/2001/XMLSchema}boolean"/&gt;
 *         &lt;element name="status" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="storageUnits" type="{}storageUnits"/&gt;
 *         &lt;element name="attributes" type="{}attributes" minOccurs="0"/&gt;
 *         &lt;element name="businessObjectDataParents" type="{}businessObjectDataParents" minOccurs="0"/&gt;
 *         &lt;element name="businessObjectDataChildren" type="{}businessObjectDataChildren" minOccurs="0"/&gt;
 *         &lt;element name="businessObjectDataStatusHistory" type="{}businessObjectDataStatusHistory" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "businessObjectData", propOrder = {

})
@XmlRootElement(name = "businessObjectData")
public class BusinessObjectData implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    protected int id;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElement(required = true)
    protected String businessObjectDefinitionName;
    @XmlElement(required = true)
    protected String businessObjectFormatUsage;
    @XmlElement(required = true)
    protected String businessObjectFormatFileType;
    protected int businessObjectFormatVersion;
    @XmlElement(required = true)
    protected String partitionKey;
    @XmlElement(required = true)
    protected String partitionValue;
    @XmlElementWrapper
    @XmlElement(name = "partitionValue")
    protected List<String> subPartitionValues;
    protected int version;
    protected boolean latestVersion;
    protected String status;
    @XmlElementWrapper(required = true)
    @XmlElement(name = "storageUnit")
    protected List<StorageUnit> storageUnits;
    @XmlElementWrapper
    @XmlElement(name = "attribute")
    protected List<Attribute> attributes;
    @XmlElementWrapper
    @XmlElement(name = "businessObjectDataKey")
    protected List<BusinessObjectDataKey> businessObjectDataParents;
    @XmlElementWrapper
    @XmlElement(name = "businessObjectDataKey")
    protected List<BusinessObjectDataKey> businessObjectDataChildren;
    @XmlElementWrapper
    @XmlElement(name = "businessObjectDataStatusChangeEvent")
    protected List<BusinessObjectDataStatusChangeEvent> businessObjectDataStatusHistory;

    /**
     * Default no-arg constructor
     * 
     */
    public BusinessObjectData() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BusinessObjectData(final int id, final String namespace, final String businessObjectDefinitionName, final String businessObjectFormatUsage, final String businessObjectFormatFileType, final int businessObjectFormatVersion, final String partitionKey, final String partitionValue, final List<String> subPartitionValues, final int version, final boolean latestVersion, final String status, final List<StorageUnit> storageUnits, final List<Attribute> attributes, final List<BusinessObjectDataKey> businessObjectDataParents, final List<BusinessObjectDataKey> businessObjectDataChildren, final List<BusinessObjectDataStatusChangeEvent> businessObjectDataStatusHistory) {
        this.id = id;
        this.namespace = namespace;
        this.businessObjectDefinitionName = businessObjectDefinitionName;
        this.businessObjectFormatUsage = businessObjectFormatUsage;
        this.businessObjectFormatFileType = businessObjectFormatFileType;
        this.businessObjectFormatVersion = businessObjectFormatVersion;
        this.partitionKey = partitionKey;
        this.partitionValue = partitionValue;
        this.subPartitionValues = subPartitionValues;
        this.version = version;
        this.latestVersion = latestVersion;
        this.status = status;
        this.storageUnits = storageUnits;
        this.attributes = attributes;
        this.businessObjectDataParents = businessObjectDataParents;
        this.businessObjectDataChildren = businessObjectDataChildren;
        this.businessObjectDataStatusHistory = businessObjectDataStatusHistory;
    }

    /**
     * Gets the value of the id property.
     * 
     */
    public int getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     */
    public void setId(int value) {
        this.id = value;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the businessObjectDefinitionName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectDefinitionName() {
        return businessObjectDefinitionName;
    }

    /**
     * Sets the value of the businessObjectDefinitionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectDefinitionName(String value) {
        this.businessObjectDefinitionName = value;
    }

    /**
     * Gets the value of the businessObjectFormatUsage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatUsage() {
        return businessObjectFormatUsage;
    }

    /**
     * Sets the value of the businessObjectFormatUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatUsage(String value) {
        this.businessObjectFormatUsage = value;
    }

    /**
     * Gets the value of the businessObjectFormatFileType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatFileType() {
        return businessObjectFormatFileType;
    }

    /**
     * Sets the value of the businessObjectFormatFileType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatFileType(String value) {
        this.businessObjectFormatFileType = value;
    }

    /**
     * Gets the value of the businessObjectFormatVersion property.
     * 
     */
    public int getBusinessObjectFormatVersion() {
        return businessObjectFormatVersion;
    }

    /**
     * Sets the value of the businessObjectFormatVersion property.
     * 
     */
    public void setBusinessObjectFormatVersion(int value) {
        this.businessObjectFormatVersion = value;
    }

    /**
     * Gets the value of the partitionKey property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPartitionKey() {
        return partitionKey;
    }

    /**
     * Sets the value of the partitionKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPartitionKey(String value) {
        this.partitionKey = value;
    }

    /**
     * Gets the value of the partitionValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPartitionValue() {
        return partitionValue;
    }

    /**
     * Sets the value of the partitionValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPartitionValue(String value) {
        this.partitionValue = value;
    }

    /**
     * Gets the value of the version property.
     * 
     */
    public int getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     */
    public void setVersion(int value) {
        this.version = value;
    }

    /**
     * Gets the value of the latestVersion property.
     * 
     */
    public boolean isLatestVersion() {
        return latestVersion;
    }

    /**
     * Sets the value of the latestVersion property.
     * 
     */
    public void setLatestVersion(boolean value) {
        this.latestVersion = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatus(String value) {
        this.status = value;
    }

    public List<String> getSubPartitionValues() {
        return subPartitionValues;
    }

    public void setSubPartitionValues(List<String> subPartitionValues) {
        this.subPartitionValues = subPartitionValues;
    }

    public List<StorageUnit> getStorageUnits() {
        return storageUnits;
    }

    public void setStorageUnits(List<StorageUnit> storageUnits) {
        this.storageUnits = storageUnits;
    }

    public List<Attribute> getAttributes() {
        return attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public List<BusinessObjectDataKey> getBusinessObjectDataParents() {
        return businessObjectDataParents;
    }

    public void setBusinessObjectDataParents(List<BusinessObjectDataKey> businessObjectDataParents) {
        this.businessObjectDataParents = businessObjectDataParents;
    }

    public List<BusinessObjectDataKey> getBusinessObjectDataChildren() {
        return businessObjectDataChildren;
    }

    public void setBusinessObjectDataChildren(List<BusinessObjectDataKey> businessObjectDataChildren) {
        this.businessObjectDataChildren = businessObjectDataChildren;
    }

    public List<BusinessObjectDataStatusChangeEvent> getBusinessObjectDataStatusHistory() {
        return businessObjectDataStatusHistory;
    }

    public void setBusinessObjectDataStatusHistory(List<BusinessObjectDataStatusChangeEvent> businessObjectDataStatusHistory) {
        this.businessObjectDataStatusHistory = businessObjectDataStatusHistory;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            int theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            strategy.appendField(locator, this, "businessObjectDefinitionName", buffer, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            strategy.appendField(locator, this, "businessObjectFormatUsage", buffer, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            strategy.appendField(locator, this, "businessObjectFormatFileType", buffer, theBusinessObjectFormatFileType);
        }
        {
            int theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            strategy.appendField(locator, this, "businessObjectFormatVersion", buffer, theBusinessObjectFormatVersion);
        }
        {
            String thePartitionKey;
            thePartitionKey = this.getPartitionKey();
            strategy.appendField(locator, this, "partitionKey", buffer, thePartitionKey);
        }
        {
            String thePartitionValue;
            thePartitionValue = this.getPartitionValue();
            strategy.appendField(locator, this, "partitionValue", buffer, thePartitionValue);
        }
        {
            List<String> theSubPartitionValues;
            theSubPartitionValues = this.getSubPartitionValues();
            strategy.appendField(locator, this, "subPartitionValues", buffer, theSubPartitionValues);
        }
        {
            int theVersion;
            theVersion = this.getVersion();
            strategy.appendField(locator, this, "version", buffer, theVersion);
        }
        {
            boolean theLatestVersion;
            theLatestVersion = this.isLatestVersion();
            strategy.appendField(locator, this, "latestVersion", buffer, theLatestVersion);
        }
        {
            String theStatus;
            theStatus = this.getStatus();
            strategy.appendField(locator, this, "status", buffer, theStatus);
        }
        {
            List<StorageUnit> theStorageUnits;
            theStorageUnits = this.getStorageUnits();
            strategy.appendField(locator, this, "storageUnits", buffer, theStorageUnits);
        }
        {
            List<Attribute> theAttributes;
            theAttributes = this.getAttributes();
            strategy.appendField(locator, this, "attributes", buffer, theAttributes);
        }
        {
            List<BusinessObjectDataKey> theBusinessObjectDataParents;
            theBusinessObjectDataParents = this.getBusinessObjectDataParents();
            strategy.appendField(locator, this, "businessObjectDataParents", buffer, theBusinessObjectDataParents);
        }
        {
            List<BusinessObjectDataKey> theBusinessObjectDataChildren;
            theBusinessObjectDataChildren = this.getBusinessObjectDataChildren();
            strategy.appendField(locator, this, "businessObjectDataChildren", buffer, theBusinessObjectDataChildren);
        }
        {
            List<BusinessObjectDataStatusChangeEvent> theBusinessObjectDataStatusHistory;
            theBusinessObjectDataStatusHistory = this.getBusinessObjectDataStatusHistory();
            strategy.appendField(locator, this, "businessObjectDataStatusHistory", buffer, theBusinessObjectDataStatusHistory);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final BusinessObjectData that = ((BusinessObjectData) object);
        {
            int lhsId;
            lhsId = this.getId();
            int rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId)) {
                return false;
            }
        }
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectDefinitionName;
            lhsBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            String rhsBusinessObjectDefinitionName;
            rhsBusinessObjectDefinitionName = that.getBusinessObjectDefinitionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDefinitionName", lhsBusinessObjectDefinitionName), LocatorUtils.property(thatLocator, "businessObjectDefinitionName", rhsBusinessObjectDefinitionName), lhsBusinessObjectDefinitionName, rhsBusinessObjectDefinitionName)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatUsage;
            lhsBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            String rhsBusinessObjectFormatUsage;
            rhsBusinessObjectFormatUsage = that.getBusinessObjectFormatUsage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatUsage", lhsBusinessObjectFormatUsage), LocatorUtils.property(thatLocator, "businessObjectFormatUsage", rhsBusinessObjectFormatUsage), lhsBusinessObjectFormatUsage, rhsBusinessObjectFormatUsage)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatFileType;
            lhsBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            String rhsBusinessObjectFormatFileType;
            rhsBusinessObjectFormatFileType = that.getBusinessObjectFormatFileType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatFileType", lhsBusinessObjectFormatFileType), LocatorUtils.property(thatLocator, "businessObjectFormatFileType", rhsBusinessObjectFormatFileType), lhsBusinessObjectFormatFileType, rhsBusinessObjectFormatFileType)) {
                return false;
            }
        }
        {
            int lhsBusinessObjectFormatVersion;
            lhsBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            int rhsBusinessObjectFormatVersion;
            rhsBusinessObjectFormatVersion = that.getBusinessObjectFormatVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatVersion", lhsBusinessObjectFormatVersion), LocatorUtils.property(thatLocator, "businessObjectFormatVersion", rhsBusinessObjectFormatVersion), lhsBusinessObjectFormatVersion, rhsBusinessObjectFormatVersion)) {
                return false;
            }
        }
        {
            String lhsPartitionKey;
            lhsPartitionKey = this.getPartitionKey();
            String rhsPartitionKey;
            rhsPartitionKey = that.getPartitionKey();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionKey", lhsPartitionKey), LocatorUtils.property(thatLocator, "partitionKey", rhsPartitionKey), lhsPartitionKey, rhsPartitionKey)) {
                return false;
            }
        }
        {
            String lhsPartitionValue;
            lhsPartitionValue = this.getPartitionValue();
            String rhsPartitionValue;
            rhsPartitionValue = that.getPartitionValue();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionValue", lhsPartitionValue), LocatorUtils.property(thatLocator, "partitionValue", rhsPartitionValue), lhsPartitionValue, rhsPartitionValue)) {
                return false;
            }
        }
        {
            List<String> lhsSubPartitionValues;
            lhsSubPartitionValues = this.getSubPartitionValues();
            List<String> rhsSubPartitionValues;
            rhsSubPartitionValues = that.getSubPartitionValues();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "subPartitionValues", lhsSubPartitionValues), LocatorUtils.property(thatLocator, "subPartitionValues", rhsSubPartitionValues), lhsSubPartitionValues, rhsSubPartitionValues)) {
                return false;
            }
        }
        {
            int lhsVersion;
            lhsVersion = this.getVersion();
            int rhsVersion;
            rhsVersion = that.getVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "version", lhsVersion), LocatorUtils.property(thatLocator, "version", rhsVersion), lhsVersion, rhsVersion)) {
                return false;
            }
        }
        {
            boolean lhsLatestVersion;
            lhsLatestVersion = this.isLatestVersion();
            boolean rhsLatestVersion;
            rhsLatestVersion = that.isLatestVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "latestVersion", lhsLatestVersion), LocatorUtils.property(thatLocator, "latestVersion", rhsLatestVersion), lhsLatestVersion, rhsLatestVersion)) {
                return false;
            }
        }
        {
            String lhsStatus;
            lhsStatus = this.getStatus();
            String rhsStatus;
            rhsStatus = that.getStatus();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "status", lhsStatus), LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus)) {
                return false;
            }
        }
        {
            List<StorageUnit> lhsStorageUnits;
            lhsStorageUnits = this.getStorageUnits();
            List<StorageUnit> rhsStorageUnits;
            rhsStorageUnits = that.getStorageUnits();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageUnits", lhsStorageUnits), LocatorUtils.property(thatLocator, "storageUnits", rhsStorageUnits), lhsStorageUnits, rhsStorageUnits)) {
                return false;
            }
        }
        {
            List<Attribute> lhsAttributes;
            lhsAttributes = this.getAttributes();
            List<Attribute> rhsAttributes;
            rhsAttributes = that.getAttributes();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "attributes", lhsAttributes), LocatorUtils.property(thatLocator, "attributes", rhsAttributes), lhsAttributes, rhsAttributes)) {
                return false;
            }
        }
        {
            List<BusinessObjectDataKey> lhsBusinessObjectDataParents;
            lhsBusinessObjectDataParents = this.getBusinessObjectDataParents();
            List<BusinessObjectDataKey> rhsBusinessObjectDataParents;
            rhsBusinessObjectDataParents = that.getBusinessObjectDataParents();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataParents", lhsBusinessObjectDataParents), LocatorUtils.property(thatLocator, "businessObjectDataParents", rhsBusinessObjectDataParents), lhsBusinessObjectDataParents, rhsBusinessObjectDataParents)) {
                return false;
            }
        }
        {
            List<BusinessObjectDataKey> lhsBusinessObjectDataChildren;
            lhsBusinessObjectDataChildren = this.getBusinessObjectDataChildren();
            List<BusinessObjectDataKey> rhsBusinessObjectDataChildren;
            rhsBusinessObjectDataChildren = that.getBusinessObjectDataChildren();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataChildren", lhsBusinessObjectDataChildren), LocatorUtils.property(thatLocator, "businessObjectDataChildren", rhsBusinessObjectDataChildren), lhsBusinessObjectDataChildren, rhsBusinessObjectDataChildren)) {
                return false;
            }
        }
        {
            List<BusinessObjectDataStatusChangeEvent> lhsBusinessObjectDataStatusHistory;
            lhsBusinessObjectDataStatusHistory = this.getBusinessObjectDataStatusHistory();
            List<BusinessObjectDataStatusChangeEvent> rhsBusinessObjectDataStatusHistory;
            rhsBusinessObjectDataStatusHistory = that.getBusinessObjectDataStatusHistory();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataStatusHistory", lhsBusinessObjectDataStatusHistory), LocatorUtils.property(thatLocator, "businessObjectDataStatusHistory", rhsBusinessObjectDataStatusHistory), lhsBusinessObjectDataStatusHistory, rhsBusinessObjectDataStatusHistory)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            int theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDefinitionName", theBusinessObjectDefinitionName), currentHashCode, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatUsage", theBusinessObjectFormatUsage), currentHashCode, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatFileType", theBusinessObjectFormatFileType), currentHashCode, theBusinessObjectFormatFileType);
        }
        {
            int theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatVersion", theBusinessObjectFormatVersion), currentHashCode, theBusinessObjectFormatVersion);
        }
        {
            String thePartitionKey;
            thePartitionKey = this.getPartitionKey();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionKey", thePartitionKey), currentHashCode, thePartitionKey);
        }
        {
            String thePartitionValue;
            thePartitionValue = this.getPartitionValue();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionValue", thePartitionValue), currentHashCode, thePartitionValue);
        }
        {
            List<String> theSubPartitionValues;
            theSubPartitionValues = this.getSubPartitionValues();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "subPartitionValues", theSubPartitionValues), currentHashCode, theSubPartitionValues);
        }
        {
            int theVersion;
            theVersion = this.getVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "version", theVersion), currentHashCode, theVersion);
        }
        {
            boolean theLatestVersion;
            theLatestVersion = this.isLatestVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "latestVersion", theLatestVersion), currentHashCode, theLatestVersion);
        }
        {
            String theStatus;
            theStatus = this.getStatus();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus);
        }
        {
            List<StorageUnit> theStorageUnits;
            theStorageUnits = this.getStorageUnits();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageUnits", theStorageUnits), currentHashCode, theStorageUnits);
        }
        {
            List<Attribute> theAttributes;
            theAttributes = this.getAttributes();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "attributes", theAttributes), currentHashCode, theAttributes);
        }
        {
            List<BusinessObjectDataKey> theBusinessObjectDataParents;
            theBusinessObjectDataParents = this.getBusinessObjectDataParents();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataParents", theBusinessObjectDataParents), currentHashCode, theBusinessObjectDataParents);
        }
        {
            List<BusinessObjectDataKey> theBusinessObjectDataChildren;
            theBusinessObjectDataChildren = this.getBusinessObjectDataChildren();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataChildren", theBusinessObjectDataChildren), currentHashCode, theBusinessObjectDataChildren);
        }
        {
            List<BusinessObjectDataStatusChangeEvent> theBusinessObjectDataStatusHistory;
            theBusinessObjectDataStatusHistory = this.getBusinessObjectDataStatusHistory();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataStatusHistory", theBusinessObjectDataStatusHistory), currentHashCode, theBusinessObjectDataStatusHistory);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof BusinessObjectData) {
            final BusinessObjectData copy = ((BusinessObjectData) draftCopy);
            {
                int sourceId;
                sourceId = this.getId();
                int copyId = strategy.copy(LocatorUtils.property(locator, "id", sourceId), sourceId);
                copy.setId(copyId);
            }
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.businessObjectDefinitionName!= null) {
                String sourceBusinessObjectDefinitionName;
                sourceBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
                String copyBusinessObjectDefinitionName = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectDefinitionName", sourceBusinessObjectDefinitionName), sourceBusinessObjectDefinitionName));
                copy.setBusinessObjectDefinitionName(copyBusinessObjectDefinitionName);
            } else {
                copy.businessObjectDefinitionName = null;
            }
            if (this.businessObjectFormatUsage!= null) {
                String sourceBusinessObjectFormatUsage;
                sourceBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
                String copyBusinessObjectFormatUsage = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatUsage", sourceBusinessObjectFormatUsage), sourceBusinessObjectFormatUsage));
                copy.setBusinessObjectFormatUsage(copyBusinessObjectFormatUsage);
            } else {
                copy.businessObjectFormatUsage = null;
            }
            if (this.businessObjectFormatFileType!= null) {
                String sourceBusinessObjectFormatFileType;
                sourceBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
                String copyBusinessObjectFormatFileType = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatFileType", sourceBusinessObjectFormatFileType), sourceBusinessObjectFormatFileType));
                copy.setBusinessObjectFormatFileType(copyBusinessObjectFormatFileType);
            } else {
                copy.businessObjectFormatFileType = null;
            }
            {
                int sourceBusinessObjectFormatVersion;
                sourceBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
                int copyBusinessObjectFormatVersion = strategy.copy(LocatorUtils.property(locator, "businessObjectFormatVersion", sourceBusinessObjectFormatVersion), sourceBusinessObjectFormatVersion);
                copy.setBusinessObjectFormatVersion(copyBusinessObjectFormatVersion);
            }
            if (this.partitionKey!= null) {
                String sourcePartitionKey;
                sourcePartitionKey = this.getPartitionKey();
                String copyPartitionKey = ((String) strategy.copy(LocatorUtils.property(locator, "partitionKey", sourcePartitionKey), sourcePartitionKey));
                copy.setPartitionKey(copyPartitionKey);
            } else {
                copy.partitionKey = null;
            }
            if (this.partitionValue!= null) {
                String sourcePartitionValue;
                sourcePartitionValue = this.getPartitionValue();
                String copyPartitionValue = ((String) strategy.copy(LocatorUtils.property(locator, "partitionValue", sourcePartitionValue), sourcePartitionValue));
                copy.setPartitionValue(copyPartitionValue);
            } else {
                copy.partitionValue = null;
            }
            if (this.subPartitionValues!= null) {
                List<String> sourceSubPartitionValues;
                sourceSubPartitionValues = this.getSubPartitionValues();
                @SuppressWarnings("unchecked")
                List<String> copySubPartitionValues = ((List<String> ) strategy.copy(LocatorUtils.property(locator, "subPartitionValues", sourceSubPartitionValues), sourceSubPartitionValues));
                copy.subPartitionValues = null;
                copy.setSubPartitionValues(copySubPartitionValues);
            } else {
                copy.subPartitionValues = null;
            }
            {
                int sourceVersion;
                sourceVersion = this.getVersion();
                int copyVersion = strategy.copy(LocatorUtils.property(locator, "version", sourceVersion), sourceVersion);
                copy.setVersion(copyVersion);
            }
            {
                boolean sourceLatestVersion;
                sourceLatestVersion = this.isLatestVersion();
                boolean copyLatestVersion = strategy.copy(LocatorUtils.property(locator, "latestVersion", sourceLatestVersion), sourceLatestVersion);
                copy.setLatestVersion(copyLatestVersion);
            }
            if (this.status!= null) {
                String sourceStatus;
                sourceStatus = this.getStatus();
                String copyStatus = ((String) strategy.copy(LocatorUtils.property(locator, "status", sourceStatus), sourceStatus));
                copy.setStatus(copyStatus);
            } else {
                copy.status = null;
            }
            if (this.storageUnits!= null) {
                List<StorageUnit> sourceStorageUnits;
                sourceStorageUnits = this.getStorageUnits();
                @SuppressWarnings("unchecked")
                List<StorageUnit> copyStorageUnits = ((List<StorageUnit> ) strategy.copy(LocatorUtils.property(locator, "storageUnits", sourceStorageUnits), sourceStorageUnits));
                copy.storageUnits = null;
                copy.setStorageUnits(copyStorageUnits);
            } else {
                copy.storageUnits = null;
            }
            if (this.attributes!= null) {
                List<Attribute> sourceAttributes;
                sourceAttributes = this.getAttributes();
                @SuppressWarnings("unchecked")
                List<Attribute> copyAttributes = ((List<Attribute> ) strategy.copy(LocatorUtils.property(locator, "attributes", sourceAttributes), sourceAttributes));
                copy.attributes = null;
                copy.setAttributes(copyAttributes);
            } else {
                copy.attributes = null;
            }
            if (this.businessObjectDataParents!= null) {
                List<BusinessObjectDataKey> sourceBusinessObjectDataParents;
                sourceBusinessObjectDataParents = this.getBusinessObjectDataParents();
                @SuppressWarnings("unchecked")
                List<BusinessObjectDataKey> copyBusinessObjectDataParents = ((List<BusinessObjectDataKey> ) strategy.copy(LocatorUtils.property(locator, "businessObjectDataParents", sourceBusinessObjectDataParents), sourceBusinessObjectDataParents));
                copy.businessObjectDataParents = null;
                copy.setBusinessObjectDataParents(copyBusinessObjectDataParents);
            } else {
                copy.businessObjectDataParents = null;
            }
            if (this.businessObjectDataChildren!= null) {
                List<BusinessObjectDataKey> sourceBusinessObjectDataChildren;
                sourceBusinessObjectDataChildren = this.getBusinessObjectDataChildren();
                @SuppressWarnings("unchecked")
                List<BusinessObjectDataKey> copyBusinessObjectDataChildren = ((List<BusinessObjectDataKey> ) strategy.copy(LocatorUtils.property(locator, "businessObjectDataChildren", sourceBusinessObjectDataChildren), sourceBusinessObjectDataChildren));
                copy.businessObjectDataChildren = null;
                copy.setBusinessObjectDataChildren(copyBusinessObjectDataChildren);
            } else {
                copy.businessObjectDataChildren = null;
            }
            if (this.businessObjectDataStatusHistory!= null) {
                List<BusinessObjectDataStatusChangeEvent> sourceBusinessObjectDataStatusHistory;
                sourceBusinessObjectDataStatusHistory = this.getBusinessObjectDataStatusHistory();
                @SuppressWarnings("unchecked")
                List<BusinessObjectDataStatusChangeEvent> copyBusinessObjectDataStatusHistory = ((List<BusinessObjectDataStatusChangeEvent> ) strategy.copy(LocatorUtils.property(locator, "businessObjectDataStatusHistory", sourceBusinessObjectDataStatusHistory), sourceBusinessObjectDataStatusHistory));
                copy.businessObjectDataStatusHistory = null;
                copy.setBusinessObjectDataStatusHistory(copyBusinessObjectDataStatusHistory);
            } else {
                copy.businessObjectDataStatusHistory = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new BusinessObjectData();
    }

}
