
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for businessObjectDataAvailability complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="businessObjectDataAvailability"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectDefinitionName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatUsage" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatFileType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatVersion" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/&gt;
 *         &lt;element name="partitionValueFilters" type="{}partitionValueFilters" minOccurs="0"/&gt;
 *         &lt;element name="partitionValueFilter" type="{}partitionValueFilter" minOccurs="0"/&gt;
 *         &lt;element name="businessObjectDataVersion" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/&gt;
 *         &lt;element name="storageNames" type="{}storageNames" minOccurs="0"/&gt;
 *         &lt;element name="storageName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="availableStatuses" type="{}businessObjectDataStatuses" minOccurs="0"/&gt;
 *         &lt;element name="notAvailableStatuses" type="{}businessObjectDataStatuses" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "businessObjectDataAvailability", propOrder = {

})
@XmlRootElement(name = "businessObjectDataAvailability")
public class BusinessObjectDataAvailability implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElement(required = true)
    protected String businessObjectDefinitionName;
    @XmlElement(required = true)
    protected String businessObjectFormatUsage;
    @XmlElement(required = true)
    protected String businessObjectFormatFileType;
    protected Integer businessObjectFormatVersion;
    @XmlElementWrapper
    @XmlElement(name = "partitionValueFilter")
    protected List<PartitionValueFilter> partitionValueFilters;
    protected PartitionValueFilter partitionValueFilter;
    protected Integer businessObjectDataVersion;
    @XmlElementWrapper
    @XmlElement(name = "storageName")
    protected List<String> storageNames;
    protected String storageName;
    @XmlElementWrapper
    @XmlElement(name = "businessObjectDataStatus")
    protected List<BusinessObjectDataStatus> availableStatuses;
    @XmlElementWrapper
    @XmlElement(name = "businessObjectDataStatus")
    protected List<BusinessObjectDataStatus> notAvailableStatuses;

    /**
     * Default no-arg constructor
     * 
     */
    public BusinessObjectDataAvailability() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BusinessObjectDataAvailability(final String namespace, final String businessObjectDefinitionName, final String businessObjectFormatUsage, final String businessObjectFormatFileType, final Integer businessObjectFormatVersion, final List<PartitionValueFilter> partitionValueFilters, final PartitionValueFilter partitionValueFilter, final Integer businessObjectDataVersion, final List<String> storageNames, final String storageName, final List<BusinessObjectDataStatus> availableStatuses, final List<BusinessObjectDataStatus> notAvailableStatuses) {
        this.namespace = namespace;
        this.businessObjectDefinitionName = businessObjectDefinitionName;
        this.businessObjectFormatUsage = businessObjectFormatUsage;
        this.businessObjectFormatFileType = businessObjectFormatFileType;
        this.businessObjectFormatVersion = businessObjectFormatVersion;
        this.partitionValueFilters = partitionValueFilters;
        this.partitionValueFilter = partitionValueFilter;
        this.businessObjectDataVersion = businessObjectDataVersion;
        this.storageNames = storageNames;
        this.storageName = storageName;
        this.availableStatuses = availableStatuses;
        this.notAvailableStatuses = notAvailableStatuses;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the businessObjectDefinitionName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectDefinitionName() {
        return businessObjectDefinitionName;
    }

    /**
     * Sets the value of the businessObjectDefinitionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectDefinitionName(String value) {
        this.businessObjectDefinitionName = value;
    }

    /**
     * Gets the value of the businessObjectFormatUsage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatUsage() {
        return businessObjectFormatUsage;
    }

    /**
     * Sets the value of the businessObjectFormatUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatUsage(String value) {
        this.businessObjectFormatUsage = value;
    }

    /**
     * Gets the value of the businessObjectFormatFileType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatFileType() {
        return businessObjectFormatFileType;
    }

    /**
     * Sets the value of the businessObjectFormatFileType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatFileType(String value) {
        this.businessObjectFormatFileType = value;
    }

    /**
     * Gets the value of the businessObjectFormatVersion property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getBusinessObjectFormatVersion() {
        return businessObjectFormatVersion;
    }

    /**
     * Sets the value of the businessObjectFormatVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setBusinessObjectFormatVersion(Integer value) {
        this.businessObjectFormatVersion = value;
    }

    /**
     * Gets the value of the partitionValueFilter property.
     * 
     * @return
     *     possible object is
     *     {@link PartitionValueFilter }
     *     
     */
    public PartitionValueFilter getPartitionValueFilter() {
        return partitionValueFilter;
    }

    /**
     * Sets the value of the partitionValueFilter property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartitionValueFilter }
     *     
     */
    public void setPartitionValueFilter(PartitionValueFilter value) {
        this.partitionValueFilter = value;
    }

    /**
     * Gets the value of the businessObjectDataVersion property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getBusinessObjectDataVersion() {
        return businessObjectDataVersion;
    }

    /**
     * Sets the value of the businessObjectDataVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setBusinessObjectDataVersion(Integer value) {
        this.businessObjectDataVersion = value;
    }

    /**
     * Gets the value of the storageName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStorageName() {
        return storageName;
    }

    /**
     * Sets the value of the storageName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStorageName(String value) {
        this.storageName = value;
    }

    public List<PartitionValueFilter> getPartitionValueFilters() {
        return partitionValueFilters;
    }

    public void setPartitionValueFilters(List<PartitionValueFilter> partitionValueFilters) {
        this.partitionValueFilters = partitionValueFilters;
    }

    public List<String> getStorageNames() {
        return storageNames;
    }

    public void setStorageNames(List<String> storageNames) {
        this.storageNames = storageNames;
    }

    public List<BusinessObjectDataStatus> getAvailableStatuses() {
        return availableStatuses;
    }

    public void setAvailableStatuses(List<BusinessObjectDataStatus> availableStatuses) {
        this.availableStatuses = availableStatuses;
    }

    public List<BusinessObjectDataStatus> getNotAvailableStatuses() {
        return notAvailableStatuses;
    }

    public void setNotAvailableStatuses(List<BusinessObjectDataStatus> notAvailableStatuses) {
        this.notAvailableStatuses = notAvailableStatuses;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            strategy.appendField(locator, this, "businessObjectDefinitionName", buffer, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            strategy.appendField(locator, this, "businessObjectFormatUsage", buffer, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            strategy.appendField(locator, this, "businessObjectFormatFileType", buffer, theBusinessObjectFormatFileType);
        }
        {
            Integer theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            strategy.appendField(locator, this, "businessObjectFormatVersion", buffer, theBusinessObjectFormatVersion);
        }
        {
            List<PartitionValueFilter> thePartitionValueFilters;
            thePartitionValueFilters = this.getPartitionValueFilters();
            strategy.appendField(locator, this, "partitionValueFilters", buffer, thePartitionValueFilters);
        }
        {
            PartitionValueFilter thePartitionValueFilter;
            thePartitionValueFilter = this.getPartitionValueFilter();
            strategy.appendField(locator, this, "partitionValueFilter", buffer, thePartitionValueFilter);
        }
        {
            Integer theBusinessObjectDataVersion;
            theBusinessObjectDataVersion = this.getBusinessObjectDataVersion();
            strategy.appendField(locator, this, "businessObjectDataVersion", buffer, theBusinessObjectDataVersion);
        }
        {
            List<String> theStorageNames;
            theStorageNames = this.getStorageNames();
            strategy.appendField(locator, this, "storageNames", buffer, theStorageNames);
        }
        {
            String theStorageName;
            theStorageName = this.getStorageName();
            strategy.appendField(locator, this, "storageName", buffer, theStorageName);
        }
        {
            List<BusinessObjectDataStatus> theAvailableStatuses;
            theAvailableStatuses = this.getAvailableStatuses();
            strategy.appendField(locator, this, "availableStatuses", buffer, theAvailableStatuses);
        }
        {
            List<BusinessObjectDataStatus> theNotAvailableStatuses;
            theNotAvailableStatuses = this.getNotAvailableStatuses();
            strategy.appendField(locator, this, "notAvailableStatuses", buffer, theNotAvailableStatuses);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final BusinessObjectDataAvailability that = ((BusinessObjectDataAvailability) object);
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectDefinitionName;
            lhsBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            String rhsBusinessObjectDefinitionName;
            rhsBusinessObjectDefinitionName = that.getBusinessObjectDefinitionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDefinitionName", lhsBusinessObjectDefinitionName), LocatorUtils.property(thatLocator, "businessObjectDefinitionName", rhsBusinessObjectDefinitionName), lhsBusinessObjectDefinitionName, rhsBusinessObjectDefinitionName)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatUsage;
            lhsBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            String rhsBusinessObjectFormatUsage;
            rhsBusinessObjectFormatUsage = that.getBusinessObjectFormatUsage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatUsage", lhsBusinessObjectFormatUsage), LocatorUtils.property(thatLocator, "businessObjectFormatUsage", rhsBusinessObjectFormatUsage), lhsBusinessObjectFormatUsage, rhsBusinessObjectFormatUsage)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatFileType;
            lhsBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            String rhsBusinessObjectFormatFileType;
            rhsBusinessObjectFormatFileType = that.getBusinessObjectFormatFileType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatFileType", lhsBusinessObjectFormatFileType), LocatorUtils.property(thatLocator, "businessObjectFormatFileType", rhsBusinessObjectFormatFileType), lhsBusinessObjectFormatFileType, rhsBusinessObjectFormatFileType)) {
                return false;
            }
        }
        {
            Integer lhsBusinessObjectFormatVersion;
            lhsBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            Integer rhsBusinessObjectFormatVersion;
            rhsBusinessObjectFormatVersion = that.getBusinessObjectFormatVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatVersion", lhsBusinessObjectFormatVersion), LocatorUtils.property(thatLocator, "businessObjectFormatVersion", rhsBusinessObjectFormatVersion), lhsBusinessObjectFormatVersion, rhsBusinessObjectFormatVersion)) {
                return false;
            }
        }
        {
            List<PartitionValueFilter> lhsPartitionValueFilters;
            lhsPartitionValueFilters = this.getPartitionValueFilters();
            List<PartitionValueFilter> rhsPartitionValueFilters;
            rhsPartitionValueFilters = that.getPartitionValueFilters();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionValueFilters", lhsPartitionValueFilters), LocatorUtils.property(thatLocator, "partitionValueFilters", rhsPartitionValueFilters), lhsPartitionValueFilters, rhsPartitionValueFilters)) {
                return false;
            }
        }
        {
            PartitionValueFilter lhsPartitionValueFilter;
            lhsPartitionValueFilter = this.getPartitionValueFilter();
            PartitionValueFilter rhsPartitionValueFilter;
            rhsPartitionValueFilter = that.getPartitionValueFilter();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionValueFilter", lhsPartitionValueFilter), LocatorUtils.property(thatLocator, "partitionValueFilter", rhsPartitionValueFilter), lhsPartitionValueFilter, rhsPartitionValueFilter)) {
                return false;
            }
        }
        {
            Integer lhsBusinessObjectDataVersion;
            lhsBusinessObjectDataVersion = this.getBusinessObjectDataVersion();
            Integer rhsBusinessObjectDataVersion;
            rhsBusinessObjectDataVersion = that.getBusinessObjectDataVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataVersion", lhsBusinessObjectDataVersion), LocatorUtils.property(thatLocator, "businessObjectDataVersion", rhsBusinessObjectDataVersion), lhsBusinessObjectDataVersion, rhsBusinessObjectDataVersion)) {
                return false;
            }
        }
        {
            List<String> lhsStorageNames;
            lhsStorageNames = this.getStorageNames();
            List<String> rhsStorageNames;
            rhsStorageNames = that.getStorageNames();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageNames", lhsStorageNames), LocatorUtils.property(thatLocator, "storageNames", rhsStorageNames), lhsStorageNames, rhsStorageNames)) {
                return false;
            }
        }
        {
            String lhsStorageName;
            lhsStorageName = this.getStorageName();
            String rhsStorageName;
            rhsStorageName = that.getStorageName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageName", lhsStorageName), LocatorUtils.property(thatLocator, "storageName", rhsStorageName), lhsStorageName, rhsStorageName)) {
                return false;
            }
        }
        {
            List<BusinessObjectDataStatus> lhsAvailableStatuses;
            lhsAvailableStatuses = this.getAvailableStatuses();
            List<BusinessObjectDataStatus> rhsAvailableStatuses;
            rhsAvailableStatuses = that.getAvailableStatuses();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "availableStatuses", lhsAvailableStatuses), LocatorUtils.property(thatLocator, "availableStatuses", rhsAvailableStatuses), lhsAvailableStatuses, rhsAvailableStatuses)) {
                return false;
            }
        }
        {
            List<BusinessObjectDataStatus> lhsNotAvailableStatuses;
            lhsNotAvailableStatuses = this.getNotAvailableStatuses();
            List<BusinessObjectDataStatus> rhsNotAvailableStatuses;
            rhsNotAvailableStatuses = that.getNotAvailableStatuses();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "notAvailableStatuses", lhsNotAvailableStatuses), LocatorUtils.property(thatLocator, "notAvailableStatuses", rhsNotAvailableStatuses), lhsNotAvailableStatuses, rhsNotAvailableStatuses)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDefinitionName", theBusinessObjectDefinitionName), currentHashCode, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatUsage", theBusinessObjectFormatUsage), currentHashCode, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatFileType", theBusinessObjectFormatFileType), currentHashCode, theBusinessObjectFormatFileType);
        }
        {
            Integer theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatVersion", theBusinessObjectFormatVersion), currentHashCode, theBusinessObjectFormatVersion);
        }
        {
            List<PartitionValueFilter> thePartitionValueFilters;
            thePartitionValueFilters = this.getPartitionValueFilters();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionValueFilters", thePartitionValueFilters), currentHashCode, thePartitionValueFilters);
        }
        {
            PartitionValueFilter thePartitionValueFilter;
            thePartitionValueFilter = this.getPartitionValueFilter();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionValueFilter", thePartitionValueFilter), currentHashCode, thePartitionValueFilter);
        }
        {
            Integer theBusinessObjectDataVersion;
            theBusinessObjectDataVersion = this.getBusinessObjectDataVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataVersion", theBusinessObjectDataVersion), currentHashCode, theBusinessObjectDataVersion);
        }
        {
            List<String> theStorageNames;
            theStorageNames = this.getStorageNames();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageNames", theStorageNames), currentHashCode, theStorageNames);
        }
        {
            String theStorageName;
            theStorageName = this.getStorageName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageName", theStorageName), currentHashCode, theStorageName);
        }
        {
            List<BusinessObjectDataStatus> theAvailableStatuses;
            theAvailableStatuses = this.getAvailableStatuses();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "availableStatuses", theAvailableStatuses), currentHashCode, theAvailableStatuses);
        }
        {
            List<BusinessObjectDataStatus> theNotAvailableStatuses;
            theNotAvailableStatuses = this.getNotAvailableStatuses();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "notAvailableStatuses", theNotAvailableStatuses), currentHashCode, theNotAvailableStatuses);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof BusinessObjectDataAvailability) {
            final BusinessObjectDataAvailability copy = ((BusinessObjectDataAvailability) draftCopy);
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.businessObjectDefinitionName!= null) {
                String sourceBusinessObjectDefinitionName;
                sourceBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
                String copyBusinessObjectDefinitionName = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectDefinitionName", sourceBusinessObjectDefinitionName), sourceBusinessObjectDefinitionName));
                copy.setBusinessObjectDefinitionName(copyBusinessObjectDefinitionName);
            } else {
                copy.businessObjectDefinitionName = null;
            }
            if (this.businessObjectFormatUsage!= null) {
                String sourceBusinessObjectFormatUsage;
                sourceBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
                String copyBusinessObjectFormatUsage = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatUsage", sourceBusinessObjectFormatUsage), sourceBusinessObjectFormatUsage));
                copy.setBusinessObjectFormatUsage(copyBusinessObjectFormatUsage);
            } else {
                copy.businessObjectFormatUsage = null;
            }
            if (this.businessObjectFormatFileType!= null) {
                String sourceBusinessObjectFormatFileType;
                sourceBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
                String copyBusinessObjectFormatFileType = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatFileType", sourceBusinessObjectFormatFileType), sourceBusinessObjectFormatFileType));
                copy.setBusinessObjectFormatFileType(copyBusinessObjectFormatFileType);
            } else {
                copy.businessObjectFormatFileType = null;
            }
            if (this.businessObjectFormatVersion!= null) {
                Integer sourceBusinessObjectFormatVersion;
                sourceBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
                Integer copyBusinessObjectFormatVersion = ((Integer) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatVersion", sourceBusinessObjectFormatVersion), sourceBusinessObjectFormatVersion));
                copy.setBusinessObjectFormatVersion(copyBusinessObjectFormatVersion);
            } else {
                copy.businessObjectFormatVersion = null;
            }
            if (this.partitionValueFilters!= null) {
                List<PartitionValueFilter> sourcePartitionValueFilters;
                sourcePartitionValueFilters = this.getPartitionValueFilters();
                @SuppressWarnings("unchecked")
                List<PartitionValueFilter> copyPartitionValueFilters = ((List<PartitionValueFilter> ) strategy.copy(LocatorUtils.property(locator, "partitionValueFilters", sourcePartitionValueFilters), sourcePartitionValueFilters));
                copy.partitionValueFilters = null;
                copy.setPartitionValueFilters(copyPartitionValueFilters);
            } else {
                copy.partitionValueFilters = null;
            }
            if (this.partitionValueFilter!= null) {
                PartitionValueFilter sourcePartitionValueFilter;
                sourcePartitionValueFilter = this.getPartitionValueFilter();
                PartitionValueFilter copyPartitionValueFilter = ((PartitionValueFilter) strategy.copy(LocatorUtils.property(locator, "partitionValueFilter", sourcePartitionValueFilter), sourcePartitionValueFilter));
                copy.setPartitionValueFilter(copyPartitionValueFilter);
            } else {
                copy.partitionValueFilter = null;
            }
            if (this.businessObjectDataVersion!= null) {
                Integer sourceBusinessObjectDataVersion;
                sourceBusinessObjectDataVersion = this.getBusinessObjectDataVersion();
                Integer copyBusinessObjectDataVersion = ((Integer) strategy.copy(LocatorUtils.property(locator, "businessObjectDataVersion", sourceBusinessObjectDataVersion), sourceBusinessObjectDataVersion));
                copy.setBusinessObjectDataVersion(copyBusinessObjectDataVersion);
            } else {
                copy.businessObjectDataVersion = null;
            }
            if (this.storageNames!= null) {
                List<String> sourceStorageNames;
                sourceStorageNames = this.getStorageNames();
                @SuppressWarnings("unchecked")
                List<String> copyStorageNames = ((List<String> ) strategy.copy(LocatorUtils.property(locator, "storageNames", sourceStorageNames), sourceStorageNames));
                copy.storageNames = null;
                copy.setStorageNames(copyStorageNames);
            } else {
                copy.storageNames = null;
            }
            if (this.storageName!= null) {
                String sourceStorageName;
                sourceStorageName = this.getStorageName();
                String copyStorageName = ((String) strategy.copy(LocatorUtils.property(locator, "storageName", sourceStorageName), sourceStorageName));
                copy.setStorageName(copyStorageName);
            } else {
                copy.storageName = null;
            }
            if (this.availableStatuses!= null) {
                List<BusinessObjectDataStatus> sourceAvailableStatuses;
                sourceAvailableStatuses = this.getAvailableStatuses();
                @SuppressWarnings("unchecked")
                List<BusinessObjectDataStatus> copyAvailableStatuses = ((List<BusinessObjectDataStatus> ) strategy.copy(LocatorUtils.property(locator, "availableStatuses", sourceAvailableStatuses), sourceAvailableStatuses));
                copy.availableStatuses = null;
                copy.setAvailableStatuses(copyAvailableStatuses);
            } else {
                copy.availableStatuses = null;
            }
            if (this.notAvailableStatuses!= null) {
                List<BusinessObjectDataStatus> sourceNotAvailableStatuses;
                sourceNotAvailableStatuses = this.getNotAvailableStatuses();
                @SuppressWarnings("unchecked")
                List<BusinessObjectDataStatus> copyNotAvailableStatuses = ((List<BusinessObjectDataStatus> ) strategy.copy(LocatorUtils.property(locator, "notAvailableStatuses", sourceNotAvailableStatuses), sourceNotAvailableStatuses));
                copy.notAvailableStatuses = null;
                copy.setNotAvailableStatuses(copyNotAvailableStatuses);
            } else {
                copy.notAvailableStatuses = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new BusinessObjectDataAvailability();
    }

}
