
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for businessObjectDataDdlRequest complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="businessObjectDataDdlRequest"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectDefinitionName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatUsage" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatFileType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatVersion" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/&gt;
 *         &lt;element name="partitionValueFilters" type="{}partitionValueFilters" minOccurs="0"/&gt;
 *         &lt;element name="partitionValueFilter" type="{}partitionValueFilter" minOccurs="0"/&gt;
 *         &lt;element name="businessObjectDataVersion" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/&gt;
 *         &lt;element name="storageNames" type="{}storageNames" minOccurs="0"/&gt;
 *         &lt;element name="storageName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element ref="{}outputFormat"/&gt;
 *         &lt;element name="tableName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="customDdlName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="includeDropTableStatement" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="includeIfNotExistsOption" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="includeDropPartitions" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="allowMissingData" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="includeAllRegisteredSubPartitions" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "businessObjectDataDdlRequest", propOrder = {

})
@XmlRootElement(name = "businessObjectDataDdlRequest")
public class BusinessObjectDataDdlRequest implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElement(required = true)
    protected String businessObjectDefinitionName;
    @XmlElement(required = true)
    protected String businessObjectFormatUsage;
    @XmlElement(required = true)
    protected String businessObjectFormatFileType;
    protected Integer businessObjectFormatVersion;
    @XmlElementWrapper
    @XmlElement(name = "partitionValueFilter")
    protected List<PartitionValueFilter> partitionValueFilters;
    protected PartitionValueFilter partitionValueFilter;
    protected Integer businessObjectDataVersion;
    @XmlElementWrapper
    @XmlElement(name = "storageName")
    protected List<String> storageNames;
    protected String storageName;
    @XmlElement(required = true)
    protected BusinessObjectDataDdlOutputFormatEnum outputFormat;
    @XmlElement(required = true)
    protected String tableName;
    protected String customDdlName;
    protected Boolean includeDropTableStatement;
    protected Boolean includeIfNotExistsOption;
    protected Boolean includeDropPartitions;
    protected Boolean allowMissingData;
    protected Boolean includeAllRegisteredSubPartitions;

    /**
     * Default no-arg constructor
     * 
     */
    public BusinessObjectDataDdlRequest() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BusinessObjectDataDdlRequest(final String namespace, final String businessObjectDefinitionName, final String businessObjectFormatUsage, final String businessObjectFormatFileType, final Integer businessObjectFormatVersion, final List<PartitionValueFilter> partitionValueFilters, final PartitionValueFilter partitionValueFilter, final Integer businessObjectDataVersion, final List<String> storageNames, final String storageName, final BusinessObjectDataDdlOutputFormatEnum outputFormat, final String tableName, final String customDdlName, final Boolean includeDropTableStatement, final Boolean includeIfNotExistsOption, final Boolean includeDropPartitions, final Boolean allowMissingData, final Boolean includeAllRegisteredSubPartitions) {
        this.namespace = namespace;
        this.businessObjectDefinitionName = businessObjectDefinitionName;
        this.businessObjectFormatUsage = businessObjectFormatUsage;
        this.businessObjectFormatFileType = businessObjectFormatFileType;
        this.businessObjectFormatVersion = businessObjectFormatVersion;
        this.partitionValueFilters = partitionValueFilters;
        this.partitionValueFilter = partitionValueFilter;
        this.businessObjectDataVersion = businessObjectDataVersion;
        this.storageNames = storageNames;
        this.storageName = storageName;
        this.outputFormat = outputFormat;
        this.tableName = tableName;
        this.customDdlName = customDdlName;
        this.includeDropTableStatement = includeDropTableStatement;
        this.includeIfNotExistsOption = includeIfNotExistsOption;
        this.includeDropPartitions = includeDropPartitions;
        this.allowMissingData = allowMissingData;
        this.includeAllRegisteredSubPartitions = includeAllRegisteredSubPartitions;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the businessObjectDefinitionName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectDefinitionName() {
        return businessObjectDefinitionName;
    }

    /**
     * Sets the value of the businessObjectDefinitionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectDefinitionName(String value) {
        this.businessObjectDefinitionName = value;
    }

    /**
     * Gets the value of the businessObjectFormatUsage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatUsage() {
        return businessObjectFormatUsage;
    }

    /**
     * Sets the value of the businessObjectFormatUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatUsage(String value) {
        this.businessObjectFormatUsage = value;
    }

    /**
     * Gets the value of the businessObjectFormatFileType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatFileType() {
        return businessObjectFormatFileType;
    }

    /**
     * Sets the value of the businessObjectFormatFileType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatFileType(String value) {
        this.businessObjectFormatFileType = value;
    }

    /**
     * Gets the value of the businessObjectFormatVersion property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getBusinessObjectFormatVersion() {
        return businessObjectFormatVersion;
    }

    /**
     * Sets the value of the businessObjectFormatVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setBusinessObjectFormatVersion(Integer value) {
        this.businessObjectFormatVersion = value;
    }

    /**
     * Gets the value of the partitionValueFilter property.
     * 
     * @return
     *     possible object is
     *     {@link PartitionValueFilter }
     *     
     */
    public PartitionValueFilter getPartitionValueFilter() {
        return partitionValueFilter;
    }

    /**
     * Sets the value of the partitionValueFilter property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartitionValueFilter }
     *     
     */
    public void setPartitionValueFilter(PartitionValueFilter value) {
        this.partitionValueFilter = value;
    }

    /**
     * Gets the value of the businessObjectDataVersion property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getBusinessObjectDataVersion() {
        return businessObjectDataVersion;
    }

    /**
     * Sets the value of the businessObjectDataVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setBusinessObjectDataVersion(Integer value) {
        this.businessObjectDataVersion = value;
    }

    /**
     * Gets the value of the storageName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStorageName() {
        return storageName;
    }

    /**
     * Sets the value of the storageName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStorageName(String value) {
        this.storageName = value;
    }

    /**
     * Gets the value of the outputFormat property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessObjectDataDdlOutputFormatEnum }
     *     
     */
    public BusinessObjectDataDdlOutputFormatEnum getOutputFormat() {
        return outputFormat;
    }

    /**
     * Sets the value of the outputFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessObjectDataDdlOutputFormatEnum }
     *     
     */
    public void setOutputFormat(BusinessObjectDataDdlOutputFormatEnum value) {
        this.outputFormat = value;
    }

    /**
     * Gets the value of the tableName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTableName() {
        return tableName;
    }

    /**
     * Sets the value of the tableName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTableName(String value) {
        this.tableName = value;
    }

    /**
     * Gets the value of the customDdlName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomDdlName() {
        return customDdlName;
    }

    /**
     * Sets the value of the customDdlName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCustomDdlName(String value) {
        this.customDdlName = value;
    }

    /**
     * Gets the value of the includeDropTableStatement property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIncludeDropTableStatement() {
        return includeDropTableStatement;
    }

    /**
     * Sets the value of the includeDropTableStatement property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeDropTableStatement(Boolean value) {
        this.includeDropTableStatement = value;
    }

    /**
     * Gets the value of the includeIfNotExistsOption property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIncludeIfNotExistsOption() {
        return includeIfNotExistsOption;
    }

    /**
     * Sets the value of the includeIfNotExistsOption property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeIfNotExistsOption(Boolean value) {
        this.includeIfNotExistsOption = value;
    }

    /**
     * Gets the value of the includeDropPartitions property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIncludeDropPartitions() {
        return includeDropPartitions;
    }

    /**
     * Sets the value of the includeDropPartitions property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeDropPartitions(Boolean value) {
        this.includeDropPartitions = value;
    }

    /**
     * Gets the value of the allowMissingData property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isAllowMissingData() {
        return allowMissingData;
    }

    /**
     * Sets the value of the allowMissingData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAllowMissingData(Boolean value) {
        this.allowMissingData = value;
    }

    /**
     * Gets the value of the includeAllRegisteredSubPartitions property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIncludeAllRegisteredSubPartitions() {
        return includeAllRegisteredSubPartitions;
    }

    /**
     * Sets the value of the includeAllRegisteredSubPartitions property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeAllRegisteredSubPartitions(Boolean value) {
        this.includeAllRegisteredSubPartitions = value;
    }

    public List<PartitionValueFilter> getPartitionValueFilters() {
        return partitionValueFilters;
    }

    public void setPartitionValueFilters(List<PartitionValueFilter> partitionValueFilters) {
        this.partitionValueFilters = partitionValueFilters;
    }

    public List<String> getStorageNames() {
        return storageNames;
    }

    public void setStorageNames(List<String> storageNames) {
        this.storageNames = storageNames;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            strategy.appendField(locator, this, "businessObjectDefinitionName", buffer, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            strategy.appendField(locator, this, "businessObjectFormatUsage", buffer, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            strategy.appendField(locator, this, "businessObjectFormatFileType", buffer, theBusinessObjectFormatFileType);
        }
        {
            Integer theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            strategy.appendField(locator, this, "businessObjectFormatVersion", buffer, theBusinessObjectFormatVersion);
        }
        {
            List<PartitionValueFilter> thePartitionValueFilters;
            thePartitionValueFilters = this.getPartitionValueFilters();
            strategy.appendField(locator, this, "partitionValueFilters", buffer, thePartitionValueFilters);
        }
        {
            PartitionValueFilter thePartitionValueFilter;
            thePartitionValueFilter = this.getPartitionValueFilter();
            strategy.appendField(locator, this, "partitionValueFilter", buffer, thePartitionValueFilter);
        }
        {
            Integer theBusinessObjectDataVersion;
            theBusinessObjectDataVersion = this.getBusinessObjectDataVersion();
            strategy.appendField(locator, this, "businessObjectDataVersion", buffer, theBusinessObjectDataVersion);
        }
        {
            List<String> theStorageNames;
            theStorageNames = this.getStorageNames();
            strategy.appendField(locator, this, "storageNames", buffer, theStorageNames);
        }
        {
            String theStorageName;
            theStorageName = this.getStorageName();
            strategy.appendField(locator, this, "storageName", buffer, theStorageName);
        }
        {
            BusinessObjectDataDdlOutputFormatEnum theOutputFormat;
            theOutputFormat = this.getOutputFormat();
            strategy.appendField(locator, this, "outputFormat", buffer, theOutputFormat);
        }
        {
            String theTableName;
            theTableName = this.getTableName();
            strategy.appendField(locator, this, "tableName", buffer, theTableName);
        }
        {
            String theCustomDdlName;
            theCustomDdlName = this.getCustomDdlName();
            strategy.appendField(locator, this, "customDdlName", buffer, theCustomDdlName);
        }
        {
            Boolean theIncludeDropTableStatement;
            theIncludeDropTableStatement = this.isIncludeDropTableStatement();
            strategy.appendField(locator, this, "includeDropTableStatement", buffer, theIncludeDropTableStatement);
        }
        {
            Boolean theIncludeIfNotExistsOption;
            theIncludeIfNotExistsOption = this.isIncludeIfNotExistsOption();
            strategy.appendField(locator, this, "includeIfNotExistsOption", buffer, theIncludeIfNotExistsOption);
        }
        {
            Boolean theIncludeDropPartitions;
            theIncludeDropPartitions = this.isIncludeDropPartitions();
            strategy.appendField(locator, this, "includeDropPartitions", buffer, theIncludeDropPartitions);
        }
        {
            Boolean theAllowMissingData;
            theAllowMissingData = this.isAllowMissingData();
            strategy.appendField(locator, this, "allowMissingData", buffer, theAllowMissingData);
        }
        {
            Boolean theIncludeAllRegisteredSubPartitions;
            theIncludeAllRegisteredSubPartitions = this.isIncludeAllRegisteredSubPartitions();
            strategy.appendField(locator, this, "includeAllRegisteredSubPartitions", buffer, theIncludeAllRegisteredSubPartitions);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final BusinessObjectDataDdlRequest that = ((BusinessObjectDataDdlRequest) object);
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectDefinitionName;
            lhsBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            String rhsBusinessObjectDefinitionName;
            rhsBusinessObjectDefinitionName = that.getBusinessObjectDefinitionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDefinitionName", lhsBusinessObjectDefinitionName), LocatorUtils.property(thatLocator, "businessObjectDefinitionName", rhsBusinessObjectDefinitionName), lhsBusinessObjectDefinitionName, rhsBusinessObjectDefinitionName)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatUsage;
            lhsBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            String rhsBusinessObjectFormatUsage;
            rhsBusinessObjectFormatUsage = that.getBusinessObjectFormatUsage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatUsage", lhsBusinessObjectFormatUsage), LocatorUtils.property(thatLocator, "businessObjectFormatUsage", rhsBusinessObjectFormatUsage), lhsBusinessObjectFormatUsage, rhsBusinessObjectFormatUsage)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatFileType;
            lhsBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            String rhsBusinessObjectFormatFileType;
            rhsBusinessObjectFormatFileType = that.getBusinessObjectFormatFileType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatFileType", lhsBusinessObjectFormatFileType), LocatorUtils.property(thatLocator, "businessObjectFormatFileType", rhsBusinessObjectFormatFileType), lhsBusinessObjectFormatFileType, rhsBusinessObjectFormatFileType)) {
                return false;
            }
        }
        {
            Integer lhsBusinessObjectFormatVersion;
            lhsBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            Integer rhsBusinessObjectFormatVersion;
            rhsBusinessObjectFormatVersion = that.getBusinessObjectFormatVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatVersion", lhsBusinessObjectFormatVersion), LocatorUtils.property(thatLocator, "businessObjectFormatVersion", rhsBusinessObjectFormatVersion), lhsBusinessObjectFormatVersion, rhsBusinessObjectFormatVersion)) {
                return false;
            }
        }
        {
            List<PartitionValueFilter> lhsPartitionValueFilters;
            lhsPartitionValueFilters = this.getPartitionValueFilters();
            List<PartitionValueFilter> rhsPartitionValueFilters;
            rhsPartitionValueFilters = that.getPartitionValueFilters();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionValueFilters", lhsPartitionValueFilters), LocatorUtils.property(thatLocator, "partitionValueFilters", rhsPartitionValueFilters), lhsPartitionValueFilters, rhsPartitionValueFilters)) {
                return false;
            }
        }
        {
            PartitionValueFilter lhsPartitionValueFilter;
            lhsPartitionValueFilter = this.getPartitionValueFilter();
            PartitionValueFilter rhsPartitionValueFilter;
            rhsPartitionValueFilter = that.getPartitionValueFilter();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionValueFilter", lhsPartitionValueFilter), LocatorUtils.property(thatLocator, "partitionValueFilter", rhsPartitionValueFilter), lhsPartitionValueFilter, rhsPartitionValueFilter)) {
                return false;
            }
        }
        {
            Integer lhsBusinessObjectDataVersion;
            lhsBusinessObjectDataVersion = this.getBusinessObjectDataVersion();
            Integer rhsBusinessObjectDataVersion;
            rhsBusinessObjectDataVersion = that.getBusinessObjectDataVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataVersion", lhsBusinessObjectDataVersion), LocatorUtils.property(thatLocator, "businessObjectDataVersion", rhsBusinessObjectDataVersion), lhsBusinessObjectDataVersion, rhsBusinessObjectDataVersion)) {
                return false;
            }
        }
        {
            List<String> lhsStorageNames;
            lhsStorageNames = this.getStorageNames();
            List<String> rhsStorageNames;
            rhsStorageNames = that.getStorageNames();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageNames", lhsStorageNames), LocatorUtils.property(thatLocator, "storageNames", rhsStorageNames), lhsStorageNames, rhsStorageNames)) {
                return false;
            }
        }
        {
            String lhsStorageName;
            lhsStorageName = this.getStorageName();
            String rhsStorageName;
            rhsStorageName = that.getStorageName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageName", lhsStorageName), LocatorUtils.property(thatLocator, "storageName", rhsStorageName), lhsStorageName, rhsStorageName)) {
                return false;
            }
        }
        {
            BusinessObjectDataDdlOutputFormatEnum lhsOutputFormat;
            lhsOutputFormat = this.getOutputFormat();
            BusinessObjectDataDdlOutputFormatEnum rhsOutputFormat;
            rhsOutputFormat = that.getOutputFormat();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "outputFormat", lhsOutputFormat), LocatorUtils.property(thatLocator, "outputFormat", rhsOutputFormat), lhsOutputFormat, rhsOutputFormat)) {
                return false;
            }
        }
        {
            String lhsTableName;
            lhsTableName = this.getTableName();
            String rhsTableName;
            rhsTableName = that.getTableName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "tableName", lhsTableName), LocatorUtils.property(thatLocator, "tableName", rhsTableName), lhsTableName, rhsTableName)) {
                return false;
            }
        }
        {
            String lhsCustomDdlName;
            lhsCustomDdlName = this.getCustomDdlName();
            String rhsCustomDdlName;
            rhsCustomDdlName = that.getCustomDdlName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "customDdlName", lhsCustomDdlName), LocatorUtils.property(thatLocator, "customDdlName", rhsCustomDdlName), lhsCustomDdlName, rhsCustomDdlName)) {
                return false;
            }
        }
        {
            Boolean lhsIncludeDropTableStatement;
            lhsIncludeDropTableStatement = this.isIncludeDropTableStatement();
            Boolean rhsIncludeDropTableStatement;
            rhsIncludeDropTableStatement = that.isIncludeDropTableStatement();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "includeDropTableStatement", lhsIncludeDropTableStatement), LocatorUtils.property(thatLocator, "includeDropTableStatement", rhsIncludeDropTableStatement), lhsIncludeDropTableStatement, rhsIncludeDropTableStatement)) {
                return false;
            }
        }
        {
            Boolean lhsIncludeIfNotExistsOption;
            lhsIncludeIfNotExistsOption = this.isIncludeIfNotExistsOption();
            Boolean rhsIncludeIfNotExistsOption;
            rhsIncludeIfNotExistsOption = that.isIncludeIfNotExistsOption();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "includeIfNotExistsOption", lhsIncludeIfNotExistsOption), LocatorUtils.property(thatLocator, "includeIfNotExistsOption", rhsIncludeIfNotExistsOption), lhsIncludeIfNotExistsOption, rhsIncludeIfNotExistsOption)) {
                return false;
            }
        }
        {
            Boolean lhsIncludeDropPartitions;
            lhsIncludeDropPartitions = this.isIncludeDropPartitions();
            Boolean rhsIncludeDropPartitions;
            rhsIncludeDropPartitions = that.isIncludeDropPartitions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "includeDropPartitions", lhsIncludeDropPartitions), LocatorUtils.property(thatLocator, "includeDropPartitions", rhsIncludeDropPartitions), lhsIncludeDropPartitions, rhsIncludeDropPartitions)) {
                return false;
            }
        }
        {
            Boolean lhsAllowMissingData;
            lhsAllowMissingData = this.isAllowMissingData();
            Boolean rhsAllowMissingData;
            rhsAllowMissingData = that.isAllowMissingData();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "allowMissingData", lhsAllowMissingData), LocatorUtils.property(thatLocator, "allowMissingData", rhsAllowMissingData), lhsAllowMissingData, rhsAllowMissingData)) {
                return false;
            }
        }
        {
            Boolean lhsIncludeAllRegisteredSubPartitions;
            lhsIncludeAllRegisteredSubPartitions = this.isIncludeAllRegisteredSubPartitions();
            Boolean rhsIncludeAllRegisteredSubPartitions;
            rhsIncludeAllRegisteredSubPartitions = that.isIncludeAllRegisteredSubPartitions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "includeAllRegisteredSubPartitions", lhsIncludeAllRegisteredSubPartitions), LocatorUtils.property(thatLocator, "includeAllRegisteredSubPartitions", rhsIncludeAllRegisteredSubPartitions), lhsIncludeAllRegisteredSubPartitions, rhsIncludeAllRegisteredSubPartitions)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDefinitionName", theBusinessObjectDefinitionName), currentHashCode, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatUsage", theBusinessObjectFormatUsage), currentHashCode, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatFileType", theBusinessObjectFormatFileType), currentHashCode, theBusinessObjectFormatFileType);
        }
        {
            Integer theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatVersion", theBusinessObjectFormatVersion), currentHashCode, theBusinessObjectFormatVersion);
        }
        {
            List<PartitionValueFilter> thePartitionValueFilters;
            thePartitionValueFilters = this.getPartitionValueFilters();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionValueFilters", thePartitionValueFilters), currentHashCode, thePartitionValueFilters);
        }
        {
            PartitionValueFilter thePartitionValueFilter;
            thePartitionValueFilter = this.getPartitionValueFilter();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionValueFilter", thePartitionValueFilter), currentHashCode, thePartitionValueFilter);
        }
        {
            Integer theBusinessObjectDataVersion;
            theBusinessObjectDataVersion = this.getBusinessObjectDataVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataVersion", theBusinessObjectDataVersion), currentHashCode, theBusinessObjectDataVersion);
        }
        {
            List<String> theStorageNames;
            theStorageNames = this.getStorageNames();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageNames", theStorageNames), currentHashCode, theStorageNames);
        }
        {
            String theStorageName;
            theStorageName = this.getStorageName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageName", theStorageName), currentHashCode, theStorageName);
        }
        {
            BusinessObjectDataDdlOutputFormatEnum theOutputFormat;
            theOutputFormat = this.getOutputFormat();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "outputFormat", theOutputFormat), currentHashCode, theOutputFormat);
        }
        {
            String theTableName;
            theTableName = this.getTableName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "tableName", theTableName), currentHashCode, theTableName);
        }
        {
            String theCustomDdlName;
            theCustomDdlName = this.getCustomDdlName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "customDdlName", theCustomDdlName), currentHashCode, theCustomDdlName);
        }
        {
            Boolean theIncludeDropTableStatement;
            theIncludeDropTableStatement = this.isIncludeDropTableStatement();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "includeDropTableStatement", theIncludeDropTableStatement), currentHashCode, theIncludeDropTableStatement);
        }
        {
            Boolean theIncludeIfNotExistsOption;
            theIncludeIfNotExistsOption = this.isIncludeIfNotExistsOption();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "includeIfNotExistsOption", theIncludeIfNotExistsOption), currentHashCode, theIncludeIfNotExistsOption);
        }
        {
            Boolean theIncludeDropPartitions;
            theIncludeDropPartitions = this.isIncludeDropPartitions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "includeDropPartitions", theIncludeDropPartitions), currentHashCode, theIncludeDropPartitions);
        }
        {
            Boolean theAllowMissingData;
            theAllowMissingData = this.isAllowMissingData();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "allowMissingData", theAllowMissingData), currentHashCode, theAllowMissingData);
        }
        {
            Boolean theIncludeAllRegisteredSubPartitions;
            theIncludeAllRegisteredSubPartitions = this.isIncludeAllRegisteredSubPartitions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "includeAllRegisteredSubPartitions", theIncludeAllRegisteredSubPartitions), currentHashCode, theIncludeAllRegisteredSubPartitions);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof BusinessObjectDataDdlRequest) {
            final BusinessObjectDataDdlRequest copy = ((BusinessObjectDataDdlRequest) draftCopy);
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.businessObjectDefinitionName!= null) {
                String sourceBusinessObjectDefinitionName;
                sourceBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
                String copyBusinessObjectDefinitionName = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectDefinitionName", sourceBusinessObjectDefinitionName), sourceBusinessObjectDefinitionName));
                copy.setBusinessObjectDefinitionName(copyBusinessObjectDefinitionName);
            } else {
                copy.businessObjectDefinitionName = null;
            }
            if (this.businessObjectFormatUsage!= null) {
                String sourceBusinessObjectFormatUsage;
                sourceBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
                String copyBusinessObjectFormatUsage = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatUsage", sourceBusinessObjectFormatUsage), sourceBusinessObjectFormatUsage));
                copy.setBusinessObjectFormatUsage(copyBusinessObjectFormatUsage);
            } else {
                copy.businessObjectFormatUsage = null;
            }
            if (this.businessObjectFormatFileType!= null) {
                String sourceBusinessObjectFormatFileType;
                sourceBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
                String copyBusinessObjectFormatFileType = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatFileType", sourceBusinessObjectFormatFileType), sourceBusinessObjectFormatFileType));
                copy.setBusinessObjectFormatFileType(copyBusinessObjectFormatFileType);
            } else {
                copy.businessObjectFormatFileType = null;
            }
            if (this.businessObjectFormatVersion!= null) {
                Integer sourceBusinessObjectFormatVersion;
                sourceBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
                Integer copyBusinessObjectFormatVersion = ((Integer) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatVersion", sourceBusinessObjectFormatVersion), sourceBusinessObjectFormatVersion));
                copy.setBusinessObjectFormatVersion(copyBusinessObjectFormatVersion);
            } else {
                copy.businessObjectFormatVersion = null;
            }
            if (this.partitionValueFilters!= null) {
                List<PartitionValueFilter> sourcePartitionValueFilters;
                sourcePartitionValueFilters = this.getPartitionValueFilters();
                @SuppressWarnings("unchecked")
                List<PartitionValueFilter> copyPartitionValueFilters = ((List<PartitionValueFilter> ) strategy.copy(LocatorUtils.property(locator, "partitionValueFilters", sourcePartitionValueFilters), sourcePartitionValueFilters));
                copy.partitionValueFilters = null;
                copy.setPartitionValueFilters(copyPartitionValueFilters);
            } else {
                copy.partitionValueFilters = null;
            }
            if (this.partitionValueFilter!= null) {
                PartitionValueFilter sourcePartitionValueFilter;
                sourcePartitionValueFilter = this.getPartitionValueFilter();
                PartitionValueFilter copyPartitionValueFilter = ((PartitionValueFilter) strategy.copy(LocatorUtils.property(locator, "partitionValueFilter", sourcePartitionValueFilter), sourcePartitionValueFilter));
                copy.setPartitionValueFilter(copyPartitionValueFilter);
            } else {
                copy.partitionValueFilter = null;
            }
            if (this.businessObjectDataVersion!= null) {
                Integer sourceBusinessObjectDataVersion;
                sourceBusinessObjectDataVersion = this.getBusinessObjectDataVersion();
                Integer copyBusinessObjectDataVersion = ((Integer) strategy.copy(LocatorUtils.property(locator, "businessObjectDataVersion", sourceBusinessObjectDataVersion), sourceBusinessObjectDataVersion));
                copy.setBusinessObjectDataVersion(copyBusinessObjectDataVersion);
            } else {
                copy.businessObjectDataVersion = null;
            }
            if (this.storageNames!= null) {
                List<String> sourceStorageNames;
                sourceStorageNames = this.getStorageNames();
                @SuppressWarnings("unchecked")
                List<String> copyStorageNames = ((List<String> ) strategy.copy(LocatorUtils.property(locator, "storageNames", sourceStorageNames), sourceStorageNames));
                copy.storageNames = null;
                copy.setStorageNames(copyStorageNames);
            } else {
                copy.storageNames = null;
            }
            if (this.storageName!= null) {
                String sourceStorageName;
                sourceStorageName = this.getStorageName();
                String copyStorageName = ((String) strategy.copy(LocatorUtils.property(locator, "storageName", sourceStorageName), sourceStorageName));
                copy.setStorageName(copyStorageName);
            } else {
                copy.storageName = null;
            }
            if (this.outputFormat!= null) {
                BusinessObjectDataDdlOutputFormatEnum sourceOutputFormat;
                sourceOutputFormat = this.getOutputFormat();
                BusinessObjectDataDdlOutputFormatEnum copyOutputFormat = ((BusinessObjectDataDdlOutputFormatEnum) strategy.copy(LocatorUtils.property(locator, "outputFormat", sourceOutputFormat), sourceOutputFormat));
                copy.setOutputFormat(copyOutputFormat);
            } else {
                copy.outputFormat = null;
            }
            if (this.tableName!= null) {
                String sourceTableName;
                sourceTableName = this.getTableName();
                String copyTableName = ((String) strategy.copy(LocatorUtils.property(locator, "tableName", sourceTableName), sourceTableName));
                copy.setTableName(copyTableName);
            } else {
                copy.tableName = null;
            }
            if (this.customDdlName!= null) {
                String sourceCustomDdlName;
                sourceCustomDdlName = this.getCustomDdlName();
                String copyCustomDdlName = ((String) strategy.copy(LocatorUtils.property(locator, "customDdlName", sourceCustomDdlName), sourceCustomDdlName));
                copy.setCustomDdlName(copyCustomDdlName);
            } else {
                copy.customDdlName = null;
            }
            if (this.includeDropTableStatement!= null) {
                Boolean sourceIncludeDropTableStatement;
                sourceIncludeDropTableStatement = this.isIncludeDropTableStatement();
                Boolean copyIncludeDropTableStatement = ((Boolean) strategy.copy(LocatorUtils.property(locator, "includeDropTableStatement", sourceIncludeDropTableStatement), sourceIncludeDropTableStatement));
                copy.setIncludeDropTableStatement(copyIncludeDropTableStatement);
            } else {
                copy.includeDropTableStatement = null;
            }
            if (this.includeIfNotExistsOption!= null) {
                Boolean sourceIncludeIfNotExistsOption;
                sourceIncludeIfNotExistsOption = this.isIncludeIfNotExistsOption();
                Boolean copyIncludeIfNotExistsOption = ((Boolean) strategy.copy(LocatorUtils.property(locator, "includeIfNotExistsOption", sourceIncludeIfNotExistsOption), sourceIncludeIfNotExistsOption));
                copy.setIncludeIfNotExistsOption(copyIncludeIfNotExistsOption);
            } else {
                copy.includeIfNotExistsOption = null;
            }
            if (this.includeDropPartitions!= null) {
                Boolean sourceIncludeDropPartitions;
                sourceIncludeDropPartitions = this.isIncludeDropPartitions();
                Boolean copyIncludeDropPartitions = ((Boolean) strategy.copy(LocatorUtils.property(locator, "includeDropPartitions", sourceIncludeDropPartitions), sourceIncludeDropPartitions));
                copy.setIncludeDropPartitions(copyIncludeDropPartitions);
            } else {
                copy.includeDropPartitions = null;
            }
            if (this.allowMissingData!= null) {
                Boolean sourceAllowMissingData;
                sourceAllowMissingData = this.isAllowMissingData();
                Boolean copyAllowMissingData = ((Boolean) strategy.copy(LocatorUtils.property(locator, "allowMissingData", sourceAllowMissingData), sourceAllowMissingData));
                copy.setAllowMissingData(copyAllowMissingData);
            } else {
                copy.allowMissingData = null;
            }
            if (this.includeAllRegisteredSubPartitions!= null) {
                Boolean sourceIncludeAllRegisteredSubPartitions;
                sourceIncludeAllRegisteredSubPartitions = this.isIncludeAllRegisteredSubPartitions();
                Boolean copyIncludeAllRegisteredSubPartitions = ((Boolean) strategy.copy(LocatorUtils.property(locator, "includeAllRegisteredSubPartitions", sourceIncludeAllRegisteredSubPartitions), sourceIncludeAllRegisteredSubPartitions));
                copy.setIncludeAllRegisteredSubPartitions(copyIncludeAllRegisteredSubPartitions);
            } else {
                copy.includeAllRegisteredSubPartitions = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new BusinessObjectDataDdlRequest();
    }

}
