
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for businessObjectDefinitionCreateRequest complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="businessObjectDefinitionCreateRequest"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectDefinitionName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="dataProviderName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="attributes" type="{}attributes" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "businessObjectDefinitionCreateRequest", propOrder = {

})
@XmlRootElement(name = "businessObjectDefinitionCreateRequest")
public class BusinessObjectDefinitionCreateRequest implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElement(required = true)
    protected String businessObjectDefinitionName;
    @XmlElement(required = true)
    protected String dataProviderName;
    protected String description;
    @XmlElementWrapper
    @XmlElement(name = "attribute")
    protected List<Attribute> attributes;

    /**
     * Default no-arg constructor
     * 
     */
    public BusinessObjectDefinitionCreateRequest() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BusinessObjectDefinitionCreateRequest(final String namespace, final String businessObjectDefinitionName, final String dataProviderName, final String description, final List<Attribute> attributes) {
        this.namespace = namespace;
        this.businessObjectDefinitionName = businessObjectDefinitionName;
        this.dataProviderName = dataProviderName;
        this.description = description;
        this.attributes = attributes;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the businessObjectDefinitionName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectDefinitionName() {
        return businessObjectDefinitionName;
    }

    /**
     * Sets the value of the businessObjectDefinitionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectDefinitionName(String value) {
        this.businessObjectDefinitionName = value;
    }

    /**
     * Gets the value of the dataProviderName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDataProviderName() {
        return dataProviderName;
    }

    /**
     * Sets the value of the dataProviderName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDataProviderName(String value) {
        this.dataProviderName = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    public List<Attribute> getAttributes() {
        return attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            strategy.appendField(locator, this, "businessObjectDefinitionName", buffer, theBusinessObjectDefinitionName);
        }
        {
            String theDataProviderName;
            theDataProviderName = this.getDataProviderName();
            strategy.appendField(locator, this, "dataProviderName", buffer, theDataProviderName);
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription);
        }
        {
            List<Attribute> theAttributes;
            theAttributes = this.getAttributes();
            strategy.appendField(locator, this, "attributes", buffer, theAttributes);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final BusinessObjectDefinitionCreateRequest that = ((BusinessObjectDefinitionCreateRequest) object);
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectDefinitionName;
            lhsBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            String rhsBusinessObjectDefinitionName;
            rhsBusinessObjectDefinitionName = that.getBusinessObjectDefinitionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDefinitionName", lhsBusinessObjectDefinitionName), LocatorUtils.property(thatLocator, "businessObjectDefinitionName", rhsBusinessObjectDefinitionName), lhsBusinessObjectDefinitionName, rhsBusinessObjectDefinitionName)) {
                return false;
            }
        }
        {
            String lhsDataProviderName;
            lhsDataProviderName = this.getDataProviderName();
            String rhsDataProviderName;
            rhsDataProviderName = that.getDataProviderName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "dataProviderName", lhsDataProviderName), LocatorUtils.property(thatLocator, "dataProviderName", rhsDataProviderName), lhsDataProviderName, rhsDataProviderName)) {
                return false;
            }
        }
        {
            String lhsDescription;
            lhsDescription = this.getDescription();
            String rhsDescription;
            rhsDescription = that.getDescription();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "description", lhsDescription), LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription)) {
                return false;
            }
        }
        {
            List<Attribute> lhsAttributes;
            lhsAttributes = this.getAttributes();
            List<Attribute> rhsAttributes;
            rhsAttributes = that.getAttributes();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "attributes", lhsAttributes), LocatorUtils.property(thatLocator, "attributes", rhsAttributes), lhsAttributes, rhsAttributes)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDefinitionName", theBusinessObjectDefinitionName), currentHashCode, theBusinessObjectDefinitionName);
        }
        {
            String theDataProviderName;
            theDataProviderName = this.getDataProviderName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "dataProviderName", theDataProviderName), currentHashCode, theDataProviderName);
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription);
        }
        {
            List<Attribute> theAttributes;
            theAttributes = this.getAttributes();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "attributes", theAttributes), currentHashCode, theAttributes);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof BusinessObjectDefinitionCreateRequest) {
            final BusinessObjectDefinitionCreateRequest copy = ((BusinessObjectDefinitionCreateRequest) draftCopy);
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.businessObjectDefinitionName!= null) {
                String sourceBusinessObjectDefinitionName;
                sourceBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
                String copyBusinessObjectDefinitionName = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectDefinitionName", sourceBusinessObjectDefinitionName), sourceBusinessObjectDefinitionName));
                copy.setBusinessObjectDefinitionName(copyBusinessObjectDefinitionName);
            } else {
                copy.businessObjectDefinitionName = null;
            }
            if (this.dataProviderName!= null) {
                String sourceDataProviderName;
                sourceDataProviderName = this.getDataProviderName();
                String copyDataProviderName = ((String) strategy.copy(LocatorUtils.property(locator, "dataProviderName", sourceDataProviderName), sourceDataProviderName));
                copy.setDataProviderName(copyDataProviderName);
            } else {
                copy.dataProviderName = null;
            }
            if (this.description!= null) {
                String sourceDescription;
                sourceDescription = this.getDescription();
                String copyDescription = ((String) strategy.copy(LocatorUtils.property(locator, "description", sourceDescription), sourceDescription));
                copy.setDescription(copyDescription);
            } else {
                copy.description = null;
            }
            if (this.attributes!= null) {
                List<Attribute> sourceAttributes;
                sourceAttributes = this.getAttributes();
                @SuppressWarnings("unchecked")
                List<Attribute> copyAttributes = ((List<Attribute> ) strategy.copy(LocatorUtils.property(locator, "attributes", sourceAttributes), sourceAttributes));
                copy.attributes = null;
                copy.setAttributes(copyAttributes);
            } else {
                copy.attributes = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new BusinessObjectDefinitionCreateRequest();
    }

}
