
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for businessObjectFormat complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="businessObjectFormat"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="id" type="{http://www.w3.org/2001/XMLSchema}int"/&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectDefinitionName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatUsage" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatFileType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatVersion" type="{http://www.w3.org/2001/XMLSchema}int"/&gt;
 *         &lt;element name="latestVersion" type="{http://www.w3.org/2001/XMLSchema}boolean"/&gt;
 *         &lt;element name="partitionKey" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="attributes" type="{}attributes" minOccurs="0"/&gt;
 *         &lt;element name="attributeDefinitions" type="{}attributeDefinitions" minOccurs="0"/&gt;
 *         &lt;element name="schema" type="{}schema" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "businessObjectFormat", propOrder = {

})
@XmlRootElement(name = "businessObjectFormat")
public class BusinessObjectFormat implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    protected int id;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElement(required = true)
    protected String businessObjectDefinitionName;
    @XmlElement(required = true)
    protected String businessObjectFormatUsage;
    @XmlElement(required = true)
    protected String businessObjectFormatFileType;
    protected int businessObjectFormatVersion;
    protected boolean latestVersion;
    @XmlElement(required = true)
    protected String partitionKey;
    protected String description;
    @XmlElementWrapper
    @XmlElement(name = "attribute")
    protected List<Attribute> attributes;
    @XmlElementWrapper
    @XmlElement(name = "attributeDefinition")
    protected List<AttributeDefinition> attributeDefinitions;
    protected Schema schema;

    /**
     * Default no-arg constructor
     * 
     */
    public BusinessObjectFormat() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BusinessObjectFormat(final int id, final String namespace, final String businessObjectDefinitionName, final String businessObjectFormatUsage, final String businessObjectFormatFileType, final int businessObjectFormatVersion, final boolean latestVersion, final String partitionKey, final String description, final List<Attribute> attributes, final List<AttributeDefinition> attributeDefinitions, final Schema schema) {
        this.id = id;
        this.namespace = namespace;
        this.businessObjectDefinitionName = businessObjectDefinitionName;
        this.businessObjectFormatUsage = businessObjectFormatUsage;
        this.businessObjectFormatFileType = businessObjectFormatFileType;
        this.businessObjectFormatVersion = businessObjectFormatVersion;
        this.latestVersion = latestVersion;
        this.partitionKey = partitionKey;
        this.description = description;
        this.attributes = attributes;
        this.attributeDefinitions = attributeDefinitions;
        this.schema = schema;
    }

    /**
     * Gets the value of the id property.
     * 
     */
    public int getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     */
    public void setId(int value) {
        this.id = value;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the businessObjectDefinitionName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectDefinitionName() {
        return businessObjectDefinitionName;
    }

    /**
     * Sets the value of the businessObjectDefinitionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectDefinitionName(String value) {
        this.businessObjectDefinitionName = value;
    }

    /**
     * Gets the value of the businessObjectFormatUsage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatUsage() {
        return businessObjectFormatUsage;
    }

    /**
     * Sets the value of the businessObjectFormatUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatUsage(String value) {
        this.businessObjectFormatUsage = value;
    }

    /**
     * Gets the value of the businessObjectFormatFileType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatFileType() {
        return businessObjectFormatFileType;
    }

    /**
     * Sets the value of the businessObjectFormatFileType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatFileType(String value) {
        this.businessObjectFormatFileType = value;
    }

    /**
     * Gets the value of the businessObjectFormatVersion property.
     * 
     */
    public int getBusinessObjectFormatVersion() {
        return businessObjectFormatVersion;
    }

    /**
     * Sets the value of the businessObjectFormatVersion property.
     * 
     */
    public void setBusinessObjectFormatVersion(int value) {
        this.businessObjectFormatVersion = value;
    }

    /**
     * Gets the value of the latestVersion property.
     * 
     */
    public boolean isLatestVersion() {
        return latestVersion;
    }

    /**
     * Sets the value of the latestVersion property.
     * 
     */
    public void setLatestVersion(boolean value) {
        this.latestVersion = value;
    }

    /**
     * Gets the value of the partitionKey property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPartitionKey() {
        return partitionKey;
    }

    /**
     * Sets the value of the partitionKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPartitionKey(String value) {
        this.partitionKey = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the schema property.
     * 
     * @return
     *     possible object is
     *     {@link Schema }
     *     
     */
    public Schema getSchema() {
        return schema;
    }

    /**
     * Sets the value of the schema property.
     * 
     * @param value
     *     allowed object is
     *     {@link Schema }
     *     
     */
    public void setSchema(Schema value) {
        this.schema = value;
    }

    public List<Attribute> getAttributes() {
        return attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return attributeDefinitions;
    }

    public void setAttributeDefinitions(List<AttributeDefinition> attributeDefinitions) {
        this.attributeDefinitions = attributeDefinitions;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            int theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            strategy.appendField(locator, this, "businessObjectDefinitionName", buffer, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            strategy.appendField(locator, this, "businessObjectFormatUsage", buffer, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            strategy.appendField(locator, this, "businessObjectFormatFileType", buffer, theBusinessObjectFormatFileType);
        }
        {
            int theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            strategy.appendField(locator, this, "businessObjectFormatVersion", buffer, theBusinessObjectFormatVersion);
        }
        {
            boolean theLatestVersion;
            theLatestVersion = this.isLatestVersion();
            strategy.appendField(locator, this, "latestVersion", buffer, theLatestVersion);
        }
        {
            String thePartitionKey;
            thePartitionKey = this.getPartitionKey();
            strategy.appendField(locator, this, "partitionKey", buffer, thePartitionKey);
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription);
        }
        {
            List<Attribute> theAttributes;
            theAttributes = this.getAttributes();
            strategy.appendField(locator, this, "attributes", buffer, theAttributes);
        }
        {
            List<AttributeDefinition> theAttributeDefinitions;
            theAttributeDefinitions = this.getAttributeDefinitions();
            strategy.appendField(locator, this, "attributeDefinitions", buffer, theAttributeDefinitions);
        }
        {
            Schema theSchema;
            theSchema = this.getSchema();
            strategy.appendField(locator, this, "schema", buffer, theSchema);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final BusinessObjectFormat that = ((BusinessObjectFormat) object);
        {
            int lhsId;
            lhsId = this.getId();
            int rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId)) {
                return false;
            }
        }
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectDefinitionName;
            lhsBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            String rhsBusinessObjectDefinitionName;
            rhsBusinessObjectDefinitionName = that.getBusinessObjectDefinitionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDefinitionName", lhsBusinessObjectDefinitionName), LocatorUtils.property(thatLocator, "businessObjectDefinitionName", rhsBusinessObjectDefinitionName), lhsBusinessObjectDefinitionName, rhsBusinessObjectDefinitionName)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatUsage;
            lhsBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            String rhsBusinessObjectFormatUsage;
            rhsBusinessObjectFormatUsage = that.getBusinessObjectFormatUsage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatUsage", lhsBusinessObjectFormatUsage), LocatorUtils.property(thatLocator, "businessObjectFormatUsage", rhsBusinessObjectFormatUsage), lhsBusinessObjectFormatUsage, rhsBusinessObjectFormatUsage)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatFileType;
            lhsBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            String rhsBusinessObjectFormatFileType;
            rhsBusinessObjectFormatFileType = that.getBusinessObjectFormatFileType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatFileType", lhsBusinessObjectFormatFileType), LocatorUtils.property(thatLocator, "businessObjectFormatFileType", rhsBusinessObjectFormatFileType), lhsBusinessObjectFormatFileType, rhsBusinessObjectFormatFileType)) {
                return false;
            }
        }
        {
            int lhsBusinessObjectFormatVersion;
            lhsBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            int rhsBusinessObjectFormatVersion;
            rhsBusinessObjectFormatVersion = that.getBusinessObjectFormatVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatVersion", lhsBusinessObjectFormatVersion), LocatorUtils.property(thatLocator, "businessObjectFormatVersion", rhsBusinessObjectFormatVersion), lhsBusinessObjectFormatVersion, rhsBusinessObjectFormatVersion)) {
                return false;
            }
        }
        {
            boolean lhsLatestVersion;
            lhsLatestVersion = this.isLatestVersion();
            boolean rhsLatestVersion;
            rhsLatestVersion = that.isLatestVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "latestVersion", lhsLatestVersion), LocatorUtils.property(thatLocator, "latestVersion", rhsLatestVersion), lhsLatestVersion, rhsLatestVersion)) {
                return false;
            }
        }
        {
            String lhsPartitionKey;
            lhsPartitionKey = this.getPartitionKey();
            String rhsPartitionKey;
            rhsPartitionKey = that.getPartitionKey();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionKey", lhsPartitionKey), LocatorUtils.property(thatLocator, "partitionKey", rhsPartitionKey), lhsPartitionKey, rhsPartitionKey)) {
                return false;
            }
        }
        {
            String lhsDescription;
            lhsDescription = this.getDescription();
            String rhsDescription;
            rhsDescription = that.getDescription();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "description", lhsDescription), LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription)) {
                return false;
            }
        }
        {
            List<Attribute> lhsAttributes;
            lhsAttributes = this.getAttributes();
            List<Attribute> rhsAttributes;
            rhsAttributes = that.getAttributes();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "attributes", lhsAttributes), LocatorUtils.property(thatLocator, "attributes", rhsAttributes), lhsAttributes, rhsAttributes)) {
                return false;
            }
        }
        {
            List<AttributeDefinition> lhsAttributeDefinitions;
            lhsAttributeDefinitions = this.getAttributeDefinitions();
            List<AttributeDefinition> rhsAttributeDefinitions;
            rhsAttributeDefinitions = that.getAttributeDefinitions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "attributeDefinitions", lhsAttributeDefinitions), LocatorUtils.property(thatLocator, "attributeDefinitions", rhsAttributeDefinitions), lhsAttributeDefinitions, rhsAttributeDefinitions)) {
                return false;
            }
        }
        {
            Schema lhsSchema;
            lhsSchema = this.getSchema();
            Schema rhsSchema;
            rhsSchema = that.getSchema();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "schema", lhsSchema), LocatorUtils.property(thatLocator, "schema", rhsSchema), lhsSchema, rhsSchema)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            int theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDefinitionName", theBusinessObjectDefinitionName), currentHashCode, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatUsage", theBusinessObjectFormatUsage), currentHashCode, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatFileType", theBusinessObjectFormatFileType), currentHashCode, theBusinessObjectFormatFileType);
        }
        {
            int theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatVersion", theBusinessObjectFormatVersion), currentHashCode, theBusinessObjectFormatVersion);
        }
        {
            boolean theLatestVersion;
            theLatestVersion = this.isLatestVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "latestVersion", theLatestVersion), currentHashCode, theLatestVersion);
        }
        {
            String thePartitionKey;
            thePartitionKey = this.getPartitionKey();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionKey", thePartitionKey), currentHashCode, thePartitionKey);
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription);
        }
        {
            List<Attribute> theAttributes;
            theAttributes = this.getAttributes();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "attributes", theAttributes), currentHashCode, theAttributes);
        }
        {
            List<AttributeDefinition> theAttributeDefinitions;
            theAttributeDefinitions = this.getAttributeDefinitions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "attributeDefinitions", theAttributeDefinitions), currentHashCode, theAttributeDefinitions);
        }
        {
            Schema theSchema;
            theSchema = this.getSchema();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "schema", theSchema), currentHashCode, theSchema);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof BusinessObjectFormat) {
            final BusinessObjectFormat copy = ((BusinessObjectFormat) draftCopy);
            {
                int sourceId;
                sourceId = this.getId();
                int copyId = strategy.copy(LocatorUtils.property(locator, "id", sourceId), sourceId);
                copy.setId(copyId);
            }
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.businessObjectDefinitionName!= null) {
                String sourceBusinessObjectDefinitionName;
                sourceBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
                String copyBusinessObjectDefinitionName = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectDefinitionName", sourceBusinessObjectDefinitionName), sourceBusinessObjectDefinitionName));
                copy.setBusinessObjectDefinitionName(copyBusinessObjectDefinitionName);
            } else {
                copy.businessObjectDefinitionName = null;
            }
            if (this.businessObjectFormatUsage!= null) {
                String sourceBusinessObjectFormatUsage;
                sourceBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
                String copyBusinessObjectFormatUsage = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatUsage", sourceBusinessObjectFormatUsage), sourceBusinessObjectFormatUsage));
                copy.setBusinessObjectFormatUsage(copyBusinessObjectFormatUsage);
            } else {
                copy.businessObjectFormatUsage = null;
            }
            if (this.businessObjectFormatFileType!= null) {
                String sourceBusinessObjectFormatFileType;
                sourceBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
                String copyBusinessObjectFormatFileType = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatFileType", sourceBusinessObjectFormatFileType), sourceBusinessObjectFormatFileType));
                copy.setBusinessObjectFormatFileType(copyBusinessObjectFormatFileType);
            } else {
                copy.businessObjectFormatFileType = null;
            }
            {
                int sourceBusinessObjectFormatVersion;
                sourceBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
                int copyBusinessObjectFormatVersion = strategy.copy(LocatorUtils.property(locator, "businessObjectFormatVersion", sourceBusinessObjectFormatVersion), sourceBusinessObjectFormatVersion);
                copy.setBusinessObjectFormatVersion(copyBusinessObjectFormatVersion);
            }
            {
                boolean sourceLatestVersion;
                sourceLatestVersion = this.isLatestVersion();
                boolean copyLatestVersion = strategy.copy(LocatorUtils.property(locator, "latestVersion", sourceLatestVersion), sourceLatestVersion);
                copy.setLatestVersion(copyLatestVersion);
            }
            if (this.partitionKey!= null) {
                String sourcePartitionKey;
                sourcePartitionKey = this.getPartitionKey();
                String copyPartitionKey = ((String) strategy.copy(LocatorUtils.property(locator, "partitionKey", sourcePartitionKey), sourcePartitionKey));
                copy.setPartitionKey(copyPartitionKey);
            } else {
                copy.partitionKey = null;
            }
            if (this.description!= null) {
                String sourceDescription;
                sourceDescription = this.getDescription();
                String copyDescription = ((String) strategy.copy(LocatorUtils.property(locator, "description", sourceDescription), sourceDescription));
                copy.setDescription(copyDescription);
            } else {
                copy.description = null;
            }
            if (this.attributes!= null) {
                List<Attribute> sourceAttributes;
                sourceAttributes = this.getAttributes();
                @SuppressWarnings("unchecked")
                List<Attribute> copyAttributes = ((List<Attribute> ) strategy.copy(LocatorUtils.property(locator, "attributes", sourceAttributes), sourceAttributes));
                copy.attributes = null;
                copy.setAttributes(copyAttributes);
            } else {
                copy.attributes = null;
            }
            if (this.attributeDefinitions!= null) {
                List<AttributeDefinition> sourceAttributeDefinitions;
                sourceAttributeDefinitions = this.getAttributeDefinitions();
                @SuppressWarnings("unchecked")
                List<AttributeDefinition> copyAttributeDefinitions = ((List<AttributeDefinition> ) strategy.copy(LocatorUtils.property(locator, "attributeDefinitions", sourceAttributeDefinitions), sourceAttributeDefinitions));
                copy.attributeDefinitions = null;
                copy.setAttributeDefinitions(copyAttributeDefinitions);
            } else {
                copy.attributeDefinitions = null;
            }
            if (this.schema!= null) {
                Schema sourceSchema;
                sourceSchema = this.getSchema();
                Schema copySchema = ((Schema) strategy.copy(LocatorUtils.property(locator, "schema", sourceSchema), sourceSchema));
                copy.setSchema(copySchema);
            } else {
                copy.schema = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new BusinessObjectFormat();
    }

}
