
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for businessObjectFormatDdlRequest complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="businessObjectFormatDdlRequest"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectDefinitionName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatUsage" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatFileType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectFormatVersion" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/&gt;
 *         &lt;element ref="{}outputFormat"/&gt;
 *         &lt;element name="tableName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="customDdlName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="includeDropTableStatement" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="includeIfNotExistsOption" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="replaceColumns" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "businessObjectFormatDdlRequest", propOrder = {

})
@XmlRootElement(name = "businessObjectFormatDdlRequest")
public class BusinessObjectFormatDdlRequest implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElement(required = true)
    protected String businessObjectDefinitionName;
    @XmlElement(required = true)
    protected String businessObjectFormatUsage;
    @XmlElement(required = true)
    protected String businessObjectFormatFileType;
    protected Integer businessObjectFormatVersion;
    @XmlElement(required = true)
    protected BusinessObjectDataDdlOutputFormatEnum outputFormat;
    @XmlElement(required = true)
    protected String tableName;
    protected String customDdlName;
    protected Boolean includeDropTableStatement;
    protected Boolean includeIfNotExistsOption;
    protected Boolean replaceColumns;

    /**
     * Default no-arg constructor
     * 
     */
    public BusinessObjectFormatDdlRequest() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BusinessObjectFormatDdlRequest(final String namespace, final String businessObjectDefinitionName, final String businessObjectFormatUsage, final String businessObjectFormatFileType, final Integer businessObjectFormatVersion, final BusinessObjectDataDdlOutputFormatEnum outputFormat, final String tableName, final String customDdlName, final Boolean includeDropTableStatement, final Boolean includeIfNotExistsOption, final Boolean replaceColumns) {
        this.namespace = namespace;
        this.businessObjectDefinitionName = businessObjectDefinitionName;
        this.businessObjectFormatUsage = businessObjectFormatUsage;
        this.businessObjectFormatFileType = businessObjectFormatFileType;
        this.businessObjectFormatVersion = businessObjectFormatVersion;
        this.outputFormat = outputFormat;
        this.tableName = tableName;
        this.customDdlName = customDdlName;
        this.includeDropTableStatement = includeDropTableStatement;
        this.includeIfNotExistsOption = includeIfNotExistsOption;
        this.replaceColumns = replaceColumns;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the businessObjectDefinitionName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectDefinitionName() {
        return businessObjectDefinitionName;
    }

    /**
     * Sets the value of the businessObjectDefinitionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectDefinitionName(String value) {
        this.businessObjectDefinitionName = value;
    }

    /**
     * Gets the value of the businessObjectFormatUsage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatUsage() {
        return businessObjectFormatUsage;
    }

    /**
     * Sets the value of the businessObjectFormatUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatUsage(String value) {
        this.businessObjectFormatUsage = value;
    }

    /**
     * Gets the value of the businessObjectFormatFileType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectFormatFileType() {
        return businessObjectFormatFileType;
    }

    /**
     * Sets the value of the businessObjectFormatFileType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectFormatFileType(String value) {
        this.businessObjectFormatFileType = value;
    }

    /**
     * Gets the value of the businessObjectFormatVersion property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getBusinessObjectFormatVersion() {
        return businessObjectFormatVersion;
    }

    /**
     * Sets the value of the businessObjectFormatVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setBusinessObjectFormatVersion(Integer value) {
        this.businessObjectFormatVersion = value;
    }

    /**
     * The output format for the generated DDL. The only format currently supported is HIVE_13_DDL
     * 
     * @return
     *     possible object is
     *     {@link BusinessObjectDataDdlOutputFormatEnum }
     *     
     */
    public BusinessObjectDataDdlOutputFormatEnum getOutputFormat() {
        return outputFormat;
    }

    /**
     * Sets the value of the outputFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessObjectDataDdlOutputFormatEnum }
     *     
     */
    public void setOutputFormat(BusinessObjectDataDdlOutputFormatEnum value) {
        this.outputFormat = value;
    }

    /**
     * Gets the value of the tableName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTableName() {
        return tableName;
    }

    /**
     * Sets the value of the tableName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTableName(String value) {
        this.tableName = value;
    }

    /**
     * Gets the value of the customDdlName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomDdlName() {
        return customDdlName;
    }

    /**
     * Sets the value of the customDdlName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCustomDdlName(String value) {
        this.customDdlName = value;
    }

    /**
     * Gets the value of the includeDropTableStatement property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIncludeDropTableStatement() {
        return includeDropTableStatement;
    }

    /**
     * Sets the value of the includeDropTableStatement property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeDropTableStatement(Boolean value) {
        this.includeDropTableStatement = value;
    }

    /**
     * Gets the value of the includeIfNotExistsOption property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIncludeIfNotExistsOption() {
        return includeIfNotExistsOption;
    }

    /**
     * Sets the value of the includeIfNotExistsOption property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeIfNotExistsOption(Boolean value) {
        this.includeIfNotExistsOption = value;
    }

    /**
     * Gets the value of the replaceColumns property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isReplaceColumns() {
        return replaceColumns;
    }

    /**
     * Sets the value of the replaceColumns property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReplaceColumns(Boolean value) {
        this.replaceColumns = value;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            strategy.appendField(locator, this, "businessObjectDefinitionName", buffer, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            strategy.appendField(locator, this, "businessObjectFormatUsage", buffer, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            strategy.appendField(locator, this, "businessObjectFormatFileType", buffer, theBusinessObjectFormatFileType);
        }
        {
            Integer theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            strategy.appendField(locator, this, "businessObjectFormatVersion", buffer, theBusinessObjectFormatVersion);
        }
        {
            BusinessObjectDataDdlOutputFormatEnum theOutputFormat;
            theOutputFormat = this.getOutputFormat();
            strategy.appendField(locator, this, "outputFormat", buffer, theOutputFormat);
        }
        {
            String theTableName;
            theTableName = this.getTableName();
            strategy.appendField(locator, this, "tableName", buffer, theTableName);
        }
        {
            String theCustomDdlName;
            theCustomDdlName = this.getCustomDdlName();
            strategy.appendField(locator, this, "customDdlName", buffer, theCustomDdlName);
        }
        {
            Boolean theIncludeDropTableStatement;
            theIncludeDropTableStatement = this.isIncludeDropTableStatement();
            strategy.appendField(locator, this, "includeDropTableStatement", buffer, theIncludeDropTableStatement);
        }
        {
            Boolean theIncludeIfNotExistsOption;
            theIncludeIfNotExistsOption = this.isIncludeIfNotExistsOption();
            strategy.appendField(locator, this, "includeIfNotExistsOption", buffer, theIncludeIfNotExistsOption);
        }
        {
            Boolean theReplaceColumns;
            theReplaceColumns = this.isReplaceColumns();
            strategy.appendField(locator, this, "replaceColumns", buffer, theReplaceColumns);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final BusinessObjectFormatDdlRequest that = ((BusinessObjectFormatDdlRequest) object);
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectDefinitionName;
            lhsBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            String rhsBusinessObjectDefinitionName;
            rhsBusinessObjectDefinitionName = that.getBusinessObjectDefinitionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDefinitionName", lhsBusinessObjectDefinitionName), LocatorUtils.property(thatLocator, "businessObjectDefinitionName", rhsBusinessObjectDefinitionName), lhsBusinessObjectDefinitionName, rhsBusinessObjectDefinitionName)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatUsage;
            lhsBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            String rhsBusinessObjectFormatUsage;
            rhsBusinessObjectFormatUsage = that.getBusinessObjectFormatUsage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatUsage", lhsBusinessObjectFormatUsage), LocatorUtils.property(thatLocator, "businessObjectFormatUsage", rhsBusinessObjectFormatUsage), lhsBusinessObjectFormatUsage, rhsBusinessObjectFormatUsage)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectFormatFileType;
            lhsBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            String rhsBusinessObjectFormatFileType;
            rhsBusinessObjectFormatFileType = that.getBusinessObjectFormatFileType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatFileType", lhsBusinessObjectFormatFileType), LocatorUtils.property(thatLocator, "businessObjectFormatFileType", rhsBusinessObjectFormatFileType), lhsBusinessObjectFormatFileType, rhsBusinessObjectFormatFileType)) {
                return false;
            }
        }
        {
            Integer lhsBusinessObjectFormatVersion;
            lhsBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            Integer rhsBusinessObjectFormatVersion;
            rhsBusinessObjectFormatVersion = that.getBusinessObjectFormatVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectFormatVersion", lhsBusinessObjectFormatVersion), LocatorUtils.property(thatLocator, "businessObjectFormatVersion", rhsBusinessObjectFormatVersion), lhsBusinessObjectFormatVersion, rhsBusinessObjectFormatVersion)) {
                return false;
            }
        }
        {
            BusinessObjectDataDdlOutputFormatEnum lhsOutputFormat;
            lhsOutputFormat = this.getOutputFormat();
            BusinessObjectDataDdlOutputFormatEnum rhsOutputFormat;
            rhsOutputFormat = that.getOutputFormat();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "outputFormat", lhsOutputFormat), LocatorUtils.property(thatLocator, "outputFormat", rhsOutputFormat), lhsOutputFormat, rhsOutputFormat)) {
                return false;
            }
        }
        {
            String lhsTableName;
            lhsTableName = this.getTableName();
            String rhsTableName;
            rhsTableName = that.getTableName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "tableName", lhsTableName), LocatorUtils.property(thatLocator, "tableName", rhsTableName), lhsTableName, rhsTableName)) {
                return false;
            }
        }
        {
            String lhsCustomDdlName;
            lhsCustomDdlName = this.getCustomDdlName();
            String rhsCustomDdlName;
            rhsCustomDdlName = that.getCustomDdlName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "customDdlName", lhsCustomDdlName), LocatorUtils.property(thatLocator, "customDdlName", rhsCustomDdlName), lhsCustomDdlName, rhsCustomDdlName)) {
                return false;
            }
        }
        {
            Boolean lhsIncludeDropTableStatement;
            lhsIncludeDropTableStatement = this.isIncludeDropTableStatement();
            Boolean rhsIncludeDropTableStatement;
            rhsIncludeDropTableStatement = that.isIncludeDropTableStatement();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "includeDropTableStatement", lhsIncludeDropTableStatement), LocatorUtils.property(thatLocator, "includeDropTableStatement", rhsIncludeDropTableStatement), lhsIncludeDropTableStatement, rhsIncludeDropTableStatement)) {
                return false;
            }
        }
        {
            Boolean lhsIncludeIfNotExistsOption;
            lhsIncludeIfNotExistsOption = this.isIncludeIfNotExistsOption();
            Boolean rhsIncludeIfNotExistsOption;
            rhsIncludeIfNotExistsOption = that.isIncludeIfNotExistsOption();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "includeIfNotExistsOption", lhsIncludeIfNotExistsOption), LocatorUtils.property(thatLocator, "includeIfNotExistsOption", rhsIncludeIfNotExistsOption), lhsIncludeIfNotExistsOption, rhsIncludeIfNotExistsOption)) {
                return false;
            }
        }
        {
            Boolean lhsReplaceColumns;
            lhsReplaceColumns = this.isReplaceColumns();
            Boolean rhsReplaceColumns;
            rhsReplaceColumns = that.isReplaceColumns();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "replaceColumns", lhsReplaceColumns), LocatorUtils.property(thatLocator, "replaceColumns", rhsReplaceColumns), lhsReplaceColumns, rhsReplaceColumns)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theBusinessObjectDefinitionName;
            theBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDefinitionName", theBusinessObjectDefinitionName), currentHashCode, theBusinessObjectDefinitionName);
        }
        {
            String theBusinessObjectFormatUsage;
            theBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatUsage", theBusinessObjectFormatUsage), currentHashCode, theBusinessObjectFormatUsage);
        }
        {
            String theBusinessObjectFormatFileType;
            theBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatFileType", theBusinessObjectFormatFileType), currentHashCode, theBusinessObjectFormatFileType);
        }
        {
            Integer theBusinessObjectFormatVersion;
            theBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectFormatVersion", theBusinessObjectFormatVersion), currentHashCode, theBusinessObjectFormatVersion);
        }
        {
            BusinessObjectDataDdlOutputFormatEnum theOutputFormat;
            theOutputFormat = this.getOutputFormat();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "outputFormat", theOutputFormat), currentHashCode, theOutputFormat);
        }
        {
            String theTableName;
            theTableName = this.getTableName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "tableName", theTableName), currentHashCode, theTableName);
        }
        {
            String theCustomDdlName;
            theCustomDdlName = this.getCustomDdlName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "customDdlName", theCustomDdlName), currentHashCode, theCustomDdlName);
        }
        {
            Boolean theIncludeDropTableStatement;
            theIncludeDropTableStatement = this.isIncludeDropTableStatement();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "includeDropTableStatement", theIncludeDropTableStatement), currentHashCode, theIncludeDropTableStatement);
        }
        {
            Boolean theIncludeIfNotExistsOption;
            theIncludeIfNotExistsOption = this.isIncludeIfNotExistsOption();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "includeIfNotExistsOption", theIncludeIfNotExistsOption), currentHashCode, theIncludeIfNotExistsOption);
        }
        {
            Boolean theReplaceColumns;
            theReplaceColumns = this.isReplaceColumns();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "replaceColumns", theReplaceColumns), currentHashCode, theReplaceColumns);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof BusinessObjectFormatDdlRequest) {
            final BusinessObjectFormatDdlRequest copy = ((BusinessObjectFormatDdlRequest) draftCopy);
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.businessObjectDefinitionName!= null) {
                String sourceBusinessObjectDefinitionName;
                sourceBusinessObjectDefinitionName = this.getBusinessObjectDefinitionName();
                String copyBusinessObjectDefinitionName = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectDefinitionName", sourceBusinessObjectDefinitionName), sourceBusinessObjectDefinitionName));
                copy.setBusinessObjectDefinitionName(copyBusinessObjectDefinitionName);
            } else {
                copy.businessObjectDefinitionName = null;
            }
            if (this.businessObjectFormatUsage!= null) {
                String sourceBusinessObjectFormatUsage;
                sourceBusinessObjectFormatUsage = this.getBusinessObjectFormatUsage();
                String copyBusinessObjectFormatUsage = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatUsage", sourceBusinessObjectFormatUsage), sourceBusinessObjectFormatUsage));
                copy.setBusinessObjectFormatUsage(copyBusinessObjectFormatUsage);
            } else {
                copy.businessObjectFormatUsage = null;
            }
            if (this.businessObjectFormatFileType!= null) {
                String sourceBusinessObjectFormatFileType;
                sourceBusinessObjectFormatFileType = this.getBusinessObjectFormatFileType();
                String copyBusinessObjectFormatFileType = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatFileType", sourceBusinessObjectFormatFileType), sourceBusinessObjectFormatFileType));
                copy.setBusinessObjectFormatFileType(copyBusinessObjectFormatFileType);
            } else {
                copy.businessObjectFormatFileType = null;
            }
            if (this.businessObjectFormatVersion!= null) {
                Integer sourceBusinessObjectFormatVersion;
                sourceBusinessObjectFormatVersion = this.getBusinessObjectFormatVersion();
                Integer copyBusinessObjectFormatVersion = ((Integer) strategy.copy(LocatorUtils.property(locator, "businessObjectFormatVersion", sourceBusinessObjectFormatVersion), sourceBusinessObjectFormatVersion));
                copy.setBusinessObjectFormatVersion(copyBusinessObjectFormatVersion);
            } else {
                copy.businessObjectFormatVersion = null;
            }
            if (this.outputFormat!= null) {
                BusinessObjectDataDdlOutputFormatEnum sourceOutputFormat;
                sourceOutputFormat = this.getOutputFormat();
                BusinessObjectDataDdlOutputFormatEnum copyOutputFormat = ((BusinessObjectDataDdlOutputFormatEnum) strategy.copy(LocatorUtils.property(locator, "outputFormat", sourceOutputFormat), sourceOutputFormat));
                copy.setOutputFormat(copyOutputFormat);
            } else {
                copy.outputFormat = null;
            }
            if (this.tableName!= null) {
                String sourceTableName;
                sourceTableName = this.getTableName();
                String copyTableName = ((String) strategy.copy(LocatorUtils.property(locator, "tableName", sourceTableName), sourceTableName));
                copy.setTableName(copyTableName);
            } else {
                copy.tableName = null;
            }
            if (this.customDdlName!= null) {
                String sourceCustomDdlName;
                sourceCustomDdlName = this.getCustomDdlName();
                String copyCustomDdlName = ((String) strategy.copy(LocatorUtils.property(locator, "customDdlName", sourceCustomDdlName), sourceCustomDdlName));
                copy.setCustomDdlName(copyCustomDdlName);
            } else {
                copy.customDdlName = null;
            }
            if (this.includeDropTableStatement!= null) {
                Boolean sourceIncludeDropTableStatement;
                sourceIncludeDropTableStatement = this.isIncludeDropTableStatement();
                Boolean copyIncludeDropTableStatement = ((Boolean) strategy.copy(LocatorUtils.property(locator, "includeDropTableStatement", sourceIncludeDropTableStatement), sourceIncludeDropTableStatement));
                copy.setIncludeDropTableStatement(copyIncludeDropTableStatement);
            } else {
                copy.includeDropTableStatement = null;
            }
            if (this.includeIfNotExistsOption!= null) {
                Boolean sourceIncludeIfNotExistsOption;
                sourceIncludeIfNotExistsOption = this.isIncludeIfNotExistsOption();
                Boolean copyIncludeIfNotExistsOption = ((Boolean) strategy.copy(LocatorUtils.property(locator, "includeIfNotExistsOption", sourceIncludeIfNotExistsOption), sourceIncludeIfNotExistsOption));
                copy.setIncludeIfNotExistsOption(copyIncludeIfNotExistsOption);
            } else {
                copy.includeIfNotExistsOption = null;
            }
            if (this.replaceColumns!= null) {
                Boolean sourceReplaceColumns;
                sourceReplaceColumns = this.isReplaceColumns();
                Boolean copyReplaceColumns = ((Boolean) strategy.copy(LocatorUtils.property(locator, "replaceColumns", sourceReplaceColumns), sourceReplaceColumns));
                copy.setReplaceColumns(copyReplaceColumns);
            } else {
                copy.replaceColumns = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new BusinessObjectFormatDdlRequest();
    }

}
