
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for jdbcExecutionRequest complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="jdbcExecutionRequest"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="connection" type="{}jdbcConnection"/&gt;
 *         &lt;element name="statements"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="statement" type="{}jdbcStatement" maxOccurs="unbounded"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="s3PropertiesLocation" type="{}s3PropertiesLocation" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "jdbcExecutionRequest", propOrder = {
    "connection",
    "statements",
    "s3PropertiesLocation"
})
@XmlRootElement(name = "jdbcExecutionRequest")
public class JdbcExecutionRequest implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected JdbcConnection connection;
    @XmlElementWrapper(required = true)
    @XmlElement(name = "statement")
    protected List<JdbcStatement> statements;
    protected S3PropertiesLocation s3PropertiesLocation;

    /**
     * Default no-arg constructor
     * 
     */
    public JdbcExecutionRequest() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public JdbcExecutionRequest(final JdbcConnection connection, final List<JdbcStatement> statements, final S3PropertiesLocation s3PropertiesLocation) {
        this.connection = connection;
        this.statements = statements;
        this.s3PropertiesLocation = s3PropertiesLocation;
    }

    /**
     * Gets the value of the connection property.
     * 
     * @return
     *     possible object is
     *     {@link JdbcConnection }
     *     
     */
    public JdbcConnection getConnection() {
        return connection;
    }

    /**
     * Sets the value of the connection property.
     * 
     * @param value
     *     allowed object is
     *     {@link JdbcConnection }
     *     
     */
    public void setConnection(JdbcConnection value) {
        this.connection = value;
    }

    /**
     * Gets the value of the s3PropertiesLocation property.
     * 
     * @return
     *     possible object is
     *     {@link S3PropertiesLocation }
     *     
     */
    public S3PropertiesLocation getS3PropertiesLocation() {
        return s3PropertiesLocation;
    }

    /**
     * Sets the value of the s3PropertiesLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link S3PropertiesLocation }
     *     
     */
    public void setS3PropertiesLocation(S3PropertiesLocation value) {
        this.s3PropertiesLocation = value;
    }

    public List<JdbcStatement> getStatements() {
        return statements;
    }

    public void setStatements(List<JdbcStatement> statements) {
        this.statements = statements;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            JdbcConnection theConnection;
            theConnection = this.getConnection();
            strategy.appendField(locator, this, "connection", buffer, theConnection);
        }
        {
            List<JdbcStatement> theStatements;
            theStatements = this.getStatements();
            strategy.appendField(locator, this, "statements", buffer, theStatements);
        }
        {
            S3PropertiesLocation theS3PropertiesLocation;
            theS3PropertiesLocation = this.getS3PropertiesLocation();
            strategy.appendField(locator, this, "s3PropertiesLocation", buffer, theS3PropertiesLocation);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final JdbcExecutionRequest that = ((JdbcExecutionRequest) object);
        {
            JdbcConnection lhsConnection;
            lhsConnection = this.getConnection();
            JdbcConnection rhsConnection;
            rhsConnection = that.getConnection();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "connection", lhsConnection), LocatorUtils.property(thatLocator, "connection", rhsConnection), lhsConnection, rhsConnection)) {
                return false;
            }
        }
        {
            List<JdbcStatement> lhsStatements;
            lhsStatements = this.getStatements();
            List<JdbcStatement> rhsStatements;
            rhsStatements = that.getStatements();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "statements", lhsStatements), LocatorUtils.property(thatLocator, "statements", rhsStatements), lhsStatements, rhsStatements)) {
                return false;
            }
        }
        {
            S3PropertiesLocation lhsS3PropertiesLocation;
            lhsS3PropertiesLocation = this.getS3PropertiesLocation();
            S3PropertiesLocation rhsS3PropertiesLocation;
            rhsS3PropertiesLocation = that.getS3PropertiesLocation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "s3PropertiesLocation", lhsS3PropertiesLocation), LocatorUtils.property(thatLocator, "s3PropertiesLocation", rhsS3PropertiesLocation), lhsS3PropertiesLocation, rhsS3PropertiesLocation)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            JdbcConnection theConnection;
            theConnection = this.getConnection();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "connection", theConnection), currentHashCode, theConnection);
        }
        {
            List<JdbcStatement> theStatements;
            theStatements = this.getStatements();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "statements", theStatements), currentHashCode, theStatements);
        }
        {
            S3PropertiesLocation theS3PropertiesLocation;
            theS3PropertiesLocation = this.getS3PropertiesLocation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "s3PropertiesLocation", theS3PropertiesLocation), currentHashCode, theS3PropertiesLocation);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof JdbcExecutionRequest) {
            final JdbcExecutionRequest copy = ((JdbcExecutionRequest) draftCopy);
            if (this.connection!= null) {
                JdbcConnection sourceConnection;
                sourceConnection = this.getConnection();
                JdbcConnection copyConnection = ((JdbcConnection) strategy.copy(LocatorUtils.property(locator, "connection", sourceConnection), sourceConnection));
                copy.setConnection(copyConnection);
            } else {
                copy.connection = null;
            }
            if (this.statements!= null) {
                List<JdbcStatement> sourceStatements;
                sourceStatements = this.getStatements();
                @SuppressWarnings("unchecked")
                List<JdbcStatement> copyStatements = ((List<JdbcStatement> ) strategy.copy(LocatorUtils.property(locator, "statements", sourceStatements), sourceStatements));
                copy.statements = null;
                copy.setStatements(copyStatements);
            } else {
                copy.statements = null;
            }
            if (this.s3PropertiesLocation!= null) {
                S3PropertiesLocation sourceS3PropertiesLocation;
                sourceS3PropertiesLocation = this.getS3PropertiesLocation();
                S3PropertiesLocation copyS3PropertiesLocation = ((S3PropertiesLocation) strategy.copy(LocatorUtils.property(locator, "s3PropertiesLocation", sourceS3PropertiesLocation), sourceS3PropertiesLocation));
                copy.setS3PropertiesLocation(copyS3PropertiesLocation);
            } else {
                copy.s3PropertiesLocation = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new JdbcExecutionRequest();
    }

}
