
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for schema complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="schema"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="columns" type="{}schemaColumns"/&gt;
 *         &lt;element name="partitions" type="{}schemaColumns" minOccurs="0"/&gt;
 *         &lt;element name="nullValue" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="delimiter" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="escapeCharacter" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="partitionKeyGroup" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "schema", propOrder = {

})
public class Schema implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElementWrapper(required = true)
    @XmlElement(name = "column")
    protected List<SchemaColumn> columns;
    @XmlElementWrapper
    @XmlElement(name = "column")
    protected List<SchemaColumn> partitions;
    protected String nullValue;
    protected String delimiter;
    protected String escapeCharacter;
    protected String partitionKeyGroup;

    /**
     * Default no-arg constructor
     * 
     */
    public Schema() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Schema(final List<SchemaColumn> columns, final List<SchemaColumn> partitions, final String nullValue, final String delimiter, final String escapeCharacter, final String partitionKeyGroup) {
        this.columns = columns;
        this.partitions = partitions;
        this.nullValue = nullValue;
        this.delimiter = delimiter;
        this.escapeCharacter = escapeCharacter;
        this.partitionKeyGroup = partitionKeyGroup;
    }

    /**
     * Gets the value of the nullValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNullValue() {
        return nullValue;
    }

    /**
     * Sets the value of the nullValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNullValue(String value) {
        this.nullValue = value;
    }

    /**
     * Gets the value of the delimiter property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDelimiter() {
        return delimiter;
    }

    /**
     * Sets the value of the delimiter property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDelimiter(String value) {
        this.delimiter = value;
    }

    /**
     * Gets the value of the escapeCharacter property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEscapeCharacter() {
        return escapeCharacter;
    }

    /**
     * Sets the value of the escapeCharacter property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEscapeCharacter(String value) {
        this.escapeCharacter = value;
    }

    /**
     * Gets the value of the partitionKeyGroup property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPartitionKeyGroup() {
        return partitionKeyGroup;
    }

    /**
     * Sets the value of the partitionKeyGroup property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPartitionKeyGroup(String value) {
        this.partitionKeyGroup = value;
    }

    public List<SchemaColumn> getColumns() {
        return columns;
    }

    public void setColumns(List<SchemaColumn> columns) {
        this.columns = columns;
    }

    public List<SchemaColumn> getPartitions() {
        return partitions;
    }

    public void setPartitions(List<SchemaColumn> partitions) {
        this.partitions = partitions;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            List<SchemaColumn> theColumns;
            theColumns = this.getColumns();
            strategy.appendField(locator, this, "columns", buffer, theColumns);
        }
        {
            List<SchemaColumn> thePartitions;
            thePartitions = this.getPartitions();
            strategy.appendField(locator, this, "partitions", buffer, thePartitions);
        }
        {
            String theNullValue;
            theNullValue = this.getNullValue();
            strategy.appendField(locator, this, "nullValue", buffer, theNullValue);
        }
        {
            String theDelimiter;
            theDelimiter = this.getDelimiter();
            strategy.appendField(locator, this, "delimiter", buffer, theDelimiter);
        }
        {
            String theEscapeCharacter;
            theEscapeCharacter = this.getEscapeCharacter();
            strategy.appendField(locator, this, "escapeCharacter", buffer, theEscapeCharacter);
        }
        {
            String thePartitionKeyGroup;
            thePartitionKeyGroup = this.getPartitionKeyGroup();
            strategy.appendField(locator, this, "partitionKeyGroup", buffer, thePartitionKeyGroup);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Schema that = ((Schema) object);
        {
            List<SchemaColumn> lhsColumns;
            lhsColumns = this.getColumns();
            List<SchemaColumn> rhsColumns;
            rhsColumns = that.getColumns();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "columns", lhsColumns), LocatorUtils.property(thatLocator, "columns", rhsColumns), lhsColumns, rhsColumns)) {
                return false;
            }
        }
        {
            List<SchemaColumn> lhsPartitions;
            lhsPartitions = this.getPartitions();
            List<SchemaColumn> rhsPartitions;
            rhsPartitions = that.getPartitions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitions", lhsPartitions), LocatorUtils.property(thatLocator, "partitions", rhsPartitions), lhsPartitions, rhsPartitions)) {
                return false;
            }
        }
        {
            String lhsNullValue;
            lhsNullValue = this.getNullValue();
            String rhsNullValue;
            rhsNullValue = that.getNullValue();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "nullValue", lhsNullValue), LocatorUtils.property(thatLocator, "nullValue", rhsNullValue), lhsNullValue, rhsNullValue)) {
                return false;
            }
        }
        {
            String lhsDelimiter;
            lhsDelimiter = this.getDelimiter();
            String rhsDelimiter;
            rhsDelimiter = that.getDelimiter();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "delimiter", lhsDelimiter), LocatorUtils.property(thatLocator, "delimiter", rhsDelimiter), lhsDelimiter, rhsDelimiter)) {
                return false;
            }
        }
        {
            String lhsEscapeCharacter;
            lhsEscapeCharacter = this.getEscapeCharacter();
            String rhsEscapeCharacter;
            rhsEscapeCharacter = that.getEscapeCharacter();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "escapeCharacter", lhsEscapeCharacter), LocatorUtils.property(thatLocator, "escapeCharacter", rhsEscapeCharacter), lhsEscapeCharacter, rhsEscapeCharacter)) {
                return false;
            }
        }
        {
            String lhsPartitionKeyGroup;
            lhsPartitionKeyGroup = this.getPartitionKeyGroup();
            String rhsPartitionKeyGroup;
            rhsPartitionKeyGroup = that.getPartitionKeyGroup();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionKeyGroup", lhsPartitionKeyGroup), LocatorUtils.property(thatLocator, "partitionKeyGroup", rhsPartitionKeyGroup), lhsPartitionKeyGroup, rhsPartitionKeyGroup)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            List<SchemaColumn> theColumns;
            theColumns = this.getColumns();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "columns", theColumns), currentHashCode, theColumns);
        }
        {
            List<SchemaColumn> thePartitions;
            thePartitions = this.getPartitions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitions", thePartitions), currentHashCode, thePartitions);
        }
        {
            String theNullValue;
            theNullValue = this.getNullValue();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "nullValue", theNullValue), currentHashCode, theNullValue);
        }
        {
            String theDelimiter;
            theDelimiter = this.getDelimiter();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "delimiter", theDelimiter), currentHashCode, theDelimiter);
        }
        {
            String theEscapeCharacter;
            theEscapeCharacter = this.getEscapeCharacter();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "escapeCharacter", theEscapeCharacter), currentHashCode, theEscapeCharacter);
        }
        {
            String thePartitionKeyGroup;
            thePartitionKeyGroup = this.getPartitionKeyGroup();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionKeyGroup", thePartitionKeyGroup), currentHashCode, thePartitionKeyGroup);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof Schema) {
            final Schema copy = ((Schema) draftCopy);
            if (this.columns!= null) {
                List<SchemaColumn> sourceColumns;
                sourceColumns = this.getColumns();
                @SuppressWarnings("unchecked")
                List<SchemaColumn> copyColumns = ((List<SchemaColumn> ) strategy.copy(LocatorUtils.property(locator, "columns", sourceColumns), sourceColumns));
                copy.columns = null;
                copy.setColumns(copyColumns);
            } else {
                copy.columns = null;
            }
            if (this.partitions!= null) {
                List<SchemaColumn> sourcePartitions;
                sourcePartitions = this.getPartitions();
                @SuppressWarnings("unchecked")
                List<SchemaColumn> copyPartitions = ((List<SchemaColumn> ) strategy.copy(LocatorUtils.property(locator, "partitions", sourcePartitions), sourcePartitions));
                copy.partitions = null;
                copy.setPartitions(copyPartitions);
            } else {
                copy.partitions = null;
            }
            if (this.nullValue!= null) {
                String sourceNullValue;
                sourceNullValue = this.getNullValue();
                String copyNullValue = ((String) strategy.copy(LocatorUtils.property(locator, "nullValue", sourceNullValue), sourceNullValue));
                copy.setNullValue(copyNullValue);
            } else {
                copy.nullValue = null;
            }
            if (this.delimiter!= null) {
                String sourceDelimiter;
                sourceDelimiter = this.getDelimiter();
                String copyDelimiter = ((String) strategy.copy(LocatorUtils.property(locator, "delimiter", sourceDelimiter), sourceDelimiter));
                copy.setDelimiter(copyDelimiter);
            } else {
                copy.delimiter = null;
            }
            if (this.escapeCharacter!= null) {
                String sourceEscapeCharacter;
                sourceEscapeCharacter = this.getEscapeCharacter();
                String copyEscapeCharacter = ((String) strategy.copy(LocatorUtils.property(locator, "escapeCharacter", sourceEscapeCharacter), sourceEscapeCharacter));
                copy.setEscapeCharacter(copyEscapeCharacter);
            } else {
                copy.escapeCharacter = null;
            }
            if (this.partitionKeyGroup!= null) {
                String sourcePartitionKeyGroup;
                sourcePartitionKeyGroup = this.getPartitionKeyGroup();
                String copyPartitionKeyGroup = ((String) strategy.copy(LocatorUtils.property(locator, "partitionKeyGroup", sourcePartitionKeyGroup), sourcePartitionKeyGroup));
                copy.setPartitionKeyGroup(copyPartitionKeyGroup);
            } else {
                copy.partitionKeyGroup = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new Schema();
    }

}
