
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for storageDailyUploadStat complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="storageDailyUploadStat"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="uploadDate" type="{http://www.w3.org/2001/XMLSchema}date"/&gt;
 *         &lt;element name="totalFiles" type="{http://www.w3.org/2001/XMLSchema}long"/&gt;
 *         &lt;element name="totalBytes" type="{http://www.w3.org/2001/XMLSchema}long"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "storageDailyUploadStat", propOrder = {
    "uploadDate",
    "totalFiles",
    "totalBytes"
})
public class StorageDailyUploadStat implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar uploadDate;
    protected long totalFiles;
    protected long totalBytes;

    /**
     * Default no-arg constructor
     * 
     */
    public StorageDailyUploadStat() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public StorageDailyUploadStat(final XMLGregorianCalendar uploadDate, final long totalFiles, final long totalBytes) {
        this.uploadDate = uploadDate;
        this.totalFiles = totalFiles;
        this.totalBytes = totalBytes;
    }

    /**
     * Gets the value of the uploadDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getUploadDate() {
        return uploadDate;
    }

    /**
     * Sets the value of the uploadDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setUploadDate(XMLGregorianCalendar value) {
        this.uploadDate = value;
    }

    /**
     * Gets the value of the totalFiles property.
     * 
     */
    public long getTotalFiles() {
        return totalFiles;
    }

    /**
     * Sets the value of the totalFiles property.
     * 
     */
    public void setTotalFiles(long value) {
        this.totalFiles = value;
    }

    /**
     * Gets the value of the totalBytes property.
     * 
     */
    public long getTotalBytes() {
        return totalBytes;
    }

    /**
     * Sets the value of the totalBytes property.
     * 
     */
    public void setTotalBytes(long value) {
        this.totalBytes = value;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            XMLGregorianCalendar theUploadDate;
            theUploadDate = this.getUploadDate();
            strategy.appendField(locator, this, "uploadDate", buffer, theUploadDate);
        }
        {
            long theTotalFiles;
            theTotalFiles = this.getTotalFiles();
            strategy.appendField(locator, this, "totalFiles", buffer, theTotalFiles);
        }
        {
            long theTotalBytes;
            theTotalBytes = this.getTotalBytes();
            strategy.appendField(locator, this, "totalBytes", buffer, theTotalBytes);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final StorageDailyUploadStat that = ((StorageDailyUploadStat) object);
        {
            XMLGregorianCalendar lhsUploadDate;
            lhsUploadDate = this.getUploadDate();
            XMLGregorianCalendar rhsUploadDate;
            rhsUploadDate = that.getUploadDate();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "uploadDate", lhsUploadDate), LocatorUtils.property(thatLocator, "uploadDate", rhsUploadDate), lhsUploadDate, rhsUploadDate)) {
                return false;
            }
        }
        {
            long lhsTotalFiles;
            lhsTotalFiles = this.getTotalFiles();
            long rhsTotalFiles;
            rhsTotalFiles = that.getTotalFiles();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "totalFiles", lhsTotalFiles), LocatorUtils.property(thatLocator, "totalFiles", rhsTotalFiles), lhsTotalFiles, rhsTotalFiles)) {
                return false;
            }
        }
        {
            long lhsTotalBytes;
            lhsTotalBytes = this.getTotalBytes();
            long rhsTotalBytes;
            rhsTotalBytes = that.getTotalBytes();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "totalBytes", lhsTotalBytes), LocatorUtils.property(thatLocator, "totalBytes", rhsTotalBytes), lhsTotalBytes, rhsTotalBytes)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            XMLGregorianCalendar theUploadDate;
            theUploadDate = this.getUploadDate();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "uploadDate", theUploadDate), currentHashCode, theUploadDate);
        }
        {
            long theTotalFiles;
            theTotalFiles = this.getTotalFiles();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "totalFiles", theTotalFiles), currentHashCode, theTotalFiles);
        }
        {
            long theTotalBytes;
            theTotalBytes = this.getTotalBytes();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "totalBytes", theTotalBytes), currentHashCode, theTotalBytes);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof StorageDailyUploadStat) {
            final StorageDailyUploadStat copy = ((StorageDailyUploadStat) draftCopy);
            if (this.uploadDate!= null) {
                XMLGregorianCalendar sourceUploadDate;
                sourceUploadDate = this.getUploadDate();
                XMLGregorianCalendar copyUploadDate = ((XMLGregorianCalendar) strategy.copy(LocatorUtils.property(locator, "uploadDate", sourceUploadDate), sourceUploadDate));
                copy.setUploadDate(copyUploadDate);
            } else {
                copy.uploadDate = null;
            }
            {
                long sourceTotalFiles;
                sourceTotalFiles = this.getTotalFiles();
                long copyTotalFiles = strategy.copy(LocatorUtils.property(locator, "totalFiles", sourceTotalFiles), sourceTotalFiles);
                copy.setTotalFiles(copyTotalFiles);
            }
            {
                long sourceTotalBytes;
                sourceTotalBytes = this.getTotalBytes();
                long copyTotalBytes = strategy.copy(LocatorUtils.property(locator, "totalBytes", sourceTotalBytes), sourceTotalBytes);
                copy.setTotalBytes(copyTotalBytes);
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new StorageDailyUploadStat();
    }

}
