
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for storageFile complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="storageFile"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="filePath" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="fileSizeBytes" type="{http://www.w3.org/2001/XMLSchema}long" minOccurs="0"/&gt;
 *         &lt;element name="rowCount" type="{http://www.w3.org/2001/XMLSchema}long" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "storageFile", propOrder = {

})
public class StorageFile implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String filePath;
    protected Long fileSizeBytes;
    protected Long rowCount;

    /**
     * Default no-arg constructor
     * 
     */
    public StorageFile() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public StorageFile(final String filePath, final Long fileSizeBytes, final Long rowCount) {
        this.filePath = filePath;
        this.fileSizeBytes = fileSizeBytes;
        this.rowCount = rowCount;
    }

    /**
     * Gets the value of the filePath property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFilePath() {
        return filePath;
    }

    /**
     * Sets the value of the filePath property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFilePath(String value) {
        this.filePath = value;
    }

    /**
     * Gets the value of the fileSizeBytes property.
     * 
     * @return
     *     possible object is
     *     {@link Long }
     *     
     */
    public Long getFileSizeBytes() {
        return fileSizeBytes;
    }

    /**
     * Sets the value of the fileSizeBytes property.
     * 
     * @param value
     *     allowed object is
     *     {@link Long }
     *     
     */
    public void setFileSizeBytes(Long value) {
        this.fileSizeBytes = value;
    }

    /**
     * Gets the value of the rowCount property.
     * 
     * @return
     *     possible object is
     *     {@link Long }
     *     
     */
    public Long getRowCount() {
        return rowCount;
    }

    /**
     * Sets the value of the rowCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link Long }
     *     
     */
    public void setRowCount(Long value) {
        this.rowCount = value;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theFilePath;
            theFilePath = this.getFilePath();
            strategy.appendField(locator, this, "filePath", buffer, theFilePath);
        }
        {
            Long theFileSizeBytes;
            theFileSizeBytes = this.getFileSizeBytes();
            strategy.appendField(locator, this, "fileSizeBytes", buffer, theFileSizeBytes);
        }
        {
            Long theRowCount;
            theRowCount = this.getRowCount();
            strategy.appendField(locator, this, "rowCount", buffer, theRowCount);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final StorageFile that = ((StorageFile) object);
        {
            String lhsFilePath;
            lhsFilePath = this.getFilePath();
            String rhsFilePath;
            rhsFilePath = that.getFilePath();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "filePath", lhsFilePath), LocatorUtils.property(thatLocator, "filePath", rhsFilePath), lhsFilePath, rhsFilePath)) {
                return false;
            }
        }
        {
            Long lhsFileSizeBytes;
            lhsFileSizeBytes = this.getFileSizeBytes();
            Long rhsFileSizeBytes;
            rhsFileSizeBytes = that.getFileSizeBytes();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "fileSizeBytes", lhsFileSizeBytes), LocatorUtils.property(thatLocator, "fileSizeBytes", rhsFileSizeBytes), lhsFileSizeBytes, rhsFileSizeBytes)) {
                return false;
            }
        }
        {
            Long lhsRowCount;
            lhsRowCount = this.getRowCount();
            Long rhsRowCount;
            rhsRowCount = that.getRowCount();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "rowCount", lhsRowCount), LocatorUtils.property(thatLocator, "rowCount", rhsRowCount), lhsRowCount, rhsRowCount)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theFilePath;
            theFilePath = this.getFilePath();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "filePath", theFilePath), currentHashCode, theFilePath);
        }
        {
            Long theFileSizeBytes;
            theFileSizeBytes = this.getFileSizeBytes();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "fileSizeBytes", theFileSizeBytes), currentHashCode, theFileSizeBytes);
        }
        {
            Long theRowCount;
            theRowCount = this.getRowCount();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "rowCount", theRowCount), currentHashCode, theRowCount);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof StorageFile) {
            final StorageFile copy = ((StorageFile) draftCopy);
            if (this.filePath!= null) {
                String sourceFilePath;
                sourceFilePath = this.getFilePath();
                String copyFilePath = ((String) strategy.copy(LocatorUtils.property(locator, "filePath", sourceFilePath), sourceFilePath));
                copy.setFilePath(copyFilePath);
            } else {
                copy.filePath = null;
            }
            if (this.fileSizeBytes!= null) {
                Long sourceFileSizeBytes;
                sourceFileSizeBytes = this.getFileSizeBytes();
                Long copyFileSizeBytes = ((Long) strategy.copy(LocatorUtils.property(locator, "fileSizeBytes", sourceFileSizeBytes), sourceFileSizeBytes));
                copy.setFileSizeBytes(copyFileSizeBytes);
            } else {
                copy.fileSizeBytes = null;
            }
            if (this.rowCount!= null) {
                Long sourceRowCount;
                sourceRowCount = this.getRowCount();
                Long copyRowCount = ((Long) strategy.copy(LocatorUtils.property(locator, "rowCount", sourceRowCount), sourceRowCount));
                copy.setRowCount(copyRowCount);
            } else {
                copy.rowCount = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new StorageFile();
    }

}
