
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for uploadSingleInitiationRequest complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="uploadSingleInitiationRequest"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="sourceBusinessObjectFormatKey" type="{}businessObjectFormatKey"/&gt;
 *         &lt;element name="targetBusinessObjectFormatKey" type="{}businessObjectFormatKey"/&gt;
 *         &lt;element name="businessObjectDataAttributes" type="{}attributes" minOccurs="0"/&gt;
 *         &lt;element name="file" type="{}file"/&gt;
 *         &lt;element name="targetStorageName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "uploadSingleInitiationRequest", propOrder = {

})
@XmlRootElement(name = "uploadSingleInitiationRequest")
public class UploadSingleInitiationRequest implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected BusinessObjectFormatKey sourceBusinessObjectFormatKey;
    @XmlElement(required = true)
    protected BusinessObjectFormatKey targetBusinessObjectFormatKey;
    @XmlElementWrapper
    @XmlElement(name = "attribute")
    protected List<Attribute> businessObjectDataAttributes;
    @XmlElement(required = true)
    protected File file;
    protected String targetStorageName;

    /**
     * Default no-arg constructor
     * 
     */
    public UploadSingleInitiationRequest() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public UploadSingleInitiationRequest(final BusinessObjectFormatKey sourceBusinessObjectFormatKey, final BusinessObjectFormatKey targetBusinessObjectFormatKey, final List<Attribute> businessObjectDataAttributes, final File file, final String targetStorageName) {
        this.sourceBusinessObjectFormatKey = sourceBusinessObjectFormatKey;
        this.targetBusinessObjectFormatKey = targetBusinessObjectFormatKey;
        this.businessObjectDataAttributes = businessObjectDataAttributes;
        this.file = file;
        this.targetStorageName = targetStorageName;
    }

    /**
     * Gets the value of the sourceBusinessObjectFormatKey property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessObjectFormatKey }
     *     
     */
    public BusinessObjectFormatKey getSourceBusinessObjectFormatKey() {
        return sourceBusinessObjectFormatKey;
    }

    /**
     * Sets the value of the sourceBusinessObjectFormatKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessObjectFormatKey }
     *     
     */
    public void setSourceBusinessObjectFormatKey(BusinessObjectFormatKey value) {
        this.sourceBusinessObjectFormatKey = value;
    }

    /**
     * Gets the value of the targetBusinessObjectFormatKey property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessObjectFormatKey }
     *     
     */
    public BusinessObjectFormatKey getTargetBusinessObjectFormatKey() {
        return targetBusinessObjectFormatKey;
    }

    /**
     * Sets the value of the targetBusinessObjectFormatKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessObjectFormatKey }
     *     
     */
    public void setTargetBusinessObjectFormatKey(BusinessObjectFormatKey value) {
        this.targetBusinessObjectFormatKey = value;
    }

    /**
     * Gets the value of the file property.
     * 
     * @return
     *     possible object is
     *     {@link File }
     *     
     */
    public File getFile() {
        return file;
    }

    /**
     * Sets the value of the file property.
     * 
     * @param value
     *     allowed object is
     *     {@link File }
     *     
     */
    public void setFile(File value) {
        this.file = value;
    }

    /**
     * Gets the value of the targetStorageName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetStorageName() {
        return targetStorageName;
    }

    /**
     * Sets the value of the targetStorageName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetStorageName(String value) {
        this.targetStorageName = value;
    }

    public List<Attribute> getBusinessObjectDataAttributes() {
        return businessObjectDataAttributes;
    }

    public void setBusinessObjectDataAttributes(List<Attribute> businessObjectDataAttributes) {
        this.businessObjectDataAttributes = businessObjectDataAttributes;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            BusinessObjectFormatKey theSourceBusinessObjectFormatKey;
            theSourceBusinessObjectFormatKey = this.getSourceBusinessObjectFormatKey();
            strategy.appendField(locator, this, "sourceBusinessObjectFormatKey", buffer, theSourceBusinessObjectFormatKey);
        }
        {
            BusinessObjectFormatKey theTargetBusinessObjectFormatKey;
            theTargetBusinessObjectFormatKey = this.getTargetBusinessObjectFormatKey();
            strategy.appendField(locator, this, "targetBusinessObjectFormatKey", buffer, theTargetBusinessObjectFormatKey);
        }
        {
            List<Attribute> theBusinessObjectDataAttributes;
            theBusinessObjectDataAttributes = this.getBusinessObjectDataAttributes();
            strategy.appendField(locator, this, "businessObjectDataAttributes", buffer, theBusinessObjectDataAttributes);
        }
        {
            File theFile;
            theFile = this.getFile();
            strategy.appendField(locator, this, "file", buffer, theFile);
        }
        {
            String theTargetStorageName;
            theTargetStorageName = this.getTargetStorageName();
            strategy.appendField(locator, this, "targetStorageName", buffer, theTargetStorageName);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final UploadSingleInitiationRequest that = ((UploadSingleInitiationRequest) object);
        {
            BusinessObjectFormatKey lhsSourceBusinessObjectFormatKey;
            lhsSourceBusinessObjectFormatKey = this.getSourceBusinessObjectFormatKey();
            BusinessObjectFormatKey rhsSourceBusinessObjectFormatKey;
            rhsSourceBusinessObjectFormatKey = that.getSourceBusinessObjectFormatKey();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "sourceBusinessObjectFormatKey", lhsSourceBusinessObjectFormatKey), LocatorUtils.property(thatLocator, "sourceBusinessObjectFormatKey", rhsSourceBusinessObjectFormatKey), lhsSourceBusinessObjectFormatKey, rhsSourceBusinessObjectFormatKey)) {
                return false;
            }
        }
        {
            BusinessObjectFormatKey lhsTargetBusinessObjectFormatKey;
            lhsTargetBusinessObjectFormatKey = this.getTargetBusinessObjectFormatKey();
            BusinessObjectFormatKey rhsTargetBusinessObjectFormatKey;
            rhsTargetBusinessObjectFormatKey = that.getTargetBusinessObjectFormatKey();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targetBusinessObjectFormatKey", lhsTargetBusinessObjectFormatKey), LocatorUtils.property(thatLocator, "targetBusinessObjectFormatKey", rhsTargetBusinessObjectFormatKey), lhsTargetBusinessObjectFormatKey, rhsTargetBusinessObjectFormatKey)) {
                return false;
            }
        }
        {
            List<Attribute> lhsBusinessObjectDataAttributes;
            lhsBusinessObjectDataAttributes = this.getBusinessObjectDataAttributes();
            List<Attribute> rhsBusinessObjectDataAttributes;
            rhsBusinessObjectDataAttributes = that.getBusinessObjectDataAttributes();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataAttributes", lhsBusinessObjectDataAttributes), LocatorUtils.property(thatLocator, "businessObjectDataAttributes", rhsBusinessObjectDataAttributes), lhsBusinessObjectDataAttributes, rhsBusinessObjectDataAttributes)) {
                return false;
            }
        }
        {
            File lhsFile;
            lhsFile = this.getFile();
            File rhsFile;
            rhsFile = that.getFile();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "file", lhsFile), LocatorUtils.property(thatLocator, "file", rhsFile), lhsFile, rhsFile)) {
                return false;
            }
        }
        {
            String lhsTargetStorageName;
            lhsTargetStorageName = this.getTargetStorageName();
            String rhsTargetStorageName;
            rhsTargetStorageName = that.getTargetStorageName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targetStorageName", lhsTargetStorageName), LocatorUtils.property(thatLocator, "targetStorageName", rhsTargetStorageName), lhsTargetStorageName, rhsTargetStorageName)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            BusinessObjectFormatKey theSourceBusinessObjectFormatKey;
            theSourceBusinessObjectFormatKey = this.getSourceBusinessObjectFormatKey();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "sourceBusinessObjectFormatKey", theSourceBusinessObjectFormatKey), currentHashCode, theSourceBusinessObjectFormatKey);
        }
        {
            BusinessObjectFormatKey theTargetBusinessObjectFormatKey;
            theTargetBusinessObjectFormatKey = this.getTargetBusinessObjectFormatKey();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targetBusinessObjectFormatKey", theTargetBusinessObjectFormatKey), currentHashCode, theTargetBusinessObjectFormatKey);
        }
        {
            List<Attribute> theBusinessObjectDataAttributes;
            theBusinessObjectDataAttributes = this.getBusinessObjectDataAttributes();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataAttributes", theBusinessObjectDataAttributes), currentHashCode, theBusinessObjectDataAttributes);
        }
        {
            File theFile;
            theFile = this.getFile();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "file", theFile), currentHashCode, theFile);
        }
        {
            String theTargetStorageName;
            theTargetStorageName = this.getTargetStorageName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targetStorageName", theTargetStorageName), currentHashCode, theTargetStorageName);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof UploadSingleInitiationRequest) {
            final UploadSingleInitiationRequest copy = ((UploadSingleInitiationRequest) draftCopy);
            if (this.sourceBusinessObjectFormatKey!= null) {
                BusinessObjectFormatKey sourceSourceBusinessObjectFormatKey;
                sourceSourceBusinessObjectFormatKey = this.getSourceBusinessObjectFormatKey();
                BusinessObjectFormatKey copySourceBusinessObjectFormatKey = ((BusinessObjectFormatKey) strategy.copy(LocatorUtils.property(locator, "sourceBusinessObjectFormatKey", sourceSourceBusinessObjectFormatKey), sourceSourceBusinessObjectFormatKey));
                copy.setSourceBusinessObjectFormatKey(copySourceBusinessObjectFormatKey);
            } else {
                copy.sourceBusinessObjectFormatKey = null;
            }
            if (this.targetBusinessObjectFormatKey!= null) {
                BusinessObjectFormatKey sourceTargetBusinessObjectFormatKey;
                sourceTargetBusinessObjectFormatKey = this.getTargetBusinessObjectFormatKey();
                BusinessObjectFormatKey copyTargetBusinessObjectFormatKey = ((BusinessObjectFormatKey) strategy.copy(LocatorUtils.property(locator, "targetBusinessObjectFormatKey", sourceTargetBusinessObjectFormatKey), sourceTargetBusinessObjectFormatKey));
                copy.setTargetBusinessObjectFormatKey(copyTargetBusinessObjectFormatKey);
            } else {
                copy.targetBusinessObjectFormatKey = null;
            }
            if (this.businessObjectDataAttributes!= null) {
                List<Attribute> sourceBusinessObjectDataAttributes;
                sourceBusinessObjectDataAttributes = this.getBusinessObjectDataAttributes();
                @SuppressWarnings("unchecked")
                List<Attribute> copyBusinessObjectDataAttributes = ((List<Attribute> ) strategy.copy(LocatorUtils.property(locator, "businessObjectDataAttributes", sourceBusinessObjectDataAttributes), sourceBusinessObjectDataAttributes));
                copy.businessObjectDataAttributes = null;
                copy.setBusinessObjectDataAttributes(copyBusinessObjectDataAttributes);
            } else {
                copy.businessObjectDataAttributes = null;
            }
            if (this.file!= null) {
                File sourceFile;
                sourceFile = this.getFile();
                File copyFile = ((File) strategy.copy(LocatorUtils.property(locator, "file", sourceFile), sourceFile));
                copy.setFile(copyFile);
            } else {
                copy.file = null;
            }
            if (this.targetStorageName!= null) {
                String sourceTargetStorageName;
                sourceTargetStorageName = this.getTargetStorageName();
                String copyTargetStorageName = ((String) strategy.copy(LocatorUtils.property(locator, "targetStorageName", sourceTargetStorageName), sourceTargetStorageName));
                copy.setTargetStorageName(copyTargetStorageName);
            } else {
                copy.targetStorageName = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new UploadSingleInitiationRequest();
    }

}
