
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for workflowError complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="workflowError"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="retriesLeft" type="{http://www.w3.org/2001/XMLSchema}int"/&gt;
 *         &lt;element name="errorStackTrace" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "workflowError", propOrder = {

})
public class WorkflowError implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String errorMessage;
    protected int retriesLeft;
    @XmlCDATA
    protected String errorStackTrace;

    /**
     * Default no-arg constructor
     * 
     */
    public WorkflowError() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public WorkflowError(final String errorMessage, final int retriesLeft, final String errorStackTrace) {
        this.errorMessage = errorMessage;
        this.retriesLeft = retriesLeft;
        this.errorStackTrace = errorStackTrace;
    }

    /**
     * Gets the value of the errorMessage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * Sets the value of the errorMessage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setErrorMessage(String value) {
        this.errorMessage = value;
    }

    /**
     * Gets the value of the retriesLeft property.
     * 
     */
    public int getRetriesLeft() {
        return retriesLeft;
    }

    /**
     * Sets the value of the retriesLeft property.
     * 
     */
    public void setRetriesLeft(int value) {
        this.retriesLeft = value;
    }

    /**
     * Gets the value of the errorStackTrace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getErrorStackTrace() {
        return errorStackTrace;
    }

    /**
     * Sets the value of the errorStackTrace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setErrorStackTrace(String value) {
        this.errorStackTrace = value;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theErrorMessage;
            theErrorMessage = this.getErrorMessage();
            strategy.appendField(locator, this, "errorMessage", buffer, theErrorMessage);
        }
        {
            int theRetriesLeft;
            theRetriesLeft = this.getRetriesLeft();
            strategy.appendField(locator, this, "retriesLeft", buffer, theRetriesLeft);
        }
        {
            String theErrorStackTrace;
            theErrorStackTrace = this.getErrorStackTrace();
            strategy.appendField(locator, this, "errorStackTrace", buffer, theErrorStackTrace);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final WorkflowError that = ((WorkflowError) object);
        {
            String lhsErrorMessage;
            lhsErrorMessage = this.getErrorMessage();
            String rhsErrorMessage;
            rhsErrorMessage = that.getErrorMessage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "errorMessage", lhsErrorMessage), LocatorUtils.property(thatLocator, "errorMessage", rhsErrorMessage), lhsErrorMessage, rhsErrorMessage)) {
                return false;
            }
        }
        {
            int lhsRetriesLeft;
            lhsRetriesLeft = this.getRetriesLeft();
            int rhsRetriesLeft;
            rhsRetriesLeft = that.getRetriesLeft();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "retriesLeft", lhsRetriesLeft), LocatorUtils.property(thatLocator, "retriesLeft", rhsRetriesLeft), lhsRetriesLeft, rhsRetriesLeft)) {
                return false;
            }
        }
        {
            String lhsErrorStackTrace;
            lhsErrorStackTrace = this.getErrorStackTrace();
            String rhsErrorStackTrace;
            rhsErrorStackTrace = that.getErrorStackTrace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "errorStackTrace", lhsErrorStackTrace), LocatorUtils.property(thatLocator, "errorStackTrace", rhsErrorStackTrace), lhsErrorStackTrace, rhsErrorStackTrace)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theErrorMessage;
            theErrorMessage = this.getErrorMessage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "errorMessage", theErrorMessage), currentHashCode, theErrorMessage);
        }
        {
            int theRetriesLeft;
            theRetriesLeft = this.getRetriesLeft();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "retriesLeft", theRetriesLeft), currentHashCode, theRetriesLeft);
        }
        {
            String theErrorStackTrace;
            theErrorStackTrace = this.getErrorStackTrace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "errorStackTrace", theErrorStackTrace), currentHashCode, theErrorStackTrace);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof WorkflowError) {
            final WorkflowError copy = ((WorkflowError) draftCopy);
            if (this.errorMessage!= null) {
                String sourceErrorMessage;
                sourceErrorMessage = this.getErrorMessage();
                String copyErrorMessage = ((String) strategy.copy(LocatorUtils.property(locator, "errorMessage", sourceErrorMessage), sourceErrorMessage));
                copy.setErrorMessage(copyErrorMessage);
            } else {
                copy.errorMessage = null;
            }
            {
                int sourceRetriesLeft;
                sourceRetriesLeft = this.getRetriesLeft();
                int copyRetriesLeft = strategy.copy(LocatorUtils.property(locator, "retriesLeft", sourceRetriesLeft), sourceRetriesLeft);
                copy.setRetriesLeft(copyRetriesLeft);
            }
            if (this.errorStackTrace!= null) {
                String sourceErrorStackTrace;
                sourceErrorStackTrace = this.getErrorStackTrace();
                String copyErrorStackTrace = ((String) strategy.copy(LocatorUtils.property(locator, "errorStackTrace", sourceErrorStackTrace), sourceErrorStackTrace));
                copy.setErrorStackTrace(copyErrorStackTrace);
            } else {
                copy.errorStackTrace = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new WorkflowError();
    }

}
