/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.List;
import org.finra.herd.dao.BusinessObjectDataDaoTestHelper;
import org.finra.herd.model.api.xml.BusinessObjectDataAttribute;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeKey;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeUpdateRequest;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessObjectDataAttributeServiceTestHelper {
    @Autowired
    private BusinessObjectDataDaoTestHelper businessObjectDataDaoTestHelper;

    public BusinessObjectDataAttributeCreateRequest createBusinessObjectDataAttributeCreateRequest(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, Integer businessObjectFormatVersion, String businessObjectDataPartitionValue, List<String> businessObjectDataSubPartitionValues, Integer businessObjectDataVersion, String businessObjectDataAttributeName, String businessObjectDataAttributeValue) {
        BusinessObjectDataAttributeCreateRequest request = new BusinessObjectDataAttributeCreateRequest();
        request.setBusinessObjectDataAttributeKey(new BusinessObjectDataAttributeKey(namespaceCode, businessObjectDefinitionName, businessObjectFormatUsage, businessObjectFormatFileType, businessObjectFormatVersion, businessObjectDataPartitionValue, businessObjectDataSubPartitionValues, businessObjectDataVersion, businessObjectDataAttributeName));
        request.setBusinessObjectDataAttributeValue(businessObjectDataAttributeValue);
        return request;
    }

    public BusinessObjectDataAttributeUpdateRequest createBusinessObjectDataAttributeUpdateRequest(String businessObjectDataAttributeValue) {
        BusinessObjectDataAttributeUpdateRequest request = new BusinessObjectDataAttributeUpdateRequest();
        request.setBusinessObjectDataAttributeValue(businessObjectDataAttributeValue);
        return request;
    }

    public void validateBusinessObjectDataAttribute(Integer businessObjectDataAttributeId, String expectedNamespace, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, String expectedBusinessObjectDataPartitionValue, List<String> expectedBusinessObjectDataSubPartitionValues, Integer expectedBusinessObjectDataVersion, String expectedBusinessObjectDataAttributeName, String expectedBusinessObjectDataAttributeValue, BusinessObjectDataAttribute actualBusinessObjectDataAttribute) {
        Assert.assertNotNull((Object)actualBusinessObjectDataAttribute);
        if (businessObjectDataAttributeId != null) {
            Assert.assertEquals((Object)businessObjectDataAttributeId, (Object)actualBusinessObjectDataAttribute.getId());
        }
        this.validateBusinessObjectDataAttributeKey(expectedNamespace, expectedBusinessObjectDefinitionName, expectedBusinessObjectFormatUsage, expectedBusinessObjectFormatFileType, expectedBusinessObjectFormatVersion, expectedBusinessObjectDataPartitionValue, expectedBusinessObjectDataSubPartitionValues, expectedBusinessObjectDataVersion, expectedBusinessObjectDataAttributeName, actualBusinessObjectDataAttribute.getBusinessObjectDataAttributeKey());
        Assert.assertEquals((Object)expectedBusinessObjectDataAttributeValue, (Object)actualBusinessObjectDataAttribute.getBusinessObjectDataAttributeValue());
    }

    public void validateBusinessObjectDataAttributeKey(String expectedNamespace, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, String expectedBusinessObjectDataPartitionValue, List<String> expectedBusinessObjectDataSubPartitionValues, Integer expectedBusinessObjectDataVersion, String expectedBusinessObjectDataAttributeName, BusinessObjectDataAttributeKey actualBusinessObjectDataAttributeKey) {
        Assert.assertNotNull((Object)actualBusinessObjectDataAttributeKey);
        Assert.assertEquals((Object)expectedNamespace, (Object)actualBusinessObjectDataAttributeKey.getNamespace());
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionName, (Object)actualBusinessObjectDataAttributeKey.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)expectedBusinessObjectFormatUsage, (Object)actualBusinessObjectDataAttributeKey.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)expectedBusinessObjectFormatFileType, (Object)actualBusinessObjectDataAttributeKey.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)expectedBusinessObjectFormatVersion, (Object)actualBusinessObjectDataAttributeKey.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)expectedBusinessObjectDataPartitionValue, (Object)actualBusinessObjectDataAttributeKey.getPartitionValue());
        Assert.assertEquals(expectedBusinessObjectDataSubPartitionValues, (Object)actualBusinessObjectDataAttributeKey.getSubPartitionValues());
        Assert.assertEquals((Object)expectedBusinessObjectDataVersion, (Object)actualBusinessObjectDataAttributeKey.getBusinessObjectDataVersion());
        Assert.assertEquals((Object)expectedBusinessObjectDataAttributeName, (Object)actualBusinessObjectDataAttributeKey.getBusinessObjectDataAttributeName());
    }
}

