/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.dto.BusinessObjectDataRestoreDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.StorageUnitAlternateKeyDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.BusinessObjectDataFinalizeRestoreHelperServiceImpl;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDataFinalizeRestoreHelperServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDataFinalizeRestoreHelperServiceImpl")
    private BusinessObjectDataFinalizeRestoreHelperServiceImpl businessObjectDataFinalizeRestoreHelperServiceImpl;

    @Test
    public void testPrepareToFinalizeRestore() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        BusinessObjectDataRestoreDto resultStoragePolicyTransitionParamsDto = this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, this.storageFileHelper.createStorageFilesFromEntities(originStorageUnitEntity.getStorageFiles()), STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null, resultStoragePolicyTransitionParamsDto);
    }

    @Test
    public void testPrepareToFinalizeRestoreMissingOptionalParameters() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        BusinessObjectDataRestoreDto resultStoragePolicyTransitionParamsDto = this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, this.storageFileHelper.createStorageFilesFromEntities(originStorageUnitEntity.getStorageFiles()), STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null, resultStoragePolicyTransitionParamsDto);
    }

    @Test
    public void testPrepareToFinalizeRestoreInvalidParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME_ORIGIN));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME_ORIGIN));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME_ORIGIN));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME_ORIGIN));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME_ORIGIN));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME_ORIGIN));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        for (int i = 0; i < SUBPARTITION_VALUES.size(); ++i) {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>(SUBPARTITION_VALUES);
            testSubPartitionValues.set(i, "I_DO_NOT_EXIST");
            try {
                this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION, STORAGE_NAME_ORIGIN));
                Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
                continue;
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
            }
        }
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION, STORAGE_NAME_ORIGIN));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "I_DO_NOT_EXIST"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find Glacier storage unit.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"%s\" storage for the business object data {%s}.", "I_DO_NOT_EXIST", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreBusinessObjectDataNoExists() {
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(new StorageUnitAlternateKeyDto(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME_ORIGIN));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreGlacierStorageUnitNoExists() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an ObjectNotFoundException when Glacier storage unit does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"%s\" storage for the business object data {%s}.", STORAGE_NAME_GLACIER, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreGlacierStorageUnitNotEnabled() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_GLACIER, "GLACIER", businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when Glacier storage unit is not enabled.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is not archived. Business object data: {%s}", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreGlacierStorageUnitNoStoragePath() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_GLACIER, "GLACIER", businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when Glacier storage unit is not enabled.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no storage directory path specified in \"%s\" %s storage. Business object data: {%s}", STORAGE_NAME_GLACIER, "GLACIER", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreGlacierStorageUnitStoragePathDoesNotStartWithOriginBucketName() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "RESTORING", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", TEST_S3_KEY_PREFIX);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when Glacier storage unit storage directory path does not start with the origin S3 bucket name.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage directory path \"%s\" for business object data in \"%s\" %s storage does not start with the origin S3 bucket name. Origin S3 bucket name: {%s}, origin storage: {%s}, business object data: {%s}", TEST_S3_KEY_PREFIX, STORAGE_NAME_GLACIER, "GLACIER", S3_BUCKET_NAME_ORIGIN, STORAGE_NAME_ORIGIN, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreOriginStorageUnitNoExists() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "DISABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitEntity glacierStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_GLACIER, businessObjectDataEntity);
        glacierStorageUnitEntity.setParentStorageUnit(null);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when glacier storage unit has no origin origin unit reference.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Glacier storage unit in \"%s\" storage has no origin S3 storage unit. Business object data: {%s}", STORAGE_NAME_GLACIER, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreOriginStorageUnitNotS3() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "DISABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, STORAGE_PLATFORM_CODE, businessObjectDataEntity, "ENABLED", TEST_S3_KEY_PREFIX);
        StorageUnitEntity glacierStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_GLACIER, businessObjectDataEntity);
        glacierStorageUnitEntity.setParentStorageUnit(storageUnitEntity);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit is not S3.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Glacier storage unit in \"%s\" storage has no origin S3 storage unit. Business object data: {%s}", STORAGE_NAME_GLACIER, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreOriginStorageUnitAlreadyEnabled() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "ENABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit is enabled.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is already available in \"%s\" S3 storage. Business object data: {%s}", STORAGE_NAME_ORIGIN, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreOriginStorageUnitNotRestoring() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, STORAGE_UNIT_STATUS, STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit is not in RESTORING state.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Origin S3 storage unit in \"%s\" storage must have \"%s\" status, but it actually has \"%s\" status. Business object data: {%s}", STORAGE_NAME_ORIGIN, "RESTORING", STORAGE_UNIT_STATUS, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreOriginStorageUnitNoStorageFiles() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "RESTORING", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        originStorageUnitEntity.getStorageFiles().clear();
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit has no storage files.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no storage files registered in \"%s\" origin storage. Business object data: {%s}", STORAGE_NAME_ORIGIN, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreNoGlacierStorageBucketName() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "DISABLED", STORAGE_NAME_GLACIER, null, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalStateException when when Glacier storage does not have an S3 bucket name configured");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), STORAGE_NAME_GLACIER), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToFinalizeRestoreNoOriginStorageBucketName() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, null, "RESTORING", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an IllegalStateException when when the origin storage does not have an S3 bucket name configured");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), STORAGE_NAME_ORIGIN), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteS3SpecificSteps() throws Exception {
        S3FileTransferRequestParamsDto originS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_ORIGIN).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ArrayList<StorageFile> originStorageFiles = new ArrayList<StorageFile>();
        for (String filePath : LOCAL_FILES) {
            originStorageFiles.add(new StorageFile(TEST_S3_KEY_PREFIX + "/" + filePath, Long.valueOf(1024L), NO_ROW_COUNT));
        }
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, originStorageFiles, STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null);
        try {
            for (StorageFile originStorageFile : originStorageFiles) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, originStorageFile.getFilePath()), (InputStream)new java.io.ByteArrayInputStream(new byte[originStorageFile.getFileSizeBytes().intValue()]), metadata), null);
            }
            this.businessObjectDataFinalizeRestoreHelperService.executeS3SpecificSteps(businessObjectDataRestoreDto);
            Assert.assertEquals((long)originStorageFiles.size(), (long)this.s3Dao.listDirectory(originS3FileTransferRequestParamsDto).size());
            Assert.assertEquals((long)originStorageFiles.size(), (long)this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteS3SpecificStepsNoLogging() throws Exception {
        S3FileTransferRequestParamsDto originS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_ORIGIN).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ArrayList<StorageFile> originStorageFiles = new ArrayList<StorageFile>();
        for (String filePath : LOCAL_FILES) {
            originStorageFiles.add(new StorageFile(TEST_S3_KEY_PREFIX + "/" + filePath, Long.valueOf(1024L), NO_ROW_COUNT));
        }
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, originStorageFiles, STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null);
        try {
            for (StorageFile originStorageFile : originStorageFiles) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, originStorageFile.getFilePath()), (InputStream)new java.io.ByteArrayInputStream(new byte[originStorageFile.getFileSizeBytes().intValue()]), metadata), null);
            }
            this.executeWithoutLogging(BusinessObjectDataFinalizeRestoreHelperServiceImpl.class, () -> this.businessObjectDataFinalizeRestoreHelperService.executeS3SpecificSteps(businessObjectDataRestoreDto));
            Assert.assertEquals((long)originStorageFiles.size(), (long)this.s3Dao.listDirectory(originS3FileTransferRequestParamsDto).size());
            Assert.assertEquals((long)originStorageFiles.size(), (long)this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteS3SpecificStepsGlacierS3FileStillRestoring() throws Exception {
        S3FileTransferRequestParamsDto originS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_ORIGIN).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, Arrays.asList(new StorageFile(TEST_S3_KEY_PREFIX + "/" + "foo.dat", Long.valueOf(1024L), NO_ROW_COUNT)), STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null);
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
            metadata.setOngoingRestore(true);
            this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s/%s", S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, "foo.dat"), (InputStream)new java.io.ByteArrayInputStream(new byte[1024]), metadata), null);
            try {
                this.businessObjectDataFinalizeRestoreHelperService.executeS3SpecificSteps(businessObjectDataRestoreDto);
                Assert.fail((String)"Should throw an IllegalStateException when a Glacier S3 file is still restoring.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)String.format("Archived Glacier S3 file \"%s/%s/%s\" is not restored. StorageClass {GLACIER}, OngoingRestore flag {true}, Glacier S3 bucket name {%s}", S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, "foo.dat", S3_BUCKET_NAME_GLACIER), (Object)e.getMessage());
            }
            Assert.assertTrue((boolean)this.s3Dao.listDirectory(originS3FileTransferRequestParamsDto).isEmpty());
            Assert.assertEquals((long)1L, (long)this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteS3SpecificStepsOriginPrefixNotEmpty() throws Exception {
        S3FileTransferRequestParamsDto originS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_ORIGIN).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ArrayList<StorageFile> originStorageFiles = new ArrayList<StorageFile>();
        for (Object filePath : LOCAL_FILES) {
            originStorageFiles.add(new StorageFile(TEST_S3_KEY_PREFIX + "/" + (String)filePath, Long.valueOf(1024L), NO_ROW_COUNT));
        }
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, originStorageFiles, STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null);
        try {
            for (StorageFile originStorageFile : originStorageFiles) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, originStorageFile.getFilePath()), (InputStream)new java.io.ByteArrayInputStream(new byte[originStorageFile.getFileSizeBytes().intValue()]), metadata), null);
            }
            this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX + "/" + "foo.dat", (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
            try {
                this.businessObjectDataFinalizeRestoreHelperService.executeS3SpecificSteps(businessObjectDataRestoreDto);
                Assert.fail((String)"Should throw an IllegalStateException when destination S3 key prefix is not empty.");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)String.format("The origin S3 key prefix is not empty. S3 bucket name: {%s}, S3 key prefix: {%s/}", S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX), (Object)e.getMessage());
            }
            Assert.assertEquals((long)1L, (long)this.s3Dao.listDirectory(originS3FileTransferRequestParamsDto).size());
            Assert.assertEquals((long)originStorageFiles.size(), (long)this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteS3SpecificStepsNonGlacierStorageClassAndS3CopyFails() throws Exception {
        S3FileTransferRequestParamsDto originS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_ORIGIN).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ArrayList<StorageFile> originStorageFiles = new ArrayList<StorageFile>();
        for (Object filePath : LOCAL_FILES) {
            originStorageFiles.add(new StorageFile(TEST_S3_KEY_PREFIX + "/" + (String)filePath, Long.valueOf(1024L), NO_ROW_COUNT));
        }
        originStorageFiles.add(new StorageFile(TEST_S3_KEY_PREFIX + "/" + "mock_s3_file_name_service_exception", Long.valueOf(1024L), NO_ROW_COUNT));
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, originStorageFiles, STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null);
        try {
            for (StorageFile originStorageFile : originStorageFiles) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)(originStorageFile.getFilePath().endsWith((String)LOCAL_FILES.get(0)) ? null : StorageClass.Standard));
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, originStorageFile.getFilePath()), (InputStream)new java.io.ByteArrayInputStream(new byte[originStorageFile.getFileSizeBytes().intValue()]), metadata), null);
            }
            try {
                this.businessObjectDataFinalizeRestoreHelperService.executeS3SpecificSteps(businessObjectDataRestoreDto);
                Assert.fail((String)"Should throw an IllegalStateException when an S3 copy operation fails.");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)String.format("Failed to copy S3 file. Source storage: {%s}, source S3 bucket name: {%s}, source S3 object key: {%s/%s/%s}, target storage: {%s}, target S3 bucket name: {%s}, target S3 object key: {%s/%s}, business object data: {%s}", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, "mock_s3_file_name_service_exception", STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, "mock_s3_file_name_service_exception", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
            }
            Assert.assertTrue((boolean)this.s3Dao.listDirectory(originS3FileTransferRequestParamsDto).isEmpty());
            Assert.assertEquals((long)originStorageFiles.size(), (long)this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    @Test
    public void testEnableOriginStorageUnit() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        Assert.assertEquals((Object)"RESTORING", (Object)originStorageUnitEntity.getStatus().getCode());
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, Arrays.asList(new StorageFile(TEST_S3_KEY_PREFIX + "/" + "foo.dat", Long.valueOf(1024L), NO_ROW_COUNT)), STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null);
        this.businessObjectDataFinalizeRestoreHelperService.enableOriginStorageUnit(businessObjectDataRestoreDto);
        Assert.assertEquals((Object)"ENABLED", (Object)originStorageUnitEntity.getStatus().getCode());
    }

    @Test
    public void testBusinessObjectDataFinalizeRestoreHelperServiceMethodsNewTransactionPropagation() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreHelperServiceImpl.prepareToFinalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        StorageFile originStorageFile = new StorageFile(TEST_S3_KEY_PREFIX + "/" + "foo.dat", Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, Arrays.asList(originStorageFile), STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, S3_BUCKET_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX, null);
        try {
            this.businessObjectDataFinalizeRestoreHelperServiceImpl.executeS3SpecificSteps(businessObjectDataRestoreDto);
            Assert.fail((String)"Should throw an ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Archived file \"%s/%s\" does not exist in \"%s\" storage.", S3_BUCKET_NAME_ORIGIN, originStorageFile.getFilePath(), STORAGE_NAME_GLACIER), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataFinalizeRestoreHelperServiceImpl.enableOriginStorageUnit(businessObjectDataRestoreDto);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }
}

