/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.StorageUnitAlternateKeyDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.BusinessObjectDataFinalizeRestoreServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDataFinalizeRestoreServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDataFinalizeRestoreServiceImpl")
    private BusinessObjectDataFinalizeRestoreServiceImpl businessObjectDataFinalizeRestoreServiceImpl;

    @Test
    public void testGetGlacierStorageUnitsToRestore() throws Exception {
        List<BusinessObjectDataKey> businessObjectDataKeys = Arrays.asList(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION));
        for (BusinessObjectDataKey businessObjectDataKey : businessObjectDataKeys) {
            this.storageUnitDaoTestHelper.createBusinessObjectDataEntityInRestoringState(businessObjectDataKey, STORAGE_NAME_ORIGIN, "RESTORING", STORAGE_NAME_GLACIER, "ENABLED");
        }
        List resultStorageUnitKeys = this.businessObjectDataFinalizeRestoreService.getGlacierStorageUnitsToRestore(MAX_RESULT.intValue());
        Assert.assertEquals((long)businessObjectDataKeys.size(), (long)resultStorageUnitKeys.size());
        for (BusinessObjectDataKey businessObjectDataKey : businessObjectDataKeys) {
            Assert.assertTrue((boolean)resultStorageUnitKeys.contains(this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER)));
        }
        Assert.assertEquals((long)1L, (long)this.businessObjectDataFinalizeRestoreService.getGlacierStorageUnitsToRestore(1).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeRestore() throws Exception {
        S3FileTransferRequestParamsDto originS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_ORIGIN).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            for (StorageFileEntity storageFileEntity : originStorageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, storageFileEntity.getPath()), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), null);
            }
            this.businessObjectDataFinalizeRestoreService.finalizeRestore(glacierStorageUnitKey);
            Assert.assertEquals((Object)"ENABLED", (Object)originStorageUnitEntity.getStatus().getCode());
            Assert.assertEquals((long)originStorageUnitEntity.getStorageFiles().size(), (long)this.s3Dao.listDirectory(originS3FileTransferRequestParamsDto).size());
            Assert.assertEquals((long)originStorageUnitEntity.getStorageFiles().size(), (long)this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeRestoreAmazonServiceException() throws Exception {
        S3FileTransferRequestParamsDto originS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_ORIGIN).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        this.storageFileDaoTestHelper.createStorageFileEntity(originStorageUnitEntity, String.format("%s/%s", TEST_S3_KEY_PREFIX, "mock_s3_file_name_service_exception"), Long.valueOf(1024L), ROW_COUNT);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            for (StorageFileEntity storageFileEntity : originStorageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, storageFileEntity.getPath()), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), null);
            }
            try {
                this.businessObjectDataFinalizeRestoreService.finalizeRestore(glacierStorageUnitKey);
                Assert.fail((String)"Should throw an IllegalStateException when a get S3 object metadata operation fails.");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)String.format("Fail to check restore status for \"%s/%s/%s\" key in \"%s\" bucket. Reason: InternalError (Service: null; Status Code: 0; Error Code: null; Request ID: null)", S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, "mock_s3_file_name_service_exception", S3_BUCKET_NAME_GLACIER), (Object)e.getMessage());
            }
            Assert.assertEquals((Object)"RESTORING", (Object)originStorageUnitEntity.getStatus().getCode());
            Assert.assertTrue((boolean)this.s3Dao.listDirectory(originS3FileTransferRequestParamsDto).isEmpty());
            Assert.assertEquals((long)originStorageUnitEntity.getStorageFiles().size(), (long)this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(originS3FileTransferRequestParamsDto, glacierS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    @Test
    public void testBusinessObjectDataFinalizeRestoreServiceMethodsNewTransactionPropagation() {
        Assert.assertEquals((long)0L, (long)this.businessObjectDataFinalizeRestoreServiceImpl.getGlacierStorageUnitsToRestore(MAX_RESULT.intValue()).size());
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitAlternateKeyDto glacierStorageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME_GLACIER);
        try {
            this.businessObjectDataFinalizeRestoreServiceImpl.finalizeRestore(glacierStorageUnitKey);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }
}

