/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.BusinessObjectDataRestoreDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDataInitiateRestoreHelperService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDataInitiateRestoreHelperServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDataInitiateRestoreHelperServiceImpl")
    private BusinessObjectDataInitiateRestoreHelperService businessObjectDataInitiateRestoreHelperServiceImpl;

    @Test
    public void testPrepareToInitiateRestore() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        BusinessObjectDataRestoreDto storagePolicyTransitionParamsDto = this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
        Assert.assertEquals((Object)businessObjectDataKey, (Object)storagePolicyTransitionParamsDto.getBusinessObjectDataKey());
    }

    @Test
    public void testPrepareToInitiateRestoreMissingRequiredParameters() {
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t ", (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when 1st subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), "      \t\t ", (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when 2nd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), "      \t\t ", (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when 3rd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), "      \t\t "), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when 4th subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, NO_DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreMissingOptionalParameters() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        BusinessObjectDataRestoreDto storagePolicyTransitionParamsDto = this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
        Assert.assertEquals((Object)businessObjectDataKey, (Object)storagePolicyTransitionParamsDto.getBusinessObjectDataKey());
    }

    @Test
    public void testPrepareToInitiateRestoreTrimParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        BusinessObjectDataRestoreDto storagePolicyTransitionParamsDto = this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION));
        Assert.assertEquals((Object)businessObjectDataKey, (Object)storagePolicyTransitionParamsDto.getBusinessObjectDataKey());
    }

    @Test
    public void testPrepareToInitiateRestoreUpperCaseParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        BusinessObjectDataRestoreDto storagePolicyTransitionParamsDto = this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
        Assert.assertEquals((Object)businessObjectDataKey, (Object)storagePolicyTransitionParamsDto.getBusinessObjectDataKey());
    }

    @Test
    public void testPrepareToInitiateRestoreLowerCaseParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        BusinessObjectDataRestoreDto storagePolicyTransitionParamsDto = this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
        Assert.assertEquals((Object)businessObjectDataKey, (Object)storagePolicyTransitionParamsDto.getBusinessObjectDataKey());
    }

    @Test
    public void testPrepareToInitiateRestoreInvalidParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        for (int i = 0; i < SUBPARTITION_VALUES.size(); ++i) {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>(SUBPARTITION_VALUES);
            testSubPartitionValues.set(i, "I_DO_NOT_EXIST");
            try {
                this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION));
                Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
                continue;
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
            }
        }
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreBusinessObjectDataNoExists() {
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreGlacierStorageUnitNoExists() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when Glacier storage unit does not exist.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is not archived. Business object data: {%s}", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreMultipleGlacierStorageUnitsExist() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "GLACIER", businessObjectDataEntity, "ENABLED", STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_2, "GLACIER", businessObjectDataEntity, "ENABLED", STORAGE_DIRECTORY_PATH);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data has multiple enabled Glacier storage units.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has multiple (2) GLACIER storage units. Business object data: {%s}", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreGlacierStorageUnitNotEnabled() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "GLACIER", businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when Glacier storage unit is not enabled.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is not archived. Business object data: {%s}", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreGlacierStorageUnitNoStoragePath() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_GLACIER, "GLACIER", businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when Glacier storage unit is not enabled.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no storage directory path specified in \"%s\" %s storage. Business object data: {%s}", STORAGE_NAME_GLACIER, "GLACIER", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreGlacierStorageUnitStoragePathDoesNotStartWithOriginBucketName() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "DISABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", TEST_S3_KEY_PREFIX);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when Glacier storage unit storage directory path does not start with the origin S3 bucket name.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage directory path \"%s\" for business object data in \"%s\" %s storage does not start with the origin S3 bucket name. Origin S3 bucket name: {%s}, origin storage: {%s}, business object data: {%s}", TEST_S3_KEY_PREFIX, STORAGE_NAME_GLACIER, "GLACIER", S3_BUCKET_NAME_ORIGIN, STORAGE_NAME_ORIGIN, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreOriginStorageUnitNoExists() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "DISABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitEntity glacierStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_GLACIER, businessObjectDataEntity);
        glacierStorageUnitEntity.setParentStorageUnit(null);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when glacier storage unit has no origin origin unit reference.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Glacier storage unit in \"%s\" storage has no origin S3 storage unit. Business object data: {%s}", STORAGE_NAME_GLACIER, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreOriginStorageUnitNotS3() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "DISABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, STORAGE_PLATFORM_CODE, businessObjectDataEntity, "ENABLED", TEST_S3_KEY_PREFIX);
        StorageUnitEntity glacierStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_GLACIER, businessObjectDataEntity);
        glacierStorageUnitEntity.setParentStorageUnit(storageUnitEntity);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit is not S3.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Glacier storage unit in \"%s\" storage has no origin S3 storage unit. Business object data: {%s}", STORAGE_NAME_GLACIER, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreOriginStorageUnitAlreadyEnabled() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "ENABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit is enabled.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is already available in \"%s\" S3 storage. Business object data: {%s}", STORAGE_NAME_ORIGIN, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreOriginStorageUnitAlreadyRestoring() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "RESTORING", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit already being restored.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is already being restored to \"%s\" S3 storage. Business object data: {%s}", STORAGE_NAME_ORIGIN, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreOriginStorageUnitNotDisabled() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, STORAGE_UNIT_STATUS, STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit is not disabled.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Origin S3 storage unit in \"%s\" storage must have \"%s\" status, but it actually has \"%s\" status. Business object data: {%s}", STORAGE_NAME_ORIGIN, "DISABLED", STORAGE_UNIT_STATUS, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreOriginStorageUnitNoStorageFiles() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "DISABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        originStorageUnitEntity.getStorageFiles().clear();
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalArgumentException when origin storage unit has no storage files.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no storage files registered in \"%s\" origin storage. Business object data: {%s}", STORAGE_NAME_ORIGIN, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreNoGlacierStorageBucketName() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, S3_BUCKET_NAME_ORIGIN, "DISABLED", STORAGE_NAME_GLACIER, null, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalStateException when when Glacier storage does not have an S3 bucket name configured");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), STORAGE_NAME_GLACIER), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareToInitiateRestoreNoOriginStorageBucketName() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, STORAGE_NAME_ORIGIN, null, "DISABLED", STORAGE_NAME_GLACIER, S3_BUCKET_NAME_GLACIER, "ENABLED", S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX);
        try {
            this.businessObjectDataInitiateRestoreHelperService.prepareToInitiateRestore(businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalStateException when when the origin storage does not have an S3 bucket name configured");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), STORAGE_NAME_ORIGIN), (Object)e.getMessage());
        }
    }

    @Test
    public void testBusinessObjectDataInitiateRestoreHelperServiceMethodsNewTransactionPropagation() {
        try {
            this.businessObjectDataInitiateRestoreHelperServiceImpl.prepareToInitiateRestore(new BusinessObjectDataKey());
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperServiceImpl.executeS3SpecificSteps(null);
            Assert.fail((String)"Should throw an NullPointerException.");
        }
        catch (NullPointerException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        try {
            this.businessObjectDataInitiateRestoreHelperServiceImpl.executeInitiateRestoreAfterStep(null);
            Assert.fail((String)"Should throw an NullPointerException.");
        }
        catch (NullPointerException e) {
            Assert.assertNull((Object)e.getMessage());
        }
    }
}

