/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchKey;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchResult;
import org.finra.herd.model.api.xml.LatestAfterPartitionValue;
import org.finra.herd.model.api.xml.LatestBeforePartitionValue;
import org.finra.herd.model.api.xml.PartitionValueFilter;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataSearchServiceTest
extends AbstractServiceTest {
    @Test
    public void testSearchBusinessObjectData() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace(NAMESPACE);
        key.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataSearchKeys.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        BusinessObjectDataSearchResult result = this.businessObjectDataService.searchBusinessObjectData(request);
        org.springframework.util.Assert.isTrue((result.getBusinessObjectDataElements().size() == 2 ? 1 : 0) != 0);
        for (BusinessObjectData data : result.getBusinessObjectDataElements()) {
            org.springframework.util.Assert.isTrue((boolean)NAMESPACE.equals(data.getNamespace()));
            org.springframework.util.Assert.isTrue((boolean)BDEF_NAME.equals(data.getBusinessObjectDefinitionName()));
        }
    }

    @Test
    public void testSearchBusinessObjectDataWithPartitionFilterValues() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace(NAMESPACE);
        key.setBusinessObjectDefinitionName(BDEF_NAME);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        PartitionValueFilter partitionValueFilter = new PartitionValueFilter();
        partitionValueFilters.add(partitionValueFilter);
        partitionValueFilter.setPartitionKey(PARTITION_KEY);
        ArrayList<String> values = new ArrayList<String>();
        values.add(PARTITION_VALUE);
        partitionValueFilter.setPartitionValues(values);
        key.setPartitionValueFilters(partitionValueFilters);
        businessObjectDataSearchKeys.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        BusinessObjectDataSearchResult result = this.businessObjectDataService.searchBusinessObjectData(request);
        org.springframework.util.Assert.isTrue((result.getBusinessObjectDataElements().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSearchBusinessObjectDataWithPartitionFilterBadRequest() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace(NAMESPACE);
        key.setBusinessObjectDefinitionName(BDEF_NAME);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        PartitionValueFilter partitionValueFilter = new PartitionValueFilter();
        partitionValueFilters.add(partitionValueFilter);
        partitionValueFilter.setLatestAfterPartitionValue(new LatestAfterPartitionValue("A"));
        partitionValueFilter.setLatestBeforePartitionValue(new LatestBeforePartitionValue("B"));
        key.setPartitionValueFilters(partitionValueFilters);
        businessObjectDataSearchKeys.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        try {
            this.businessObjectDataService.searchBusinessObjectData(request);
            Assert.fail((String)"Should not get here, as IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

