/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailability;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStatus;
import org.finra.herd.model.api.xml.LatestAfterPartitionValue;
import org.finra.herd.model.api.xml.LatestBeforePartitionValue;
import org.finra.herd.model.api.xml.PartitionValueFilter;
import org.finra.herd.model.api.xml.PartitionValueRange;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataServiceCheckBusinessObjectDataAvailabilityTest
extends AbstractServiceTest {
    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueList() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListStandalonePartitionValueFilter() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setPartitionValueFilter((PartitionValueFilter)request.getPartitionValueFilters().get(0));
        request.setPartitionValueFilters(null);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueRange() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("2014-04-02", "2014-04-08");
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, PROCESS_DATE_AVAILABLE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, PROCESS_DATE_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("2014-04-02", "2014-04-02");
        resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, Arrays.asList("2014-04-02"), NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, null, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLatestBeforePartitionValue() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String upperBoundPartitionValue : Arrays.asList(PARTITION_VALUE, PARTITION_VALUE_2)) {
            BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(upperBoundPartitionValue), NO_LATEST_AFTER_PARTITION_VALUE)), null, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
            Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(upperBoundPartitionValue), NO_LATEST_AFTER_PARTITION_VALUE)), null, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLatestAfterPartitionValue() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String lowerBoundPartitionValue : Arrays.asList(PARTITION_VALUE, PARTITION_VALUE_2)) {
            BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(lowerBoundPartitionValue))), null, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
            Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(lowerBoundPartitionValue))), null, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityMissingRequiredParameters() {
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectDefinitionName("      \t\t ");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectFormatUsage("      \t\t ");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectFormatFileType("      \t\t ");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey("      \t\t ");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key is not specified in one of the partition value filters.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("      \t\t ", "2014-04-08");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when start partition values is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A start partition value for the partition value range must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("2014-04-02", "      \t\t ");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when end partition values is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An end partition value for the partition value range must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(new ArrayList<String>());
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value list has no partition values specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one partition value must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add("      \t\t ");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when one of the partition values in the partition value list is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(NO_PARTITION_VALUES);
        for (String partitionValue : Arrays.asList(null, "      \t\t ")) {
            ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setLatestBeforePartitionValue(new LatestBeforePartitionValue(partitionValue));
            try {
                this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
                Assert.fail((String)"Should throw an IllegalArgumentException when the latest before partition value filter option has no partition value specified.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
            }
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(NO_PARTITION_VALUES);
        for (String partitionValue : Arrays.asList(null, "      \t\t ")) {
            ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setLatestAfterPartitionValue(new LatestAfterPartitionValue(partitionValue));
            try {
                this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
                Assert.fail((String)"Should throw an IllegalArgumentException when the latest after partition value filter option has no partition value specified.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
            }
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName("      \t\t ");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when standalone storage name parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName(null);
        request.setStorageNames(Arrays.asList("      \t\t "));
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name parameter in the list of storage names is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityMissingOptionalParameters() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null, this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), 1, NO_SUBPARTITION_VALUES, NO_ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectFormatVersion(null);
        request.setBusinessObjectDataVersion(null);
        request.setStorageName(null);
        request.setIncludeAllRegisteredSubPartitions(null);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, MULTI_STORAGE_AVAILABLE_PARTITION_VALUES_UNION, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(null, 1, MULTI_STORAGE_NOT_AVAILABLE_PARTITION_VALUES, null, null, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityMissingOptionalParametersStandalonePartitionValueFilter() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null, this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), 1, NO_SUBPARTITION_VALUES, NO_ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setPartitionValueFilter((PartitionValueFilter)request.getPartitionValueFilters().get(0));
        request.setPartitionValueFilters(null);
        request.setBusinessObjectFormatVersion(null);
        request.getPartitionValueFilter().setPartitionKey("      \t\t ");
        request.setBusinessObjectDataVersion(null);
        request.setStorageName(null);
        request.setIncludeAllRegisteredSubPartitions(null);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, MULTI_STORAGE_AVAILABLE_PARTITION_VALUES_UNION, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(null, 1, MULTI_STORAGE_NOT_AVAILABLE_PARTITION_VALUES, null, null, "NOT_REGISTERED", true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityMissingFormatVersion() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectFormatVersion(null);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(null, 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLatestBeforePartitionValueNoStorage() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String upperBoundPartitionValue : Arrays.asList(PARTITION_VALUE, PARTITION_VALUE_2)) {
            BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(upperBoundPartitionValue), NO_LATEST_AFTER_PARTITION_VALUE)), null, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
            Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(upperBoundPartitionValue), NO_LATEST_AFTER_PARTITION_VALUE)), null, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLatestAfterPartitionValueNoStorage() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String lowerBoundPartitionValue : Arrays.asList(PARTITION_VALUE, PARTITION_VALUE_2)) {
            BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(lowerBoundPartitionValue))), null, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
            Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(lowerBoundPartitionValue))), null, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityTrimParametersPartitionValueList() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectDefinitionName(this.addWhitespace(request.getBusinessObjectDefinitionName()));
        request.setBusinessObjectFormatUsage(this.addWhitespace(request.getBusinessObjectFormatUsage()));
        request.setBusinessObjectFormatFileType(this.addWhitespace(request.getBusinessObjectFormatFileType()));
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(this.addWhitespace(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey()));
        for (int i = 0; i < ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().size(); ++i) {
            ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().set(i, this.addWhitespace((String)((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().get(i)));
        }
        request.setStorageName(this.addWhitespace(request.getStorageName()));
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityTrimParametersPartitionValueRange() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(this.addWhitespace("2014-04-02"), this.addWhitespace("2014-04-08"));
        request.setBusinessObjectDefinitionName(this.addWhitespace(request.getBusinessObjectDefinitionName()));
        request.setBusinessObjectFormatUsage(this.addWhitespace(request.getBusinessObjectFormatUsage()));
        request.setBusinessObjectFormatFileType(this.addWhitespace(request.getBusinessObjectFormatFileType()));
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(this.addWhitespace(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey()));
        request.setStorageName(this.addWhitespace(request.getStorageName()));
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, PROCESS_DATE_AVAILABLE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, PROCESS_DATE_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityUpperCaseParameters() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectDefinitionName(request.getBusinessObjectDefinitionName().toUpperCase());
        request.setBusinessObjectFormatUsage(request.getBusinessObjectFormatUsage().toUpperCase());
        request.setBusinessObjectFormatFileType(request.getBusinessObjectFormatFileType().toUpperCase());
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey().toUpperCase());
        request.setStorageName(request.getStorageName().toUpperCase());
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLowerCaseParameters() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectDefinitionName(request.getBusinessObjectDefinitionName().toLowerCase());
        request.setBusinessObjectFormatUsage(request.getBusinessObjectFormatUsage().toLowerCase());
        request.setBusinessObjectFormatFileType(request.getBusinessObjectFormatFileType().toLowerCase());
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey().toLowerCase());
        request.setStorageName(request.getStorageName().toLowerCase());
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityInvalidParameters() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectDefinitionName("I_DO_NOT_EXIST");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing business object format is used.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey("I_DO_NOT_EXIST");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when non-existing partition key is used.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The partition key \"%s\" does not exist in first %d partition columns in the schema for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey(), 5, request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setPartitionValueFilter(new PartitionValueFilter("PRTN_CLMN001".toUpperCase(), new ArrayList(UNSORTED_PARTITION_VALUES), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when both a list of partition value filters and a standalone partition value filter are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A list of partition value filters and a standalone partition value filter cannot be both specified.", (Object)e.getMessage());
        }
        for (PartitionValueFilter partitionValueFilter : this.businessObjectDataServiceTestHelper.getInvalidPartitionValueFilters()) {
            request = new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(partitionValueFilter), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS);
            try {
                this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
                Assert.fail((String)"Should throw an IllegalArgumentException when partition value filter has more than one partition value filter option.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"Exactly one partition value filter option must be specified.", (Object)e.getMessage());
            }
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("${maximum.partition.value}", "2014-04-08");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified with a partition value range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified with a partition value range.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("${minimum.partition.value}", "2014-04-08");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified with a partition value range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified with a partition value range.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("2014-04-02", "${maximum.partition.value}");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified with a partition value range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified with a partition value range.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("2014-04-08", "${minimum.partition.value}");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified with a partition value range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified with a partition value range.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("2014-04-08", "2014-04-02");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when start partition value which is greater than the end partition value.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The start partition value \"%s\" cannot be greater than the end partition value \"%s\".", "2014-04-08", "2014-04-02"), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName("      \t\t ");
        request.setStorageNames(STORAGE_NAMES);
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when both a list of storage names and standalone storage name are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A list of storage names and a standalone storage name cannot be both specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName("I_DO_NOT_EXIST");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing storage is used as a standalone storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getStorageName()), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName(null);
        request.setStorageNames(Arrays.asList("I_DO_NOT_EXIST"));
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing storage is used in the list of storage names.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getStorageNames().get(0)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityTwoPartitionValueRanges() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001", null, new PartitionValueRange("2014-04-02", "2014-04-08"), NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001", null, new PartitionValueRange("2014-04-02", "2014-04-08"), NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when more than one partition value range is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Cannot specify more than one partition value range.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityInvalidPartitionKeyAndNoSchemaExists() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null, new ArrayList(), new ArrayList(), 1, NO_SUBPARTITION_VALUES, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey("I_DO_NOT_EXIST");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when non-existing partition key is used.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition key \"%s\" doesn't match configured business object format partition key \"%s\" and there is no schema defined to check subpartition columns for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey(), PARTITION_KEY, request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityDuplicatePartitionColumns() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001".toUpperCase(), new ArrayList(UNSORTED_PARTITION_VALUES), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001".toLowerCase(), new ArrayList(UNSORTED_PARTITION_VALUES), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value filters use duplicate partition columns.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Partition value filters specify duplicate partition columns.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityNoStorageUnitExists() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 0, null, null, DATA_VERSION, null, false);
        List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityNoStorageUnitExistsBdataArchived() {
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, STORAGE_PLATFORM_CODE);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_2, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("", "", "", ""), NO_DATA_VERSION, "NOT_REGISTERED"))), (Object)result);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("", "", "", ""), NO_DATA_VERSION, "NOT_REGISTERED"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityNonAvailableStorageUnitForSingleValidVersion() {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailabilityRequest request = new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "VALID")), NO_NOT_AVAILABLE_STATUSES), (Object)result);
        storageUnitEntity.setStatus(this.storageUnitStatusDaoTestHelper.createStorageUnitStatusEntity(STORAGE_UNIT_STATUS, DESCRIPTION, NO_STORAGE_UNIT_STATUS_AVAILABLE_FLAG_SET));
        this.herdDao.saveAndRefresh((Object)storageUnitEntity);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "NO_ENABLED_STORAGE_UNIT"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityNonAvailableStorageUnitForSecondValidVersion() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), INITIAL_DATA_VERSION, NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), SECOND_DATA_VERSION, NO_LATEST_VERSION_FLAG_SET, "VALID", "DISABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), INITIAL_DATA_VERSION, "VALID")), NO_NOT_AVAILABLE_STATUSES), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityAvailableStorageUnitBdataArchived() {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        StorageEntity glacierStorageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity, storageUnitEntity.getBusinessObjectData(), this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"), NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "VALID")), NO_NOT_AVAILABLE_STATUSES), (Object)result);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "VALID")), NO_NOT_AVAILABLE_STATUSES), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityNonAvailableStorageUnitBdataArchived() {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "DISABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "NO_ENABLED_STORAGE_UNIT"))), (Object)result);
        StorageEntity glacierStorageEntity1 = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        StorageEntity glacierStorageEntity2 = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3, "GLACIER");
        StorageUnitEntity glacierStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity1, storageUnitEntity.getBusinessObjectData(), this.storageUnitStatusDao.getStorageUnitStatusByCode("DISABLED"), NO_STORAGE_DIRECTORY_PATH);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "NO_ENABLED_STORAGE_UNIT"))), (Object)result);
        glacierStorageUnitEntity.setStatus(this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"));
        this.herdDao.saveAndRefresh((Object)glacierStorageUnitEntity);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "ARCHIVED"))), (Object)result);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "ARCHIVED"))), (Object)result);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity2, storageUnitEntity.getBusinessObjectData(), "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "ARCHIVED"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityGlacierStorageOnly() {
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "GLACIER");
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, DESCRIPTION, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("", "", "", ""), NO_DATA_VERSION, "NOT_REGISTERED"))), (Object)result);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("", "", "", ""), NO_DATA_VERSION, "NOT_REGISTERED"))), (Object)result);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "DISABLED", NO_STORAGE_DIRECTORY_PATH);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "NO_ENABLED_STORAGE_UNIT"))), (Object)result);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("", "", "", ""), NO_DATA_VERSION, "NOT_REGISTERED"))), (Object)result);
        storageUnitEntity.setStatus(this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"));
        this.herdDao.saveAndRefresh((Object)storageUnitEntity);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "ARCHIVED"))), (Object)result);
        result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_AVAILABLE_STATUSES, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("", "", "", ""), NO_DATA_VERSION, "NOT_REGISTERED"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityBusinessObjectDataNotAvailableNoValidStatus() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(PARTITION_KEY, Arrays.asList(PARTITION_VALUE));
        request.setBusinessObjectDataVersion(null);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        BusinessObjectDataStatus expectedNotAvailableStatus = new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, BDATA_STATUS);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, NO_BUSINESS_OBJECT_DATA_STATUSES, Arrays.asList(expectedNotAvailableStatus), resultAvailability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueRangeMaxValuesExceeded() throws Exception {
        Integer testMaxAllowedPartitionValues = 1;
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("2014-04-02", "2014-04-08");
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.AVAILABILITY_DDL_MAX_PARTITION_VALUES.getKey(), testMaxAllowedPartitionValues.toString());
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when the maximum allowed number of partition values have been exceeded.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The number of partition values (5) exceeds the system limit of %d.", testMaxAllowedPartitionValues), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueRangeFormatWithoutPartitionKeyGroup() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest("2014-04-02", "2014-04-08");
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when checking availability using partition value range and business object format has no partition key group.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A partition key group, which is required to use partition value ranges, is not specified for the business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueRangeExpectedPartitionValueMatchesMaxPartitionValueToken() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(PARTITION_KEY_GROUP);
        String startPartitionValue = "${maximum.partition.value}".replace("maximum", "a");
        String endPartitionValue = "${maximum.partition.value}".replace("maximum", "z");
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(PARTITION_KEY_GROUP, Arrays.asList(startPartitionValue, "${maximum.partition.value}", endPartitionValue));
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(startPartitionValue, endPartitionValue);
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when expected partition value matches to the maximum partition value token.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified as one of the expected partition values.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueRangeExpectedPartitionValueMatchesMinPartitionValueToken() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(PARTITION_KEY_GROUP);
        String startPartitionValue = "${minimum.partition.value}".replace("minimum", "a");
        String endPartitionValue = "${minimum.partition.value}".replace("minimum", "z");
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(PARTITION_KEY_GROUP, Arrays.asList(startPartitionValue, "${minimum.partition.value}", endPartitionValue));
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(startPartitionValue, endPartitionValue);
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when expected partition value matches to the minimum partition value token.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified as one of the expected partition values.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityFilterOnSubPartitionValues() {
        List columns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        for (int i = 0; i < Math.min(5, PARTITION_COLUMNS.length); ++i) {
            this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null, columns, partitionColumns, i + 1, SUBPARTITION_VALUES, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
            BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
            ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(((SchemaColumn)partitionColumns.get(i)).getName());
            BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, i + 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
            List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, i + 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false);
            this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityFilterOnSubPartitionValuesStandalonePartitionValueFilter() {
        List columns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        for (int i = 0; i < Math.min(5, PARTITION_COLUMNS.length); ++i) {
            this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null, columns, partitionColumns, i + 1, SUBPARTITION_VALUES, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
            BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
            request.setPartitionValueFilter((PartitionValueFilter)request.getPartitionValueFilters().get(0));
            request.setPartitionValueFilters(null);
            request.getPartitionValueFilter().setPartitionKey(((SchemaColumn)partitionColumns.get(i)).getName());
            BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
            List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, i + 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
            List<BusinessObjectDataStatus> expectedNotAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, i + 1, STORAGE_1_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", true);
            this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLargePartitionValueListPrimaryPartitionOnly() {
        int PRIMARY_PARTITION_VALUES_SIZE = 10000;
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        ArrayList<String> partitionValues = new ArrayList<String>();
        for (int i = 0; i < 10000; ++i) {
            partitionValues.add(String.format("%s-%s", PARTITION_VALUE, i));
        }
        partitionValues.addAll(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(partitionValues);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        Assert.assertNotNull((Object)resultAvailability);
        Assert.assertEquals((long)STORAGE_1_AVAILABLE_PARTITION_VALUES.size(), (long)resultAvailability.getAvailableStatuses().size());
        Assert.assertEquals((long)(partitionValues.size() - STORAGE_1_AVAILABLE_PARTITION_VALUES.size()), (long)resultAvailability.getNotAvailableStatuses().size());
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityMultiplePartitionValueFilters() {
        int PRIMARY_PARTITION_VALUES_SIZE = 5;
        String[][] subPartitionValues = new String[][]{{null, null, null, null}, {"A", null, null, null}, {"A", "X", null, null}, {"A", "X", "0", null}, {"A", "X", "0", "0"}, {"A", "X", "0", "1"}, {"A", "X", "1", "0"}, {"A", "X", "1", "1"}, {"A", "Y", "0", "0"}, {"A", "Y", "0", "1"}, {"A", "Y", "1", "0"}, {"A", "Y", "1", "1"}};
        String[] secondStorageSubPartitionValues = new String[]{"A", "X", "2", "2"};
        List columns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, partitionKey, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", columns, partitionColumns);
        List<StorageEntity> storageEntities = Arrays.asList(this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME), this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2));
        ArrayList<String> primaryPartitionValues = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            BusinessObjectDataEntity businessObjectDataEntity;
            String primaryPartitionValue = String.format("%s-%s", PARTITION_VALUE, i);
            primaryPartitionValues.add(primaryPartitionValue);
            for (String[] subPartitionValuesSet : subPartitionValues) {
                businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, Arrays.asList(subPartitionValuesSet), DATA_VERSION, Boolean.valueOf(true), "VALID");
                this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntities.get(0), businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
            }
            businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, Arrays.asList(secondStorageSubPartitionValues), DATA_VERSION, Boolean.valueOf(true), "VALID");
            this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntities.get(1), businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        }
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(null);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter(((SchemaColumn)partitionColumns.get(0)).getName(), primaryPartitionValues, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        partitionValueFilters.add(new PartitionValueFilter(((SchemaColumn)partitionColumns.get(1)).getName(), Arrays.asList("A"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        partitionValueFilters.add(new PartitionValueFilter(((SchemaColumn)partitionColumns.get(2)).getName(), Arrays.asList("X", "Y"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        partitionValueFilters.add(new PartitionValueFilter(((SchemaColumn)partitionColumns.get(3)).getName(), Arrays.asList("0", "1"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        partitionValueFilters.add(new PartitionValueFilter(((SchemaColumn)partitionColumns.get(4)).getName(), Arrays.asList("0", "1"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        request.setBusinessObjectFormatVersion(null);
        request.setBusinessObjectDataVersion(null);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        Assert.assertNotNull((Object)resultAvailability);
        Assert.assertEquals((long)40L, (long)resultAvailability.getAvailableStatuses().size());
        Assert.assertEquals((long)0L, (long)resultAvailability.getNotAvailableStatuses().size());
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListMaxPartitionValueToken() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(null);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList("${maximum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, Arrays.asList(STORAGE_1_GREATEST_PARTITION_VALUE), NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        ArrayList<BusinessObjectDataStatus> expectedNotAvailableStatuses = new ArrayList<BusinessObjectDataStatus>();
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListMaxPartitionValueTokenWhenLatestDataVersionInvalid() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, SECOND_DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList("${maximum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, INITIAL_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList("${maximum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, INITIAL_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, "INVALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
        resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList("${maximum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList("${maximum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListMaxPartitionValueTokenNoStorage() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(NO_PARTITION_KEY_GROUP, this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), 1, NO_SUBPARTITION_VALUES, NO_ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(null);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList("${maximum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        request.setStorageNames(NO_STORAGE_NAMES);
        request.setStorageName(NO_STORAGE_NAME);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, Arrays.asList(STORAGE_1_GREATEST_PARTITION_VALUE), NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        ArrayList<BusinessObjectDataStatus> expectedNotAvailableStatuses = new ArrayList<BusinessObjectDataStatus>();
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListMinPartitionValueToken() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(null);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList("${minimum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, Arrays.asList(STORAGE_1_LEAST_PARTITION_VALUE), NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        ArrayList<BusinessObjectDataStatus> expectedNotAvailableStatuses = new ArrayList<BusinessObjectDataStatus>();
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListMinPartitionValueTokenWhenLatestDataVersionInvalid() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, SECOND_DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList("${minimum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, INITIAL_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList("${minimum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, INITIAL_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, "INVALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
        resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList("${minimum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList("${minimum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListMinPartitionValueTokenNoStorage() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(NO_PARTITION_KEY_GROUP, this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), 1, NO_SUBPARTITION_VALUES, NO_ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(null);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList("${minimum.partition.value}"), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        request.setStorageNames(NO_STORAGE_NAMES);
        request.setStorageName(NO_STORAGE_NAME);
        BusinessObjectDataAvailability resultAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        List<BusinessObjectDataStatus> expectedAvailableStatuses = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, Arrays.asList(STORAGE_1_LEAST_PARTITION_VALUE), NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false);
        ArrayList<BusinessObjectDataStatus> expectedNotAvailableStatuses = new ArrayList<BusinessObjectDataStatus>();
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataAvailability(request, expectedAvailableStatuses, expectedNotAvailableStatuses, resultAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListPartitionValueTokensMissingOptionalParameters() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(NO_PARTITION_KEY_GROUP, this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), 1, NO_SUBPARTITION_VALUES, NO_ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
        BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add("${maximum.partition.value}");
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add("${minimum.partition.value}");
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add("${maximum.partition.value}");
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add("${minimum.partition.value}");
        request.setBusinessObjectFormatVersion(null);
        request.setBusinessObjectDataVersion(null);
        request.setStorageNames(NO_STORAGE_NAMES);
        request.setStorageName(NO_STORAGE_NAME);
        BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, request.getPartitionValueFilters(), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, MULTI_STORAGE_AVAILABLE_PARTITION_VALUES_UNION, NO_SUBPARTITION_VALUES, DATA_VERSION, "VALID", false), this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(NO_FORMAT_VERSION, 1, MULTI_STORAGE_NOT_AVAILABLE_PARTITION_VALUES, null, NO_DATA_VERSION, "NOT_REGISTERED", false)), (Object)resultBusinessObjectDataAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityPartitionValueListPartitionValueTokensNoPartitionValueExists() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        for (String partitionValueToken : Arrays.asList("${maximum.partition.value}", "${minimum.partition.value}")) {
            BusinessObjectDataAvailabilityRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityRequest(null);
            ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
            request.setPartitionValueFilters(partitionValueFilters);
            partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN002", Arrays.asList(partitionValueToken), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
            try {
                this.businessObjectDataService.checkBusinessObjectDataAvailability(request);
                Assert.fail((String)"Suppose to throw an ObjectNotFoundException when failed to find a maximum partition value.");
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)String.format("Failed to find %s partition value for partition key = \"%s\" due to no available business object data in \"%s\" storage(s) that is registered using that partition. Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataVersion: %d}", partitionValueToken.equals("${maximum.partition.value}") ? "maximum" : "minimum", "PRTN_CLMN002", STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, DATA_VERSION), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLatestBeforePartitionValueNoExists() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(PARTITION_VALUE), NO_LATEST_AFTER_PARTITION_VALUE)), null, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when failed to find the latest before partition value.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Failed to find partition value which is the latest before partition value = \"%s\" for partition key = \"%s\" due to no available business object data in \"%s\" storage that satisfies the search criteria. Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataVersion: %d}", PARTITION_VALUE, PARTITION_KEY, STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLatestBeforePartitionValueWhenLatestDataVersionInvalid() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, SECOND_DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(PARTITION_VALUE_3), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, INITIAL_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(PARTITION_VALUE_3), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, INITIAL_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, "INVALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
        resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(PARTITION_VALUE_3), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(PARTITION_VALUE_3), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLatestAfterPartitionValueNoExists() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(PARTITION_VALUE_2))), null, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when failed to find the latest after partition value.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Failed to find partition value which is the latest after partition value = \"%s\" for partition key = \"%s\" due to no available business object data in \"%s\" storage that satisfies the search criteria. Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataVersion: %d}", PARTITION_VALUE_2, PARTITION_KEY, STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityLatestAfterPartitionValueWhenLatestDataVersionInvalid() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, SECOND_DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_3, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(PARTITION_VALUE))), NO_STANDALONE_PARTITION_VALUE_FILTER, INITIAL_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(PARTITION_VALUE))), NO_STANDALONE_PARTITION_VALUE_FILTER, INITIAL_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE_3, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, "INVALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
        resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(PARTITION_VALUE))), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(PARTITION_VALUE))), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityMultipleStorages() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null, new ArrayList(), new ArrayList(), 1, SUBPARTITION_VALUES, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
        BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, UNSORTED_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), null, DATA_VERSION, STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, UNSORTED_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), null, DATA_VERSION, STORAGE_NAMES, NO_STORAGE_NAME, this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, MULTI_STORAGE_AVAILABLE_PARTITION_VALUES_UNION, SUBPARTITION_VALUES, DATA_VERSION, "VALID", false), this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataStatuses(FORMAT_VERSION, 1, MULTI_STORAGE_NOT_AVAILABLE_PARTITION_VALUES, null, DATA_VERSION, "NOT_REGISTERED", false)), (Object)resultBusinessObjectDataAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityNoStorageNamesAndSameBusinessObjectDataInMultipleStorages() {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null, new ArrayList(), new ArrayList(), 1, SUBPARTITION_VALUES, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA.booleanValue());
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, UNSORTED_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), null, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an IllegalArgumentException when business object data registered in more than one storage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Found business object data registered in more than one storage. Please specify storage(s) in the request to resolve this. Business object data {%s}", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, (String)MULTI_STORAGE_AVAILABLE_PARTITION_VALUES_INTERSECTION.get(0), SUBPARTITION_VALUES, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityNoStorageNamesAndMultipleValidBusinessObjectFormatVersionsInDifferentStorage() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, DESCRIPTION, NO_LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, DESCRIPTION, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        List<BusinessObjectDataKey> businessObjectDataKeys = Arrays.asList(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKeys.get(0), NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_2, businessObjectDataKeys.get(1), NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(SECOND_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityNoStorageNamesAndMultipleValidBusinessObjectDataVersionsInDifferentStorage() {
        List<BusinessObjectDataKey> businessObjectDataKeys = Arrays.asList(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION), new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, SECOND_DATA_VERSION));
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKeys.get(0), NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_2, businessObjectDataKeys.get(1), NO_LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability resultBusinessObjectDataAvailability = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, SECOND_DATA_VERSION, "VALID")), new ArrayList()), (Object)resultBusinessObjectDataAvailability);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionValid() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID"), new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, "VALID")), NO_NOT_AVAILABLE_STATUSES), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionDeleted() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "DELETED", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID")), NO_NOT_AVAILABLE_STATUSES), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionInvalid() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID")), Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, "INVALID"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionValidNonAvailableStorageUnit() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "DISABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID")), Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, "NO_ENABLED_STORAGE_UNIT"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionValidNonAvailableStorageUnitBdataArchived() {
        List<StorageUnitEntity> storageUnitEntities = Arrays.asList(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH), this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        StorageEntity glacierStorageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity, storageUnitEntities.get(1).getBusinessObjectData(), this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"), NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID")), Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, "ARCHIVED"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionInvalidBdataArchived() {
        List<StorageUnitEntity> storageUnitEntities = Arrays.asList(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH), this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "INVALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH));
        StorageEntity glacierStorageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity, storageUnitEntities.get(1).getBusinessObjectData(), this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"), NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID")), Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, "INVALID"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionInvalidNonAvailableStorageUnitBdataArchived() {
        List<StorageUnitEntity> storageUnitEntities = Arrays.asList(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH), this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        StorageEntity glacierStorageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity, storageUnitEntities.get(1).getBusinessObjectData(), this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"), NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID")), Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, "ARCHIVED"))), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionDeletedBdataArchived() {
        List<StorageUnitEntity> storageUnitEntities = Arrays.asList(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH), this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "DELETED", "ENABLED", NO_STORAGE_DIRECTORY_PATH));
        StorageEntity glacierStorageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity, storageUnitEntities.get(1).getBusinessObjectData(), this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"), NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID")), NO_NOT_AVAILABLE_STATUSES), (Object)result);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityIncludeAllRegisteredSubPartitionsSecondSubPartitionDeletedNonAvailableStorageUnitBdataArchived() {
        List<StorageUnitEntity> storageUnitEntities = Arrays.asList(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH), this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_2), DATA_VERSION, LATEST_VERSION_FLAG_SET, "DELETED", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        StorageEntity glacierStorageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity, storageUnitEntities.get(1).getBusinessObjectData(), this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"), NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataAvailability result = this.businessObjectDataService.checkBusinessObjectDataAvailability(new BusinessObjectDataAvailabilityRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, INCLUDE_ALL_REGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataAvailability(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION, "VALID")), NO_NOT_AVAILABLE_STATUSES), (Object)result);
    }
}

