/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BusinessObjectDataServiceDeleteBusinessObjectDataTest
extends AbstractServiceTest {
    private static final String testS3KeyPrefix = BusinessObjectDataServiceDeleteBusinessObjectDataTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, INITIAL_DATA_VERSION);
    private Path localTempPath;

    @Before
    public void setupEnv() throws IOException {
        this.localTempPath = Files.createTempDirectory(null, new FileAttribute[0]);
    }

    @After
    public void cleanEnv() throws IOException {
        FileUtils.deleteDirectory((File)this.localTempPath.toFile());
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        for (String keyPrefix : Arrays.asList(testS3KeyPrefix, TEST_S3_KEY_PREFIX)) {
            s3FileTransferRequestParamsDto.setS3KeyPrefix(keyPrefix + "/");
            this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
        }
    }

    @Test
    public void testDeleteBusinessObjectData() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION), Boolean.valueOf(false));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    @Test
    public void testDeleteBusinessObjectDataMissingRequiredParameters() {
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t ", (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when 1st subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), "      \t\t ", (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when 2nd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), "      \t\t ", (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when 3rd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), "      \t\t "), DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when 4th subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), null);
            Assert.fail((String)"Should throw an IllegalArgumentException when delete files flag is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A delete files flag must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataMissingOptionalParameters() throws Exception {
        for (int i = 0; i <= 4; ++i) {
            List<String> subPartitionValues = SUBPARTITION_VALUES.subList(0, i);
            BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
            BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION);
            Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
            BusinessObjectData deletedBusinessObjectData = null;
            switch (i) {
                case 0: {
                    deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
                    break;
                }
                case 1: {
                    deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)subPartitionValues.get(0)), DATA_VERSION), Boolean.valueOf(false));
                    break;
                }
                case 2: {
                    deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)subPartitionValues.get(0), subPartitionValues.get(1)), DATA_VERSION), Boolean.valueOf(false));
                    break;
                }
                case 3: {
                    deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)subPartitionValues.get(0), subPartitionValues.get(1), subPartitionValues.get(2)), DATA_VERSION), Boolean.valueOf(false));
                    break;
                }
                case 4: {
                    deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
                }
            }
            this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
            Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        }
    }

    @Test
    public void testDeleteBusinessObjectDataTrimParameters() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION), Boolean.valueOf(false));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    @Test
    public void testDeleteBusinessObjectDataUpperCaseParameters() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS.toLowerCase());
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION), Boolean.valueOf(false));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, true, BDATA_STATUS.toLowerCase(), deletedBusinessObjectData);
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    @Test
    public void testDeleteBusinessObjectDataLowerCaseParameters() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS.toUpperCase());
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION), Boolean.valueOf(false));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, true, BDATA_STATUS.toUpperCase(), deletedBusinessObjectData);
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    @Test
    public void testDeleteBusinessObjectDataInvalidParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        for (int i = 0; i < SUBPARTITION_VALUES.size(); ++i) {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>(SUBPARTITION_VALUES);
            testSubPartitionValues.set(i, "I_DO_NOT_EXIST");
            try {
                this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION), Boolean.valueOf(false));
                Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
                continue;
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION, null), (Object)e.getMessage());
            }
        }
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataBusinessObjectDataNoExists() {
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataChildrenExist() {
        BusinessObjectDataEntity businessObjectDataParentEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataEntity businessObjectDataChildEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        businessObjectDataParentEntity.getBusinessObjectDataChildren().add(businessObjectDataChildEntity);
        businessObjectDataChildEntity.getBusinessObjectDataParents().add(businessObjectDataParentEntity);
        try {
            this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when trying to delete a business object data that has children associated with it.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Can not delete a business object data that has children associated with it. Business object data: {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES.get(0), SUBPARTITION_VALUES.get(1), SUBPARTITION_VALUES.get(2), SUBPARTITION_VALUES.get(3), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataNotLatestVersion() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(false), BDATA_STATUS);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), Boolean.valueOf(false));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, false, BDATA_STATUS, deletedBusinessObjectData);
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    @Test
    public void testDeleteBusinessObjectDataLatestVersionWhenPreviousVersionExists() {
        BusinessObjectDataEntity initialVersionBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, Boolean.valueOf(false), BDATA_STATUS);
        BusinessObjectDataEntity latestVersionBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, SECOND_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        Assert.assertFalse((boolean)initialVersionBusinessObjectDataEntity.getLatestVersion());
        Assert.assertTrue((boolean)latestVersionBusinessObjectDataEntity.getLatestVersion());
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, SECOND_DATA_VERSION), Boolean.valueOf(false));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(latestVersionBusinessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, SECOND_DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, SECOND_DATA_VERSION)));
        initialVersionBusinessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)initialVersionBusinessObjectDataEntity);
        Assert.assertTrue((boolean)initialVersionBusinessObjectDataEntity.getLatestVersion());
        deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION), Boolean.valueOf(false));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(initialVersionBusinessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION)));
    }

    @Test
    public void testDeleteBusinessObjectDataS3ManagedBucket() throws Exception {
        this.createTestDatabaseEntities("S3_MANAGED", "S3", testS3KeyPrefix, LOCAL_FILES);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, LOCAL_FILES);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, new ArrayList(), INITIAL_DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey);
        Assert.assertNotNull((Object)businessObjectDataEntity);
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION), Boolean.valueOf(true));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
        S3FileTransferRequestParamsDto params = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        params.setS3KeyPrefix(testS3KeyPrefix);
        Assert.assertTrue((boolean)this.s3Dao.listDirectory(params).isEmpty());
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    @Test
    public void testDeleteBusinessObjectDataS3NonManagedBucketDeletingDirectory() throws Exception {
        this.createTestDatabaseEntities(STORAGE_NAME, "S3", TEST_S3_KEY_PREFIX, new ArrayList<String>());
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(TEST_S3_KEY_PREFIX, this.localTempPath, LOCAL_FILES);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey);
        Assert.assertNotNull((Object)businessObjectDataEntity);
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION), Boolean.valueOf(true));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
        S3FileTransferRequestParamsDto params = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        params.setS3KeyPrefix(TEST_S3_KEY_PREFIX);
        Assert.assertTrue((boolean)this.s3Dao.listDirectory(params).isEmpty());
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    @Test
    public void testDeleteBusinessObjectDataS3NonManagedBucketDeletingListOfFiles() throws Exception {
        this.createTestDatabaseEntities(STORAGE_NAME, "S3", TEST_S3_KEY_PREFIX, LOCAL_FILES);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(TEST_S3_KEY_PREFIX, this.localTempPath, LOCAL_FILES_SUBSET);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey);
        Assert.assertNotNull((Object)businessObjectDataEntity);
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION), Boolean.valueOf(true));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
        S3FileTransferRequestParamsDto params = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        params.setS3KeyPrefix(TEST_S3_KEY_PREFIX);
        Assert.assertTrue((boolean)this.s3Dao.listDirectory(params).isEmpty());
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    @Test
    public void testDeleteBusinessObjectDataNonS3StoragePlatform() throws Exception {
        this.createTestDatabaseEntities(STORAGE_NAME, STORAGE_PLATFORM_CODE, testS3KeyPrefix, LOCAL_FILES);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey);
        Assert.assertNotNull((Object)businessObjectDataEntity);
        BusinessObjectData deletedBusinessObjectData = this.businessObjectDataService.deleteBusinessObjectData(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION), Boolean.valueOf(true));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, deletedBusinessObjectData);
        Assert.assertNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
    }

    private void createTestDatabaseEntities(String storageName, String storagePlatform, String directoryPath, List<String> localFiles) throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        StorageEntity storageEntity = this.storageDao.getStorageByName(storageName);
        if (storageEntity == null) {
            storageEntity = this.storageDaoTestHelper.createStorageEntity(storageName, storagePlatform, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), this.storageDaoTestHelper.getS3ManagedBucketName());
        }
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", directoryPath);
        for (String fileLocalPath : localFiles) {
            this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, String.format("%s/%s", directoryPath, fileLocalPath), Long.valueOf(1024L), Long.valueOf(1000L));
        }
        this.herdDao.saveAndRefresh((Object)businessObjectDataEntity);
    }
}

