/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataServiceRestoreBusinessObjectDataTest
extends AbstractServiceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreBusinessObjectData() throws Exception {
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        try {
            for (StorageFileEntity storageFileEntity : originStorageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, storageFileEntity.getPath()), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), null);
            }
            BusinessObjectData businessObjectData = this.businessObjectDataService.restoreBusinessObjectData(businessObjectDataKey);
            this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
            Assert.assertEquals((Object)"RESTORING", (Object)originStorageUnitEntity.getStatus().getCode());
            for (StorageFileEntity storageFileEntity : originStorageUnitEntity.getStorageFiles()) {
                ObjectMetadata objectMetadata = this.s3Operations.getObjectMetadata(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, storageFileEntity.getPath()), null);
                Assert.assertTrue((boolean)objectMetadata.getOngoingRestore());
            }
        }
        finally {
            if (!this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(glacierS3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreBusinessObjectDataAmazonServiceException() throws Exception {
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        this.storageFileDaoTestHelper.createStorageFileEntity(originStorageUnitEntity, String.format("%s/%s", TEST_S3_KEY_PREFIX, "mock_s3_file_name_service_exception"), Long.valueOf(1024L), ROW_COUNT);
        try {
            for (StorageFileEntity storageFileEntity : originStorageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, storageFileEntity.getPath()), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), null);
            }
            try {
                this.businessObjectDataService.restoreBusinessObjectData(businessObjectDataKey);
                Assert.fail((String)"Should throw an IllegalStateException when an S3 restore object operation fails.");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)String.format("java.lang.IllegalStateException: Failed to initiate a restore request for \"%s/%s/%s\" key in \"%s\" bucket. Reason: InternalError (Service: null; Status Code: 0; Error Code: null; Request ID: null)", S3_BUCKET_NAME_ORIGIN, TEST_S3_KEY_PREFIX, "mock_s3_file_name_service_exception", S3_BUCKET_NAME_GLACIER), (Object)e.getMessage());
            }
            Assert.assertEquals((Object)"DISABLED", (Object)originStorageUnitEntity.getStatus().getCode());
        }
        finally {
            if (!this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(glacierS3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreBusinessObjectDataNonGlacierStorageClass() throws Exception {
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_GLACIER).s3KeyPrefix(S3_BUCKET_NAME_ORIGIN + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME_ORIGIN, businessObjectDataEntity);
        try {
            for (StorageFileEntity storageFileEntity : originStorageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Standard);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, storageFileEntity.getPath()), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), null);
            }
            BusinessObjectData businessObjectData = this.businessObjectDataService.restoreBusinessObjectData(businessObjectDataKey);
            this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
            Assert.assertEquals((Object)"RESTORING", (Object)originStorageUnitEntity.getStatus().getCode());
            for (StorageFileEntity storageFileEntity : originStorageUnitEntity.getStorageFiles()) {
                ObjectMetadata objectMetadata = this.s3Operations.getObjectMetadata(S3_BUCKET_NAME_GLACIER, String.format("%s/%s", S3_BUCKET_NAME_ORIGIN, storageFileEntity.getPath()), null);
                Assert.assertFalse((boolean)objectMetadata.getOngoingRestore());
            }
        }
        finally {
            if (!this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(glacierS3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
        }
    }
}

