/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDataAttributeDaoTestHelper;
import org.finra.herd.dao.BusinessObjectDataDaoTestHelper;
import org.finra.herd.dao.BusinessObjectDataStatusDaoTestHelper;
import org.finra.herd.dao.BusinessObjectFormatDao;
import org.finra.herd.dao.BusinessObjectFormatDaoTestHelper;
import org.finra.herd.dao.CustomDdlDaoTestHelper;
import org.finra.herd.dao.S3DaoTestHelper;
import org.finra.herd.dao.S3Operations;
import org.finra.herd.dao.SchemaColumnDaoTestHelper;
import org.finra.herd.dao.StorageDao;
import org.finra.herd.dao.StorageDaoTestHelper;
import org.finra.herd.dao.StorageFileDaoTestHelper;
import org.finra.herd.dao.StorageUnitDaoTestHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.AttributeDefinition;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailability;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityCollectionRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityCollectionResponse;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataDdl;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlCollectionRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlCollectionResponse;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlOutputFormatEnum;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStatus;
import org.finra.herd.model.api.xml.BusinessObjectDataStatusInformation;
import org.finra.herd.model.api.xml.BusinessObjectDataStatusUpdateResponse;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageFilesCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageFilesCreateResponse;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.LatestAfterPartitionValue;
import org.finra.herd.model.api.xml.LatestBeforePartitionValue;
import org.finra.herd.model.api.xml.PartitionValueFilter;
import org.finra.herd.model.api.xml.PartitionValueRange;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.api.xml.StorageDirectory;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.api.xml.StorageUnitCreateRequest;
import org.finra.herd.model.dto.BusinessObjectDataRestoreDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.S3FileTransferResultsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectDataStatusEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDefinitionServiceTestHelper;
import org.finra.herd.service.CustomDdlServiceTestHelper;
import org.finra.herd.service.S3Service;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.S3KeyPrefixHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BusinessObjectDataServiceTestHelper {
    @Autowired
    private BusinessObjectDataAttributeDaoTestHelper businessObjectDataAttributeDaoTestHelper;
    @Autowired
    private BusinessObjectDataDaoTestHelper businessObjectDataDaoTestHelper;
    @Autowired
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Autowired
    private BusinessObjectDataStatusDaoTestHelper businessObjectDataStatusDaoTestHelper;
    @Autowired
    private BusinessObjectDefinitionServiceTestHelper businessObjectDefinitionServiceTestHelper;
    @Autowired
    private BusinessObjectFormatDao businessObjectFormatDao;
    @Autowired
    private BusinessObjectFormatDaoTestHelper businessObjectFormatDaoTestHelper;
    @Autowired
    private ConfigurationHelper configurationHelper;
    @Autowired
    private CustomDdlDaoTestHelper customDdlDaoTestHelper;
    @Autowired
    private CustomDdlServiceTestHelper customDdlServiceTestHelper;
    @Autowired
    private S3DaoTestHelper s3DaoTestHelper;
    @Autowired
    private S3KeyPrefixHelper s3KeyPrefixHelper;
    @Autowired
    private S3Operations s3Operations;
    @Autowired
    private S3Service s3Service;
    @Autowired
    private SchemaColumnDaoTestHelper schemaColumnDaoTestHelper;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private StorageDaoTestHelper storageDaoTestHelper;
    @Autowired
    private StorageFileDaoTestHelper storageFileDaoTestHelper;
    @Autowired
    private StorageHelper storageHelper;
    @Autowired
    private StorageUnitDaoTestHelper storageUnitDaoTestHelper;

    public BusinessObjectDataCreateRequest createBusinessObjectDataCreateRequest(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, Integer businessObjectFormatVersion, String partitionKey, String partitionValue, String businessObjectDataStatusCode, String storageName, String storageDirectoryPath, List<StorageFile> storageFiles) {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = new BusinessObjectDataCreateRequest();
        businessObjectDataCreateRequest.setNamespace(namespaceCode);
        businessObjectDataCreateRequest.setBusinessObjectDefinitionName(businessObjectDefinitionName);
        businessObjectDataCreateRequest.setBusinessObjectFormatUsage(businessObjectFormatUsage);
        businessObjectDataCreateRequest.setBusinessObjectFormatFileType(businessObjectFormatFileType);
        businessObjectDataCreateRequest.setBusinessObjectFormatVersion(businessObjectFormatVersion);
        businessObjectDataCreateRequest.setPartitionKey(partitionKey);
        businessObjectDataCreateRequest.setPartitionValue(partitionValue);
        businessObjectDataCreateRequest.setStatus(businessObjectDataStatusCode);
        ArrayList<StorageUnitCreateRequest> storageUnits = new ArrayList<StorageUnitCreateRequest>();
        businessObjectDataCreateRequest.setStorageUnits(storageUnits);
        StorageUnitCreateRequest storageUnit = new StorageUnitCreateRequest();
        storageUnits.add(storageUnit);
        storageUnit.setStorageName(storageName);
        if (storageDirectoryPath != null) {
            StorageDirectory storageDirectory = new StorageDirectory();
            storageUnit.setStorageDirectory(storageDirectory);
            storageDirectory.setDirectoryPath(storageDirectoryPath);
        }
        storageUnit.setStorageFiles(storageFiles);
        return businessObjectDataCreateRequest;
    }

    public void createDatabaseEntitiesForBusinessObjectDataAvailabilityCollectionTesting() {
        this.storageUnitDaoTestHelper.createStorageUnitEntity(AbstractServiceTest.STORAGE_NAME, AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.PARTITION_VALUE, AbstractServiceTest.SUBPARTITION_VALUES, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", AbstractServiceTest.NO_STORAGE_DIRECTORY_PATH);
    }

    public void createDatabaseEntitiesForBusinessObjectDataDdlTesting() {
        this.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", AbstractServiceTest.PARTITION_KEY_GROUP, 1, AbstractServiceTest.UNSORTED_PARTITION_VALUES, AbstractServiceTest.SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, AbstractServiceTest.CUSTOM_DDL_NAME, AbstractServiceTest.LATEST_VERSION_FLAG_SET, AbstractServiceTest.ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
    }

    public void createDatabaseEntitiesForBusinessObjectDataDdlTesting(String businessObjectFormatFileType, String partitionKey, String partitionKeyGroupName, int partitionColumnPosition, List<String> partitionValues, List<String> subPartitionValues, String schemaDelimiterCharacter, String schemaEscapeCharacter, String schemaNullValue, List<SchemaColumn> schemaColumns, List<SchemaColumn> partitionColumns, boolean replaceUnderscoresWithHyphens, String customDdlName, boolean generateStorageFileEntities, boolean allowDuplicateBusinessObjectData) {
        StorageEntity storageEntity2;
        StorageEntity storageEntity1;
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, businessObjectFormatFileType, AbstractServiceTest.FORMAT_VERSION));
        if (businessObjectFormatEntity == null) {
            businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, businessObjectFormatFileType, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.FORMAT_DESCRIPTION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, partitionKey, partitionKeyGroupName, AbstractServiceTest.NO_ATTRIBUTES, schemaDelimiterCharacter, schemaEscapeCharacter, schemaNullValue, schemaColumns, partitionColumns);
        }
        if (StringUtils.isNotBlank((CharSequence)customDdlName)) {
            boolean partitioned = partitionColumns != null;
            this.customDdlDaoTestHelper.createCustomDdlEntity(businessObjectFormatEntity, customDdlName, this.customDdlServiceTestHelper.getTestCustomDdl(partitioned));
        }
        if ((storageEntity1 = this.storageDao.getStorageByName(AbstractServiceTest.STORAGE_NAME)) == null) {
            storageEntity1 = this.storageDaoTestHelper.createStorageEntity(AbstractServiceTest.STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), AbstractServiceTest.S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end")));
        }
        if ((storageEntity2 = this.storageDao.getStorageByName(AbstractServiceTest.STORAGE_NAME_2)) == null) {
            storageEntity2 = this.storageDaoTestHelper.createStorageEntity(AbstractServiceTest.STORAGE_NAME_2, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), AbstractServiceTest.S3_BUCKET_NAME_2), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end")));
        }
        for (String partitionValue : partitionValues) {
            StorageUnitEntity storageUnitEntity;
            BusinessObjectDataEntity businessObjectDataEntity;
            if (partitionColumnPosition == 1) {
                businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, businessObjectFormatFileType, AbstractServiceTest.FORMAT_VERSION, partitionValue, subPartitionValues, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "VALID");
            } else {
                ArrayList<String> testSubPartitionValues = new ArrayList<String>(subPartitionValues);
                testSubPartitionValues.set(partitionColumnPosition - 2, partitionValue);
                businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, businessObjectFormatFileType, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.PARTITION_VALUE, testSubPartitionValues, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "VALID");
            }
            String s3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity), AbstractServiceTest.STORAGE_NAME);
            if (AbstractServiceTest.STORAGE_1_AVAILABLE_PARTITION_VALUES.contains(partitionValue) || "none".equals(partitionValue)) {
                storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity1, businessObjectDataEntity, "ENABLED", AbstractServiceTest.NO_STORAGE_DIRECTORY_PATH);
                if (generateStorageFileEntities) {
                    this.storageFileDaoTestHelper.createStorageFileEntities(storageUnitEntity, s3KeyPrefix, partitionColumns, subPartitionValues, replaceUnderscoresWithHyphens);
                } else {
                    storageUnitEntity.setDirectoryPath(s3KeyPrefix);
                }
            }
            if (!AbstractServiceTest.STORAGE_2_AVAILABLE_PARTITION_VALUES.contains(partitionValue) || !allowDuplicateBusinessObjectData && AbstractServiceTest.STORAGE_1_AVAILABLE_PARTITION_VALUES.contains(partitionValue)) continue;
            storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity2, businessObjectDataEntity, "ENABLED", AbstractServiceTest.NO_STORAGE_DIRECTORY_PATH);
            if (generateStorageFileEntities) {
                this.storageFileDaoTestHelper.createStorageFileEntities(storageUnitEntity, s3KeyPrefix, partitionColumns, subPartitionValues, replaceUnderscoresWithHyphens);
                continue;
            }
            storageUnitEntity.setDirectoryPath(s3KeyPrefix);
        }
    }

    public StorageUnitEntity createDatabaseEntitiesForBusinessObjectDataDdlTesting(String partitionValue) {
        if (partitionValue != null) {
            String s3KeyPrefix = AbstractServiceTest.getExpectedS3KeyPrefix(AbstractServiceTest.NAMESPACE, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, "PRTN_CLMN001", partitionValue, null, null, AbstractServiceTest.DATA_VERSION);
            return this.createDatabaseEntitiesForBusinessObjectDataDdlTesting(partitionValue, s3KeyPrefix);
        }
        return this.createDatabaseEntitiesForBusinessObjectDataDdlTesting(null, null);
    }

    public StorageUnitEntity createDatabaseEntitiesForBusinessObjectDataDdlTesting(String partitionValue, String s3KeyPrefix) {
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        schemaColumns.add(new SchemaColumn("PRTN_CLMN001", "DATE", AbstractServiceTest.NO_COLUMN_SIZE, AbstractServiceTest.COLUMN_REQUIRED, AbstractServiceTest.NO_COLUMN_DEFAULT_VALUE, AbstractServiceTest.NO_COLUMN_DESCRIPTION));
        schemaColumns.add(new SchemaColumn(AbstractServiceTest.COLUMN_NAME, "NUMBER", AbstractServiceTest.COLUMN_SIZE, AbstractServiceTest.NO_COLUMN_REQUIRED, AbstractServiceTest.COLUMN_DEFAULT_VALUE, AbstractServiceTest.COLUMN_DESCRIPTION));
        List partitionColumns = schemaColumns.subList(0, 1);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.FORMAT_DESCRIPTION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", AbstractServiceTest.NO_PARTITION_KEY_GROUP, AbstractServiceTest.NO_ATTRIBUTES, "|", "\\", "\\N", schemaColumns, partitionColumns);
        if (partitionValue != null) {
            BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, partitionValue, AbstractServiceTest.NO_SUBPARTITION_VALUES, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "VALID");
            StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(AbstractServiceTest.STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), AbstractServiceTest.S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end")));
            return this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", s3KeyPrefix);
        }
        return null;
    }

    public List<StorageUnitEntity> createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(List<List<String>> partitions) {
        ArrayList<StorageUnitEntity> result = new ArrayList<StorageUnitEntity>();
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        schemaColumns.add(new SchemaColumn("PRTN_CLMN001", "DATE", AbstractServiceTest.NO_COLUMN_SIZE, AbstractServiceTest.COLUMN_REQUIRED, AbstractServiceTest.NO_COLUMN_DEFAULT_VALUE, AbstractServiceTest.NO_COLUMN_DESCRIPTION));
        schemaColumns.add(new SchemaColumn("PRTN_CLMN002", "STRING", AbstractServiceTest.NO_COLUMN_SIZE, AbstractServiceTest.COLUMN_REQUIRED, AbstractServiceTest.NO_COLUMN_DEFAULT_VALUE, AbstractServiceTest.NO_COLUMN_DESCRIPTION));
        schemaColumns.add(new SchemaColumn(AbstractServiceTest.COLUMN_NAME, "NUMBER", AbstractServiceTest.COLUMN_SIZE, AbstractServiceTest.NO_COLUMN_REQUIRED, AbstractServiceTest.COLUMN_DEFAULT_VALUE, AbstractServiceTest.COLUMN_DESCRIPTION));
        List partitionColumns = schemaColumns.subList(0, 2);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.FORMAT_DESCRIPTION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", AbstractServiceTest.NO_PARTITION_KEY_GROUP, AbstractServiceTest.NO_ATTRIBUTES, "|", "\\", "\\N", schemaColumns, partitionColumns);
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(AbstractServiceTest.STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), AbstractServiceTest.S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end")));
        for (List<String> partition : partitions) {
            String s3KeyPrefix = AbstractServiceTest.getExpectedS3KeyPrefix(AbstractServiceTest.NAMESPACE, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, "PRTN_CLMN001", partition.get(0), partitionColumns.subList(1, 2).toArray(new SchemaColumn[1]), Arrays.asList(partition.get(1)).toArray(new String[1]), AbstractServiceTest.DATA_VERSION);
            BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, partition.get(0), Arrays.asList(partition.get(1)), AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "VALID");
            result.add(this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", s3KeyPrefix));
        }
        return result;
    }

    public void createDatabaseEntitiesForBusinessObjectDataSearchTesting() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.PARTITION_VALUE, AbstractServiceTest.NO_SUBPARTITION_VALUES, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "VALID");
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE_2, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.PARTITION_VALUE, AbstractServiceTest.NO_SUBPARTITION_VALUES, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "INVALID");
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(AbstractServiceTest.NAMESPACE_2, AbstractServiceTest.BDEF_NAME_2, AbstractServiceTest.FORMAT_USAGE_CODE_2, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION_2, AbstractServiceTest.PARTITION_VALUE, AbstractServiceTest.NO_SUBPARTITION_VALUES, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "INVALID");
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(AbstractServiceTest.NAMESPACE_2, AbstractServiceTest.BDEF_NAME_2, AbstractServiceTest.FORMAT_USAGE_CODE_2, AbstractServiceTest.FORMAT_FILE_TYPE_CODE_2, AbstractServiceTest.FORMAT_VERSION_2, AbstractServiceTest.PARTITION_VALUE, AbstractServiceTest.NO_SUBPARTITION_VALUES, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "VALID");
    }

    public BusinessObjectDataEntity createDatabaseEntitiesForFinalizeRestoreTesting(BusinessObjectDataKey businessObjectDataKey) {
        return this.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, AbstractServiceTest.STORAGE_NAME_ORIGIN, AbstractServiceTest.S3_BUCKET_NAME_ORIGIN, "RESTORING", AbstractServiceTest.STORAGE_NAME_GLACIER, AbstractServiceTest.S3_BUCKET_NAME_GLACIER, "ENABLED", AbstractServiceTest.S3_BUCKET_NAME_ORIGIN + "/" + AbstractServiceTest.TEST_S3_KEY_PREFIX);
    }

    public BusinessObjectDataEntity createDatabaseEntitiesForFinalizeRestoreTesting(BusinessObjectDataKey businessObjectDataKey, String originStorageName, String originBucketName, String originStorageUnitStatus, String glacierStorageName, String glacierStorageBucketName, String glacierStorageUnitStatus, String glacierStorageDirectoryPath) {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, AbstractServiceTest.LATEST_VERSION_FLAG_SET, AbstractServiceTest.BDATA_STATUS);
        StorageEntity originStorageEntity = originBucketName != null ? this.storageDaoTestHelper.createStorageEntity(originStorageName, "S3", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), originBucketName) : this.storageDaoTestHelper.createStorageEntity(originStorageName, "S3");
        StorageEntity glacierStorageEntity = glacierStorageBucketName != null ? this.storageDaoTestHelper.createStorageEntity(glacierStorageName, "GLACIER", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), glacierStorageBucketName) : this.storageDaoTestHelper.createStorageEntity(glacierStorageName, "GLACIER");
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(originStorageEntity, businessObjectDataEntity, originStorageUnitStatus, AbstractServiceTest.NO_STORAGE_DIRECTORY_PATH);
        StorageUnitEntity glacierStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity, businessObjectDataEntity, glacierStorageUnitStatus, glacierStorageDirectoryPath);
        glacierStorageUnitEntity.setParentStorageUnit(originStorageUnitEntity);
        for (String relativeFilePath : AbstractServiceTest.LOCAL_FILES) {
            this.storageFileDaoTestHelper.createStorageFileEntity(originStorageUnitEntity, String.format("%s/%s", AbstractServiceTest.TEST_S3_KEY_PREFIX, relativeFilePath), Long.valueOf(1024L), AbstractServiceTest.ROW_COUNT);
        }
        return businessObjectDataEntity;
    }

    public void createDatabaseEntitiesForGetS3KeyPrefixTesting(boolean createBusinessObjectDataEntity) {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.FORMAT_DESCRIPTION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, partitionKey, AbstractServiceTest.NO_PARTITION_KEY_GROUP, AbstractServiceTest.NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns);
        this.storageDaoTestHelper.createStorageEntity(AbstractServiceTest.STORAGE_NAME, "S3", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end");
        if (createBusinessObjectDataEntity) {
            this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, AbstractServiceTest.PARTITION_VALUE, AbstractServiceTest.SUBPARTITION_VALUES, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, AbstractServiceTest.BDATA_STATUS);
        }
    }

    public BusinessObjectDataEntity createDatabaseEntitiesForInitiateRestoreTesting(BusinessObjectDataKey businessObjectDataKey) {
        return this.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, AbstractServiceTest.STORAGE_NAME_ORIGIN, AbstractServiceTest.S3_BUCKET_NAME_ORIGIN, "DISABLED", AbstractServiceTest.STORAGE_NAME_GLACIER, AbstractServiceTest.S3_BUCKET_NAME_GLACIER, "ENABLED", AbstractServiceTest.S3_BUCKET_NAME_ORIGIN + "/" + AbstractServiceTest.TEST_S3_KEY_PREFIX);
    }

    public BusinessObjectDataEntity createDatabaseEntitiesForInitiateRestoreTesting(BusinessObjectDataKey businessObjectDataKey, String originStorageName, String originBucketName, String originStorageUnitStatus, String glacierStorageName, String glacierStorageBucketName, String glacierStorageUnitStatus, String glacierStorageDirectoryPath) {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, AbstractServiceTest.LATEST_VERSION_FLAG_SET, AbstractServiceTest.BDATA_STATUS);
        StorageEntity originStorageEntity = originBucketName != null ? this.storageDaoTestHelper.createStorageEntity(originStorageName, "S3", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), originBucketName) : this.storageDaoTestHelper.createStorageEntity(originStorageName, "S3");
        StorageEntity glacierStorageEntity = glacierStorageBucketName != null ? this.storageDaoTestHelper.createStorageEntity(glacierStorageName, "GLACIER", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), glacierStorageBucketName) : this.storageDaoTestHelper.createStorageEntity(glacierStorageName, "GLACIER");
        StorageUnitEntity originStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(originStorageEntity, businessObjectDataEntity, originStorageUnitStatus, AbstractServiceTest.NO_STORAGE_DIRECTORY_PATH);
        StorageUnitEntity glacierStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(glacierStorageEntity, businessObjectDataEntity, glacierStorageUnitStatus, glacierStorageDirectoryPath);
        glacierStorageUnitEntity.setParentStorageUnit(originStorageUnitEntity);
        for (String relativeFilePath : AbstractServiceTest.LOCAL_FILES) {
            this.storageFileDaoTestHelper.createStorageFileEntity(originStorageUnitEntity, String.format("%s/%s", AbstractServiceTest.TEST_S3_KEY_PREFIX, relativeFilePath), Long.valueOf(1024L), AbstractServiceTest.ROW_COUNT);
        }
        return businessObjectDataEntity;
    }

    public void createS3Object(BusinessObjectFormatEntity businessObjectFormatEntity, BusinessObjectDataInvalidateUnregisteredRequest request, int businessObjectDataVersion) {
        StorageEntity storageEntity = this.storageDao.getStorageByName(request.getStorageName());
        String s3BucketName = this.storageHelper.getS3BucketAccessParams(storageEntity).getS3BucketName();
        BusinessObjectDataKey businessObjectDataKey = this.getBusinessObjectDataKey(request);
        businessObjectDataKey.setBusinessObjectDataVersion(Integer.valueOf(businessObjectDataVersion));
        String s3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, businessObjectDataKey, storageEntity.getName());
        String s3ObjectKey = s3KeyPrefix + "/test";
        PutObjectRequest putObjectRequest = new PutObjectRequest(s3BucketName, s3ObjectKey, (InputStream)new ByteArrayInputStream(new byte[1]), new ObjectMetadata());
        this.s3Operations.putObject(putObjectRequest, null);
    }

    public BusinessObjectDataEntity createTestValidBusinessObjectData() {
        return this.createTestValidBusinessObjectData(AbstractServiceTest.SUBPARTITION_VALUES, AbstractServiceTest.NO_ATTRIBUTE_DEFINITIONS, AbstractServiceTest.NO_ATTRIBUTES);
    }

    public BusinessObjectDataEntity createTestValidBusinessObjectData(List<String> subPartitionValues, List<AttributeDefinition> attributeDefinitions, List<Attribute> attributes) {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.PARTITION_VALUE, subPartitionValues, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "VALID");
        if (!CollectionUtils.isEmpty(attributeDefinitions)) {
            for (AttributeDefinition attributeDefinition : attributeDefinitions) {
                this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(businessObjectDataEntity.getBusinessObjectFormat(), attributeDefinition.getName(), attributeDefinition.isPublish().booleanValue());
            }
        }
        if (!CollectionUtils.isEmpty(attributes)) {
            for (Attribute attribute : attributes) {
                this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataEntity, attribute.getName(), attribute.getValue());
            }
        }
        return businessObjectDataEntity;
    }

    public BusinessObjectDataKey getBusinessObjectDataKey(BusinessObjectDataInvalidateUnregisteredRequest request) {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(request.getNamespace());
        businessObjectDataKey.setBusinessObjectDefinitionName(request.getBusinessObjectDefinitionName());
        businessObjectDataKey.setBusinessObjectFormatUsage(request.getBusinessObjectFormatUsage());
        businessObjectDataKey.setBusinessObjectFormatFileType(request.getBusinessObjectFormatFileType());
        businessObjectDataKey.setBusinessObjectFormatVersion(request.getBusinessObjectFormatVersion());
        businessObjectDataKey.setPartitionValue(request.getPartitionValue());
        businessObjectDataKey.setSubPartitionValues(request.getSubPartitionValues());
        return businessObjectDataKey;
    }

    public BusinessObjectDataAvailabilityCollectionResponse getExpectedBusinessObjectDataAvailabilityCollectionResponse() {
        BusinessObjectDataAvailabilityCollectionResponse businessObjectDataAvailabilityCollectionResponse = new BusinessObjectDataAvailabilityCollectionResponse();
        ArrayList<BusinessObjectDataAvailability> businessObjectDataAvailabilityResponses = new ArrayList<BusinessObjectDataAvailability>();
        businessObjectDataAvailabilityCollectionResponse.setBusinessObjectDataAvailabilityResponses(businessObjectDataAvailabilityResponses);
        BusinessObjectDataAvailability businessObjectDataAvailability = new BusinessObjectDataAvailability(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, Arrays.asList(AbstractServiceTest.PARTITION_VALUE), AbstractServiceTest.NO_PARTITION_VALUE_RANGE, AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE)), null, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.NO_STORAGE_NAMES, AbstractServiceTest.STORAGE_NAME, Arrays.asList(new BusinessObjectDataStatus(AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.PARTITION_VALUE, AbstractServiceTest.SUBPARTITION_VALUES, AbstractServiceTest.DATA_VERSION, "VALID")), new ArrayList());
        businessObjectDataAvailabilityResponses.add(businessObjectDataAvailability);
        businessObjectDataAvailabilityCollectionResponse.setIsAllDataAvailable(true);
        businessObjectDataAvailabilityCollectionResponse.setIsAllDataNotAvailable(false);
        return businessObjectDataAvailabilityCollectionResponse;
    }

    public String getExpectedBusinessObjectDataDdl() {
        return this.getExpectedBusinessObjectDataDdl(AbstractServiceTest.PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, AbstractServiceTest.STORAGE_1_AVAILABLE_PARTITION_VALUES, AbstractServiceTest.SUBPARTITION_VALUES, false, true, true);
    }

    public String getExpectedBusinessObjectDataDdl(int partitionLevels, String firstColumnName, String firstColumnDataType, String hiveRowFormat, String hiveFileFormat, String businessObjectFormatFileType, int partitionColumnPosition, List<String> partitionValues, List<String> subPartitionValues, boolean replaceUnderscoresWithHyphens, boolean isDropStatementIncluded, boolean isIfNotExistsOptionIncluded) {
        return this.getExpectedBusinessObjectDataDdl(partitionLevels, firstColumnName, firstColumnDataType, hiveRowFormat, hiveFileFormat, businessObjectFormatFileType, partitionColumnPosition, partitionValues, subPartitionValues, replaceUnderscoresWithHyphens, isDropStatementIncluded, isIfNotExistsOptionIncluded, AbstractServiceTest.NO_INCLUDE_DROP_PARTITIONS);
    }

    public String getExpectedBusinessObjectDataDdl(int partitionLevels, String firstColumnName, String firstColumnDataType, String hiveRowFormat, String hiveFileFormat, String businessObjectFormatFileType, int partitionColumnPosition, List<String> partitionValues, List<String> subPartitionValues, boolean replaceUnderscoresWithHyphens, boolean isDropStatementIncluded, boolean isIfNotExistsOptionIncluded, boolean isDropPartitionsStatementsIncluded) {
        StringBuilder sb = new StringBuilder();
        if (isDropStatementIncluded) {
            sb.append("DROP TABLE IF EXISTS `[Table Name]`;\n\n");
        }
        sb.append("CREATE EXTERNAL TABLE [If Not Exists]`[Table Name]` (\n");
        sb.append(String.format("    `%s` %s,\n", firstColumnName, firstColumnDataType));
        sb.append("    `COLUMN002` SMALLINT COMMENT 'This is \\'COLUMN002\\' column. ");
        sb.append("Here are \\'single\\' and \"double\" quotes along with a backslash \\.',\n");
        sb.append("    `COLUMN003` INT,\n");
        sb.append("    `COLUMN004` BIGINT,\n");
        sb.append("    `COLUMN005` FLOAT,\n");
        sb.append("    `COLUMN006` DOUBLE,\n");
        sb.append("    `COLUMN007` DECIMAL,\n");
        sb.append("    `COLUMN008` DECIMAL(p,s),\n");
        sb.append("    `COLUMN009` DECIMAL,\n");
        sb.append("    `COLUMN010` DECIMAL(p),\n");
        sb.append("    `COLUMN011` DECIMAL(p,s),\n");
        sb.append("    `COLUMN012` TIMESTAMP,\n");
        sb.append("    `COLUMN013` DATE,\n");
        sb.append("    `COLUMN014` STRING,\n");
        sb.append("    `COLUMN015` VARCHAR(n),\n");
        sb.append("    `COLUMN016` VARCHAR(n),\n");
        sb.append("    `COLUMN017` CHAR(n),\n");
        sb.append("    `COLUMN018` BOOLEAN,\n");
        sb.append("    `COLUMN019` BINARY)\n");
        if (partitionLevels > 0) {
            if (partitionLevels > 1) {
                sb.append("PARTITIONED BY (`PRTN_CLMN001` DATE, `PRTN_CLMN002` STRING, `PRTN_CLMN003` INT, `PRTN_CLMN004` DECIMAL, `PRTN_CLMN005` BOOLEAN, `PRTN_CLMN006` DECIMAL, `PRTN_CLMN007` DECIMAL)\n");
            } else {
                sb.append("PARTITIONED BY (`PRTN_CLMN001` DATE)\n");
            }
        }
        sb.append("[Row Format]\n");
        sb.append(String.format("STORED AS [Hive File Format]%s\n", partitionLevels > 0 ? ";" : ""));
        if (partitionLevels > 0) {
            if (!CollectionUtils.isEmpty(partitionValues)) {
                if (isDropPartitionsStatementsIncluded) {
                    sb.append("\n");
                    for (String partitionValue : partitionValues) {
                        sb.append(String.format("ALTER TABLE `[Table Name]` DROP IF EXISTS PARTITION (`PRTN_CLMN00%d`='%s');\n", partitionColumnPosition, partitionValue));
                    }
                }
                sb.append("\n");
                for (String partitionValue : partitionValues) {
                    if (partitionLevels > 1) {
                        String testPrimaryPartitionValue = partitionColumnPosition == 1 ? partitionValue : AbstractServiceTest.PARTITION_VALUE;
                        ArrayList<String> testSubPartitionValues = new ArrayList<String>(subPartitionValues);
                        if (partitionColumnPosition > 1) {
                            testSubPartitionValues.set(partitionColumnPosition - 2, partitionValue);
                        }
                        if (partitionLevels == AbstractServiceTest.SUBPARTITION_VALUES.size() + 1) {
                            sb.append(String.format("ALTER TABLE `[Table Name]` ADD [If Not Exists]PARTITION (`PRTN_CLMN001`='%s', `PRTN_CLMN002`='%s', `PRTN_CLMN003`='%s', `PRTN_CLMN004`='%s', `PRTN_CLMN005`='%s') LOCATION 's3n://%s/ut-namespace-1-[Random Suffix]/ut-dataprovider-1-[Random Suffix]/ut-usage[Random Suffix]/[Format File Type]/ut-businessobjectdefinition-name-1-[Random Suffix]/schm-v[Format Version]/data-v[Data Version]/prtn-clmn001=%s/prtn-clmn002=%s/prtn-clmn003=%s/prtn-clmn004=%s/prtn-clmn005=%s';\n", testPrimaryPartitionValue, testSubPartitionValues.get(0), testSubPartitionValues.get(1), testSubPartitionValues.get(2), testSubPartitionValues.get(3), this.getExpectedS3BucketName(partitionValue), testPrimaryPartitionValue, testSubPartitionValues.get(0), testSubPartitionValues.get(1), testSubPartitionValues.get(2), testSubPartitionValues.get(3)));
                            continue;
                        }
                        for (String binaryString : Arrays.asList("00", "01", "10", "11")) {
                            sb.append(String.format("ALTER TABLE `[Table Name]` ADD [If Not Exists]PARTITION (`PRTN_CLMN001`='%s', `PRTN_CLMN002`='%s', `PRTN_CLMN003`='%s', `PRTN_CLMN004`='%s', `PRTN_CLMN005`='%s', `PRTN_CLMN006`='%s', `PRTN_CLMN007`='%s') LOCATION 's3n://%s/ut-namespace-1-[Random Suffix]/ut-dataprovider-1-[Random Suffix]/ut-usage[Random Suffix]/[Format File Type]/ut-businessobjectdefinition-name-1-[Random Suffix]/schm-v[Format Version]/data-v[Data Version]/prtn-clmn001=%s/prtn-clmn002=%s/prtn-clmn003=%s/prtn-clmn004=%s/prtn-clmn005=%s/" + (replaceUnderscoresWithHyphens ? "prtn-clmn006" : "prtn_clmn006") + "=%s/" + (replaceUnderscoresWithHyphens ? "prtn-clmn007" : "prtn_clmn007") + "=%s';\n", testPrimaryPartitionValue, testSubPartitionValues.get(0), testSubPartitionValues.get(1), testSubPartitionValues.get(2), testSubPartitionValues.get(3), binaryString.substring(0, 1), binaryString.substring(1, 2), this.getExpectedS3BucketName(partitionValue), testPrimaryPartitionValue, testSubPartitionValues.get(0), testSubPartitionValues.get(1), testSubPartitionValues.get(2), testSubPartitionValues.get(3), binaryString.substring(0, 1), binaryString.substring(1, 2)));
                        }
                        continue;
                    }
                    sb.append(String.format("ALTER TABLE `[Table Name]` ADD [If Not Exists]PARTITION (`PRTN_CLMN001`='%s') LOCATION 's3n://%s/ut-namespace-1-[Random Suffix]/ut-dataprovider-1-[Random Suffix]/ut-usage[Random Suffix]/[Format File Type]/ut-businessobjectdefinition-name-1-[Random Suffix]/schm-v[Format Version]/data-v[Data Version]/prtn-clmn001=%s';\n", partitionValue, this.getExpectedS3BucketName(partitionValue), partitionValue));
                }
            }
        } else if (!CollectionUtils.isEmpty(partitionValues)) {
            sb.append(String.format("LOCATION 's3n://%s/ut-namespace-1-[Random Suffix]/ut-dataprovider-1-[Random Suffix]/ut-usage[Random Suffix]/txt/ut-businessobjectdefinition-name-1-[Random Suffix]/schm-v[Format Version]/data-v[Data Version]/partition=none';", this.getExpectedS3BucketName("none")));
        } else {
            sb.append("LOCATION '${non-partitioned.table.location}';");
        }
        String ddlTemplate = sb.toString().trim();
        Pattern pattern = Pattern.compile("\\[(.+?)\\]");
        Matcher matcher = pattern.matcher(ddlTemplate);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("Table Name", AbstractServiceTest.TABLE_NAME);
        replacements.put("Random Suffix", AbstractServiceTest.RANDOM_SUFFIX);
        replacements.put("Format Version", String.valueOf(AbstractServiceTest.FORMAT_VERSION));
        replacements.put("Data Version", String.valueOf(AbstractServiceTest.DATA_VERSION));
        replacements.put("Row Format", hiveRowFormat);
        replacements.put("Hive File Format", hiveFileFormat);
        replacements.put("Format File Type", businessObjectFormatFileType.toLowerCase());
        replacements.put("If Not Exists", isIfNotExistsOptionIncluded ? "IF NOT EXISTS " : "");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = (String)replacements.get(matcher.group(1));
            builder.append(ddlTemplate.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(ddlTemplate.substring(i, ddlTemplate.length()));
        return builder.toString();
    }

    public String getExpectedBusinessObjectDataDdl(String partitionValue) {
        return this.getExpectedBusinessObjectDataDdl(partitionValue, partitionValue);
    }

    public String getExpectedBusinessObjectDataDdl(String partitionValueToDrop, String partitionValueToAdd) {
        StringBuilder ddlBuilder = new StringBuilder();
        ddlBuilder.append("DROP TABLE IF EXISTS `" + AbstractServiceTest.TABLE_NAME + "`;\n");
        ddlBuilder.append("\n");
        ddlBuilder.append("CREATE EXTERNAL TABLE IF NOT EXISTS `" + AbstractServiceTest.TABLE_NAME + "` (\n");
        ddlBuilder.append("    `ORGNL_PRTN_CLMN001` DATE,\n");
        ddlBuilder.append("    `" + AbstractServiceTest.COLUMN_NAME + "` DECIMAL(" + AbstractServiceTest.COLUMN_SIZE + ") COMMENT '" + AbstractServiceTest.COLUMN_DESCRIPTION + "')\n");
        ddlBuilder.append("PARTITIONED BY (`PRTN_CLMN001` DATE)\n");
        ddlBuilder.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'\n");
        ddlBuilder.append("STORED AS TEXTFILE;");
        if (partitionValueToDrop != null) {
            ddlBuilder.append("\n\n");
            ddlBuilder.append("ALTER TABLE `" + AbstractServiceTest.TABLE_NAME + "` DROP IF EXISTS PARTITION (`" + "PRTN_CLMN001" + "`='" + partitionValueToDrop + "');");
        }
        if (partitionValueToAdd != null) {
            String expectedS3KeyPrefix = AbstractServiceTest.getExpectedS3KeyPrefix(AbstractServiceTest.NAMESPACE, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, "PRTN_CLMN001", partitionValueToAdd, null, null, AbstractServiceTest.DATA_VERSION);
            ddlBuilder.append("\n\n");
            ddlBuilder.append("ALTER TABLE `" + AbstractServiceTest.TABLE_NAME + "` ADD IF NOT EXISTS PARTITION (`" + "PRTN_CLMN001" + "`='" + partitionValueToAdd + "') LOCATION 's3n://" + AbstractServiceTest.S3_BUCKET_NAME + "/" + expectedS3KeyPrefix + "';");
        }
        String expectedDdl = ddlBuilder.toString();
        return expectedDdl;
    }

    public BusinessObjectDataDdlCollectionResponse getExpectedBusinessObjectDataDdlCollectionResponse() {
        BusinessObjectDataDdlCollectionResponse businessObjectDataDdlCollectionResponse = new BusinessObjectDataDdlCollectionResponse();
        ArrayList<BusinessObjectDataDdl> businessObjectDataDdlResponses = new ArrayList<BusinessObjectDataDdl>();
        businessObjectDataDdlCollectionResponse.setBusinessObjectDataDdlResponses(businessObjectDataDdlResponses);
        String expectedDdl = this.getExpectedBusinessObjectDataDdl(AbstractServiceTest.PARTITION_VALUE);
        BusinessObjectDataDdl expectedBusinessObjectDataDdl = new BusinessObjectDataDdl(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(AbstractServiceTest.PARTITION_VALUE), AbstractServiceTest.NO_PARTITION_VALUE_RANGE, AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE)), AbstractServiceTest.NO_STANDALONE_PARTITION_VALUE_FILTER, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.NO_STORAGE_NAMES, AbstractServiceTest.STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, AbstractServiceTest.TABLE_NAME, AbstractServiceTest.NO_CUSTOM_DDL_NAME, expectedDdl);
        businessObjectDataDdlResponses.add(expectedBusinessObjectDataDdl);
        businessObjectDataDdlResponses.add(expectedBusinessObjectDataDdl);
        businessObjectDataDdlCollectionResponse.setDdlCollection(String.format("%s\n\n%s", expectedDdl, expectedDdl));
        return businessObjectDataDdlCollectionResponse;
    }

    public String getExpectedBusinessObjectDataDdlTwoPartitionLevels(List<List<String>> partitions) {
        StringBuilder ddlBuilder = new StringBuilder();
        ddlBuilder.append("DROP TABLE IF EXISTS `" + AbstractServiceTest.TABLE_NAME + "`;\n");
        ddlBuilder.append("\n");
        ddlBuilder.append("CREATE EXTERNAL TABLE IF NOT EXISTS `" + AbstractServiceTest.TABLE_NAME + "` (\n");
        ddlBuilder.append("    `ORGNL_PRTN_CLMN001` DATE,\n");
        ddlBuilder.append("    `ORGNL_PRTN_CLMN002` STRING,\n");
        ddlBuilder.append("    `" + AbstractServiceTest.COLUMN_NAME + "` DECIMAL(" + AbstractServiceTest.COLUMN_SIZE + ") COMMENT '" + AbstractServiceTest.COLUMN_DESCRIPTION + "')\n");
        ddlBuilder.append("PARTITIONED BY (`PRTN_CLMN001` DATE, `PRTN_CLMN002` STRING)\n");
        ddlBuilder.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'\n");
        ddlBuilder.append("STORED AS TEXTFILE;");
        ddlBuilder.append("\n\n");
        ddlBuilder.append("ALTER TABLE `" + AbstractServiceTest.TABLE_NAME + "` DROP IF EXISTS PARTITION (`" + "PRTN_CLMN001" + "`='" + partitions.get(0).get(0) + "');");
        ddlBuilder.append("\n");
        for (List<String> partition : partitions) {
            String expectedS3KeyPrefix = AbstractServiceTest.getExpectedS3KeyPrefix(AbstractServiceTest.NAMESPACE, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, "PRTN_CLMN001", partition.get(0), Arrays.asList(new SchemaColumn("PRTN_CLMN002", "STRING", AbstractServiceTest.NO_COLUMN_SIZE, AbstractServiceTest.COLUMN_REQUIRED, AbstractServiceTest.NO_COLUMN_DEFAULT_VALUE, AbstractServiceTest.NO_COLUMN_DESCRIPTION)).toArray(new SchemaColumn[1]), Arrays.asList(partition.get(1)).toArray(new String[1]), AbstractServiceTest.DATA_VERSION);
            ddlBuilder.append("\n");
            ddlBuilder.append("ALTER TABLE `" + AbstractServiceTest.TABLE_NAME + "` ADD IF NOT EXISTS PARTITION (`" + "PRTN_CLMN001" + "`='" + partition.get(0) + "', `" + "PRTN_CLMN002" + "`='" + partition.get(1) + "') LOCATION 's3n://" + AbstractServiceTest.S3_BUCKET_NAME + "/" + expectedS3KeyPrefix + "';");
        }
        String expectedDdl = ddlBuilder.toString();
        return expectedDdl;
    }

    public String getExpectedBusinessObjectDataKeyAsString(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, Integer businessObjectFormatVersion, String partitionValue, List<String> subPartitionValues, Integer businessObjectDataVersion) {
        return String.format("namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s\", businessObjectDataVersion: %d", namespaceCode, businessObjectDefinitionName, businessObjectFormatUsage, businessObjectFormatFileType, businessObjectFormatVersion, partitionValue, CollectionUtils.isEmpty(subPartitionValues) ? "" : StringUtils.join(subPartitionValues, (String)","), businessObjectDataVersion);
    }

    public String getExpectedBusinessObjectDataKeyAsString(BusinessObjectDataKey businessObjectDataKey) {
        return this.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey.getNamespace(), businessObjectDataKey.getBusinessObjectDefinitionName(), businessObjectDataKey.getBusinessObjectFormatUsage(), businessObjectDataKey.getBusinessObjectFormatFileType(), businessObjectDataKey.getBusinessObjectFormatVersion(), businessObjectDataKey.getPartitionValue(), businessObjectDataKey.getSubPartitionValues(), businessObjectDataKey.getBusinessObjectDataVersion());
    }

    public String getExpectedBusinessObjectDataNotFoundErrorMessage(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, Integer businessObjectFormatVersion, String partitionValue, List<String> subPartitionValues, Integer businessObjectDataVersion, String businessObjectDataStatus) {
        return this.getExpectedBusinessObjectDataNotFoundErrorMessage(new BusinessObjectDataKey(namespaceCode, businessObjectDefinitionName, businessObjectFormatUsage, businessObjectFormatFileType, businessObjectFormatVersion, partitionValue, subPartitionValues, businessObjectDataVersion), businessObjectDataStatus);
    }

    public String getExpectedBusinessObjectDataNotFoundErrorMessage(BusinessObjectDataKey businessObjectDataKey, String businessObjectDataStatus) {
        return String.format("Business object data {%s, businessObjectDataStatus: \"%s\"} doesn't exist.", this.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey), businessObjectDataStatus);
    }

    public String getExpectedS3BucketName(String partitionValue) {
        if (AbstractServiceTest.STORAGE_1_AVAILABLE_PARTITION_VALUES.contains(partitionValue) || "none".equals(partitionValue)) {
            return AbstractServiceTest.S3_BUCKET_NAME;
        }
        return AbstractServiceTest.S3_BUCKET_NAME_2;
    }

    public List<PartitionValueFilter> getInvalidPartitionValueFilters() {
        return Arrays.asList(new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.NO_PARTITION_VALUES, AbstractServiceTest.NO_PARTITION_VALUE_RANGE, AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.NO_PARTITION_VALUES, AbstractServiceTest.NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(), new LatestAfterPartitionValue()), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.NO_PARTITION_VALUES, new PartitionValueRange("2014-04-02", "2014-04-08"), AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue()), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.NO_PARTITION_VALUES, new PartitionValueRange("2014-04-02", "2014-04-08"), new LatestBeforePartitionValue(), AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.NO_PARTITION_VALUES, new PartitionValueRange("2014-04-02", "2014-04-08"), new LatestBeforePartitionValue(), new LatestAfterPartitionValue()), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.UNSORTED_PARTITION_VALUES, AbstractServiceTest.NO_PARTITION_VALUE_RANGE, AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue()), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.UNSORTED_PARTITION_VALUES, AbstractServiceTest.NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(), AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.UNSORTED_PARTITION_VALUES, AbstractServiceTest.NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(), new LatestAfterPartitionValue()), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.UNSORTED_PARTITION_VALUES, new PartitionValueRange("2014-04-02", "2014-04-08"), AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.UNSORTED_PARTITION_VALUES, new PartitionValueRange("2014-04-02", "2014-04-08"), AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue()), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.UNSORTED_PARTITION_VALUES, new PartitionValueRange("2014-04-02", "2014-04-08"), new LatestBeforePartitionValue(), AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE), new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.UNSORTED_PARTITION_VALUES, new PartitionValueRange("2014-04-02", "2014-04-08"), new LatestBeforePartitionValue(), new LatestAfterPartitionValue()));
    }

    public BusinessObjectDataCreateRequest getNewBusinessObjectDataCreateRequest() {
        return this.getNewBusinessObjectDataCreateRequest(true);
    }

    public BusinessObjectDataCreateRequest getNewBusinessObjectDataCreateRequest(boolean includeAttributes) {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(includeAttributes);
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity();
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = new BusinessObjectDataCreateRequest();
        businessObjectDataCreateRequest.setNamespace(businessObjectFormatEntity.getBusinessObjectDefinition().getNamespace().getCode());
        businessObjectDataCreateRequest.setBusinessObjectDefinitionName(businessObjectFormatEntity.getBusinessObjectDefinition().getName());
        businessObjectDataCreateRequest.setBusinessObjectFormatUsage(businessObjectFormatEntity.getUsage());
        businessObjectDataCreateRequest.setBusinessObjectFormatFileType(businessObjectFormatEntity.getFileType().getCode());
        businessObjectDataCreateRequest.setBusinessObjectFormatVersion(businessObjectFormatEntity.getBusinessObjectFormatVersion());
        businessObjectDataCreateRequest.setPartitionKey(businessObjectFormatEntity.getPartitionKey());
        businessObjectDataCreateRequest.setPartitionValue(AbstractServiceTest.PARTITION_VALUE);
        businessObjectDataCreateRequest.setSubPartitionValues(AbstractServiceTest.SUBPARTITION_VALUES);
        ArrayList<StorageUnitCreateRequest> storageUnits = new ArrayList<StorageUnitCreateRequest>();
        businessObjectDataCreateRequest.setStorageUnits(storageUnits);
        StorageUnitCreateRequest storageUnit = new StorageUnitCreateRequest();
        storageUnits.add(storageUnit);
        storageUnit.setStorageName(storageEntity.getName());
        StorageDirectory storageDirectory = new StorageDirectory();
        storageUnit.setStorageDirectory(storageDirectory);
        storageDirectory.setDirectoryPath("Folder");
        ArrayList<StorageFile> storageFiles = new ArrayList<StorageFile>();
        storageUnit.setStorageFiles(storageFiles);
        StorageFile storageFile1 = new StorageFile();
        storageFiles.add(storageFile1);
        storageFile1.setFilePath("Folder/file1.gz");
        storageFile1.setFileSizeBytes(Long.valueOf(0L));
        storageFile1.setRowCount(Long.valueOf(0L));
        StorageFile storageFile2 = new StorageFile();
        storageFiles.add(storageFile2);
        storageFile2.setFilePath("Folder/file2.gz");
        storageFile2.setFileSizeBytes(Long.valueOf(2999L));
        storageFile2.setRowCount(Long.valueOf(1000L));
        StorageFile storageFile3 = new StorageFile();
        storageFiles.add(storageFile3);
        storageFile3.setFilePath("Folder/file3.gz");
        storageFile3.setFileSizeBytes(Long.valueOf(Long.MAX_VALUE));
        storageFile3.setRowCount(Long.valueOf(Long.MAX_VALUE));
        if (includeAttributes) {
            businessObjectDataCreateRequest.setAttributes(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        }
        ArrayList<BusinessObjectDataKey> businessObjectDataParents = new ArrayList<BusinessObjectDataKey>();
        businessObjectDataCreateRequest.setBusinessObjectDataParents(businessObjectDataParents);
        for (int i = 0; i < 2; ++i) {
            BusinessObjectDataEntity parentBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity();
            BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
            businessObjectDataKey.setNamespace(parentBusinessObjectDataEntity.getBusinessObjectFormat().getBusinessObjectDefinition().getNamespace().getCode());
            businessObjectDataKey.setBusinessObjectDefinitionName(parentBusinessObjectDataEntity.getBusinessObjectFormat().getBusinessObjectDefinition().getName());
            businessObjectDataKey.setBusinessObjectFormatUsage(parentBusinessObjectDataEntity.getBusinessObjectFormat().getUsage());
            businessObjectDataKey.setBusinessObjectFormatFileType(parentBusinessObjectDataEntity.getBusinessObjectFormat().getFileType().getCode());
            businessObjectDataKey.setBusinessObjectFormatVersion(parentBusinessObjectDataEntity.getBusinessObjectFormat().getBusinessObjectFormatVersion());
            businessObjectDataKey.setPartitionValue(parentBusinessObjectDataEntity.getPartitionValue());
            businessObjectDataKey.setBusinessObjectDataVersion(parentBusinessObjectDataEntity.getVersion());
            businessObjectDataKey.setSubPartitionValues(this.businessObjectDataHelper.getSubPartitionValues(parentBusinessObjectDataEntity));
            businessObjectDataParents.add(businessObjectDataKey);
        }
        return businessObjectDataCreateRequest;
    }

    public BusinessObjectDataStorageFilesCreateRequest getNewBusinessObjectDataStorageFilesCreateRequest() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(false);
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(AbstractServiceTest.BDATA_STATUS, AbstractServiceTest.DESCRIPTION, AbstractServiceTest.BDATA_STATUS_PRE_REGISTRATION_FLAG_SET);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, AbstractServiceTest.PARTITION_VALUE, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, businessObjectDataStatusEntity.getCode());
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity();
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", AbstractServiceTest.NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataStorageFilesCreateRequest businessObjectDataStorageFilesCreateRequest = new BusinessObjectDataStorageFilesCreateRequest();
        businessObjectDataStorageFilesCreateRequest.setNamespace(businessObjectFormatEntity.getBusinessObjectDefinition().getNamespace().getCode());
        businessObjectDataStorageFilesCreateRequest.setBusinessObjectDefinitionName(businessObjectFormatEntity.getBusinessObjectDefinition().getName());
        businessObjectDataStorageFilesCreateRequest.setBusinessObjectFormatUsage(businessObjectFormatEntity.getUsage());
        businessObjectDataStorageFilesCreateRequest.setBusinessObjectFormatFileType(businessObjectFormatEntity.getFileType().getCode());
        businessObjectDataStorageFilesCreateRequest.setBusinessObjectFormatVersion(businessObjectFormatEntity.getBusinessObjectFormatVersion());
        businessObjectDataStorageFilesCreateRequest.setPartitionValue(businessObjectDataEntity.getPartitionValue());
        businessObjectDataStorageFilesCreateRequest.setBusinessObjectDataVersion(businessObjectDataEntity.getVersion());
        businessObjectDataStorageFilesCreateRequest.setStorageName(storageEntity.getName());
        ArrayList<StorageFile> storageFiles = new ArrayList<StorageFile>();
        businessObjectDataStorageFilesCreateRequest.setStorageFiles(storageFiles);
        StorageFile storageFile1 = new StorageFile();
        storageFiles.add(storageFile1);
        storageFile1.setFilePath("Folder/file1.gz");
        storageFile1.setFileSizeBytes(Long.valueOf(0L));
        storageFile1.setRowCount(Long.valueOf(0L));
        StorageFile storageFile2 = new StorageFile();
        storageFiles.add(storageFile2);
        storageFile2.setFilePath("Folder/file2.gz");
        storageFile2.setFileSizeBytes(Long.valueOf(2999L));
        storageFile2.setRowCount(Long.valueOf(1000L));
        StorageFile storageFile3 = new StorageFile();
        storageFiles.add(storageFile3);
        storageFile3.setFilePath("Folder/file3.gz");
        storageFile3.setFileSizeBytes(Long.valueOf(Long.MAX_VALUE));
        storageFile3.setRowCount(Long.valueOf(Long.MAX_VALUE));
        return businessObjectDataStorageFilesCreateRequest;
    }

    public BusinessObjectDataAvailabilityCollectionRequest getTestBusinessObjectDataAvailabilityCollectionRequest() {
        BusinessObjectDataAvailabilityCollectionRequest businessObjectDataAvailabilityCollectionRequest = new BusinessObjectDataAvailabilityCollectionRequest();
        ArrayList<BusinessObjectDataAvailabilityRequest> businessObjectDataAvailabilityRequests = new ArrayList<BusinessObjectDataAvailabilityRequest>();
        businessObjectDataAvailabilityCollectionRequest.setBusinessObjectDataAvailabilityRequests(businessObjectDataAvailabilityRequests);
        BusinessObjectDataAvailabilityRequest businessObjectDataAvailabilityRequest = new BusinessObjectDataAvailabilityRequest(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(AbstractServiceTest.PARTITION_KEY, Arrays.asList(AbstractServiceTest.PARTITION_VALUE), AbstractServiceTest.NO_PARTITION_VALUE_RANGE, AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE)), null, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.NO_STORAGE_NAMES, AbstractServiceTest.STORAGE_NAME, AbstractServiceTest.NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS);
        businessObjectDataAvailabilityRequests.add(businessObjectDataAvailabilityRequest);
        return businessObjectDataAvailabilityCollectionRequest;
    }

    public BusinessObjectDataAvailabilityRequest getTestBusinessObjectDataAvailabilityRequest(String partitionKey, String startPartitionValue, String endPartitionValue, List<String> partitionValues) {
        BusinessObjectDataAvailabilityRequest request = new BusinessObjectDataAvailabilityRequest();
        request.setNamespace(AbstractServiceTest.NAMESPACE);
        request.setBusinessObjectDefinitionName(AbstractServiceTest.BDEF_NAME);
        request.setBusinessObjectFormatUsage(AbstractServiceTest.FORMAT_USAGE_CODE);
        request.setBusinessObjectFormatFileType(AbstractServiceTest.FORMAT_FILE_TYPE_CODE);
        request.setBusinessObjectFormatVersion(AbstractServiceTest.FORMAT_VERSION);
        PartitionValueFilter partitionValueFilter = new PartitionValueFilter();
        request.setPartitionValueFilters(Arrays.asList(partitionValueFilter));
        partitionValueFilter.setPartitionKey(partitionKey);
        if (startPartitionValue != null || endPartitionValue != null) {
            PartitionValueRange partitionValueRange = new PartitionValueRange();
            partitionValueFilter.setPartitionValueRange(partitionValueRange);
            partitionValueRange.setStartPartitionValue(startPartitionValue);
            partitionValueRange.setEndPartitionValue(endPartitionValue);
        }
        if (partitionValues != null) {
            partitionValueFilter.setPartitionValues(new ArrayList<String>(partitionValues));
        }
        request.setBusinessObjectDataVersion(AbstractServiceTest.DATA_VERSION);
        request.setStorageName(AbstractServiceTest.STORAGE_NAME);
        request.setIncludeAllRegisteredSubPartitions(AbstractServiceTest.NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS);
        return request;
    }

    public BusinessObjectDataAvailabilityRequest getTestBusinessObjectDataAvailabilityRequest(String partitionKey, List<String> partitionValues) {
        return this.getTestBusinessObjectDataAvailabilityRequest(partitionKey, null, null, partitionValues);
    }

    public BusinessObjectDataAvailabilityRequest getTestBusinessObjectDataAvailabilityRequest(String startPartitionValue, String endPartitionValue) {
        return this.getTestBusinessObjectDataAvailabilityRequest("PRTN_CLMN001", startPartitionValue, endPartitionValue, null);
    }

    public BusinessObjectDataAvailabilityRequest getTestBusinessObjectDataAvailabilityRequest(List<String> partitionValues) {
        return this.getTestBusinessObjectDataAvailabilityRequest("PRTN_CLMN001", null, null, partitionValues);
    }

    public BusinessObjectDataDdlCollectionRequest getTestBusinessObjectDataDdlCollectionRequest() {
        BusinessObjectDataDdlCollectionRequest businessObjectDataDdlCollectionRequest = new BusinessObjectDataDdlCollectionRequest();
        ArrayList<BusinessObjectDataDdlRequest> businessObjectDataDdlRequests = new ArrayList<BusinessObjectDataDdlRequest>();
        businessObjectDataDdlCollectionRequest.setBusinessObjectDataDdlRequests(businessObjectDataDdlRequests);
        BusinessObjectDataDdlRequest businessObjectDataDdlRequest = new BusinessObjectDataDdlRequest(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(AbstractServiceTest.PARTITION_VALUE), AbstractServiceTest.NO_PARTITION_VALUE_RANGE, AbstractServiceTest.NO_LATEST_BEFORE_PARTITION_VALUE, AbstractServiceTest.NO_LATEST_AFTER_PARTITION_VALUE)), AbstractServiceTest.NO_STANDALONE_PARTITION_VALUE_FILTER, AbstractServiceTest.DATA_VERSION, AbstractServiceTest.NO_STORAGE_NAMES, AbstractServiceTest.STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, AbstractServiceTest.TABLE_NAME, AbstractServiceTest.NO_CUSTOM_DDL_NAME, AbstractServiceTest.INCLUDE_DROP_TABLE_STATEMENT, AbstractServiceTest.INCLUDE_IF_NOT_EXISTS_OPTION, AbstractServiceTest.INCLUDE_DROP_PARTITIONS, AbstractServiceTest.NO_ALLOW_MISSING_DATA, AbstractServiceTest.NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS);
        businessObjectDataDdlRequests.add(businessObjectDataDdlRequest);
        businessObjectDataDdlRequests.add(businessObjectDataDdlRequest);
        return businessObjectDataDdlCollectionRequest;
    }

    public BusinessObjectDataDdlRequest getTestBusinessObjectDataDdlRequest(String startPartitionValue, String endPartitionValue, List<String> partitionValues, String customDdlName) {
        BusinessObjectDataDdlRequest request = new BusinessObjectDataDdlRequest();
        request.setNamespace(AbstractServiceTest.NAMESPACE);
        request.setBusinessObjectDefinitionName(AbstractServiceTest.BDEF_NAME);
        request.setBusinessObjectFormatUsage(AbstractServiceTest.FORMAT_USAGE_CODE);
        request.setBusinessObjectFormatFileType("TXT");
        request.setBusinessObjectFormatVersion(AbstractServiceTest.FORMAT_VERSION);
        PartitionValueFilter partitionValueFilter = new PartitionValueFilter();
        request.setPartitionValueFilters(Arrays.asList(partitionValueFilter));
        partitionValueFilter.setPartitionKey("PRTN_CLMN001");
        if (startPartitionValue != null || endPartitionValue != null) {
            PartitionValueRange partitionValueRange = new PartitionValueRange();
            partitionValueFilter.setPartitionValueRange(partitionValueRange);
            partitionValueRange.setStartPartitionValue(startPartitionValue);
            partitionValueRange.setEndPartitionValue(endPartitionValue);
        }
        if (partitionValues != null) {
            partitionValueFilter.setPartitionValues(new ArrayList<String>(partitionValues));
        }
        request.setBusinessObjectDataVersion(AbstractServiceTest.DATA_VERSION);
        request.setStorageName(AbstractServiceTest.STORAGE_NAME);
        request.setOutputFormat(BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL);
        request.setTableName(AbstractServiceTest.TABLE_NAME);
        request.setCustomDdlName(customDdlName);
        request.setIncludeDropTableStatement(Boolean.valueOf(true));
        request.setIncludeIfNotExistsOption(Boolean.valueOf(true));
        request.setAllowMissingData(Boolean.valueOf(true));
        request.setIncludeAllRegisteredSubPartitions(AbstractServiceTest.NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS);
        return request;
    }

    public BusinessObjectDataDdlRequest getTestBusinessObjectDataDdlRequest(List<String> partitionValues) {
        return this.getTestBusinessObjectDataDdlRequest(null, null, partitionValues, AbstractServiceTest.NO_CUSTOM_DDL_NAME);
    }

    public BusinessObjectDataDdlRequest getTestBusinessObjectDataDdlRequest(String startPartitionValue, String endPartitionValue) {
        return this.getTestBusinessObjectDataDdlRequest(startPartitionValue, endPartitionValue, null, AbstractServiceTest.NO_CUSTOM_DDL_NAME);
    }

    public BusinessObjectDataDdlRequest getTestBusinessObjectDataDdlRequest(List<String> partitionValues, String customDdlName) {
        return this.getTestBusinessObjectDataDdlRequest(null, null, partitionValues, customDdlName);
    }

    public BusinessObjectDataDdlRequest getTestBusinessObjectDataDdlRequest(String startPartitionValue, String endPartitionValue, String customDdlName) {
        return this.getTestBusinessObjectDataDdlRequest(startPartitionValue, endPartitionValue, null, customDdlName);
    }

    public List<BusinessObjectDataStatus> getTestBusinessObjectDataStatuses(Integer businessObjectFormatVersion, int partitionColumnPosition, List<String> partitionValues, List<String> subPartitionValues, Integer businessObjectDataVersion, String reason, boolean useSinglePartitionValue) {
        ArrayList<BusinessObjectDataStatus> businessObjectDataStatuses = new ArrayList<BusinessObjectDataStatus>();
        if (partitionValues != null) {
            for (String partitionValue : partitionValues) {
                BusinessObjectDataStatus businessObjectDataStatus = new BusinessObjectDataStatus();
                businessObjectDataStatuses.add(businessObjectDataStatus);
                businessObjectDataStatus.setBusinessObjectFormatVersion(businessObjectFormatVersion);
                businessObjectDataStatus.setBusinessObjectDataVersion(businessObjectDataVersion);
                businessObjectDataStatus.setReason(reason);
                if ("NOT_REGISTERED".equals(reason)) {
                    if (partitionColumnPosition == 1) {
                        businessObjectDataStatus.setPartitionValue(partitionValue);
                        businessObjectDataStatus.setSubPartitionValues(useSinglePartitionValue ? null : Arrays.asList("", "", "", ""));
                        continue;
                    }
                    if (useSinglePartitionValue) {
                        businessObjectDataStatus.setPartitionValue(partitionValue);
                        continue;
                    }
                    businessObjectDataStatus.setPartitionValue("");
                    businessObjectDataStatus.setSubPartitionValues(Arrays.asList("", "", "", ""));
                    businessObjectDataStatus.getSubPartitionValues().set(partitionColumnPosition - 2, partitionValue);
                    continue;
                }
                if (partitionColumnPosition == 1) {
                    businessObjectDataStatus.setPartitionValue(partitionValue);
                    businessObjectDataStatus.setSubPartitionValues(subPartitionValues);
                    continue;
                }
                businessObjectDataStatus.setPartitionValue(AbstractServiceTest.PARTITION_VALUE);
                ArrayList<String> testSubPartitionValues = new ArrayList<String>(subPartitionValues);
                testSubPartitionValues.set(partitionColumnPosition - 2, partitionValue);
                businessObjectDataStatus.setSubPartitionValues(testSubPartitionValues);
            }
        }
        return businessObjectDataStatuses;
    }

    public List<StorageFile> getTestStorageFiles(String s3KeyPrefix, List<String> relativeFilePaths) {
        return this.getTestStorageFiles(s3KeyPrefix, relativeFilePaths, true);
    }

    public List<StorageFile> getTestStorageFiles(String s3KeyPrefix, List<String> relativeFilePaths, boolean setRowCount) {
        ArrayList<StorageFile> storageFiles = new ArrayList<StorageFile>();
        for (String file : relativeFilePaths) {
            StorageFile storageFile = new StorageFile();
            storageFiles.add(storageFile);
            storageFile.setFilePath(s3KeyPrefix + "/" + file.replaceAll("\\\\", "/"));
            storageFile.setFileSizeBytes(Long.valueOf(1024L));
            if (!setRowCount) continue;
            storageFile.setRowCount(file.equals(AbstractServiceTest.LOCAL_FILES.get(0)) ? null : Long.valueOf(1000L));
        }
        return storageFiles;
    }

    public void prepareTestS3Files(String s3keyPrefix, Path localTempPath, List<String> localFilePaths) throws Exception {
        this.prepareTestS3Files(s3keyPrefix, localTempPath, localFilePaths, new ArrayList<String>());
    }

    public void prepareTestS3Files(String s3KeyPrefix, Path localTempPath, List<String> localFilePaths, List<String> directoryPaths) throws Exception {
        this.prepareTestS3Files(null, s3KeyPrefix, localTempPath, localFilePaths, directoryPaths);
    }

    public void prepareTestS3Files(String bucketName, String s3KeyPrefix, Path localTempPath, List<String> localFilePaths, List<String> directoryPaths) throws Exception {
        for (String file : localFilePaths) {
            AbstractServiceTest.createLocalFile((String)localTempPath.toString(), (String)file, (long)1024L);
        }
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        if (bucketName != null) {
            s3FileTransferRequestParamsDto.setS3BucketName(bucketName);
        }
        s3FileTransferRequestParamsDto.setS3KeyPrefix(s3KeyPrefix);
        s3FileTransferRequestParamsDto.setLocalPath(localTempPath.toString());
        s3FileTransferRequestParamsDto.setRecursive(Boolean.valueOf(true));
        S3FileTransferResultsDto results = this.s3Service.uploadDirectory(s3FileTransferRequestParamsDto);
        Assert.assertEquals((Object)localFilePaths.size(), (Object)results.getTotalFilesTransferred());
        for (String directoryPath : directoryPaths) {
            s3FileTransferRequestParamsDto.setS3KeyPrefix(s3KeyPrefix + "/" + directoryPath);
            this.s3Service.createDirectory(s3FileTransferRequestParamsDto);
        }
        s3FileTransferRequestParamsDto.setS3KeyPrefix(s3KeyPrefix);
        Assert.assertEquals((long)(localFilePaths.size() + directoryPaths.size()), (long)this.s3Service.listDirectory(s3FileTransferRequestParamsDto).size());
    }

    public void validateBusinessObjectData(BusinessObjectDataCreateRequest request, Integer expectedBusinessObjectDataVersion, Boolean expectedLatestVersion, BusinessObjectData actualBusinessObjectData) {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(StringUtils.isNotBlank((CharSequence)request.getNamespace()) ? request.getNamespace() : AbstractServiceTest.NAMESPACE, request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()));
        ArrayList<String> expectedSubPartitionValues = CollectionUtils.isEmpty((Collection)request.getSubPartitionValues()) ? new ArrayList() : request.getSubPartitionValues();
        String expectedStatusCode = StringUtils.isNotBlank((CharSequence)request.getStatus()) ? request.getStatus() : "VALID";
        StorageUnitCreateRequest storageUnitCreateRequest = (StorageUnitCreateRequest)request.getStorageUnits().get(0);
        StorageEntity storageEntity = this.storageDao.getStorageByName(storageUnitCreateRequest.getStorageName());
        String expectedStorageDirectoryPath = storageUnitCreateRequest.getStorageDirectory() != null ? storageUnitCreateRequest.getStorageDirectory().getDirectoryPath() : null;
        List expectedStorageFiles = CollectionUtils.isEmpty((Collection)storageUnitCreateRequest.getStorageFiles()) ? null : storageUnitCreateRequest.getStorageFiles();
        ArrayList<Attribute> expectedAttributes = CollectionUtils.isEmpty((Collection)request.getAttributes()) ? new ArrayList() : request.getAttributes();
        this.validateBusinessObjectData(businessObjectFormatEntity, request.getPartitionValue(), expectedSubPartitionValues, expectedBusinessObjectDataVersion, expectedLatestVersion, expectedStatusCode, storageEntity.getName(), expectedStorageDirectoryPath, expectedStorageFiles, expectedAttributes, actualBusinessObjectData);
    }

    public void validateBusinessObjectData(BusinessObjectFormatEntity businessObjectFormatEntity, String expectedBusinessObjectDataPartitionValue, List<String> expectedBusinessObjectDataSubPartitionValues, Integer expectedBusinessObjectDataVersion, Boolean expectedLatestVersion, String expectedStatusCode, String expectedStorageName, String expectedStorageDirectoryPath, List<StorageFile> expectedStorageFiles, List<Attribute> expectedAttributes, BusinessObjectData actualBusinessObjectData) {
        this.validateBusinessObjectData(null, businessObjectFormatEntity.getBusinessObjectDefinition().getNamespace().getCode(), businessObjectFormatEntity.getBusinessObjectDefinition().getName(), businessObjectFormatEntity.getUsage(), businessObjectFormatEntity.getFileType().getCode(), businessObjectFormatEntity.getBusinessObjectFormatVersion(), expectedBusinessObjectDataPartitionValue, expectedBusinessObjectDataSubPartitionValues, expectedBusinessObjectDataVersion, expectedLatestVersion, expectedStatusCode, expectedStorageName, expectedStorageDirectoryPath, expectedStorageFiles, expectedAttributes, actualBusinessObjectData);
    }

    public void validateBusinessObjectData(Integer expectedBusinessObjectDataId, String expectedNamespace, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, String expectedBusinessObjectDataPartitionValue, List<String> expectedBusinessObjectDataSubPartitionValues, Integer expectedBusinessObjectDataVersion, Boolean expectedLatestVersion, String expectedStatusCode, String expectedStorageName, String expectedStorageDirectoryPath, List<StorageFile> expectedStorageFiles, List<Attribute> expectedAttributes, BusinessObjectData actualBusinessObjectData) {
        this.validateBusinessObjectData(expectedBusinessObjectDataId, expectedNamespace, expectedBusinessObjectDefinitionName, expectedBusinessObjectFormatUsage, expectedBusinessObjectFormatFileType, expectedBusinessObjectFormatVersion, expectedBusinessObjectDataPartitionValue, expectedBusinessObjectDataSubPartitionValues, expectedBusinessObjectDataVersion, expectedLatestVersion, expectedStatusCode, actualBusinessObjectData);
        Assert.assertEquals((long)1L, (long)actualBusinessObjectData.getStorageUnits().size());
        StorageUnit actualStorageUnit = (StorageUnit)actualBusinessObjectData.getStorageUnits().get(0);
        Assert.assertEquals((Object)expectedStorageName, (Object)actualStorageUnit.getStorage().getName());
        Assert.assertEquals((Object)expectedStorageDirectoryPath, actualStorageUnit.getStorageDirectory() != null ? actualStorageUnit.getStorageDirectory().getDirectoryPath() : null);
        AbstractServiceTest.assertEqualsIgnoreOrder((String)"storage files", expectedStorageFiles, (Collection)actualStorageUnit.getStorageFiles());
        Assert.assertEquals(expectedAttributes, (Object)actualBusinessObjectData.getAttributes());
    }

    public void validateBusinessObjectData(Integer expectedBusinessObjectDataId, BusinessObjectDataKey expectedBusinessObjectDataKey, Boolean expectedLatestVersion, String expectedStatusCode, BusinessObjectData actualBusinessObjectData) {
        this.validateBusinessObjectData(expectedBusinessObjectDataId, expectedBusinessObjectDataKey.getNamespace(), expectedBusinessObjectDataKey.getBusinessObjectDefinitionName(), expectedBusinessObjectDataKey.getBusinessObjectFormatUsage(), expectedBusinessObjectDataKey.getBusinessObjectFormatFileType(), expectedBusinessObjectDataKey.getBusinessObjectFormatVersion(), expectedBusinessObjectDataKey.getPartitionValue(), expectedBusinessObjectDataKey.getSubPartitionValues(), expectedBusinessObjectDataKey.getBusinessObjectDataVersion(), expectedLatestVersion, expectedStatusCode, actualBusinessObjectData);
    }

    public void validateBusinessObjectData(Integer expectedBusinessObjectDataId, String expectedNamespace, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, String expectedBusinessObjectDataPartitionValue, List<String> expectedBusinessObjectDataSubPartitionValues, Integer expectedBusinessObjectDataVersion, Boolean expectedLatestVersion, String expectedStatusCode, BusinessObjectData actualBusinessObjectData) {
        Assert.assertNotNull((Object)actualBusinessObjectData);
        if (expectedBusinessObjectDataId != null) {
            Assert.assertEquals((Object)expectedBusinessObjectDataId, (Object)actualBusinessObjectData.getId());
        }
        Assert.assertEquals((Object)expectedNamespace, (Object)actualBusinessObjectData.getNamespace());
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionName, (Object)actualBusinessObjectData.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)expectedBusinessObjectFormatUsage, (Object)actualBusinessObjectData.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)expectedBusinessObjectFormatFileType, (Object)actualBusinessObjectData.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)expectedBusinessObjectFormatVersion, (Object)actualBusinessObjectData.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)expectedBusinessObjectDataPartitionValue, (Object)actualBusinessObjectData.getPartitionValue());
        Assert.assertEquals(expectedBusinessObjectDataSubPartitionValues, (Object)actualBusinessObjectData.getSubPartitionValues());
        Assert.assertEquals((Object)expectedBusinessObjectDataVersion, (Object)actualBusinessObjectData.getVersion());
        Assert.assertEquals((Object)expectedLatestVersion, (Object)actualBusinessObjectData.isLatestVersion());
        Assert.assertEquals((Object)expectedStatusCode, (Object)actualBusinessObjectData.getStatus());
    }

    public void validateBusinessObjectData(String expectedNamespaceCode, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, String expectedBusinessObjectDataStatus, List<Attribute> expectedAttributes, String expectedStorageName, String expectedFileName, Long expectedFileSizeBytes, BusinessObjectData businessObjectData) {
        Assert.assertNotNull((Object)businessObjectData);
        Assert.assertEquals((Object)expectedNamespaceCode, (Object)businessObjectData.getNamespace());
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionName, (Object)businessObjectData.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)expectedBusinessObjectFormatUsage, (Object)businessObjectData.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)expectedBusinessObjectFormatFileType, (Object)businessObjectData.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)expectedBusinessObjectFormatVersion, (Object)businessObjectData.getBusinessObjectFormatVersion());
        Assert.assertNotNull((Object)businessObjectData.getPartitionValue());
        Assert.assertEquals((long)36L, (long)businessObjectData.getPartitionValue().length());
        Assert.assertEquals((Object)AbstractServiceTest.NO_SUBPARTITION_VALUES, (Object)businessObjectData.getSubPartitionValues());
        Assert.assertEquals((Object)AbstractServiceTest.INITIAL_DATA_VERSION, (Object)businessObjectData.getVersion());
        Assert.assertTrue((boolean)businessObjectData.isLatestVersion());
        Assert.assertEquals((Object)expectedBusinessObjectDataStatus, (Object)businessObjectData.getStatus());
        this.businessObjectDefinitionServiceTestHelper.validateAttributes(expectedAttributes, businessObjectData.getAttributes());
        Assert.assertEquals((long)1L, (long)businessObjectData.getStorageUnits().size());
        StorageUnit storageUnit = (StorageUnit)businessObjectData.getStorageUnits().get(0);
        Assert.assertEquals((Object)expectedStorageName, (Object)storageUnit.getStorage().getName());
        String expectedStorageDirectoryPath = String.format("%s/%s/%s", "TEST".trim().toLowerCase().replace('_', '-'), expectedNamespaceCode.trim().toLowerCase().replace('_', '-'), businessObjectData.getPartitionValue());
        Assert.assertEquals((Object)expectedStorageDirectoryPath, (Object)storageUnit.getStorageDirectory().getDirectoryPath());
        Assert.assertEquals((long)1L, (long)storageUnit.getStorageFiles().size());
        StorageFile storageFile = (StorageFile)storageUnit.getStorageFiles().get(0);
        String expectedStorageFilePath = String.format("%s/%s", expectedStorageDirectoryPath, expectedFileName);
        Assert.assertEquals((Object)expectedStorageFilePath, (Object)storageFile.getFilePath());
        Assert.assertEquals((Object)expectedFileSizeBytes, (Object)storageFile.getFileSizeBytes());
        Assert.assertEquals(null, (Object)storageFile.getRowCount());
    }

    public void validateBusinessObjectDataAvailability(BusinessObjectDataAvailabilityRequest request, List<BusinessObjectDataStatus> expectedAvailableStatuses, List<BusinessObjectDataStatus> expectedNotAvailableStatuses, BusinessObjectDataAvailability actualBusinessObjectDataAvailability) {
        Assert.assertNotNull((Object)actualBusinessObjectDataAvailability);
        Assert.assertEquals((Object)request.getNamespace(), (Object)actualBusinessObjectDataAvailability.getNamespace());
        Assert.assertEquals((Object)request.getBusinessObjectDefinitionName(), (Object)actualBusinessObjectDataAvailability.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)request.getBusinessObjectFormatUsage(), (Object)actualBusinessObjectDataAvailability.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)request.getBusinessObjectFormatFileType(), (Object)actualBusinessObjectDataAvailability.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)request.getBusinessObjectFormatVersion(), (Object)actualBusinessObjectDataAvailability.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)request.getPartitionValueFilter(), (Object)actualBusinessObjectDataAvailability.getPartitionValueFilter());
        Assert.assertEquals((Object)request.getBusinessObjectDataVersion(), (Object)actualBusinessObjectDataAvailability.getBusinessObjectDataVersion());
        Assert.assertEquals((Object)request.getStorageName(), (Object)actualBusinessObjectDataAvailability.getStorageName());
        Assert.assertEquals(expectedAvailableStatuses, (Object)actualBusinessObjectDataAvailability.getAvailableStatuses());
        Assert.assertEquals(expectedNotAvailableStatuses, (Object)actualBusinessObjectDataAvailability.getNotAvailableStatuses());
    }

    public void validateBusinessObjectDataDdl(BusinessObjectDataDdlRequest request, String expectedDdl, BusinessObjectDataDdl actualBusinessObjectDataDdl) {
        Assert.assertNotNull((Object)actualBusinessObjectDataDdl);
        Assert.assertEquals((Object)request.getNamespace(), (Object)actualBusinessObjectDataDdl.getNamespace());
        Assert.assertEquals((Object)request.getBusinessObjectDefinitionName(), (Object)actualBusinessObjectDataDdl.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)request.getBusinessObjectFormatUsage(), (Object)actualBusinessObjectDataDdl.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)request.getBusinessObjectFormatFileType(), (Object)actualBusinessObjectDataDdl.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)request.getBusinessObjectFormatVersion(), (Object)actualBusinessObjectDataDdl.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)request.getPartitionValueFilter(), (Object)actualBusinessObjectDataDdl.getPartitionValueFilter());
        Assert.assertEquals((Object)request.getBusinessObjectDataVersion(), (Object)actualBusinessObjectDataDdl.getBusinessObjectDataVersion());
        Assert.assertEquals((Object)request.getStorageName(), (Object)actualBusinessObjectDataDdl.getStorageName());
        Assert.assertEquals((Object)request.getOutputFormat(), (Object)actualBusinessObjectDataDdl.getOutputFormat());
        Assert.assertEquals((Object)request.getTableName(), (Object)actualBusinessObjectDataDdl.getTableName());
        Assert.assertEquals((Object)expectedDdl, (Object)actualBusinessObjectDataDdl.getDdl());
    }

    public void validateBusinessObjectDataKey(String expectedNamespace, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, String expectedBusinessObjectDataPartitionValue, List<String> expectedBusinessObjectDataSubPartitionValues, Integer expectedBusinessObjectDataVersion, BusinessObjectDataKey actualBusinessObjectDataKey) {
        Assert.assertNotNull((Object)actualBusinessObjectDataKey);
        Assert.assertEquals((Object)expectedNamespace, (Object)actualBusinessObjectDataKey.getNamespace());
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionName, (Object)actualBusinessObjectDataKey.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)expectedBusinessObjectFormatUsage, (Object)actualBusinessObjectDataKey.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)expectedBusinessObjectFormatFileType, (Object)actualBusinessObjectDataKey.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)expectedBusinessObjectFormatVersion, (Object)actualBusinessObjectDataKey.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)expectedBusinessObjectDataPartitionValue, (Object)actualBusinessObjectDataKey.getPartitionValue());
        Assert.assertEquals(expectedBusinessObjectDataSubPartitionValues, (Object)actualBusinessObjectDataKey.getSubPartitionValues());
        Assert.assertEquals((Object)expectedBusinessObjectDataVersion, (Object)actualBusinessObjectDataKey.getBusinessObjectDataVersion());
    }

    public void validateBusinessObjectDataRestoreDto(BusinessObjectDataKey expectedBusinessObjectDataKey, String expectedOriginStorageName, String expectedOriginBucketName, String expectedOriginS3KeyPrefix, List<StorageFile> expectedOriginStorageFiles, String expectedGlacierStorageName, String expectedGlacierBucketName, String expectedGlacierS3KeyBasePrefix, String expectedGlacierS3KeyPrefix, Exception expectedException, BusinessObjectDataRestoreDto actualBusinessObjectDataRestoreDto) {
        Assert.assertNotNull((Object)actualBusinessObjectDataRestoreDto);
        Assert.assertEquals((Object)expectedBusinessObjectDataKey, (Object)actualBusinessObjectDataRestoreDto.getBusinessObjectDataKey());
        Assert.assertEquals((Object)expectedOriginStorageName, (Object)actualBusinessObjectDataRestoreDto.getOriginStorageName());
        Assert.assertEquals((Object)expectedOriginBucketName, (Object)actualBusinessObjectDataRestoreDto.getOriginBucketName());
        Assert.assertEquals((Object)expectedOriginS3KeyPrefix, (Object)actualBusinessObjectDataRestoreDto.getOriginS3KeyPrefix());
        Assert.assertEquals(expectedOriginStorageFiles, (Object)actualBusinessObjectDataRestoreDto.getOriginStorageFiles());
        Assert.assertEquals((Object)expectedGlacierStorageName, (Object)actualBusinessObjectDataRestoreDto.getGlacierStorageName());
        Assert.assertEquals((Object)expectedGlacierBucketName, (Object)actualBusinessObjectDataRestoreDto.getGlacierBucketName());
        Assert.assertEquals((Object)expectedGlacierS3KeyBasePrefix, (Object)actualBusinessObjectDataRestoreDto.getGlacierS3KeyBasePrefix());
        Assert.assertEquals((Object)expectedGlacierS3KeyPrefix, (Object)actualBusinessObjectDataRestoreDto.getGlacierS3KeyPrefix());
        Assert.assertEquals((Object)expectedException, (Object)actualBusinessObjectDataRestoreDto.getException());
    }

    public void validateBusinessObjectDataStatusChangeMessage(String message, BusinessObjectDataKey businessObjectDataKey, Integer businessObjectDataId, String username, String newBusinessObjectDataStatus, String oldBusinessObjectDataStatus, List<Attribute> businessObjectDataAttributes) {
        this.validateXmlFieldPresent(message, "correlation-id", "BusinessObjectData_" + businessObjectDataId);
        this.validateXmlFieldPresent(message, "triggered-by-username", username);
        this.validateXmlFieldPresent(message, "context-message-type", "testDomain/testApplication/BusinessObjectDataStatusChanged");
        this.validateXmlFieldPresent(message, "newBusinessObjectDataStatus", newBusinessObjectDataStatus);
        if (oldBusinessObjectDataStatus == null) {
            this.validateXmlFieldNotPresent(message, "oldBusinessObjectDataStatus");
        } else {
            this.validateXmlFieldPresent(message, "oldBusinessObjectDataStatus", oldBusinessObjectDataStatus);
        }
        this.validateXmlFieldPresent(message, "namespace", businessObjectDataKey.getNamespace());
        this.validateXmlFieldPresent(message, "businessObjectDefinitionName", businessObjectDataKey.getBusinessObjectDefinitionName());
        this.validateXmlFieldPresent(message, "businessObjectFormatUsage", businessObjectDataKey.getBusinessObjectFormatUsage());
        this.validateXmlFieldPresent(message, "businessObjectFormatFileType", businessObjectDataKey.getBusinessObjectFormatFileType());
        this.validateXmlFieldPresent(message, "businessObjectFormatVersion", businessObjectDataKey.getBusinessObjectFormatVersion());
        this.validateXmlFieldPresent(message, "partitionValue", businessObjectDataKey.getPartitionValue());
        if (CollectionUtils.isEmpty((Collection)businessObjectDataKey.getSubPartitionValues())) {
            this.validateXmlFieldNotPresent(message, "subPartitionValues");
        } else {
            this.validateXmlFieldPresent(message, "subPartitionValues");
        }
        for (String subPartitionValue : businessObjectDataKey.getSubPartitionValues()) {
            this.validateXmlFieldPresent(message, "partitionValue", subPartitionValue);
        }
        if (CollectionUtils.isEmpty(businessObjectDataAttributes)) {
            this.validateXmlFieldNotPresent(message, "attributes");
        } else {
            this.validateXmlFieldPresent(message, "attributes");
        }
        for (Attribute attribute : businessObjectDataAttributes) {
            this.validateXmlFieldPresent(message, "attribute", "name", attribute.getName(), attribute.getValue() == null ? "" : attribute.getValue());
        }
        this.validateXmlFieldPresent(message, "businessObjectDataVersion", businessObjectDataKey.getBusinessObjectDataVersion());
    }

    public void validateBusinessObjectDataStatusInformation(BusinessObjectDataKey expectedBusinessObjectDataKey, String expectedBusinessObjectDataStatus, BusinessObjectDataStatusInformation businessObjectDataStatusInformation) {
        Assert.assertNotNull((Object)businessObjectDataStatusInformation);
        Assert.assertEquals((Object)expectedBusinessObjectDataKey, (Object)businessObjectDataStatusInformation.getBusinessObjectDataKey());
        Assert.assertEquals((Object)expectedBusinessObjectDataStatus, (Object)businessObjectDataStatusInformation.getStatus());
    }

    public void validateBusinessObjectDataStatusUpdateResponse(BusinessObjectDataKey expectedBusinessObjectDataKey, String expectedBusinessObjectDataStatus, String expectedPreviousBusinessObjectDataStatus, BusinessObjectDataStatusUpdateResponse actualResponse) {
        Assert.assertNotNull((Object)actualResponse);
        Assert.assertEquals((Object)expectedBusinessObjectDataKey, (Object)actualResponse.getBusinessObjectDataKey());
        Assert.assertEquals((Object)expectedBusinessObjectDataStatus, (Object)actualResponse.getStatus());
        Assert.assertEquals((Object)expectedPreviousBusinessObjectDataStatus, (Object)actualResponse.getPreviousStatus());
    }

    public void validateBusinessObjectDataStorageFilesCreateResponse(String expectedNamespace, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, String expectedPartitionValue, List<String> expectedSubPartitionValues, Integer expectedBusinessObjectDataVersion, String expectedStorageName, List<StorageFile> expectedStorageFiles, BusinessObjectDataStorageFilesCreateResponse actualResponse) {
        Assert.assertNotNull((Object)actualResponse);
        Assert.assertEquals((Object)expectedNamespace, (Object)actualResponse.getNamespace());
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionName, (Object)actualResponse.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)expectedBusinessObjectFormatUsage, (Object)actualResponse.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)expectedBusinessObjectFormatFileType, (Object)actualResponse.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)expectedBusinessObjectFormatVersion, (Object)actualResponse.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)expectedPartitionValue, (Object)actualResponse.getPartitionValue());
        Assert.assertEquals(expectedSubPartitionValues, (Object)actualResponse.getSubPartitionValues());
        Assert.assertEquals((Object)expectedBusinessObjectDataVersion, (Object)actualResponse.getBusinessObjectDataVersion());
        Assert.assertEquals((Object)expectedStorageName, (Object)actualResponse.getStorageName());
        Assert.assertEquals(expectedStorageFiles, (Object)actualResponse.getStorageFiles());
    }

    public void validateStorageFiles(List<StorageFile> expectedStorageFiles, List<StorageFile> actualStorageFiles) {
        Assert.assertEquals((long)expectedStorageFiles.size(), (long)actualStorageFiles.size());
        for (int i = 0; i < expectedStorageFiles.size(); ++i) {
            StorageFile expectedStorageFile = expectedStorageFiles.get(i);
            StorageFile actualStorageFile = actualStorageFiles.get(i);
            Assert.assertEquals((Object)expectedStorageFile.getFilePath(), (Object)actualStorageFile.getFilePath());
            Assert.assertEquals((Object)expectedStorageFile.getFileSizeBytes(), (Object)actualStorageFile.getFileSizeBytes());
            Assert.assertEquals((Object)expectedStorageFile.getRowCount(), (Object)actualStorageFile.getRowCount());
        }
    }

    private void validateXmlFieldNotPresent(String message, String xmlTagName) {
        for (String xmlTag : Arrays.asList(String.format("<%s>", xmlTagName), String.format("</%s>", xmlTagName))) {
            Assert.assertTrue((String)String.format("%s tag not expected, but found.", xmlTag), (!message.contains(xmlTag) ? 1 : 0) != 0);
        }
    }

    private void validateXmlFieldPresent(String message, String xmlTagName) {
        for (String xmlTag : Arrays.asList(String.format("<%s>", xmlTagName), String.format("</%s>", xmlTagName))) {
            Assert.assertTrue((String)String.format("%s expected, but not found.", xmlTag), (boolean)message.contains(xmlTag));
        }
    }

    private void validateXmlFieldPresent(String message, String xmlTagName, Object value) {
        Assert.assertTrue((String)(xmlTagName + " \"" + value + "\" expected, but not found."), (boolean)message.contains("<" + xmlTagName + ">" + (value == null ? null : value.toString()) + "</" + xmlTagName + ">"));
    }

    private void validateXmlFieldPresent(String message, String xmlTagName, String xmlTagAttributeName, String xmlTagAttributeValue, Object xmlTagValue) {
        Assert.assertTrue((String)String.format("<%s> is expected, but not found or does not match expected attribute and/or value.", xmlTagName), (boolean)message.contains(String.format("<%s %s=\"%s\">%s</%s>", xmlTagName, xmlTagAttributeName, xmlTagAttributeValue, xmlTagValue == null ? null : xmlTagValue.toString(), xmlTagName)));
    }
}

