/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStatusInformation;
import org.finra.herd.model.api.xml.BusinessObjectDataStatusUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataStatusUpdateResponse;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.BusinessObjectDataStatusServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDataStatusServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDataStatusServiceImpl")
    private BusinessObjectDataStatusServiceImpl businessObjectDataStatusServiceImpl;

    @Test
    public void testGetBusinessObjectDataStatus() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataStatusInformation resultBusinessObjectDataStatusInformation = this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusInformation(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, resultBusinessObjectDataStatusInformation);
    }

    @Test
    public void testGetBusinessObjectDataStatusMissingRequiredParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey("      \t\t ", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t "), DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an IllegalArgumentException when subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataStatusMissingOptionalParameters() {
        for (int i = 0; i <= 4; ++i) {
            List subPartitionValues = SUBPARTITION_VALUES.subList(0, i);
            this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
            BusinessObjectDataStatusInformation resultBusinessObjectDataStatusInformation = this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, subPartitionValues, null), "      \t\t ");
            this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusInformation(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION), BDATA_STATUS, resultBusinessObjectDataStatusInformation);
        }
    }

    @Test
    public void testGetBusinessObjectDataStatusMissingOptionalParametersPassedAsNulls() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataStatusInformation resultBusinessObjectDataStatusInformation = this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, NO_SUBPARTITION_VALUES, null), null);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusInformation(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, resultBusinessObjectDataStatusInformation);
    }

    @Test
    public void testGetBusinessObjectDataStatusTrimParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataStatusInformation resultBusinessObjectDataStatusInformation = this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION), this.addWhitespace(PARTITION_KEY));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusInformation(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, resultBusinessObjectDataStatusInformation);
    }

    @Test
    public void testGetBusinessObjectDataStatusUpperCaseParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataStatusInformation resultBusinessObjectDataStatusInformation = this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY.toUpperCase());
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusInformation(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, resultBusinessObjectDataStatusInformation);
    }

    @Test
    public void testGetBusinessObjectDataStatusLowerCaseParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataStatusInformation resultBusinessObjectDataStatusInformation = this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY.toLowerCase());
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusInformation(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, resultBusinessObjectDataStatusInformation);
    }

    @Test
    public void testGetBusinessObjectDataStatusInvalidParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataStatusInformation resultBusinessObjectDataStatusInformation = this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusInformation(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, resultBusinessObjectDataStatusInformation);
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), "I_DO_NOT_EXIST");
            Assert.fail((String)"Should throw an IllegalArgumentException when using an invalid partition key.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition key \"%s\" doesn't match configured business object format partition key \"%s\".", "I_DO_NOT_EXIST", PARTITION_KEY), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        for (int i = 0; i < SUBPARTITION_VALUES.size(); ++i) {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>();
            try {
                testSubPartitionValues = new ArrayList(SUBPARTITION_VALUES);
                testSubPartitionValues.set(i, "I_DO_NOT_EXIST");
                this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION), PARTITION_KEY);
                Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
                continue;
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION, null), (Object)e.getMessage());
            }
        }
        try {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>(SUBPARTITION_VALUES);
            testSubPartitionValues.add("EXTRA_SUBPARTITION_VALUE");
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an IllegalArgumentException when passing too many subpartition values.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Exceeded maximum number of allowed subpartitions: %d.", 4), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataStatusBusinessObjectDataNoExists() {
        try {
            this.businessObjectDataStatusService.getBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataStatus() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS_2);
        BusinessObjectDataStatusUpdateResponse response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusUpdateResponse(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS_2, BDATA_STATUS, response);
    }

    @Test
    public void testUpdateBusinessObjectDataStatusMissingRequiredParameters() {
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t ", (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when 1st subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), "      \t\t ", (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when 2nd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), "      \t\t ", (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when 3rd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), "      \t\t "), DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when 4th subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object status is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data status must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataStatusMissingOptionalParameters() {
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS_2);
        for (int i = 0; i <= 4; ++i) {
            List subPartitionValues = SUBPARTITION_VALUES.subList(0, i);
            this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
            BusinessObjectDataStatusUpdateResponse response = null;
            switch (i) {
                case 0: {
                    response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2));
                    break;
                }
                case 1: {
                    response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)subPartitionValues.get(0)), DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2));
                    break;
                }
                case 2: {
                    response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)subPartitionValues.get(0), (String)subPartitionValues.get(1)), DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2));
                    break;
                }
                case 3: {
                    response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)subPartitionValues.get(0), (String)subPartitionValues.get(1), (String)subPartitionValues.get(2)), DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2));
                    break;
                }
                case 4: {
                    response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2));
                }
            }
            this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusUpdateResponse(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION), BDATA_STATUS_2, BDATA_STATUS, response);
        }
    }

    @Test
    public void testUpdateBusinessObjectDataStatusTrimParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS_2);
        BusinessObjectDataStatusUpdateResponse response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(this.addWhitespace(BDATA_STATUS_2)));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusUpdateResponse(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS_2, BDATA_STATUS, response);
    }

    @Test
    public void testUpdateBusinessObjectDataStatusUpperCaseParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS.toLowerCase());
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS_2.toLowerCase());
        BusinessObjectDataStatusUpdateResponse response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2.toUpperCase()));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusUpdateResponse(new BusinessObjectDataKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS_2.toLowerCase(), BDATA_STATUS.toLowerCase(), response);
    }

    @Test
    public void testUpdateBusinessObjectDataStatusLowerCaseParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS.toUpperCase());
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS_2.toUpperCase());
        BusinessObjectDataStatusUpdateResponse response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2.toLowerCase()));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusUpdateResponse(new BusinessObjectDataKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS_2.toUpperCase(), BDATA_STATUS.toUpperCase(), response);
    }

    @Test
    public void testUpdateBusinessObjectDataStatusBusinessObjectDataNoExists() {
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataStatusNoStatusChange() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataStatusUpdateResponse response = this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusUpdateResponse(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, BDATA_STATUS, response);
    }

    @Test
    public void testUpdateBusinessObjectDataStatusStatusNoExists() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        try {
            this.businessObjectDataStatusService.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataStatusUpdateRequest("I_DO_NOT_EXIST"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data status does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)"Business object data status \"I_DO_NOT_EXIST\" doesn't exist.", (Object)e.getMessage());
        }
    }

    @Test
    public void testBusinessObjectDataStatusServiceMethodsNewTransactionPropagation() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        try {
            this.businessObjectDataStatusServiceImpl.getBusinessObjectDataStatus(businessObjectDataKey, NO_PARTITION_KEY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStatusServiceImpl.updateBusinessObjectDataStatus(businessObjectDataKey, new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS_2));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }
}

