/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageFilesCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageFilesCreateResponse;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectDataStatusEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.DataProviderEntity;
import org.finra.herd.model.jpa.FileTypeEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDataStorageFileService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDataStorageFileServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDataStorageFileServiceImpl")
    private BusinessObjectDataStorageFileService businessObjectDataStorageFileServiceImpl;
    private static final String FILE_PATH_1 = "file1";
    private static final String FILE_PATH_2 = "file2";
    private static final String FILE_PATH_3 = "file3";
    private static final String PARTITION_KEY_2 = "pk2_" + Math.random();
    private static final String PARTITION_KEY_3 = "pk3_" + Math.random();
    private static final String PARTITION_KEY_4 = "pk4_" + Math.random();
    private static final String PARTITION_KEY_5 = "pk5_" + Math.random();
    private static final String PARTITION_VALUE_2 = "pv2_" + Math.random();
    private static final String PARTITION_VALUE_3 = "pv3_" + Math.random();
    private static final String PARTITION_VALUE_4 = "pv4_" + Math.random();
    private static final String PARTITION_VALUE_5 = "pv5_" + Math.random();
    private static final List<String> SUB_PARTITION_VALUES = Arrays.asList(PARTITION_VALUE_2, PARTITION_VALUE_3, PARTITION_VALUE_4, PARTITION_VALUE_5);
    private static final String testS3KeyPrefix = BusinessObjectDataStorageFileServiceTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
    private Path localTempPath;

    @Before
    public void setupEnv() throws IOException {
        this.localTempPath = Files.createTempDirectory(null, new FileAttribute[0]);
    }

    @After
    public void cleanEnv() throws IOException {
        FileUtils.deleteDirectory((File)this.localTempPath.toFile());
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3KeyPrefix(testS3KeyPrefix);
        this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFiles() {
        this.createDataWithSubPartitions();
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesMissingRequiredParameters() {
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t "), DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, null, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, "      \t\t ", Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, null, NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage files are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one storage file must be specified when discovery of storage files is not enabled.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile("      \t\t ", 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage file path is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A file path must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, null, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage file size is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A file size must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesMissingOptionalParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.createData(null, false);
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, null)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME, request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesTrimParameters() {
        this.createDataWithSubPartitions();
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUB_PARTITION_VALUES), DATA_VERSION, this.addWhitespace(STORAGE_NAME), Arrays.asList(this.createFile(this.addWhitespace(FILE_PATH_2), 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesUpperCaseParameters() {
        this.createDataWithSubPartitions();
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME.toUpperCase(), Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesLowerCaseParameters() {
        this.createDataWithSubPartitions();
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME.toLowerCase(), Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesInvalidParameters() {
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(PARTITION_VALUE_2, PARTITION_VALUE_3, PARTITION_VALUE_4, PARTITION_VALUE_5, PARTITION_KEY_2), DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when too many sub-partition values are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Exceeded maximum number of allowed subpartitions: %d.", 4), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, -1L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage file has an invalid row count number.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("File \"%s\" has a row count which is < 0.", FILE_PATH_2), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L), this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when trying to add duplicate storage files.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate storage file found: %s", FILE_PATH_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesWithStorageDirectory() {
        this.createData("some/path", false);
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile("some/path/file2", 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME, request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesWithStorageDirectoryIncorrectStorageDirectory() {
        this.createData("some/path", false);
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile("incorrect/path/file2", 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when a storage file path does not match the storage directory path.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage file path \"incorrect/path/%s\" does not match the storage directory path \"some/path/\".", FILE_PATH_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesBusinessObjectDataNoExists() {
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesBusinessObjectDataHasNoPreRegistrationStatus() {
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS, DESCRIPTION, NO_BDATA_STATUS_PRE_REGISTRATION_FLAG_SET);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, DATA_VERSION, Boolean.valueOf(true), businessObjectDataStatusEntity.getCode());
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data status is not flagged as a pre-registration status.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data status must be one of the pre-registration statuses. Business object data status {%s}, business object data {%s}", businessObjectDataStatusEntity.getCode(), this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_PARTITION_VALUES, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesStorageNoExists() {
        this.createData(null, false);
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "I_DO_NOT_EXIST", Arrays.asList(this.createFile(FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"I_DO_NOT_EXIST\" storage for the business object data {%s}.", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesStorageHasValidateFileSizeEnabledWithoutValidateFileExistence() {
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME_2), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_SIZE), Boolean.toString(true))));
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_1, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when adding files to storage with file existence validation enabled without file size validation.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage \"%s\" has file size validation enabled without file existence validation.", STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesPreviouslyRegisteredS3FileSizeMismatchIgnoredDueToDisabledFileSizeValidation() throws Exception {
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), this.storageDaoTestHelper.getS3ManagedBucketName()), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.toString(false)), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.toString(true)), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_SIZE), Boolean.toString(false))));
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        StorageFileEntity storageFileEntity = this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, testS3KeyPrefix + "/" + FILE_PATH_1, Long.valueOf(2048L), Long.valueOf(1000L));
        storageUnitEntity.getStorageFiles().add(storageFileEntity);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME, request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesStorageFilePreviouslyRegistered() {
        this.createData(null, false);
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, STORAGE_NAME, Arrays.asList(this.createFile(FILE_PATH_1, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an AlreadyExistsException when request contains storage file what is already registered.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("S3 file \"%s\" in \"%s\" storage is already registered by the business object data {%s}.", FILE_PATH_1, STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3Managed() throws Exception {
        this.createData(null, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedStorageUnitHasStorageDirectoryPathSet() throws Exception {
        this.createData(testS3KeyPrefix, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedExtraFilesInS3() throws Exception {
        this.createData(null, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2, FILE_PATH_3));
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", request.getStorageFiles(), response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedInvalidS3FilePath() throws Exception {
        this.createData(null, true);
        String invalidS3KeyPrefix = "INVALID_S3_KEY_PREFIX";
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(invalidS3KeyPrefix + "/" + FILE_PATH_1, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when a storage file path in S3 managed storage does not match the expected S3 key prefix.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Specified storage file path \"%s/%s\" does not match the expected S3 key prefix \"%s\".", invalidS3KeyPrefix, FILE_PATH_1, testS3KeyPrefix + "/"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedStorageFilePreviouslyRegistered() {
        String testFilePath = testS3KeyPrefix + "/" + FILE_PATH_1;
        this.createData(null, true, Arrays.asList(testFilePath));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testFilePath, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an AlreadyExistsException when request contains storage file what is already registered.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("S3 file \"%s\" in \"%s\" storage is already registered by the business object data {%s}.", testFilePath, "S3_MANAGED", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedPreviouslyRegisteredS3FileNotFound() throws Exception {
        this.createData(null, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_2));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an ObjectNotFoundException when an already registered storage file not found in S3.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Previously registered storage file not found at s3://%s/%s/%s location.", this.storageDaoTestHelper.getS3ManagedBucketName(), testS3KeyPrefix, FILE_PATH_1), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedPreviouslyRegisteredS3FileSizeIsNull() throws Exception {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity("S3_MANAGED", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING", "ENABLED", testS3KeyPrefix);
        StorageFileEntity storageFileEntity = this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, testS3KeyPrefix + "/" + FILE_PATH_1, NO_FILE_SIZE, NO_ROW_COUNT);
        storageUnitEntity.getStorageFiles().add(storageFileEntity);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when an already registered storage file has a null file size");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Previously registered storage file \"%s/%s\" has no file size specified.", testS3KeyPrefix, FILE_PATH_1, 2048L, 1024L), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedPreviouslyRegisteredS3FileSizeMismatch() throws Exception {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity("S3_MANAGED", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING", "ENABLED", testS3KeyPrefix);
        StorageFileEntity storageFileEntity = this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, testS3KeyPrefix + "/" + FILE_PATH_1, Long.valueOf(2048L), Long.valueOf(1000L));
        storageUnitEntity.getStorageFiles().add(storageFileEntity);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when an already registered storage file size does not match file size reported by S3.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Previously registered storage file \"%s/%s\" has file size of %d bytes that does not match file size of %d bytes reported by S3.", testS3KeyPrefix, FILE_PATH_1, 2048L, 1024L), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedS3FileNotFound() throws Exception {
        this.createData(null, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 1024L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an ObjectNotFoundException when a storage file does not exist in S3 managed storage.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File not found at s3://%s/%s/%s location.", this.storageDaoTestHelper.getS3ManagedBucketName(), testS3KeyPrefix, FILE_PATH_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesS3ManagedS3FileSizeMismatch() throws Exception {
        this.createData(null, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(testS3KeyPrefix + "/" + FILE_PATH_2, 0L, 1000L)), NO_DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when a storage file size does not match file size reported by S3.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Specified file size of %d bytes for \"%s/%s\" storage file does not match file size of %d bytes reported by S3.", 0L, testS3KeyPrefix, FILE_PATH_2, 1024L), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesAutoDiscovery() throws Exception {
        this.createData(testS3KeyPrefix, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        BusinessObjectDataStorageFilesCreateResponse response = this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", NO_STORAGE_FILES, DISCOVER_STORAGE_FILES));
        Assert.assertEquals((Object)new BusinessObjectDataStorageFilesCreateResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", Arrays.asList(new StorageFile(testS3KeyPrefix + "/" + FILE_PATH_2, Long.valueOf(1024L), NO_ROW_COUNT))), (Object)response);
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesAutoDiscoveryStorageFilesSpecified() {
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", Arrays.asList(this.createFile(FILE_PATH_1, 0L, 1000L)), DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when discovery of storage files is enabled and storage files are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage files cannot be specified when discovery of storage files is enabled.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesAutoDiscoveryStorageUnitHasNoStorageDirectoryPath() throws Exception {
        this.createData(null, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", NO_STORAGE_FILES, DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage unit has no storage directory path.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object data has no storage directory path which is required for auto-discovery of storage files.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesAutoDiscoveryStorageDirectoryPathMatchesAnotherBdataStorageFiles() throws Exception {
        this.createData(testS3KeyPrefix, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity("S3_MANAGED", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, NO_SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING", "ENABLED", testS3KeyPrefix);
        StorageFileEntity storageFileEntity = this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, testS3KeyPrefix + "/" + FILE_PATH_2, Long.valueOf(1024L), NO_ROW_COUNT);
        storageUnitEntity.getStorageFiles().add(storageFileEntity);
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", NO_STORAGE_FILES, DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when another business object data have a storage file starting with the test S3 key prefix.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Number of storage files (1) already registered for the business object data in \"%s\" storage is not equal to the number of registered storage files (2) matching \"%s/\" S3 key prefix in the same storage.", "S3_MANAGED", testS3KeyPrefix), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesAutoDiscoveryPreviouslyRegisteredS3FileNotFound() throws Exception {
        this.createData(testS3KeyPrefix, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_2));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", NO_STORAGE_FILES, DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an ObjectNotFoundException when an already registered storage file not found in S3.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Previously registered storage file not found at s3://%s/%s/%s location.", this.storageDaoTestHelper.getS3ManagedBucketName(), testS3KeyPrefix, FILE_PATH_1), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesAutoDiscoveryPreviouslyRegisteredS3FileSizeMismatch() throws Exception {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity("S3_MANAGED", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING", "ENABLED", testS3KeyPrefix);
        StorageFileEntity storageFileEntity = this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, testS3KeyPrefix + "/" + FILE_PATH_1, Long.valueOf(2048L), NO_ROW_COUNT);
        storageUnitEntity.getStorageFiles().add(storageFileEntity);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1, FILE_PATH_2));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", NO_STORAGE_FILES, DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when an already registered storage file size does not match file size reported by S3.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Previously registered storage file \"%s/%s\" has file size of %d bytes that does not match file size of %d bytes reported by S3.", testS3KeyPrefix, FILE_PATH_1, 2048L, 1024L), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageFilesAutoDiscoveryNoUnregisteredS3FilesExist() throws Exception {
        this.createData(testS3KeyPrefix, true, Arrays.asList(testS3KeyPrefix + "/" + FILE_PATH_1));
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList(FILE_PATH_1));
        try {
            this.businessObjectDataStorageFileService.createBusinessObjectDataStorageFiles(new BusinessObjectDataStorageFilesCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "S3_MANAGED", NO_STORAGE_FILES, DISCOVER_STORAGE_FILES));
            Assert.fail((String)"Should throw an IllegalArgumentException when no unregistered storage files are present in S3.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("No unregistered storage files were discovered at s3://%s/%s/ location.", this.storageDaoTestHelper.getS3ManagedBucketName(), testS3KeyPrefix), (Object)e.getMessage());
        }
    }

    @Test
    public void testBusinessObjectDataStorageFileServiceMethodsNewTx() throws Exception {
        BusinessObjectDataStorageFilesCreateRequest request = new BusinessObjectDataStorageFilesCreateRequest();
        try {
            this.businessObjectDataStorageFileServiceImpl.createBusinessObjectDataStorageFiles(request);
            Assert.fail((String)"Should throw a IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    private StorageFile createFile(String filePath, Long size, Long rowCount) {
        StorageFile f = new StorageFile();
        f.setFilePath(filePath);
        f.setFileSizeBytes(size);
        f.setRowCount(rowCount);
        return f;
    }

    private void createData(String storageUnitDirectory, boolean s3Managed) {
        this.createData(storageUnitDirectory, s3Managed, Arrays.asList(FILE_PATH_1));
    }

    private void createData(String storageUnitDirectory, boolean s3Managed, Collection<String> files) {
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS, DESCRIPTION, BDATA_STATUS_PRE_REGISTRATION_FLAG_SET);
        BusinessObjectDataEntity bod = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, DATA_VERSION, Boolean.valueOf(true), businessObjectDataStatusEntity.getCode());
        StorageEntity s = s3Managed ? this.storageDao.getStorageByName("S3_MANAGED") : this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, STORAGE_PLATFORM_CODE);
        StorageUnitEntity su = this.storageUnitDaoTestHelper.createStorageUnitEntity(s, bod, "ENABLED", storageUnitDirectory);
        for (String file : files) {
            StorageFileEntity f = this.storageFileDaoTestHelper.createStorageFileEntity(su, file, Long.valueOf(1024L), Long.valueOf(1000L));
            su.getStorageFiles().add(f);
        }
    }

    private void createDataWithSubPartitions() {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        DataProviderEntity dataProviderEntity = this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(namespaceEntity, BDEF_NAME, dataProviderEntity, null, null);
        FileTypeEntity fileTypeEntity = this.fileTypeDaoTestHelper.createFileTypeEntity(FORMAT_FILE_TYPE_CODE, FORMAT_DESCRIPTION);
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        SchemaColumn schemaColumn = new SchemaColumn();
        schemaColumn.setName(PARTITION_KEY);
        schemaColumn.setType("STRING");
        schemaColumns.add(schemaColumn);
        schemaColumn = new SchemaColumn();
        schemaColumn.setName(PARTITION_KEY_2);
        schemaColumn.setType("STRING");
        schemaColumns.add(schemaColumn);
        schemaColumn = new SchemaColumn();
        schemaColumn.setName(PARTITION_KEY_3);
        schemaColumn.setType("STRING");
        schemaColumns.add(schemaColumn);
        schemaColumn = new SchemaColumn();
        schemaColumn.setName(PARTITION_KEY_4);
        schemaColumn.setType("STRING");
        schemaColumns.add(schemaColumn);
        schemaColumn = new SchemaColumn();
        schemaColumn.setName(PARTITION_KEY_5);
        schemaColumn.setType("STRING");
        schemaColumns.add(schemaColumn);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(businessObjectDefinitionEntity, FORMAT_USAGE_CODE, fileTypeEntity, FORMAT_VERSION, null, Boolean.valueOf(true), PARTITION_KEY, null, NO_ATTRIBUTES, null, null, null, schemaColumns, null);
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS, DESCRIPTION, BDATA_STATUS_PRE_REGISTRATION_FLAG_SET);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, PARTITION_VALUE, SUB_PARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), businessObjectDataStatusEntity.getCode());
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, FILE_PATH_1, Long.valueOf(1024L), null);
    }
}

