/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKeys;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDefinitionService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDefinitionServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDefinitionServiceImpl")
    private BusinessObjectDefinitionService businessObjectDefinitionServiceImpl;

    @Test
    public void testCreateBusinessObjectDefinition() throws Exception {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinitionCreateRequest request = this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest("      \t\t ", BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, "      \t\t ", DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, "      \t\t ", BDEF_DESCRIPTION, BDEF_DISPLAY_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when data provider name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A data provider name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, Arrays.asList(new Attribute("      \t\t ", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionMissingOptionalParametersPassedAsWhitespace() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, "      \t\t ", "      \t\t ", Arrays.asList(new Attribute("Attribute Name 1", "      \t\t "))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, "      \t\t ", "", Arrays.asList(new Attribute("Attribute Name 1", "      \t\t "))), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionMissingOptionalParametersPassedAsNulls() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null, Arrays.asList(new Attribute("Attribute Name 1", null))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null, Arrays.asList(new Attribute("Attribute Name 1", null))), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionNoAttributes() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null));
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null, NO_ATTRIBUTES), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionTrimParameters() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(DATA_PROVIDER_NAME), this.addWhitespace(BDEF_DESCRIPTION), this.addWhitespace(BDEF_DISPLAY_NAME), Arrays.asList(new Attribute(this.addWhitespace("Attribute Name 1"), this.addWhitespace("Attribute Value 1")))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, this.addWhitespace(BDEF_DESCRIPTION), BDEF_DISPLAY_NAME, Arrays.asList(new Attribute("Attribute Name 1", this.addWhitespace("Attribute Value 1")))), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionUpperCaseParameters() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting(NAMESPACE.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase()))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase()))), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionLowerCaseParameters() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting(NAMESPACE.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase()))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase()))), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionInvalidParameters() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinitionCreateRequest request = this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest("I_DO_NOT_EXIST", BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", request.getNamespace()), (Object)e.getMessage());
        }
        request = this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(this.addSlash(BDEF_NAMESPACE), BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(BDEF_NAMESPACE, this.addSlash(BDEF_NAME), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name contains a forward slash character");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", BDEF_DESCRIPTION, BDEF_DISPLAY_NAME);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing data provider name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Data provider with name \"%s\" doesn't exist.", request.getDataProviderName()), (Object)e.getMessage());
        }
        request = this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(BDEF_NAMESPACE, BDEF_NAME, this.addSlash(DATA_PROVIDER_NAME), BDEF_DESCRIPTION, BDEF_DISPLAY_NAME);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when data provider name contains a forward slash character");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Data provider name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionDuplicateAttributes() {
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, Arrays.asList(new Attribute("Attribute Name 3".toLowerCase(), "Attribute Value 3"), new Attribute("Attribute Name 3".toUpperCase(), "Attribute Value 3"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate attributes are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate attribute name found: %s", "Attribute Name 3".toUpperCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionAlreadyExists() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME));
            Assert.fail((String)"Should throw an AlreadyExistsException when business object definition already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create business object definition with name \"%s\" because it already exists for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionDuplicateNamesWithDifferentNamespaces() throws Exception {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting(NAMESPACE_2, DATA_PROVIDER_NAME);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        BusinessObjectDefinitionCreateRequest request = this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionCreateRequest(NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinition() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, "      \t\t "), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, Arrays.asList(new Attribute("      \t\t ", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionTrimParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME)), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(this.addWhitespace(BDEF_DESCRIPTION_2), this.addWhitespace(BDEF_DISPLAY_NAME_2), Arrays.asList(new Attribute(this.addWhitespace("Attribute Name 1"), this.addWhitespace("Attribute Value 1")))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, this.addWhitespace(BDEF_DESCRIPTION_2), BDEF_DISPLAY_NAME_2, Arrays.asList(new Attribute("Attribute Name 1", this.addWhitespace("Attribute Value 1")))), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionUpperCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase())));
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2.toUpperCase(), BDEF_DISPLAY_NAME_2.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase()))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION_2.toUpperCase(), BDEF_DISPLAY_NAME_2.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toUpperCase()))), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionLowerCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase())));
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2.toLowerCase(), BDEF_DISPLAY_NAME_2.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase()))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION_2.toLowerCase(), BDEF_DISPLAY_NAME_2.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toLowerCase()))), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDuplicateAttributes() {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, Arrays.asList(new Attribute("Attribute Name 3".toLowerCase(), "Attribute Value 3"), new Attribute("Attribute Name 3".toUpperCase(), "Attribute Value 3"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate attributes are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate attribute name found: %s", "Attribute Name 3".toUpperCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionNoExists() throws Exception {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionNoOriginalAttributes() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDuplicateOriginalAttributes() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1"), new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1 Updated")));
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
            Assert.fail((String)"Should throw an IllegalStateException when business object definition contains duplicate attributes.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Found duplicate attribute with name \"%s\" for business object definition {namespace: \"%s\", businessObjectDefinitionName: \"%s\"}.", "Attribute Name 1".toLowerCase(), NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationrmation() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationrmationMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey("      \t\t ", BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(NAMESPACE, "      \t\t "), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationOptionalParametersPassedAsWhitespace() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest("      \t\t ", "      \t\t "));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, "      \t\t ", "      \t\t ".trim(), NO_ATTRIBUTES), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationrmationOptionalParametersPassedAsNulls() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(null, null));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null, NO_ATTRIBUTES), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationTrimParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME)), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(this.addWhitespace(BDEF_DESCRIPTION_2), this.addWhitespace(BDEF_DISPLAY_NAME_2)));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, this.addWhitespace(BDEF_DESCRIPTION_2), BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationUpperCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationLowerCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationBusinessObjectDefinitionNoExists() throws Exception {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), this.businessObjectDefinitionServiceTestHelper.createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DESCRIPTION_2));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinition() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionTrimParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME)));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionUpperCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionLowerCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionNoExists() throws Exception {
        try {
            this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionNewTransaction() throws Exception {
        try {
            this.businessObjectDefinitionServiceImpl.getBusinessObjectDefinition(new BusinessObjectDefinitionKey());
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitions() throws Exception {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions(NAMESPACE);
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeys(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsTrimParameters() {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions(this.addWhitespace(NAMESPACE));
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeys(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsUpperCaseParameters() {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions(NAMESPACE.toUpperCase());
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeys(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsLowerCaseParameters() {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions(NAMESPACE.toLowerCase());
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeys(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsEmptyList() throws Exception {
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions("I_DO_NOT_EXIST");
        Assert.assertNotNull((Object)resultKeys);
        Assert.assertEquals((long)0L, (long)resultKeys.getBusinessObjectDefinitionKeys().size());
    }

    @Test
    public void testDeleteBusinessObjectDefinition() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        Assert.assertNotNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
        BusinessObjectDefinition deletedBusinessObjectDefinition = this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)deletedBusinessObjectDefinition);
        Assert.assertNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDefinitionTrimParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        Assert.assertNotNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
        BusinessObjectDefinition deletedBusinessObjectDefinition = this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME)));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)deletedBusinessObjectDefinition);
        Assert.assertNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionUpperCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase());
        Assert.assertNotNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
        BusinessObjectDefinition deletedBusinessObjectDefinition = this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)deletedBusinessObjectDefinition);
        Assert.assertNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionLowerCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toLowerCase());
        Assert.assertNotNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
        BusinessObjectDefinition deletedBusinessObjectDefinition = this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId().intValue(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), (Object)deletedBusinessObjectDefinition);
        Assert.assertNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionNoExists() throws Exception {
        try {
            this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }
}

