/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.List;
import org.finra.herd.dao.DataProviderDaoTestHelper;
import org.finra.herd.dao.NamespaceDaoTestHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptiveInformationUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionUpdateRequest;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessObjectDefinitionServiceTestHelper {
    @Autowired
    private DataProviderDaoTestHelper dataProviderDaoTestHelper;
    @Autowired
    private NamespaceDaoTestHelper namespaceDaoTestHelper;

    public BusinessObjectDefinitionCreateRequest createBusinessObjectDefinitionCreateRequest(String namespaceCode, String businessObjectDefinitionName, String dataProviderName, String businessObjectDefinitionDescription, String displayName) {
        return this.createBusinessObjectDefinitionCreateRequest(namespaceCode, businessObjectDefinitionName, dataProviderName, businessObjectDefinitionDescription, displayName, AbstractServiceTest.NO_ATTRIBUTES);
    }

    public BusinessObjectDefinitionCreateRequest createBusinessObjectDefinitionCreateRequest(String namespaceCode, String businessObjectDefinitionName, String dataProviderName, String businessObjectDefinitionDescription, String displayName, List<Attribute> attributes) {
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest();
        request.setNamespace(namespaceCode);
        request.setBusinessObjectDefinitionName(businessObjectDefinitionName);
        request.setDataProviderName(dataProviderName);
        request.setDescription(businessObjectDefinitionDescription);
        request.setDisplayName(displayName);
        request.setAttributes(attributes);
        return request;
    }

    public BusinessObjectDefinitionDescriptiveInformationUpdateRequest createBusinessObjectDefinitionDescriptiveInformationUpdateRequest(String businessObjectDefinitionDescription, String displayName) {
        BusinessObjectDefinitionDescriptiveInformationUpdateRequest request = new BusinessObjectDefinitionDescriptiveInformationUpdateRequest();
        request.setDescription(businessObjectDefinitionDescription);
        request.setDisplayName(displayName);
        return request;
    }

    public BusinessObjectDefinitionUpdateRequest createBusinessObjectDefinitionUpdateRequest(String businessObjectDefinitionDescription, String displayName, List<Attribute> attributes) {
        BusinessObjectDefinitionUpdateRequest request = new BusinessObjectDefinitionUpdateRequest();
        request.setDescription(businessObjectDefinitionDescription);
        request.setDisplayName(displayName);
        request.setAttributes(attributes);
        return request;
    }

    public void createDatabaseEntitiesForBusinessObjectDefinitionTesting() {
        this.createDatabaseEntitiesForBusinessObjectDefinitionTesting(AbstractServiceTest.NAMESPACE, AbstractServiceTest.DATA_PROVIDER_NAME);
    }

    public void createDatabaseEntitiesForBusinessObjectDefinitionTesting(String namespaceCode, String dataProviderName) {
        this.namespaceDaoTestHelper.createNamespaceEntity(namespaceCode);
        this.dataProviderDaoTestHelper.createDataProviderEntity(dataProviderName);
    }

    public String getExpectedBusinessObjectDefinitionKeyAsString(BusinessObjectDefinitionKey businessObjectDefinitionKey) {
        return this.getExpectedBusinessObjectDefinitionKeyAsString(businessObjectDefinitionKey.getNamespace(), businessObjectDefinitionKey.getBusinessObjectDefinitionName());
    }

    public String getExpectedBusinessObjectDefinitionKeyAsString(String namespace, String businessObjectDefinitionName) {
        return String.format("namespace: \"%s\", businessObjectDefinitionName: \"%s\"", namespace, businessObjectDefinitionName);
    }

    public String getExpectedBusinessObjectDefinitionNotFoundErrorMessage(String namespace, String businessObjectDefinitionName) {
        return String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", businessObjectDefinitionName, namespace);
    }

    public List<Attribute> getNewAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("Attribute Name 1", "Attribute Value 1"));
        attributes.add(new Attribute("Attribute Name 2", "   Attribute Value 2  "));
        attributes.add(new Attribute("Attribute Name 3", "Attribute Value 3"));
        return attributes;
    }

    public List<Attribute> getNewAttributes2() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("Attribute Name 1", "Attribute Value 1 Updated"));
        attributes.add(new Attribute("Attribute Name 3", "Attribute Value 3"));
        attributes.add(new Attribute("Attribute Name 4", "Attribute Value 4"));
        return attributes;
    }

    public void validateAttributes(List<Attribute> expectedAttributes, List<Attribute> actualAttributes) {
        Assert.assertEquals((long)expectedAttributes.size(), (long)actualAttributes.size());
        for (int i = 0; i < expectedAttributes.size(); ++i) {
            Attribute expectedAttribute = expectedAttributes.get(i);
            Attribute actualAttribute = actualAttributes.get(i);
            Assert.assertEquals((Object)expectedAttribute.getName(), (Object)actualAttribute.getName());
            Assert.assertEquals((Object)expectedAttribute.getValue(), (Object)actualAttribute.getValue());
        }
    }
}

