/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionTag;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionTagCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionTagKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionTagKeys;
import org.finra.herd.model.api.xml.TagKey;
import org.finra.herd.model.jpa.BusinessObjectDefinitionTagEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDefinitionTagServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateBusinessObjectDefinitionTag() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionTagKey businessObjectDefinitionTagKey = new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, new TagKey(TAG_TYPE, TAG_CODE));
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(businessObjectDefinitionKey, DATA_PROVIDER_NAME, DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        BusinessObjectDefinitionTag result = this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(businessObjectDefinitionTagKey));
        Assert.assertEquals((Object)new BusinessObjectDefinitionTag(result.getId(), businessObjectDefinitionTagKey), (Object)result);
    }

    @Test
    public void testCreateBusinessObjectDefinitionTagBusinessObjectDefinitionNoExists() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE))));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionTagBusinessObjectDefinitionTagAlreadyExists() {
        BusinessObjectDefinitionTagKey businessObjectDefinitionTagKey = new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionTagKey);
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(businessObjectDefinitionTagKey));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Tag with tag type \"%s\" and code \"%s\" already exists for business object definition {%s}.", TAG_TYPE, TAG_CODE, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionTagInvalidParameters() {
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(this.addSlash(BDEF_NAMESPACE), BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, this.addSlash(BDEF_NAME)), new TagKey(TAG_TYPE, TAG_CODE))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(this.addSlash(TAG_TYPE), TAG_CODE))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag type code can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, this.addSlash(TAG_CODE)))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag code can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionTagLowerCaseParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        BusinessObjectDefinitionTag result = this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()), new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()))));
        Assert.assertEquals((Object)new BusinessObjectDefinitionTag(result.getId(), new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE))), (Object)result);
    }

    @Test
    public void testCreateBusinessObjectDefinitionTagMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey("      \t\t ", BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, "      \t\t "), new TagKey(TAG_TYPE, TAG_CODE))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey("      \t\t ", TAG_CODE))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, "      \t\t "))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionTagTagNoExists() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, DESCRIPTION);
        try {
            this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE))));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionTagTrimParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        BusinessObjectDefinitionTag result = this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME)), new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)))));
        Assert.assertEquals((Object)new BusinessObjectDefinitionTag(result.getId(), new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE))), (Object)result);
    }

    @Test
    public void testCreateBusinessObjectDefinitionTagUpperCaseParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        BusinessObjectDefinitionTag result = this.businessObjectDefinitionTagService.createBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagCreateRequest(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()), new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()))));
        Assert.assertEquals((Object)new BusinessObjectDefinitionTag(result.getId(), new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE))), (Object)result);
    }

    @Test
    public void testDeleteBusinessObjectDefinitionTag() {
        BusinessObjectDefinitionTagKey businessObjectDefinitionTagKey = new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        BusinessObjectDefinitionTagEntity businessObjectDefinitionTagEntity = this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertNotNull((Object)this.businessObjectDefinitionTagDao.getBusinessObjectDefinitionTagByKey(businessObjectDefinitionTagKey));
        BusinessObjectDefinitionTag result = this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(businessObjectDefinitionTagKey);
        Assert.assertEquals((Object)new BusinessObjectDefinitionTag(businessObjectDefinitionTagEntity.getId().intValue(), businessObjectDefinitionTagKey), (Object)result);
        Assert.assertNull((Object)this.businessObjectDefinitionTagDao.getBusinessObjectDefinitionTagByKey(businessObjectDefinitionTagKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionTagLowerCaseParameters() {
        BusinessObjectDefinitionTagKey businessObjectDefinitionTagKey = new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        BusinessObjectDefinitionTagEntity businessObjectDefinitionTagEntity = this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertNotNull((Object)this.businessObjectDefinitionTagDao.getBusinessObjectDefinitionTagByKey(businessObjectDefinitionTagKey));
        BusinessObjectDefinitionTag result = this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()), new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase())));
        Assert.assertEquals((Object)new BusinessObjectDefinitionTag(businessObjectDefinitionTagEntity.getId().intValue(), businessObjectDefinitionTagKey), (Object)result);
        Assert.assertNull((Object)this.businessObjectDefinitionTagDao.getBusinessObjectDefinitionTagByKey(businessObjectDefinitionTagKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionTagMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey("      \t\t ", BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, "      \t\t "), new TagKey(TAG_TYPE, TAG_CODE)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey("      \t\t ", TAG_CODE)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, "      \t\t ")));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDefinitionTagTagNoExists() {
        try {
            this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with tag type \"%s\" and code \"%s\" does not exist for business object definition {%s}.", TAG_TYPE, TAG_CODE, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDefinitionTagTrimParameters() {
        BusinessObjectDefinitionTagKey businessObjectDefinitionTagKey = new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        BusinessObjectDefinitionTagEntity businessObjectDefinitionTagEntity = this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertNotNull((Object)this.businessObjectDefinitionTagDao.getBusinessObjectDefinitionTagByKey(businessObjectDefinitionTagKey));
        BusinessObjectDefinitionTag result = this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME)), new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE))));
        Assert.assertEquals((Object)new BusinessObjectDefinitionTag(businessObjectDefinitionTagEntity.getId().intValue(), businessObjectDefinitionTagKey), (Object)result);
        Assert.assertNull((Object)this.businessObjectDefinitionTagDao.getBusinessObjectDefinitionTagByKey(businessObjectDefinitionTagKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionTagUpperCaseParameters() {
        BusinessObjectDefinitionTagKey businessObjectDefinitionTagKey = new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        BusinessObjectDefinitionTagEntity businessObjectDefinitionTagEntity = this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertNotNull((Object)this.businessObjectDefinitionTagDao.getBusinessObjectDefinitionTagByKey(businessObjectDefinitionTagKey));
        BusinessObjectDefinitionTag result = this.businessObjectDefinitionTagService.deleteBusinessObjectDefinitionTag(new BusinessObjectDefinitionTagKey(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()), new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase())));
        Assert.assertEquals((Object)new BusinessObjectDefinitionTag(businessObjectDefinitionTagEntity.getId().intValue(), businessObjectDefinitionTagKey), (Object)result);
        Assert.assertNull((Object)this.businessObjectDefinitionTagDao.getBusinessObjectDefinitionTagByKey(businessObjectDefinitionTagKey));
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByBusinessObjectDefinition() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        List<TagKey> tagKeys = Arrays.asList(new TagKey(TAG_TYPE, TAG_CODE), new TagKey(TAG_TYPE_2, TAG_CODE_2));
        for (TagKey tagKey : tagKeys) {
            this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionKey, tagKey);
        }
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByBusinessObjectDefinition(businessObjectDefinitionKey);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, tagKeys.get(0)), new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, tagKeys.get(1))), (Object)result.getBusinessObjectDefinitionTagKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByBusinessObjectDefinitionBusinessObjectDefinitionNoExists() {
        try {
            this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByBusinessObjectDefinitionLowerCaseParameters() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        List<TagKey> tagKeys = Arrays.asList(new TagKey(TAG_TYPE, TAG_CODE), new TagKey(TAG_TYPE_2, TAG_CODE_2));
        for (TagKey tagKey : tagKeys) {
            this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionKey, tagKey);
        }
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, tagKeys.get(0)), new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, tagKeys.get(1))), (Object)result.getBusinessObjectDefinitionTagKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByBusinessObjectDefinition(new BusinessObjectDefinitionKey("      \t\t ", BDEF_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByBusinessObjectDefinitionNoBusinessObjectDefinitionTagsExist() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(businessObjectDefinitionKey, DATA_PROVIDER_NAME, DESCRIPTION);
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByBusinessObjectDefinition(businessObjectDefinitionKey);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getBusinessObjectDefinitionTagKeys().isEmpty());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByBusinessObjectDefinitionTrimParameters() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        List<TagKey> tagKeys = Arrays.asList(new TagKey(TAG_TYPE, TAG_CODE), new TagKey(TAG_TYPE_2, TAG_CODE_2));
        for (TagKey tagKey : tagKeys) {
            this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionKey, tagKey);
        }
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME)));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, tagKeys.get(0)), new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, tagKeys.get(1))), (Object)result.getBusinessObjectDefinitionTagKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByBusinessObjectDefinitionUpperCaseParameters() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        List<TagKey> tagKeys = Arrays.asList(new TagKey(TAG_TYPE, TAG_CODE), new TagKey(TAG_TYPE_2, TAG_CODE_2));
        for (TagKey tagKey : tagKeys) {
            this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionKey, tagKey);
        }
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, tagKeys.get(0)), new BusinessObjectDefinitionTagKey(businessObjectDefinitionKey, tagKeys.get(1))), (Object)result.getBusinessObjectDefinitionTagKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByTag() {
        List<BusinessObjectDefinitionKey> businessObjectDefinitionKeys = Arrays.asList(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionKey(BDEF_NAMESPACE_2, BDEF_NAME_2));
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        for (BusinessObjectDefinitionKey businessObjectDefinitionKey : businessObjectDefinitionKeys) {
            this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionKey, tagKey);
        }
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByTag(tagKey);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(new BusinessObjectDefinitionTagKey(businessObjectDefinitionKeys.get(0), tagKey), new BusinessObjectDefinitionTagKey(businessObjectDefinitionKeys.get(1), tagKey)), (Object)result.getBusinessObjectDefinitionTagKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByTagLowerCaseParameters() {
        List<BusinessObjectDefinitionKey> businessObjectDefinitionKeys = Arrays.asList(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionKey(BDEF_NAMESPACE_2, BDEF_NAME_2));
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        for (BusinessObjectDefinitionKey businessObjectDefinitionKey : businessObjectDefinitionKeys) {
            this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionKey, tagKey);
        }
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByTag(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(new BusinessObjectDefinitionTagKey(businessObjectDefinitionKeys.get(0), tagKey), new BusinessObjectDefinitionTagKey(businessObjectDefinitionKeys.get(1), tagKey)), (Object)result.getBusinessObjectDefinitionTagKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByTagMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByTag(new TagKey("      \t\t ", TAG_CODE));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByTag(new TagKey(TAG_TYPE, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByTagNoBusinessObjectDefinitionTagsExist() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByTag(new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getBusinessObjectDefinitionTagKeys().isEmpty());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByTagTagNoExists() {
        try {
            this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByTag(new TagKey(TAG_TYPE, TAG_CODE));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByTagTrimParamters() {
        List<BusinessObjectDefinitionKey> businessObjectDefinitionKeys = Arrays.asList(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionKey(BDEF_NAMESPACE_2, BDEF_NAME_2));
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        for (BusinessObjectDefinitionKey businessObjectDefinitionKey : businessObjectDefinitionKeys) {
            this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionKey, tagKey);
        }
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByTag(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(new BusinessObjectDefinitionTagKey(businessObjectDefinitionKeys.get(0), tagKey), new BusinessObjectDefinitionTagKey(businessObjectDefinitionKeys.get(1), tagKey)), (Object)result.getBusinessObjectDefinitionTagKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionTagsByTagUpperCaseParameters() {
        List<BusinessObjectDefinitionKey> businessObjectDefinitionKeys = Arrays.asList(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionKey(BDEF_NAMESPACE_2, BDEF_NAME_2));
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        for (BusinessObjectDefinitionKey businessObjectDefinitionKey : businessObjectDefinitionKeys) {
            this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionKey, tagKey);
        }
        BusinessObjectDefinitionTagKeys result = this.businessObjectDefinitionTagService.getBusinessObjectDefinitionTagsByTag(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(new BusinessObjectDefinitionTagKey(businessObjectDefinitionKeys.get(0), tagKey), new BusinessObjectDefinitionTagKey(businessObjectDefinitionKeys.get(1), tagKey)), (Object)result.getBusinessObjectDefinitionTagKeys());
    }
}

