/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.dao.BusinessObjectDefinitionDaoTestHelper;
import org.finra.herd.dao.BusinessObjectFormatDao;
import org.finra.herd.dao.BusinessObjectFormatDaoTestHelper;
import org.finra.herd.dao.CustomDdlDaoTestHelper;
import org.finra.herd.dao.DataProviderDaoTestHelper;
import org.finra.herd.dao.FileTypeDaoTestHelper;
import org.finra.herd.dao.NamespaceDaoTestHelper;
import org.finra.herd.dao.PartitionKeyGroupDaoTestHelper;
import org.finra.herd.dao.SchemaColumnDaoTestHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.AttributeDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlOutputFormatEnum;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormat;
import org.finra.herd.model.api.xml.BusinessObjectFormatCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdl;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdlCollectionRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdlCollectionResponse;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdlRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatUpdateRequest;
import org.finra.herd.model.api.xml.Schema;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.DataProviderEntity;
import org.finra.herd.model.jpa.FileTypeEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.SchemaColumnEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectFormatService;
import org.finra.herd.service.CustomDdlServiceTestHelper;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BusinessObjectFormatServiceTestHelper {
    @Autowired
    private BusinessObjectDefinitionDaoTestHelper businessObjectDefinitionDaoTestHelper;
    @Autowired
    private BusinessObjectFormatDao businessObjectFormatDao;
    @Autowired
    private BusinessObjectFormatDaoTestHelper businessObjectFormatDaoTestHelper;
    @Autowired
    private BusinessObjectFormatService businessObjectFormatService;
    @Autowired
    private CustomDdlDaoTestHelper customDdlDaoTestHelper;
    @Autowired
    private CustomDdlServiceTestHelper customDdlServiceTestHelper;
    @Autowired
    private DataProviderDaoTestHelper dataProviderDaoTestHelper;
    @Autowired
    private FileTypeDaoTestHelper fileTypeDaoTestHelper;
    @Autowired
    private NamespaceDaoTestHelper namespaceDaoTestHelper;
    @Autowired
    private PartitionKeyGroupDaoTestHelper partitionKeyGroupDaoTestHelper;
    @Autowired
    private SchemaColumnDaoTestHelper schemaColumnDaoTestHelper;

    public BusinessObjectFormatEntity createBusinessObjectFormat(BusinessObjectDataInvalidateUnregisteredRequest request) {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(request.getNamespace());
        DataProviderEntity dataProviderEntity = this.dataProviderDaoTestHelper.createDataProviderEntity(AbstractServiceTest.DATA_PROVIDER_NAME);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(namespaceEntity, request.getBusinessObjectDefinitionName(), dataProviderEntity, null, null);
        FileTypeEntity fileTypeEntity = this.fileTypeDaoTestHelper.createFileTypeEntity(request.getBusinessObjectFormatFileType());
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        businessObjectFormatEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectFormatEntity.setUsage(request.getBusinessObjectFormatUsage());
        businessObjectFormatEntity.setFileType(fileTypeEntity);
        businessObjectFormatEntity.setBusinessObjectFormatVersion(request.getBusinessObjectFormatVersion());
        if (!CollectionUtils.isEmpty((Collection)request.getSubPartitionValues())) {
            ArrayList<SchemaColumnEntity> schemaColumnEntities = new ArrayList<SchemaColumnEntity>();
            for (int partitionLevel = 0; partitionLevel < request.getSubPartitionValues().size() + 1; ++partitionLevel) {
                SchemaColumnEntity schemaColumnEntity = new SchemaColumnEntity();
                schemaColumnEntity.setBusinessObjectFormat(businessObjectFormatEntity);
                schemaColumnEntity.setName(AbstractServiceTest.PARTITION_KEY + partitionLevel);
                schemaColumnEntity.setType("STRING");
                schemaColumnEntity.setPartitionLevel(Integer.valueOf(partitionLevel));
                schemaColumnEntity.setPosition(Integer.valueOf(partitionLevel));
                schemaColumnEntities.add(schemaColumnEntity);
            }
            businessObjectFormatEntity.setSchemaColumns(schemaColumnEntities);
            businessObjectFormatEntity.setPartitionKey(AbstractServiceTest.PARTITION_KEY + "0");
        } else {
            businessObjectFormatEntity.setPartitionKey(AbstractServiceTest.PARTITION_KEY);
        }
        businessObjectFormatEntity.setLatestVersion(Boolean.valueOf(true));
        this.businessObjectFormatDao.saveAndRefresh((Object)businessObjectFormatEntity);
        return businessObjectFormatEntity;
    }

    public BusinessObjectFormatCreateRequest createBusinessObjectFormatCreateRequest(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, String partitionKey, String description, List<Attribute> attributes, List<AttributeDefinition> attributeDefinitions, Schema schema) {
        BusinessObjectFormatCreateRequest businessObjectFormatCreateRequest = new BusinessObjectFormatCreateRequest();
        businessObjectFormatCreateRequest.setNamespace(namespaceCode);
        businessObjectFormatCreateRequest.setBusinessObjectDefinitionName(businessObjectDefinitionName);
        businessObjectFormatCreateRequest.setBusinessObjectFormatUsage(businessObjectFormatUsage);
        businessObjectFormatCreateRequest.setBusinessObjectFormatFileType(businessObjectFormatFileType);
        businessObjectFormatCreateRequest.setPartitionKey(partitionKey);
        businessObjectFormatCreateRequest.setDescription(description);
        businessObjectFormatCreateRequest.setAttributes(attributes);
        businessObjectFormatCreateRequest.setAttributeDefinitions(attributeDefinitions);
        businessObjectFormatCreateRequest.setSchema(schema);
        return businessObjectFormatCreateRequest;
    }

    public BusinessObjectFormatUpdateRequest createBusinessObjectFormatUpdateRequest(String description, List<Attribute> attributes, Schema schema) {
        BusinessObjectFormatUpdateRequest businessObjectFormatCreateRequest = new BusinessObjectFormatUpdateRequest();
        businessObjectFormatCreateRequest.setDescription(description);
        businessObjectFormatCreateRequest.setAttributes(attributes);
        businessObjectFormatCreateRequest.setSchema(schema);
        return businessObjectFormatCreateRequest;
    }

    public void createDatabaseEntitiesForBusinessObjectFormatDdlCollectionTesting() {
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        schemaColumns.add(new SchemaColumn("PRTN_CLMN001", "DATE", AbstractServiceTest.NO_COLUMN_SIZE, AbstractServiceTest.COLUMN_REQUIRED, AbstractServiceTest.NO_COLUMN_DEFAULT_VALUE, AbstractServiceTest.NO_COLUMN_DESCRIPTION));
        schemaColumns.add(new SchemaColumn(AbstractServiceTest.COLUMN_NAME, "NUMBER", AbstractServiceTest.COLUMN_SIZE, AbstractServiceTest.NO_COLUMN_REQUIRED, AbstractServiceTest.COLUMN_DEFAULT_VALUE, AbstractServiceTest.COLUMN_DESCRIPTION));
        List partitionColumns = schemaColumns.subList(0, 1);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.FORMAT_DESCRIPTION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", AbstractServiceTest.NO_PARTITION_KEY_GROUP, AbstractServiceTest.NO_ATTRIBUTES, "|", "\\", "\\N", schemaColumns, partitionColumns);
    }

    public void createDatabaseEntitiesForBusinessObjectFormatDdlTesting() {
        this.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", "PRTN_CLMN001", "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), AbstractServiceTest.CUSTOM_DDL_NAME);
    }

    public void createDatabaseEntitiesForBusinessObjectFormatDdlTesting(String businessObjectFormatFileType, String partitionKey, String schemaDelimiterCharacter, String schemaEscapeCharacter, String schemaNullValue, List<SchemaColumn> schemaColumns, List<SchemaColumn> partitionColumns, String customDdlName) {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, businessObjectFormatFileType, AbstractServiceTest.FORMAT_VERSION));
        if (businessObjectFormatEntity == null) {
            businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, businessObjectFormatFileType, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.FORMAT_DESCRIPTION, AbstractServiceTest.LATEST_VERSION_FLAG_SET, partitionKey, AbstractServiceTest.NO_PARTITION_KEY_GROUP, AbstractServiceTest.NO_ATTRIBUTES, schemaDelimiterCharacter, schemaEscapeCharacter, schemaNullValue, schemaColumns, partitionColumns);
        }
        if (StringUtils.isNotBlank((CharSequence)customDdlName)) {
            boolean partitioned = partitionColumns != null;
            this.customDdlDaoTestHelper.createCustomDdlEntity(businessObjectFormatEntity, customDdlName, this.customDdlServiceTestHelper.getTestCustomDdl(partitioned));
        }
    }

    public BusinessObjectFormat createTestBusinessObjectFormat() {
        return this.createTestBusinessObjectFormat(AbstractServiceTest.NO_ATTRIBUTES);
    }

    public BusinessObjectFormat createTestBusinessObjectFormat(List<Attribute> attributes) {
        this.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.createBusinessObjectFormatCreateRequest(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.FORMAT_DESCRIPTION, attributes, this.getTestAttributeDefinitions(), this.getTestSchema());
        return this.businessObjectFormatService.createBusinessObjectFormat(request);
    }

    public void createTestDatabaseEntitiesForBusinessObjectFormatTesting() {
        this.createTestDatabaseEntitiesForBusinessObjectFormatTesting(AbstractServiceTest.NAMESPACE, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.PARTITION_KEY_GROUP);
    }

    public void createTestDatabaseEntitiesForBusinessObjectFormatTesting(String namespaceCode, String dataProviderName, String businessObjectDefinitionName, String businessObjectFormatFileType, String partitionKeyGroupName) {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(namespaceCode, businessObjectDefinitionName, dataProviderName, AbstractServiceTest.BDEF_DESCRIPTION);
        this.fileTypeDaoTestHelper.createFileTypeEntity(businessObjectFormatFileType, AbstractServiceTest.FORMAT_FILE_TYPE_DESCRIPTION);
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(partitionKeyGroupName);
    }

    public String getExpectedBusinessObjectFormatDdl() {
        StringBuilder ddlBuilder = new StringBuilder();
        ddlBuilder.append("DROP TABLE IF EXISTS `" + AbstractServiceTest.TABLE_NAME + "`;\n");
        ddlBuilder.append("\n");
        ddlBuilder.append("CREATE EXTERNAL TABLE IF NOT EXISTS `" + AbstractServiceTest.TABLE_NAME + "` (\n");
        ddlBuilder.append("    `ORGNL_PRTN_CLMN001` DATE,\n");
        ddlBuilder.append("    `" + AbstractServiceTest.COLUMN_NAME + "` DECIMAL(" + AbstractServiceTest.COLUMN_SIZE + ") COMMENT '" + AbstractServiceTest.COLUMN_DESCRIPTION + "')\n");
        ddlBuilder.append("PARTITIONED BY (`PRTN_CLMN001` DATE)\n");
        ddlBuilder.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'\n");
        ddlBuilder.append("STORED AS TEXTFILE;");
        return ddlBuilder.toString();
    }

    public String getExpectedBusinessObjectFormatDdl(int partitionLevels, String firstColumnName, String firstColumnDataType, String hiveRowFormat, String hiveFileFormat, String businessObjectFormatFileType, boolean isDropStatementIncluded, boolean isIfNotExistsOptionIncluded) {
        StringBuilder sb = new StringBuilder();
        if (isDropStatementIncluded) {
            sb.append("DROP TABLE IF EXISTS `[Table Name]`;\n\n");
        }
        sb.append("CREATE EXTERNAL TABLE [If Not Exists]`[Table Name]` (\n");
        sb.append(String.format("    `%s` %s,\n", firstColumnName, firstColumnDataType));
        sb.append("    `COLUMN002` SMALLINT COMMENT 'This is \\'COLUMN002\\' column. ");
        sb.append("Here are \\'single\\' and \"double\" quotes along with a backslash \\.',\n");
        sb.append("    `COLUMN003` INT,\n");
        sb.append("    `COLUMN004` BIGINT,\n");
        sb.append("    `COLUMN005` FLOAT,\n");
        sb.append("    `COLUMN006` DOUBLE,\n");
        sb.append("    `COLUMN007` DECIMAL,\n");
        sb.append("    `COLUMN008` DECIMAL(p,s),\n");
        sb.append("    `COLUMN009` DECIMAL,\n");
        sb.append("    `COLUMN010` DECIMAL(p),\n");
        sb.append("    `COLUMN011` DECIMAL(p,s),\n");
        sb.append("    `COLUMN012` TIMESTAMP,\n");
        sb.append("    `COLUMN013` DATE,\n");
        sb.append("    `COLUMN014` STRING,\n");
        sb.append("    `COLUMN015` VARCHAR(n),\n");
        sb.append("    `COLUMN016` VARCHAR(n),\n");
        sb.append("    `COLUMN017` CHAR(n),\n");
        sb.append("    `COLUMN018` BOOLEAN,\n");
        sb.append("    `COLUMN019` BINARY)\n");
        if (partitionLevels > 0) {
            if (partitionLevels > 1) {
                sb.append("PARTITIONED BY (`PRTN_CLMN001` DATE, `PRTN_CLMN002` STRING, `PRTN_CLMN003` INT, `PRTN_CLMN004` DECIMAL, `PRTN_CLMN005` BOOLEAN, `PRTN_CLMN006` DECIMAL, `PRTN_CLMN007` DECIMAL)\n");
            } else {
                sb.append("PARTITIONED BY (`PRTN_CLMN001` DATE)\n");
            }
        }
        sb.append("[Row Format]\n");
        sb.append(String.format("STORED AS [Hive File Format]%s\n", partitionLevels > 0 ? ";" : ""));
        if (partitionLevels == 0) {
            sb.append("LOCATION '${non-partitioned.table.location}';");
        }
        String ddlTemplate = sb.toString().trim();
        Pattern pattern = Pattern.compile("\\[(.+?)\\]");
        Matcher matcher = pattern.matcher(ddlTemplate);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("Table Name", AbstractServiceTest.TABLE_NAME);
        replacements.put("Random Suffix", AbstractServiceTest.RANDOM_SUFFIX);
        replacements.put("Format Version", String.valueOf(AbstractServiceTest.FORMAT_VERSION));
        replacements.put("Data Version", String.valueOf(AbstractServiceTest.DATA_VERSION));
        replacements.put("Row Format", hiveRowFormat);
        replacements.put("Hive File Format", hiveFileFormat);
        replacements.put("Format File Type", businessObjectFormatFileType.toLowerCase());
        replacements.put("If Not Exists", isIfNotExistsOptionIncluded ? "IF NOT EXISTS " : "");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = (String)replacements.get(matcher.group(1));
            builder.append(ddlTemplate.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(ddlTemplate.substring(i, ddlTemplate.length()));
        return builder.toString();
    }

    public BusinessObjectFormatDdlCollectionResponse getExpectedBusinessObjectFormatDdlCollectionResponse() {
        BusinessObjectFormatDdlCollectionResponse businessObjectFormatDdlCollectionResponse = new BusinessObjectFormatDdlCollectionResponse();
        ArrayList<BusinessObjectFormatDdl> businessObjectFormatDdlResponses = new ArrayList<BusinessObjectFormatDdl>();
        businessObjectFormatDdlCollectionResponse.setBusinessObjectFormatDdlResponses(businessObjectFormatDdlResponses);
        String expectedDdl = this.getExpectedBusinessObjectFormatDdl();
        BusinessObjectFormatDdl expectedBusinessObjectFormatDdl = new BusinessObjectFormatDdl(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, AbstractServiceTest.TABLE_NAME, AbstractServiceTest.NO_CUSTOM_DDL_NAME, expectedDdl);
        businessObjectFormatDdlResponses.add(expectedBusinessObjectFormatDdl);
        businessObjectFormatDdlResponses.add(expectedBusinessObjectFormatDdl);
        businessObjectFormatDdlCollectionResponse.setDdlCollection(String.format("%s\n\n%s", expectedDdl, expectedDdl));
        return businessObjectFormatDdlCollectionResponse;
    }

    public String getExpectedBusinessObjectFormatKeyAsString(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, Integer businessObjectFormatVersion) {
        return String.format("namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d", namespaceCode, businessObjectDefinitionName, businessObjectFormatUsage, businessObjectFormatFileType, businessObjectFormatVersion);
    }

    public String getExpectedBusinessObjectFormatNotFoundErrorMessage(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, Integer businessObjectFormatVersion) {
        return String.format("Business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\" doesn't exist.", namespaceCode, businessObjectDefinitionName, businessObjectFormatUsage, businessObjectFormatFileType, businessObjectFormatVersion);
    }

    public List<AttributeDefinition> getTestAttributeDefinitions() {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 1", AbstractServiceTest.NO_PUBLISH_ATTRIBUTE));
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 2", AbstractServiceTest.NO_PUBLISH_ATTRIBUTE));
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 3", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        return attributeDefinitions;
    }

    public BusinessObjectFormatDdlCollectionRequest getTestBusinessObjectFormatDdlCollectionRequest() {
        BusinessObjectFormatDdlCollectionRequest businessObjectFormatDdlCollectionRequest = new BusinessObjectFormatDdlCollectionRequest();
        ArrayList<BusinessObjectFormatDdlRequest> businessObjectFormatDdlRequests = new ArrayList<BusinessObjectFormatDdlRequest>();
        businessObjectFormatDdlCollectionRequest.setBusinessObjectFormatDdlRequests(businessObjectFormatDdlRequests);
        BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = new BusinessObjectFormatDdlRequest(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, AbstractServiceTest.TABLE_NAME, AbstractServiceTest.NO_CUSTOM_DDL_NAME, AbstractServiceTest.INCLUDE_DROP_TABLE_STATEMENT, AbstractServiceTest.INCLUDE_IF_NOT_EXISTS_OPTION, null);
        businessObjectFormatDdlRequests.add(businessObjectFormatDdlRequest);
        businessObjectFormatDdlRequests.add(businessObjectFormatDdlRequest);
        return businessObjectFormatDdlCollectionRequest;
    }

    public BusinessObjectFormatDdlRequest getTestBusinessObjectFormatDdlRequest(String customDdlName) {
        BusinessObjectFormatDdlRequest request = new BusinessObjectFormatDdlRequest();
        request.setNamespace(AbstractServiceTest.NAMESPACE);
        request.setBusinessObjectDefinitionName(AbstractServiceTest.BDEF_NAME);
        request.setBusinessObjectFormatUsage(AbstractServiceTest.FORMAT_USAGE_CODE);
        request.setBusinessObjectFormatFileType("TXT");
        request.setBusinessObjectFormatVersion(AbstractServiceTest.FORMAT_VERSION);
        request.setOutputFormat(BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL);
        request.setTableName(AbstractServiceTest.TABLE_NAME);
        request.setCustomDdlName(customDdlName);
        request.setIncludeDropTableStatement(Boolean.valueOf(true));
        request.setIncludeIfNotExistsOption(Boolean.valueOf(true));
        return request;
    }

    public Schema getTestSchema() {
        Schema schema = new Schema();
        schema.setNullValue("\\N");
        schema.setDelimiter("|");
        schema.setEscapeCharacter("\\");
        schema.setPartitionKeyGroup(AbstractServiceTest.PARTITION_KEY_GROUP);
        schema.setColumns(this.schemaColumnDaoTestHelper.getTestSchemaColumns(AbstractServiceTest.RANDOM_SUFFIX));
        schema.setPartitions(this.schemaColumnDaoTestHelper.getTestPartitionColumns(AbstractServiceTest.RANDOM_SUFFIX));
        return schema;
    }

    public Schema getTestSchema2() {
        Schema schema = new Schema();
        schema.setNullValue("NULL");
        schema.setDelimiter(",");
        schema.setEscapeCharacter("~");
        schema.setPartitionKeyGroup(AbstractServiceTest.PARTITION_KEY_GROUP_2);
        schema.setColumns(this.schemaColumnDaoTestHelper.getTestSchemaColumns(AbstractServiceTest.RANDOM_SUFFIX_2));
        schema.setPartitions(this.schemaColumnDaoTestHelper.getTestPartitionColumns(AbstractServiceTest.RANDOM_SUFFIX_2));
        return schema;
    }

    public void validateBusinessObjectFormat(Integer expectedBusinessObjectFormatId, String expectedNamespaceCode, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, Boolean expectedIsLatestVersion, String expectedPartitionKey, String expectedDescription, List<Attribute> expectedAttributes, List<AttributeDefinition> expectedAttributeDefinitions, Schema expectedSchema, BusinessObjectFormat actualBusinessObjectFormat) {
        Assert.assertNotNull((Object)actualBusinessObjectFormat);
        if (expectedBusinessObjectFormatId != null) {
            Assert.assertEquals((Object)expectedBusinessObjectFormatId, (Object)actualBusinessObjectFormat.getId());
        }
        Assert.assertEquals((Object)expectedNamespaceCode, (Object)actualBusinessObjectFormat.getNamespace());
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionName, (Object)actualBusinessObjectFormat.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)expectedBusinessObjectFormatUsage, (Object)actualBusinessObjectFormat.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)expectedBusinessObjectFormatFileType, (Object)actualBusinessObjectFormat.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)expectedBusinessObjectFormatVersion, (Object)actualBusinessObjectFormat.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)expectedIsLatestVersion, (Object)actualBusinessObjectFormat.isLatestVersion());
        Assert.assertEquals((Object)expectedPartitionKey, (Object)actualBusinessObjectFormat.getPartitionKey());
        AbstractServiceTest.assertEqualsIgnoreNullOrEmpty((String)"description", (String)expectedDescription, (String)actualBusinessObjectFormat.getDescription());
        if (!CollectionUtils.isEmpty(expectedAttributes)) {
            Assert.assertEquals(expectedAttributes, (Object)actualBusinessObjectFormat.getAttributes());
        } else {
            Assert.assertEquals((long)0L, (long)actualBusinessObjectFormat.getAttributes().size());
        }
        if (!CollectionUtils.isEmpty(expectedAttributeDefinitions)) {
            Assert.assertEquals(expectedAttributeDefinitions, (Object)actualBusinessObjectFormat.getAttributeDefinitions());
        } else {
            Assert.assertEquals((long)0L, (long)actualBusinessObjectFormat.getAttributeDefinitions().size());
        }
        if (expectedSchema != null) {
            int i;
            Assert.assertNotNull((Object)actualBusinessObjectFormat.getSchema());
            AbstractServiceTest.assertEqualsIgnoreNullOrEmpty((String)"null value", (String)expectedSchema.getNullValue(), (String)actualBusinessObjectFormat.getSchema().getNullValue());
            AbstractServiceTest.assertEqualsIgnoreNullOrEmpty((String)"delimiter", (String)expectedSchema.getDelimiter(), (String)actualBusinessObjectFormat.getSchema().getDelimiter());
            AbstractServiceTest.assertEqualsIgnoreNullOrEmpty((String)"escape character", (String)expectedSchema.getEscapeCharacter(), (String)actualBusinessObjectFormat.getSchema().getEscapeCharacter());
            Assert.assertEquals((Object)expectedSchema.getPartitionKeyGroup(), (Object)actualBusinessObjectFormat.getSchema().getPartitionKeyGroup());
            Assert.assertEquals((long)expectedSchema.getColumns().size(), (long)actualBusinessObjectFormat.getSchema().getColumns().size());
            for (i = 0; i < expectedSchema.getColumns().size(); ++i) {
                SchemaColumn expectedSchemaColumn = (SchemaColumn)expectedSchema.getColumns().get(i);
                SchemaColumn actualSchemaColumn = (SchemaColumn)actualBusinessObjectFormat.getSchema().getColumns().get(i);
                Assert.assertEquals((Object)expectedSchemaColumn.getName(), (Object)actualSchemaColumn.getName());
                Assert.assertEquals((Object)expectedSchemaColumn.getType(), (Object)actualSchemaColumn.getType());
                Assert.assertEquals((Object)expectedSchemaColumn.getSize(), (Object)actualSchemaColumn.getSize());
                Assert.assertEquals((Object)expectedSchemaColumn.isRequired(), (Object)actualSchemaColumn.isRequired());
                Assert.assertEquals((Object)expectedSchemaColumn.getDefaultValue(), (Object)actualSchemaColumn.getDefaultValue());
                Assert.assertEquals((Object)expectedSchemaColumn.getDescription(), (Object)actualSchemaColumn.getDescription());
            }
            if (CollectionUtils.isEmpty((Collection)expectedSchema.getPartitions())) {
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)actualBusinessObjectFormat.getSchema().getPartitions()));
            } else {
                for (i = 0; i < expectedSchema.getPartitions().size(); ++i) {
                    SchemaColumn expectedPartitionColumn = (SchemaColumn)expectedSchema.getPartitions().get(i);
                    SchemaColumn actualPartitionColumn = (SchemaColumn)actualBusinessObjectFormat.getSchema().getPartitions().get(i);
                    Assert.assertEquals((Object)expectedPartitionColumn.getName(), (Object)actualPartitionColumn.getName());
                    Assert.assertEquals((Object)expectedPartitionColumn.getType(), (Object)actualPartitionColumn.getType());
                    Assert.assertEquals((Object)expectedPartitionColumn.getSize(), (Object)actualPartitionColumn.getSize());
                    Assert.assertEquals((Object)expectedPartitionColumn.isRequired(), (Object)actualPartitionColumn.isRequired());
                    Assert.assertEquals((Object)expectedPartitionColumn.getDefaultValue(), (Object)actualPartitionColumn.getDefaultValue());
                    Assert.assertEquals((Object)expectedPartitionColumn.getDescription(), (Object)actualPartitionColumn.getDescription());
                }
            }
        } else {
            Assert.assertNull((Object)actualBusinessObjectFormat.getSchema());
        }
    }

    public void validateBusinessObjectFormatDdl(String expectedNamespaceCode, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, BusinessObjectDataDdlOutputFormatEnum expectedOutputFormat, String expectedTableName, String expectedCustomDdlName, String expectedDdl, BusinessObjectFormatDdl actualBusinessObjectFormatDdl) {
        Assert.assertNotNull((Object)actualBusinessObjectFormatDdl);
        Assert.assertEquals((Object)expectedNamespaceCode, (Object)actualBusinessObjectFormatDdl.getNamespace());
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionName, (Object)actualBusinessObjectFormatDdl.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)expectedBusinessObjectFormatUsage, (Object)actualBusinessObjectFormatDdl.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)expectedBusinessObjectFormatFileType, (Object)actualBusinessObjectFormatDdl.getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)expectedBusinessObjectFormatVersion, (Object)actualBusinessObjectFormatDdl.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)expectedOutputFormat, (Object)actualBusinessObjectFormatDdl.getOutputFormat());
        Assert.assertEquals((Object)expectedTableName, (Object)actualBusinessObjectFormatDdl.getTableName());
        Assert.assertEquals((Object)expectedCustomDdlName, (Object)actualBusinessObjectFormatDdl.getCustomDdlName());
        Assert.assertEquals((Object)expectedDdl, (Object)actualBusinessObjectFormatDdl.getDdl());
    }

    public void validateBusinessObjectFormatDdl(String expectedCustomDdlName, String expectedDdl, BusinessObjectFormatDdl actualBusinessObjectFormatDdl) {
        this.validateBusinessObjectFormatDdl(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, "TXT", AbstractServiceTest.FORMAT_VERSION, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, AbstractServiceTest.TABLE_NAME, expectedCustomDdlName, expectedDdl, actualBusinessObjectFormatDdl);
    }
}

