/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.model.api.xml.NamespaceAuthorization;
import org.finra.herd.model.api.xml.UserAuthorizations;
import org.finra.herd.model.dto.ApplicationUser;
import org.finra.herd.model.dto.SecurityUserWrapper;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class CurrentUserServiceTest
extends AbstractServiceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCurrentUser() throws Exception {
        final LinkedHashSet<NamespaceAuthorization> namespaceAuthorizations = new LinkedHashSet<NamespaceAuthorization>();
        namespaceAuthorizations.add(new NamespaceAuthorization(NAMESPACE, SUPPORTED_NAMESPACE_PERMISSIONS));
        namespaceAuthorizations.add(new NamespaceAuthorization(NAMESPACE_2, SUPPORTED_NAMESPACE_PERMISSIONS));
        Authentication originalAuthentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            SecurityContextHolder.getContext().setAuthentication(new Authentication(){

                public String getName() {
                    return null;
                }

                public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
                }

                public boolean isAuthenticated() {
                    return false;
                }

                public Object getPrincipal() {
                    List authorities = Collections.emptyList();
                    ApplicationUser applicationUser = new ApplicationUser(this.getClass());
                    applicationUser.setUserId(AbstractDaoTest.USER_ID);
                    applicationUser.setNamespaceAuthorizations(namespaceAuthorizations);
                    return new SecurityUserWrapper(AbstractDaoTest.USER_ID, AbstractDaoTest.STRING_VALUE, true, true, true, true, authorities, applicationUser);
                }

                public Object getDetails() {
                    return null;
                }

                public Object getCredentials() {
                    return null;
                }

                public Collection<? extends GrantedAuthority> getAuthorities() {
                    return null;
                }
            });
            UserAuthorizations userAuthorizations = this.currentUserService.getCurrentUser();
            Assert.assertEquals((Object)new UserAuthorizations(USER_ID, new ArrayList(namespaceAuthorizations)), (Object)userAuthorizations);
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(originalAuthentication);
        }
    }

    @Test
    public void testGetCurrentUserNoAuthentication() throws Exception {
        Authentication originalAuthentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            UserAuthorizations userAuthorizations = this.currentUserService.getCurrentUser();
            Assert.assertEquals((Object)new UserAuthorizations(null, null), (Object)userAuthorizations);
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(originalAuthentication);
        }
    }
}

