/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.finra.herd.model.api.xml.JdbcExecutionRequest;
import org.finra.herd.model.api.xml.JdbcExecutionResponse;
import org.finra.herd.model.api.xml.JdbcStatement;
import org.finra.herd.model.api.xml.JdbcStatementResultSetRow;
import org.finra.herd.model.api.xml.JdbcStatementStatus;
import org.finra.herd.model.api.xml.JdbcStatementType;
import org.finra.herd.model.api.xml.S3PropertiesLocation;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.JdbcServiceTestHelper;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class JdbcServiceTest
extends AbstractServiceTest {
    @Autowired
    private JdbcServiceTestHelper jdbcServiceTestHelper;

    @Test
    public void testExecuteJdbcStatementSuccess() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
        Assert.assertNull((String)"JDBC connection is not null", (Object)jdbcExecutionResponse.getConnection());
        Assert.assertEquals((String)"JDBC statements size", (long)jdbcExecutionRequest.getStatements().size(), (long)jdbcExecutionResponse.getStatements().size());
        JdbcStatement expectedJdbcStatement = (JdbcStatement)jdbcExecutionRequest.getStatements().get(0);
        JdbcStatement actualJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(0);
        Assert.assertEquals((String)"JDBC statement [0] type", (Object)expectedJdbcStatement.getType(), (Object)actualJdbcStatement.getType());
        Assert.assertEquals((String)"JDBC statement [0] sql", (Object)expectedJdbcStatement.getSql(), (Object)actualJdbcStatement.getSql());
        Assert.assertEquals((String)"JDBC statement [0] status", (Object)JdbcStatementStatus.SUCCESS, (Object)actualJdbcStatement.getStatus());
        Assert.assertEquals((String)"JDBC statement [0] result", (Object)"1", (Object)actualJdbcStatement.getResult());
    }

    @Test
    public void testExecuteJdbcStatementError() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getStatements().add(new JdbcStatement(JdbcStatementType.UPDATE, "case2", null, null, null, null, null));
        jdbcExecutionRequest.getStatements().add(new JdbcStatement(JdbcStatementType.UPDATE, "case1", null, null, null, null, null));
        JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
        Assert.assertNull((String)"JDBC connection is null", (Object)jdbcExecutionResponse.getConnection());
        Assert.assertEquals((String)"JDBC statements size", (long)jdbcExecutionRequest.getStatements().size(), (long)jdbcExecutionResponse.getStatements().size());
        JdbcStatement actualJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(0);
        Assert.assertEquals((String)"JDBC statement [0] status", (Object)JdbcStatementStatus.SUCCESS, (Object)actualJdbcStatement.getStatus());
        actualJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(1);
        Assert.assertEquals((String)"JDBC statement [1] status", (Object)JdbcStatementStatus.ERROR, (Object)actualJdbcStatement.getStatus());
        Assert.assertNull((String)"JDBC statement [1] result is not null", (Object)actualJdbcStatement.getResult());
        Assert.assertEquals((String)"JDBC statement [1] error message", (Object)"java.sql.SQLException: test DataIntegrityViolationException cause", (Object)actualJdbcStatement.getErrorMessage());
        actualJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(2);
        Assert.assertEquals((String)"JDBC statement [2] status", (Object)JdbcStatementStatus.SKIPPED, (Object)actualJdbcStatement.getStatus());
        Assert.assertNull((String)"JDBC statement [2] result is not null", (Object)actualJdbcStatement.getResult());
    }

    @Test
    public void testExecuteJdbcStatementErrorContinueOnError() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getStatements().add(new JdbcStatement(JdbcStatementType.UPDATE, "case2", Boolean.valueOf(true), null, null, null, null));
        jdbcExecutionRequest.getStatements().add(new JdbcStatement(JdbcStatementType.UPDATE, "case1", Boolean.valueOf(false), null, null, null, null));
        JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
        Assert.assertNull((String)"JDBC connection is not null", (Object)jdbcExecutionResponse.getConnection());
        Assert.assertEquals((String)"JDBC statements size", (long)jdbcExecutionRequest.getStatements().size(), (long)jdbcExecutionResponse.getStatements().size());
        JdbcStatement actualJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(0);
        Assert.assertEquals((String)"JDBC statement [0] status", (Object)JdbcStatementStatus.SUCCESS, (Object)actualJdbcStatement.getStatus());
        JdbcStatement expectedJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(1);
        JdbcStatement actualJdbcStatement2 = (JdbcStatement)jdbcExecutionResponse.getStatements().get(1);
        Assert.assertEquals((String)"JDBC statement [1] continue on error", (Object)expectedJdbcStatement.isContinueOnError(), (Object)actualJdbcStatement2.isContinueOnError());
        Assert.assertEquals((String)"JDBC statement [1] status", (Object)JdbcStatementStatus.ERROR, (Object)actualJdbcStatement2.getStatus());
        Assert.assertNull((String)"JDBC statement [1] result is not null", (Object)actualJdbcStatement2.getResult());
        Assert.assertEquals((String)"JDBC statement [1] error message", (Object)"java.sql.SQLException: test DataIntegrityViolationException cause", (Object)actualJdbcStatement2.getErrorMessage());
        expectedJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(2);
        actualJdbcStatement2 = (JdbcStatement)jdbcExecutionResponse.getStatements().get(2);
        Assert.assertEquals((String)"JDBC statement [2] status", (Object)expectedJdbcStatement.isContinueOnError(), (Object)actualJdbcStatement2.isContinueOnError());
        Assert.assertEquals((String)"JDBC statement [2] status", (Object)JdbcStatementStatus.SUCCESS, (Object)actualJdbcStatement2.getStatus());
    }

    @Test
    public void testExecuteJdbcStatementTypeQuerySuccess() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultQueryJdbcExecutionRequest();
        JdbcStatement expectedJdbcStatement = (JdbcStatement)jdbcExecutionRequest.getStatements().get(0);
        JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
        Assert.assertEquals((String)"JDBC statements size", (long)1L, (long)jdbcExecutionResponse.getStatements().size());
        JdbcStatement actualJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(0);
        Assert.assertNull((String)"JDBC statement error message is not null", (Object)actualJdbcStatement.getErrorMessage());
        Assert.assertNull((String)"JDBC statement result not is null", (Object)actualJdbcStatement.getResult());
        Assert.assertEquals((String)"JDBC statement SQL", (Object)expectedJdbcStatement.getSql(), (Object)actualJdbcStatement.getSql());
        Assert.assertEquals((String)"JDBC statement status", (Object)JdbcStatementStatus.SUCCESS, (Object)actualJdbcStatement.getStatus());
        Assert.assertEquals((String)"JDBC statement type", (Object)expectedJdbcStatement.getType(), (Object)actualJdbcStatement.getType());
        Assert.assertNotNull((String)"JDBC statement result set is null", (Object)actualJdbcStatement.getResultSet());
        Assert.assertNotNull((String)"JDBC statement result set column names is null", (Object)actualJdbcStatement.getResultSet().getColumnNames());
        Assert.assertEquals((String)"JDBC statement result set column names", Arrays.asList("COL1", "COL2", "COL3"), (Object)actualJdbcStatement.getResultSet().getColumnNames());
        Assert.assertNotNull((String)"JDBC statement result set rows is null", (Object)actualJdbcStatement.getResultSet().getRows());
        Assert.assertEquals((String)"JDBC statement result set rows size", (long)2L, (long)actualJdbcStatement.getResultSet().getRows().size());
        JdbcStatementResultSetRow row = (JdbcStatementResultSetRow)actualJdbcStatement.getResultSet().getRows().get(0);
        Assert.assertNotNull((String)"JDBC statement row [0] columns is null", (Object)row.getColumns());
        Assert.assertEquals((String)"JDBC statement row [0] columns", Arrays.asList("A", "B", "C"), (Object)row.getColumns());
        row = (JdbcStatementResultSetRow)actualJdbcStatement.getResultSet().getRows().get(1);
        Assert.assertNotNull((String)"JDBC statement row [1] columns is null", (Object)row.getColumns());
        Assert.assertEquals((String)"JDBC statement row [1] columns", Arrays.asList("D", "E", "F"), (Object)row.getColumns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteJdbcStatementTypeQueryMaximumRows() {
        int expectedRowSize = 1;
        try {
            HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
            overrideMap.put(ConfigurationValue.JDBC_RESULT_MAX_ROWS.getKey(), expectedRowSize);
            this.modifyPropertySourceInEnvironment(overrideMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Error modifying environment variables", e);
        }
        try {
            JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultQueryJdbcExecutionRequest();
            JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.assertEquals((String)"result set row size", (long)expectedRowSize, (long)((JdbcStatement)jdbcExecutionResponse.getStatements().get(0)).getResultSet().getRows().size());
        }
        finally {
            try {
                this.restorePropertySourceInEnvironment();
            }
            catch (Exception e) {
                throw new RuntimeException("Error restoring environment variables. Subsequent tests may be affected.", e);
            }
        }
    }

    @Test
    public void testExecuteJdbcStatementTypeQueryError() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultQueryJdbcExecutionRequest();
        JdbcStatement expectedJdbcStatement = (JdbcStatement)jdbcExecutionRequest.getStatements().get(0);
        expectedJdbcStatement.setSql("case2");
        JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
        Assert.assertEquals((String)"JDBC statements size", (long)1L, (long)jdbcExecutionResponse.getStatements().size());
        JdbcStatement actualJdbcStatement = (JdbcStatement)jdbcExecutionResponse.getStatements().get(0);
        Assert.assertNotNull((String)"JDBC statement error message", (Object)actualJdbcStatement.getErrorMessage());
        Assert.assertEquals((String)"JDBC statement error message", (Object)"java.sql.SQLException: test DataIntegrityViolationException cause", (Object)actualJdbcStatement.getErrorMessage());
        Assert.assertNull((String)"JDBC statement result", (Object)actualJdbcStatement.getResult());
        Assert.assertEquals((String)"JDBC statement status", (Object)JdbcStatementStatus.ERROR, (Object)actualJdbcStatement.getStatus());
        Assert.assertEquals((String)"JDBC statement type", (Object)expectedJdbcStatement.getType(), (Object)actualJdbcStatement.getType());
        Assert.assertNull((String)"JDBC statement result set", (Object)actualJdbcStatement.getResultSet());
    }

    @Test
    public void testExecuteJdbcParamValidationRequestNull() {
        try {
            this.jdbcService.executeJdbc(null);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC execution request is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationConnectionNull() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.setConnection(null);
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC connection is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationConnectionUrlEmpty() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getConnection().setUrl(" \t\n\r");
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC connection URL is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationConnectionUsernameNull() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getConnection().setUsername(null);
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC connection user name is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationConnectionPasswordNull() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getConnection().setPassword(null);
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC connection password is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationConnectionDatabaseTypeNull() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getConnection().setDatabaseType(null);
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC connection database type is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationStatementsNull() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.setStatements(null);
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC statements are required", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteJdbcParamValidationStatementsMaximumStatementsSpecified() {
        int maxStatements = 1;
        try {
            HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
            overrideMap.put(ConfigurationValue.JDBC_MAX_STATEMENTS.getKey(), maxStatements);
            this.modifyPropertySourceInEnvironment(overrideMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Error modifying environment variable.", e);
        }
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        try {
            JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.assertNotNull((String)"jdbcExecutionResponse", (Object)jdbcExecutionResponse);
        }
        finally {
            try {
                this.restorePropertySourceInEnvironment();
            }
            catch (Exception e) {
                throw new RuntimeException("Error restoring environment variables. Subsequent tests may be affected.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteJdbcParamValidationStatementsExceedMaximum() {
        int maxStatements = 1;
        try {
            HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
            overrideMap.put(ConfigurationValue.JDBC_MAX_STATEMENTS.getKey(), maxStatements);
            this.modifyPropertySourceInEnvironment(overrideMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Error modifying environment variable.", e);
        }
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getStatements().add(new JdbcStatement());
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)("The number of JDBC statements exceeded the maximum allowed " + maxStatements + "."), (Object)e.getMessage());
        }
        finally {
            try {
                this.restorePropertySourceInEnvironment();
            }
            catch (Exception e) {
                throw new RuntimeException("Error restoring environment variables. Subsequent tests may be affected.", e);
            }
        }
    }

    @Test
    public void testExecuteJdbcParamValidationStatementsEmpty() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getStatements().clear();
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC statements are required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationStatementTypeNull() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        ((JdbcStatement)jdbcExecutionRequest.getStatements().get(0)).setType(null);
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC statement [0] type is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationStatementTypeSqlEmpty() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        ((JdbcStatement)jdbcExecutionRequest.getStatements().get(0)).setSql(" \t\n\r");
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC statement [0] SQL is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcErrorConnection() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        ((JdbcStatement)jdbcExecutionRequest.getStatements().get(0)).setSql("case3");
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"java.sql.SQLException: test CannotGetJdbcConnectionException cause", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationS3PropertiesLocationBucketNameBlank() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.setS3PropertiesLocation(new S3PropertiesLocation("      \t\t ", "test_key"));
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"S3 properties location bucket name is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcParamValidationS3PropertiesLocationKeyBlank() {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.setS3PropertiesLocation(new S3PropertiesLocation("test_bucket", "      \t\t "));
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"S3 properties location key is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcWithS3PropertiesParamUrlBlankAfterReplace() {
        String s3BucketName = "test_bucket";
        String s3ObjectKey = "test_key";
        String content = "foo=";
        this.putS3Object(s3BucketName, s3ObjectKey, content);
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getConnection().setUrl("${foo}");
        jdbcExecutionRequest.setS3PropertiesLocation(new S3PropertiesLocation(s3BucketName, s3ObjectKey));
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC connection URL is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcWithS3PropertiesParamSqlBlankAfterReplace() {
        String s3BucketName = "test_bucket";
        String s3ObjectKey = "test_key";
        String content = "foo=";
        this.putS3Object(s3BucketName, s3ObjectKey, content);
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        ((JdbcStatement)jdbcExecutionRequest.getStatements().get(0)).setSql("${foo}");
        jdbcExecutionRequest.setS3PropertiesLocation(new S3PropertiesLocation(s3BucketName, s3ObjectKey));
        try {
            this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.fail((String)"expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"JDBC statement [0] SQL is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteJdbcWithS3PropertiesSuccess() {
        String s3BucketName = "test_bucket";
        String s3ObjectKey = "test_key";
        String content = "foo=bar";
        this.putS3Object(s3BucketName, s3ObjectKey, content);
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.getConnection().setUrl("test_url_${foo}");
        jdbcExecutionRequest.getConnection().setUsername("test_username_${foo}");
        jdbcExecutionRequest.getConnection().setPassword("test_password_${foo}");
        JdbcStatement jdbcStatement = (JdbcStatement)jdbcExecutionRequest.getStatements().get(0);
        jdbcStatement.setSql("test_sql_${foo}");
        jdbcExecutionRequest.setS3PropertiesLocation(new S3PropertiesLocation(s3BucketName, s3ObjectKey));
        try {
            JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
            Assert.assertEquals((String)"jdbc execution response statement [0] sql", (Object)"test_sql_${foo}", (Object)((JdbcStatement)jdbcExecutionResponse.getStatements().get(0)).getSql());
        }
        catch (Exception e) {
            Assert.fail((String)("unexpected exception was thrown. " + e));
        }
    }

    @Test
    public void testExecuteJdbcSensitiveDataIsMaskedInErrorMessage() {
        String s3BucketName = "test_bucket";
        String s3ObjectKey = "test_key";
        String content = "foo=DataIntegrityViolationException";
        this.putS3Object(s3BucketName, s3ObjectKey, content);
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        ((JdbcStatement)jdbcExecutionRequest.getStatements().get(0)).setSql("case2");
        jdbcExecutionRequest.setS3PropertiesLocation(new S3PropertiesLocation(s3BucketName, s3ObjectKey));
        JdbcExecutionResponse jdbcExecutionResponse = this.jdbcService.executeJdbc(jdbcExecutionRequest);
        Assert.assertEquals((String)"jdbc execution response statement [0] error message", (Object)"java.sql.SQLException: test **** cause", (Object)((JdbcStatement)jdbcExecutionResponse.getStatements().get(0)).getErrorMessage());
    }

    private void putS3Object(String s3BucketName, String s3ObjectKey, String content) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(s3BucketName, s3ObjectKey, (InputStream)new ByteArrayInputStream(content.getBytes()), new ObjectMetadata());
        this.s3Operations.putObject(putObjectRequest, null);
    }
}

