/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import org.finra.herd.model.jpa.JmsMessageEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.JmsPublishingService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class JmsPublishingServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="jmsPublishingServiceImpl")
    private JmsPublishingService jmsPublishingServiceImpl;

    @Test
    public void testPublishOldestJmsMessageFromDatabaseQueue() throws Exception {
        this.jmsMessageDaoTestHelper.createJmsMessageEntity(JMS_QUEUE_NAME, MESSAGE_TEXT);
        Assert.assertTrue((boolean)this.jmsPublishingService.publishOldestJmsMessageFromDatabaseQueue());
        Assert.assertFalse((boolean)this.jmsPublishingService.publishOldestJmsMessageFromDatabaseQueue());
    }

    @Test
    public void testPublishOldestJmsMessageFromDatabaseQueueAwsServiceException() throws Exception {
        this.jmsMessageDaoTestHelper.createJmsMessageEntity("mock_sqs_queue_not_found_name", MESSAGE_TEXT);
        try {
            this.jmsPublishingService.publishOldestJmsMessageFromDatabaseQueue();
            Assert.fail((String)"Should throw a RuntimeException when AWS SQS queue does not exist.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("AWS SQS queue with \"%s\" name not found.", "mock_sqs_queue_not_found_name"), (Object)e.getMessage());
        }
        JmsMessageEntity jmsMessageEntity = this.jmsMessageDao.getOldestJmsMessage();
        Assert.assertNotNull((Object)jmsMessageEntity);
        Assert.assertEquals((Object)"mock_sqs_queue_not_found_name", (Object)jmsMessageEntity.getJmsQueueName());
        Assert.assertEquals((Object)MESSAGE_TEXT, (Object)jmsMessageEntity.getMessageText());
    }

    @Test
    public void JmsPublishingServiceMethodsNewTransactionPropagation() {
        Assert.assertNull((Object)this.jmsMessageDao.getOldestJmsMessage());
        this.jmsPublishingServiceImpl.addJmsMessageToDatabaseQueue(SQS_QUEUE_NAME, MESSAGE_TEXT);
        Assert.assertNotNull((Object)this.jmsMessageDao.getOldestJmsMessage());
        Assert.assertTrue((boolean)this.jmsPublishingServiceImpl.publishOldestJmsMessageFromDatabaseQueue());
    }
}

