/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.io.IOUtils;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.JobActionEnum;
import org.finra.herd.model.api.xml.JobCreateRequest;
import org.finra.herd.model.api.xml.JobDefinition;
import org.finra.herd.model.api.xml.JobDefinitionCreateRequest;
import org.finra.herd.model.api.xml.JobDeleteRequest;
import org.finra.herd.model.api.xml.JobSignalRequest;
import org.finra.herd.model.api.xml.JobStatusEnum;
import org.finra.herd.model.api.xml.JobSummaries;
import org.finra.herd.model.api.xml.JobSummary;
import org.finra.herd.model.api.xml.JobUpdateRequest;
import org.finra.herd.model.api.xml.NamespaceAuthorization;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.api.xml.S3PropertiesLocation;
import org.finra.herd.model.dto.ApplicationUser;
import org.finra.herd.model.dto.SecurityUserWrapper;
import org.finra.herd.model.jpa.JobDefinitionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;

public class JobServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateJob() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest jobDefinitionCreateRequest = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        this.jobDefinitionService.createJobDefinition(jobDefinitionCreateRequest, false);
        JobCreateRequest jobCreateRequest = this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow");
        Job resultJob = this.jobService.createAndStartJob(jobCreateRequest);
        Assert.assertNotNull((Object)resultJob);
        Assert.assertNotNull((Object)resultJob.getId());
        Assert.assertTrue((!resultJob.getId().isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testNamespace", (Object)resultJob.getNamespace());
        Assert.assertEquals((Object)"testHerdWorkflow", (Object)resultJob.getJobName());
        Assert.assertEquals((long)(jobDefinitionCreateRequest.getParameters().size() + jobCreateRequest.getParameters().size()), (long)resultJob.getParameters().size());
        ArrayList<String> expectedParameters = new ArrayList<String>();
        expectedParameters.addAll(this.parametersToStringList(jobDefinitionCreateRequest.getParameters()));
        expectedParameters.addAll(this.parametersToStringList(jobCreateRequest.getParameters()));
        List<String> resultParameters = this.parametersToStringList(resultJob.getParameters());
        Assert.assertTrue((boolean)expectedParameters.containsAll(resultParameters));
        Assert.assertTrue((boolean)resultParameters.containsAll(expectedParameters));
    }

    @Test
    public void testCreateJobNoParams() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest jobDefinitionCreateRequest = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        jobDefinitionCreateRequest.setParameters(null);
        this.jobDefinitionService.createJobDefinition(jobDefinitionCreateRequest, false);
        JobCreateRequest jobCreateRequest = this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow");
        jobCreateRequest.setParameters(null);
        Job resultJob = this.jobService.createAndStartJob(jobCreateRequest);
        Assert.assertNotNull((Object)resultJob);
        Assert.assertNotNull((Object)resultJob.getId());
        Assert.assertTrue((!resultJob.getId().isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testNamespace", (Object)resultJob.getNamespace());
        Assert.assertEquals((Object)"testHerdWorkflow", (Object)resultJob.getJobName());
        Assert.assertNull((Object)resultJob.getParameters());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateJobNamespaceEmpty() throws Exception {
        this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest(" ", "testHerdWorkflow"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateJobJobNameEmpty() throws Exception {
        this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", " "));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateJobParameterNameEmpty() throws Exception {
        JobCreateRequest jobCreateRequest = this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow");
        Parameter parameter = new Parameter(" ", "Attribute Value 1");
        jobCreateRequest.getParameters().add(parameter);
        this.jobService.createAndStartJob(jobCreateRequest);
    }

    @Test
    public void testCreateJobInvalidParameters() throws Exception {
        try {
            this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest(this.addSlash("testNamespace"), "testHerdWorkflow"));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", this.addSlash("testHerdWorkflow")));
            Assert.fail((String)"Should throw an IllegalArgumentException when job name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Job name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateJobDuplicateParameterName() throws Exception {
        JobCreateRequest jobCreateRequest = this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow");
        Parameter parameter = new Parameter();
        parameter.setName(this.addWhitespace(((Parameter)jobCreateRequest.getParameters().get(0)).getName().toUpperCase()));
        parameter.setValue(((Parameter)jobCreateRequest.getParameters().get(0)).getValue());
        jobCreateRequest.getParameters().add(parameter);
        this.jobService.createAndStartJob(jobCreateRequest);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testCreateJobNamespaceNoExists() throws Exception {
        this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("I_DO_NOT_EXIST", "testHerdWorkflow"));
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testCreateJobJobNameNoExists() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "I_DO_NOT_EXIST"));
    }

    @Test
    public void testGetJob() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        String activitiXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml").getInputStream());
        Job jobGet = this.jobService.getJob(job.getId(), true);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNotNull((Object)jobGet.getActivitiJobXml());
        Assert.assertEquals((Object)activitiXml, (Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((jobGet.getCompletedWorkflowSteps().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(job.getId())).list();
        this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        jobGet = this.jobService.getJob(job.getId(), true);
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGet.getStatus());
        Assert.assertNotNull((Object)jobGet.getStartTime());
        Assert.assertNotNull((Object)jobGet.getEndTime());
        Assert.assertNotNull((Object)jobGet.getActivitiJobXml());
        Assert.assertEquals((Object)activitiXml, (Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((jobGet.getCompletedWorkflowSteps().size() > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)jobGet.getCurrentWorkflowStep());
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGet.getStatus());
        Assert.assertNotNull((Object)jobGet.getStartTime());
        Assert.assertNotNull((Object)jobGet.getEndTime());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertNull((Object)jobGet.getCurrentWorkflowStep());
    }

    @Test
    public void testGetJobIntermediateTimer() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdIntermediateTimerWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        String activitiXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:org/finra/herd/service/testHerdIntermediateTimerWorkflow.bpmn20.xml").getInputStream());
        Job jobGet = this.jobService.getJob(job.getId(), true);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNotNull((Object)jobGet.getActivitiJobXml());
        Assert.assertEquals((Object)activitiXml, (Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((jobGet.getCompletedWorkflowSteps().size() > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)jobGet.getCurrentWorkflowStep());
        org.activiti.engine.runtime.Job timer = (org.activiti.engine.runtime.Job)this.activitiManagementService.createJobQuery().processInstanceId(job.getId()).timers().singleResult();
        if (timer != null) {
            this.activitiManagementService.executeJob(timer.getId());
        }
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getCurrentWorkflowStep());
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testGetJobNoJobFound() throws Exception {
        this.jobService.getJob("job_not_submitted", true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJobNoJobId() throws Exception {
        this.jobService.getJob(null, false);
    }

    @Test
    public void testGetJobs() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        final List<Job> jobs = Arrays.asList(this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")), this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")), this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")));
        this.jobServiceTestHelper.setCurrentUserNamespaceAuthorizations("testNamespace", Arrays.asList(NamespacePermissionEnum.READ));
        DateTime startTime = new DateTime().minusHours(1);
        DateTime endTime = new DateTime().plusHours(1);
        JobSummaries resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.RUNNING, startTime, NO_END_TIME);
        HashMap<String, JobStatusEnum> expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.RUNNING);
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.RUNNING);
                this.put(((Job)jobs.get(2)).getId(), JobStatusEnum.RUNNING);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        for (Job job : jobs) {
            List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(job.getId())).list();
            this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        }
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.COMPLETED, startTime, endTime);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.COMPLETED);
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.COMPLETED);
                this.put(((Job)jobs.get(2)).getId(), JobStatusEnum.COMPLETED);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
    }

    @Test
    public void testGetJobsTrimAndCaseInsensitivity() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        final Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        this.jobServiceTestHelper.setCurrentUserNamespaceAuthorizations("testNamespace", Arrays.asList(NamespacePermissionEnum.READ));
        DateTime startTime = new DateTime().minusHours(1);
        DateTime endTime = new DateTime().plusHours(1);
        JobSummaries resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.RUNNING, startTime, NO_END_TIME);
        HashMap<String, JobStatusEnum> expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(job.getId(), JobStatusEnum.RUNNING);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(job.getId())).list();
        this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        resultJobSummaries = this.jobService.getJobs("testNamespace".toUpperCase(), "testHerdWorkflow".toUpperCase(), JobStatusEnum.COMPLETED, startTime, endTime);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(job.getId(), JobStatusEnum.COMPLETED);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        resultJobSummaries = this.jobService.getJobs("testNamespace".toLowerCase(), "testHerdWorkflow".toLowerCase(), JobStatusEnum.COMPLETED, startTime, endTime);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(job.getId(), JobStatusEnum.COMPLETED);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
    }

    @Test
    public void testGetJobsMissingOptionalParameters() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        final List<Job> jobs = Arrays.asList(this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")), this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")), this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")));
        this.jobServiceTestHelper.setCurrentUserNamespaceAuthorizations("testNamespace", Arrays.asList(NamespacePermissionEnum.READ));
        JobSummaries resultJobSummaries = this.jobService.getJobs(NO_NAMESPACE, NO_ACTIVITI_JOB_NAME, NO_ACTIVITI_JOB_STATUS, NO_START_TIME, NO_END_TIME);
        HashMap<String, JobStatusEnum> expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.RUNNING);
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.RUNNING);
                this.put(((Job)jobs.get(2)).getId(), JobStatusEnum.RUNNING);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        for (Job job : jobs) {
            List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(job.getId())).list();
            this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        }
        resultJobSummaries = this.jobService.getJobs(NO_NAMESPACE, NO_ACTIVITI_JOB_NAME, NO_ACTIVITI_JOB_STATUS, NO_START_TIME, NO_END_TIME);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.COMPLETED);
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.COMPLETED);
                this.put(((Job)jobs.get(2)).getId(), JobStatusEnum.COMPLETED);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
    }

    @Test
    public void testGetJobsInvalidParameters() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        final List<Job> jobs = Arrays.asList(this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")), this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")), this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")));
        this.jobServiceTestHelper.setCurrentUserNamespaceAuthorizations("testNamespace", Arrays.asList(NamespacePermissionEnum.READ));
        JobSummaries resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.RUNNING, NO_START_TIME, NO_END_TIME);
        HashMap<String, JobStatusEnum> expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.RUNNING);
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.RUNNING);
                this.put(((Job)jobs.get(2)).getId(), JobStatusEnum.RUNNING);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        resultJobSummaries = this.jobService.getJobs("I_DO_NOT_EXIST", "testHerdWorkflow", JobStatusEnum.RUNNING, NO_START_TIME, NO_END_TIME);
        Assert.assertEquals((long)0L, (long)resultJobSummaries.getJobSummaries().size());
        resultJobSummaries = this.jobService.getJobs("testNamespace", "I_DO_NOT_EXIST", JobStatusEnum.RUNNING, NO_START_TIME, NO_END_TIME);
        Assert.assertEquals((long)0L, (long)resultJobSummaries.getJobSummaries().size());
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.SUSPENDED, NO_START_TIME, NO_END_TIME);
        Assert.assertEquals((long)0L, (long)resultJobSummaries.getJobSummaries().size());
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.COMPLETED, NO_START_TIME, NO_END_TIME);
        Assert.assertEquals((long)0L, (long)resultJobSummaries.getJobSummaries().size());
        DateTime invalidStartTime = new DateTime().plusHours(1);
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.RUNNING, invalidStartTime, NO_END_TIME);
        Assert.assertEquals((long)0L, (long)resultJobSummaries.getJobSummaries().size());
        for (Job job : jobs) {
            List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(job.getId())).list();
            this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        }
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.COMPLETED, NO_START_TIME, NO_END_TIME);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.COMPLETED);
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.COMPLETED);
                this.put(((Job)jobs.get(2)).getId(), JobStatusEnum.COMPLETED);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        DateTime invalidEndTime = new DateTime().minusHours(1);
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.COMPLETED, NO_START_TIME, invalidEndTime);
        Assert.assertEquals((long)0L, (long)resultJobSummaries.getJobSummaries().size());
    }

    @Test
    public void testGetJobsValidateJobStatusFilter() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        final List<Job> jobs = Arrays.asList(this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")), this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow")));
        this.jobServiceTestHelper.setCurrentUserNamespaceAuthorizations("testNamespace", Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.EXECUTE));
        JobSummaries resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.RUNNING, NO_START_TIME, NO_END_TIME);
        HashMap<String, JobStatusEnum> expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.RUNNING);
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.RUNNING);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        this.jobService.updateJob(jobs.get(0).getId(), new JobUpdateRequest(JobActionEnum.SUSPEND));
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.RUNNING, NO_START_TIME, NO_END_TIME);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.RUNNING);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.SUSPENDED, NO_START_TIME, NO_END_TIME);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.SUSPENDED);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        this.jobService.updateJob(jobs.get(0).getId(), new JobUpdateRequest(JobActionEnum.RESUME));
        List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(jobs.get(0).getId())).list();
        this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.COMPLETED, NO_START_TIME, NO_END_TIME);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.COMPLETED);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
        tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(jobs.get(1).getId())).list();
        this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.RUNNING, NO_START_TIME, NO_END_TIME);
        Assert.assertEquals((long)0L, (long)resultJobSummaries.getJobSummaries().size());
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.SUSPENDED, NO_START_TIME, NO_END_TIME);
        Assert.assertEquals((long)0L, (long)resultJobSummaries.getJobSummaries().size());
        resultJobSummaries = this.jobService.getJobs("testNamespace", "testHerdWorkflow", JobStatusEnum.COMPLETED, NO_START_TIME, NO_END_TIME);
        expectedJobStatuses = new HashMap<String, JobStatusEnum>(){
            {
                this.put(((Job)jobs.get(0)).getId(), JobStatusEnum.COMPLETED);
                this.put(((Job)jobs.get(1)).getId(), JobStatusEnum.COMPLETED);
            }
        };
        this.validateJobSummaries((Map<String, JobStatusEnum>)expectedJobStatuses, resultJobSummaries);
    }

    @Test
    public void testSignalJob() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        Job jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertEquals((Object)"receivetask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        ArrayList<Parameter> signalParameters = new ArrayList<Parameter>();
        Parameter signalPameter1 = new Parameter("UT_SIGNAL_PARAM_1", "UT_SIGNAL_VALUE_1");
        signalParameters.add(signalPameter1);
        JobSignalRequest jobSignalRequest = new JobSignalRequest(job.getId(), "receivetask1", signalParameters, null);
        Job signalJob = this.jobService.signalJob(jobSignalRequest);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)signalJob.getStatus());
        Assert.assertEquals((Object)"receivetask1", (Object)signalJob.getCurrentWorkflowStep().getId());
        Assert.assertTrue((boolean)signalJob.getParameters().contains(signalPameter1));
        jobGet = this.jobService.getJob(job.getId(), true);
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGet.getStatus());
        Assert.assertTrue((boolean)jobGet.getParameters().contains(signalPameter1));
    }

    @Test
    public void testSignalJobNoParameters() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        Job jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertEquals((Object)"receivetask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        JobSignalRequest jobSignalRequest = new JobSignalRequest(job.getId(), "receivetask1", null, null);
        Job signalJob = this.jobService.signalJob(jobSignalRequest);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)signalJob.getStatus());
        Assert.assertEquals((Object)"receivetask1", (Object)signalJob.getCurrentWorkflowStep().getId());
        jobGet = this.jobService.getJob(job.getId(), true);
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGet.getStatus());
    }

    @Test
    public void testSignalJobNoExists() throws Exception {
        try {
            this.jobService.signalJob(new JobSignalRequest("job_does_not_exist", "receivetask1", null, null));
            Assert.fail((String)"Should throw an ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException ex) {
            Assert.assertEquals((Object)String.format("No job found for matching job id: \"%s\" and receive task id: \"%s\".", "job_does_not_exist", "receivetask1"), (Object)ex.getMessage());
        }
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        try {
            Job jobGet = this.jobService.getJob(job.getId(), false);
            Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
            Assert.assertEquals((Object)"receivetask1", (Object)jobGet.getCurrentWorkflowStep().getId());
            this.jobService.signalJob(new JobSignalRequest(job.getId(), "receivetask_does_not_exist", null, null));
            Assert.fail((String)"Should throw an ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException ex) {
            Assert.assertEquals((Object)String.format("No job found for matching job id: \"%s\" and receive task id: \"%s\".", job.getId(), "receivetask_does_not_exist"), (Object)ex.getMessage());
        }
    }

    @Test
    public void testSignalJobWithS3Properties() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Parameter parameter = new Parameter("testName", "testValue");
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation("s3BucketName", "s3ObjectKey", parameter);
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        JobSignalRequest jobSignalRequest = new JobSignalRequest(job.getId(), "receivetask1", null, null);
        jobSignalRequest.setS3PropertiesLocation(s3PropertiesLocation);
        Job signalJob = this.jobService.signalJob(jobSignalRequest);
        this.assertParameterEquals(parameter, signalJob.getParameters());
    }

    @Test
    public void testSignalJobWithS3PropertiesPrecedenceRequestParamsOverridesS3() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Parameter s3Parameter = new Parameter("testName", "testValue");
        Parameter requestParameter = new Parameter("testName", "expectedValue");
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation("s3BucketName", "s3ObjectKey", s3Parameter);
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        JobSignalRequest jobSignalRequest = new JobSignalRequest(job.getId(), "receivetask1", null, null);
        jobSignalRequest.setS3PropertiesLocation(s3PropertiesLocation);
        jobSignalRequest.setParameters(Arrays.asList(requestParameter));
        Job signalJob = this.jobService.signalJob(jobSignalRequest);
        this.assertParameterEquals(requestParameter, signalJob.getParameters());
    }

    @Test
    public void testUpdateJob() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        Job jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        this.jobService.updateJob(job.getId(), new JobUpdateRequest(JobActionEnum.SUSPEND));
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.SUSPENDED, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        this.jobService.updateJob(job.getId(), new JobUpdateRequest(JobActionEnum.RESUME));
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(job.getId())).list();
        this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGet.getStatus());
        Assert.assertNotNull((Object)jobGet.getStartTime());
        Assert.assertNotNull((Object)jobGet.getEndTime());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertNull((Object)jobGet.getCurrentWorkflowStep());
    }

    @Test
    public void testUpdateJobMissingRequiredParameters() {
        try {
            this.jobService.updateJob("      \t\t ", new JobUpdateRequest(JobActionEnum.RESUME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A job id must be specified.", (Object)e.getMessage());
        }
        try {
            this.jobService.updateJob(INTEGER_VALUE.toString(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A job update request must be specified.", (Object)e.getMessage());
        }
        try {
            this.jobService.updateJob(INTEGER_VALUE.toString(), new JobUpdateRequest(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A job update action must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateJobTrimParameters() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        Job jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        this.jobService.updateJob(this.addWhitespace(job.getId()), new JobUpdateRequest(JobActionEnum.SUSPEND));
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.SUSPENDED, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        this.jobService.updateJob(this.addWhitespace(job.getId()), new JobUpdateRequest(JobActionEnum.RESUME));
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(job.getId())).list();
        this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGet.getStatus());
        Assert.assertNotNull((Object)jobGet.getStartTime());
        Assert.assertNotNull((Object)jobGet.getEndTime());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertNull((Object)jobGet.getCurrentWorkflowStep());
    }

    @Test
    public void testUpdateJobInvalidParameters() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        Job jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        try {
            this.jobService.updateJob("I_DO_NOT_EXIST", new JobUpdateRequest(JobActionEnum.SUSPEND));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)"Job with ID \"I_DO_NOT_EXIST\" does not exist or is already completed.", (Object)e.getMessage());
        }
        try {
            this.jobService.updateJob(job.getId(), new JobUpdateRequest(JobActionEnum.RESUME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Job with ID \"%s\" is already in an active state.", job.getId()), (Object)e.getMessage());
        }
        this.jobService.updateJob(job.getId(), new JobUpdateRequest(JobActionEnum.SUSPEND));
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.SUSPENDED, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        try {
            this.jobService.updateJob(job.getId(), new JobUpdateRequest(JobActionEnum.SUSPEND));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Job with ID \"%s\" is already in a suspended state.", job.getId()), (Object)e.getMessage());
        }
        this.jobService.updateJob(job.getId(), new JobUpdateRequest(JobActionEnum.RESUME));
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobGet.getStatus());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertEquals((Object)"usertask1", (Object)jobGet.getCurrentWorkflowStep().getId());
        List tasks = ((TaskQuery)this.activitiTaskService.createTaskQuery().processInstanceId(job.getId())).list();
        this.activitiTaskService.complete(((Task)tasks.get(0)).getId());
        jobGet = this.jobService.getJob(job.getId(), false);
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGet.getStatus());
        Assert.assertNotNull((Object)jobGet.getStartTime());
        Assert.assertNotNull((Object)jobGet.getEndTime());
        Assert.assertNull((Object)jobGet.getActivitiJobXml());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)jobGet.getCompletedWorkflowSteps()));
        Assert.assertNull((Object)jobGet.getCurrentWorkflowStep());
        try {
            this.jobService.updateJob(job.getId(), new JobUpdateRequest(JobActionEnum.SUSPEND));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Job with ID \"%s\" does not exist or is already completed.", job.getId()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateJobWithS3Properties() throws Exception {
        Parameter jobDefinitionS3Parameter = new Parameter("name1", "value1");
        Parameter jobCreateRequestS3Parameter = new Parameter("name2", "value2");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobDefinitionS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobDefinitionObjectKey", jobDefinitionS3Parameter);
        S3PropertiesLocation jobCreateRequestS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobCreationObjectKey", jobCreateRequestS3Parameter);
        Job resultJob = this.createJobWithParameters(jobDefinitionS3PropertiesLocation, null, jobCreateRequestS3PropertiesLocation, null);
        List actualParameters = resultJob.getParameters();
        this.assertParameterEquals(jobDefinitionS3Parameter, actualParameters);
        this.assertParameterEquals(jobCreateRequestS3Parameter, actualParameters);
    }

    @Test
    public void testCreateJobWithS3PropertiesWithInvalidUnicodeThrows() throws Exception {
        Parameter jobCreateRequestS3Parameter = new Parameter("name2", "value2\\uxxxx");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobCreateRequestS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobCreationObjectKey", jobCreateRequestS3Parameter);
        String bucketName = jobCreateRequestS3PropertiesLocation.getBucketName();
        String key = jobCreateRequestS3PropertiesLocation.getKey();
        try {
            this.createJobWithParameters(null, null, jobCreateRequestS3PropertiesLocation, null);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)("The properties file in S3 bucket '" + bucketName + "' and key '" + key + "' is invalid."), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateJobWithS3PropertiesPrecedenceJobRequestParamHighestPrecedence() throws Exception {
        Parameter jobDefinitionS3Parameter = new Parameter("testName", "testValue1");
        Parameter jobDefinitionRequestParameter = new Parameter("testName", "testValue2");
        Parameter jobCreateRequestS3Parameter = new Parameter("testName", "testValue3");
        Parameter jobCreateRequestParameter = new Parameter("testName", "expectedValue");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobDefinitionS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobDefinitionObjectKey", jobDefinitionS3Parameter);
        S3PropertiesLocation jobCreateRequestS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobCreateRequestObjectKey", jobCreateRequestS3Parameter);
        Job resultJob = this.createJobWithParameters(jobDefinitionS3PropertiesLocation, Arrays.asList(jobDefinitionRequestParameter), jobCreateRequestS3PropertiesLocation, Arrays.asList(jobCreateRequestParameter));
        List actualParameters = resultJob.getParameters();
        this.assertParameterEquals(jobCreateRequestParameter, actualParameters);
    }

    @Test
    public void testCreateJobWithS3PropertiesPrecedenceJobRequestS3OverridesDefinitionParams() throws Exception {
        Parameter jobDefinitionS3Parameter = new Parameter("testName", "testValue1");
        Parameter jobDefinitionRequestParameter = new Parameter("testName", "testValue2");
        Parameter jobCreateRequestS3Parameter = new Parameter("testName", "expectedValue");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobDefinitionS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobDefinitionObjectKey", jobDefinitionS3Parameter);
        S3PropertiesLocation jobCreateRequestS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobCreateRequestObjectKey", jobCreateRequestS3Parameter);
        Job resultJob = this.createJobWithParameters(jobDefinitionS3PropertiesLocation, Arrays.asList(jobDefinitionRequestParameter), jobCreateRequestS3PropertiesLocation, null);
        List actualParameters = resultJob.getParameters();
        this.assertParameterEquals(jobCreateRequestS3Parameter, actualParameters);
    }

    @Test
    public void testCreateJobWithS3PropertiesPrecedenceDefinitionParamsOverridesDefinitionS3() throws Exception {
        Parameter jobDefinitionS3Parameter = new Parameter("testName", "testValue1");
        Parameter jobDefinitionRequestParameter = new Parameter("testName", "expectedValue");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobDefinitionS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobDefinitionObjectKey", jobDefinitionS3Parameter);
        Job resultJob = this.createJobWithParameters(jobDefinitionS3PropertiesLocation, Arrays.asList(jobDefinitionRequestParameter), null, null);
        List actualParameters = resultJob.getParameters();
        this.assertParameterEquals(jobDefinitionRequestParameter, actualParameters);
    }

    @Test
    public void testCreateJobWithS3PropertiesDefinitionObjectKeyNotFoundThrows() throws Exception {
        Parameter jobDefinitionS3Parameter = new Parameter("name1", "value1");
        Parameter jobCreateRequestS3Parameter = new Parameter("name2", "value2");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobDefinitionS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobDefinitionObjectKey", jobDefinitionS3Parameter);
        S3PropertiesLocation jobCreateRequestS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobCreationObjectKey", jobCreateRequestS3Parameter);
        jobDefinitionS3PropertiesLocation.setKey("NOT_FOUND");
        try {
            this.createJobWithParameters(jobDefinitionS3PropertiesLocation, null, jobCreateRequestS3PropertiesLocation, null);
            Assert.fail((String)"expected ObjectNotFoundException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)("Specified S3 object key '" + jobDefinitionS3PropertiesLocation.getKey() + "' does not exist."), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateJobWithS3PropertiesCreateRequestObjectKeyNotFoundThrows() throws Exception {
        Parameter jobDefinitionS3Parameter = new Parameter("name1", "value1");
        Parameter jobCreateRequestS3Parameter = new Parameter("name2", "value2");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobDefinitionS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobDefinitionObjectKey", jobDefinitionS3Parameter);
        S3PropertiesLocation jobCreateRequestS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobCreationObjectKey", jobCreateRequestS3Parameter);
        jobCreateRequestS3PropertiesLocation.setKey("NOT_FOUND");
        try {
            this.createJobWithParameters(jobDefinitionS3PropertiesLocation, null, jobCreateRequestS3PropertiesLocation, null);
            Assert.fail((String)"expected ObjectNotFoundException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)("Specified S3 object key '" + jobCreateRequestS3PropertiesLocation.getKey() + "' does not exist."), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateJobWithS3PropertiesValidationBucketNameRequired() throws Exception {
        Parameter jobCreateRequestS3Parameter = new Parameter("name2", "value2");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobCreateRequestS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobCreationObjectKey", jobCreateRequestS3Parameter);
        jobCreateRequestS3PropertiesLocation.setBucketName(null);
        try {
            this.createJobWithParameters(null, null, jobCreateRequestS3PropertiesLocation, null);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"S3 properties location bucket name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateJobWithS3PropertiesValidationObjectKeyRequired() throws Exception {
        Parameter jobCreateRequestS3Parameter = new Parameter("name2", "value2");
        String s3BucketName = "s3BucketName";
        S3PropertiesLocation jobCreateRequestS3PropertiesLocation = this.getS3PropertiesLocation(s3BucketName, "jobCreationObjectKey", jobCreateRequestS3Parameter);
        jobCreateRequestS3PropertiesLocation.setKey(null);
        try {
            this.createJobWithParameters(null, null, jobCreateRequestS3PropertiesLocation, null);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"S3 properties location object key must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateJobWithS3PropertiesJobDefinitionWrongDatafixSafety() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest jobDefinitionCreateRequest = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        jobDefinitionCreateRequest.setS3PropertiesLocation(this.getS3PropertiesLocation("testBucketName", "testObjectKey", new Parameter("testName", "testValue")));
        jobDefinitionCreateRequest.setParameters(null);
        JobDefinition jobDefinition = this.jobDefinitionService.createJobDefinition(jobDefinitionCreateRequest, false);
        Integer jobDefinitionId = jobDefinition.getId();
        JobDefinitionEntity jobDefinitionEntity = (JobDefinitionEntity)this.herdDao.findById(JobDefinitionEntity.class, (Object)jobDefinitionId);
        jobDefinitionEntity.setS3ObjectKey(null);
        JobCreateRequest jobCreateRequest = this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow");
        jobCreateRequest.setParameters(null);
        Job resultJob = this.jobService.createAndStartJob(jobCreateRequest);
        Assert.assertNull((String)"resultJob parameters", (Object)resultJob.getParameters());
    }

    @Test
    public void testDeleteJob() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        JobDeleteRequest jobDeleteRequest = new JobDeleteRequest();
        jobDeleteRequest.setDeleteReason("test delete reason");
        Job deleteJobResponse = this.jobService.deleteJob(job.getId(), jobDeleteRequest);
        Assert.assertEquals((Object)job.getId(), (Object)deleteJobResponse.getId());
        Assert.assertNull((Object)deleteJobResponse.getNamespace());
        Assert.assertNull((Object)deleteJobResponse.getJobName());
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)deleteJobResponse.getStatus());
        Assert.assertEquals((Object)jobDeleteRequest.getDeleteReason(), (Object)deleteJobResponse.getDeleteReason());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertEquals((Object)jobDeleteRequest.getDeleteReason(), (Object)historicProcessInstance.getDeleteReason());
    }

    @Test
    public void testDeleteJobAssertErrorDeleteReasonBlank() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        JobDeleteRequest jobDeleteRequest = new JobDeleteRequest();
        jobDeleteRequest.setDeleteReason("      \t\t ");
        try {
            this.jobService.deleteJob(job.getId(), jobDeleteRequest);
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"deleteReason must be specified", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteJobAssertErrorJobDoesNotExist() throws Exception {
        JobDeleteRequest jobDeleteRequest = new JobDeleteRequest();
        jobDeleteRequest.setDeleteReason("test delete reason");
        try {
            this.jobService.deleteJob("DOES_NOT_EXIST", jobDeleteRequest);
        }
        catch (Exception e) {
            Assert.assertEquals(ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((Object)"Job with ID \"DOES_NOT_EXIST\" does not exist or is already completed.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteJobAssertAccessDeniedWhenUserHasNoPermissions() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        String username = "username";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(username);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(username, "password", false, false, false, false, Collections.emptyList(), applicationUser), null));
        try {
            this.jobService.deleteJob(job.getId(), new JobDeleteRequest("test delete reason"));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[EXECUTE]\" permission(s) to the namespace \"%s\"", username, "testNamespace"), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteJobAssertNoErrorWhenUserHasPermissions() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdReceiveTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        String username = "username";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(username);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("testNamespace", Arrays.asList(NamespacePermissionEnum.EXECUTE)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(username, "password", false, false, false, false, Collections.emptyList(), applicationUser), null));
        try {
            this.jobService.deleteJob(job.getId(), new JobDeleteRequest("test delete reason"));
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetJobAssertAccessDeniedGivenJobCompletedAndUserDoesNotHavePermissions() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition(null);
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        String username = "username";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(username);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(username, "password", false, false, false, false, Collections.emptyList(), applicationUser), null));
        try {
            this.jobService.getJob(job.getId(), false);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"%s\"", username, "testNamespace"), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetJobAssertNoErrorGivenJobCompletedAndUserDoesHasPermissions() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition(null);
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        String username = "username";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(username);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("testNamespace", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(username, "password", false, false, false, false, Collections.emptyList(), applicationUser), null));
        try {
            this.jobService.getJob(job.getId(), false);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetJobAssertAccessDeniedGivenJobRunningAndUserDoesNotHavePermissions() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        String username = "username";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(username);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(username, "password", false, false, false, false, Collections.emptyList(), applicationUser), null));
        try {
            this.jobService.getJob(job.getId(), false);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"%s\"", username, "testNamespace"), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetJobAssertNoErrorGivenJobRunningAndUserDoesHasPermissions() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdUserTaskWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        String username = "username";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(username);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("testNamespace", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(username, "password", false, false, false, false, Collections.emptyList(), applicationUser), null));
        try {
            this.jobService.getJob(job.getId(), false);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    private S3PropertiesLocation getS3PropertiesLocation(String s3BucketName, String s3ObjectKey, Parameter parameter) {
        this.putParameterIntoS3(s3BucketName, s3ObjectKey, parameter);
        S3PropertiesLocation jobDefinitionS3PropertiesLocation = new S3PropertiesLocation();
        jobDefinitionS3PropertiesLocation.setBucketName(s3BucketName);
        jobDefinitionS3PropertiesLocation.setKey(s3ObjectKey);
        return jobDefinitionS3PropertiesLocation;
    }

    private Job createJobWithParameters(S3PropertiesLocation jobDefinitionS3PropertiesLocation, List<Parameter> jobDefinitionParameters, S3PropertiesLocation jobCreateRequestS3PropertiesLocation, List<Parameter> jobCreateRequestParameters) throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest jobDefinitionCreateRequest = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        jobDefinitionCreateRequest.setParameters(jobDefinitionParameters);
        jobDefinitionCreateRequest.setS3PropertiesLocation(jobDefinitionS3PropertiesLocation);
        this.jobDefinitionService.createJobDefinition(jobDefinitionCreateRequest, false);
        JobCreateRequest jobCreateRequest = this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow");
        jobCreateRequest.setParameters(jobCreateRequestParameters);
        jobCreateRequest.setS3PropertiesLocation(jobCreateRequestS3PropertiesLocation);
        return this.jobService.createAndStartJob(jobCreateRequest);
    }

    private void assertParameterEquals(Parameter expectedParameter, List<Parameter> actualParameters) {
        String name = expectedParameter.getName();
        Parameter actualParameter = this.getParameter(name, actualParameters);
        Assert.assertNotNull((String)("parameter ['" + name + "'] not found"), (Object)actualParameter);
        Assert.assertEquals((String)("parameter ['" + name + "'] value"), (Object)actualParameter.getValue(), (Object)expectedParameter.getValue());
    }

    private void putParameterIntoS3(String s3BucketName, String s3ObjectKey, Parameter parameter) {
        String content = parameter.getName() + "=" + parameter.getValue();
        byte[] bytes = content.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)content.length());
        PutObjectRequest putObjectRequest = new PutObjectRequest(s3BucketName, s3ObjectKey, (InputStream)inputStream, metadata);
        this.s3Operations.putObject(putObjectRequest, null);
    }

    private Parameter getParameter(String name, Collection<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    private void validateJobSummaries(Map<String, JobStatusEnum> expectedJobStatuses, JobSummaries actualJobSummaries) {
        HashMap<String, JobStatusEnum> actualJobStatuses = new HashMap<String, JobStatusEnum>();
        for (JobSummary actualJobSummary : actualJobSummaries.getJobSummaries()) {
            actualJobStatuses.put(actualJobSummary.getId(), actualJobSummary.getStatus());
        }
        Assert.assertEquals(expectedJobStatuses, actualJobStatuses);
    }
}

