/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.finra.herd.dao.EmrClusterDefinitionDaoTestHelper;
import org.finra.herd.dao.NamespaceDao;
import org.finra.herd.dao.helper.XmlHelper;
import org.finra.herd.model.api.xml.EmrClusterDefinition;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.JobCreateRequest;
import org.finra.herd.model.api.xml.NamespaceAuthorization;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.dto.ApplicationUser;
import org.finra.herd.model.dto.SecurityUserWrapper;
import org.finra.herd.model.jpa.EmrClusterDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.JobDefinitionServiceTestHelper;
import org.finra.herd.service.JobService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class JobServiceTestHelper {
    @Autowired
    private EmrClusterDefinitionDaoTestHelper emrClusterDefinitionDaoTestHelper;
    @Autowired
    private JobDefinitionServiceTestHelper jobDefinitionServiceTestHelper;
    @Autowired
    private JobService jobService;
    @Autowired
    private NamespaceDao namespaceDao;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private XmlHelper xmlHelper;

    public Job createJob(String activitiXmlClasspathResourceName) throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition(activitiXmlClasspathResourceName);
        return this.jobService.createAndStartJob(this.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
    }

    public Job createJob(String activitiXmlClasspathResourceName, List<Parameter> parameters) throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition(activitiXmlClasspathResourceName);
        return this.jobService.createAndStartJob(this.createJobCreateRequest("testNamespace", "testHerdWorkflow", parameters));
    }

    public JobCreateRequest createJobCreateRequest(String namespaceCd, String jobName) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("Attribute Name 2", "   Attribute Value 2  ");
        parameters.add(parameter);
        parameter = new Parameter("Extra Attribute With No Value", null);
        parameters.add(parameter);
        return this.createJobCreateRequest(namespaceCd, jobName, parameters);
    }

    public JobCreateRequest createJobCreateRequest(String namespaceCd, String jobName, List<Parameter> parameters) {
        JobCreateRequest jobCreateRequest = new JobCreateRequest();
        jobCreateRequest.setNamespace(namespaceCd);
        jobCreateRequest.setJobName(jobName);
        jobCreateRequest.setParameters(parameters);
        return jobCreateRequest;
    }

    public Job createJobForCreateCluster(String activitiXmlClasspathResourceName, List<Parameter> parameters, String amiVersion) throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition(activitiXmlClasspathResourceName);
        NamespaceEntity namespaceEntity = this.namespaceDao.getNamespaceByCd("testNamespace");
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setAmiVersion(amiVersion);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, AbstractServiceTest.EMR_CLUSTER_DEFINITION_NAME, configXml);
        Parameter parameter = new Parameter("emrClusterDefinitionName", emrClusterDefinitionEntity.getName());
        parameters.add(parameter);
        parameter = new Parameter("namespace", "testNamespace");
        parameters.add(parameter);
        return this.jobService.createAndStartJob(this.createJobCreateRequest("testNamespace", "testHerdWorkflow", parameters));
    }

    public Job createJobForCreateCluster(String activitiXmlClasspathResourceName, List<Parameter> parameters) throws Exception {
        return this.createJobForCreateCluster(activitiXmlClasspathResourceName, parameters, null);
    }

    public Job createJobForCreateClusterForActivitiXml(String activitiXml, List<Parameter> parameters) throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinitionForActivitiXml(activitiXml);
        NamespaceEntity namespaceEntity = this.namespaceDao.getNamespaceByCd("testNamespace");
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, AbstractServiceTest.EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        Parameter parameter = new Parameter("namespace", namespaceEntity.getCode());
        parameters.add(parameter);
        parameter = new Parameter("emrClusterDefinitionName", emrClusterDefinitionEntity.getName());
        parameters.add(parameter);
        parameter = new Parameter("dryRun", null);
        parameters.add(parameter);
        parameter = new Parameter("contentType", null);
        parameters.add(parameter);
        parameter = new Parameter("emrClusterDefinitionOverride", null);
        parameters.add(parameter);
        return this.jobService.createAndStartJob(this.createJobCreateRequest("testNamespace", "testHerdWorkflow", parameters));
    }

    public Job createJobFromActivitiXml(String activitiXml, List<Parameter> parameters) throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinitionForActivitiXml(activitiXml);
        return this.jobService.createAndStartJob(this.createJobCreateRequest("testNamespace", "testHerdWorkflow", parameters));
    }

    public void setCurrentUserNamespaceAuthorizations(String namespace, List<NamespacePermissionEnum> namespacePermissions) {
        String username = AbstractServiceTest.USER_ID;
        ApplicationUser applicationUser = new ApplicationUser(this.getClass());
        applicationUser.setUserId(username);
        LinkedHashSet<NamespaceAuthorization> namespaceAuthorizations = new LinkedHashSet<NamespaceAuthorization>();
        namespaceAuthorizations.add(new NamespaceAuthorization(namespace, namespacePermissions));
        applicationUser.setNamespaceAuthorizations(namespaceAuthorizations);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(username, "password", false, false, false, false, Collections.emptyList(), applicationUser), null));
    }
}

