/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.NamespaceIamRoleAuthorizationDao;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.IamRole;
import org.finra.herd.model.api.xml.NamespaceIamRoleAuthorization;
import org.finra.herd.model.api.xml.NamespaceIamRoleAuthorizationCreateRequest;
import org.finra.herd.model.api.xml.NamespaceIamRoleAuthorizationUpdateRequest;
import org.finra.herd.model.api.xml.NamespaceIamRoleAuthorizations;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.NamespaceIamRoleAuthorizationEntity;
import org.finra.herd.service.helper.NamespaceDaoHelper;
import org.finra.herd.service.impl.NamespaceIamRoleAuthorizationServiceImpl;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class NamespaceIamRoleAuthorizationServiceTest {
    @InjectMocks
    private NamespaceIamRoleAuthorizationServiceImpl namespaceIamRoleAuthorizationServiceImpl;
    @Mock
    private NamespaceDaoHelper namespaceDaoHelper;
    @Mock
    private NamespaceIamRoleAuthorizationDao namespaceIamRoleAuthorizationDao;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void createNamespaceIamRoleAuthorizationAssertDependenciesCalledAndResultExpected() {
        IamRole expectedIamRole1 = new IamRole("iamRoleName1", "iamRoleDescription1");
        IamRole expectedIamRole2 = new IamRole("iamRoleName2", " ");
        List<IamRole> expectedIamRoles = Arrays.asList(expectedIamRole1, expectedIamRole2);
        NamespaceIamRoleAuthorizationCreateRequest expectedRequest = new NamespaceIamRoleAuthorizationCreateRequest("namespace", expectedIamRoles);
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(Collections.emptyList());
        NamespaceIamRoleAuthorization response = this.namespaceIamRoleAuthorizationServiceImpl.createNamespaceIamRoleAuthorization(expectedRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)expectedNamespaceEntity.getCode(), (Object)response.getNamespace());
        Assert.assertNotNull((Object)response.getIamRoles());
        Assert.assertEquals((long)expectedIamRoles.size(), (long)response.getIamRoles().size());
        IamRole iamRole = (IamRole)response.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)expectedIamRole1.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)expectedIamRole1.getIamRoleDescription(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)response.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)expectedIamRole2.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals(null, (Object)iamRole.getIamRoleDescription());
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedRequest.getNamespace());
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).saveAndRefresh((Object)this.namespaceIamRoleAuthorizationEntityEq(expectedNamespaceEntity.getCode(), expectedIamRole1.getIamRoleName(), expectedIamRole1.getIamRoleDescription()));
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).saveAndRefresh((Object)this.namespaceIamRoleAuthorizationEntityEq(expectedNamespaceEntity.getCode(), expectedIamRole2.getIamRoleName(), null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void createNamespaceIamRoleAuthorizationAssertErrorWhenAuthorizationAlreadyExist() {
        IamRole expectedIamRole1 = new IamRole("iamRoleName1", "iamRoleDescription1");
        IamRole expectedIamRole2 = new IamRole("iamRoleName2", "iamRoleDescription2");
        List<IamRole> expectedIamRoles = Arrays.asList(expectedIamRole1, expectedIamRole2);
        NamespaceIamRoleAuthorizationCreateRequest expectedRequest = new NamespaceIamRoleAuthorizationCreateRequest("namespace", expectedIamRoles);
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(Arrays.asList(new NamespaceIamRoleAuthorizationEntity()));
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.createNamespaceIamRoleAuthorization(expectedRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AlreadyExistsException.class, e.getClass());
            Assert.assertEquals((Object)String.format("Namespace IAM role authorizations with namespace \"%s\" already exist", expectedNamespaceEntity.getCode()), (Object)e.getMessage());
        }
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedRequest.getNamespace());
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void createNamespaceIamRoleAuthorizationAssertErrorWhenRoleNameIsBlank() {
        IamRole expectedIamRole1 = new IamRole("iamRoleName1", "iamRoleDescription1");
        IamRole expectedIamRole2 = new IamRole(" ", "iamRoleDescription2");
        List<IamRole> expectedIamRoles = Arrays.asList(expectedIamRole1, expectedIamRole2);
        NamespaceIamRoleAuthorizationCreateRequest expectedRequest = new NamespaceIamRoleAuthorizationCreateRequest("namespace", expectedIamRoles);
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.createNamespaceIamRoleAuthorization(expectedRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"IAM role name must be specified", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void createNamespaceIamRoleAuthorizationAssertErrorWhenIamRolesEmpty() {
        List<IamRole> expectedIamRoles = Arrays.asList(new IamRole[0]);
        NamespaceIamRoleAuthorizationCreateRequest expectedRequest = new NamespaceIamRoleAuthorizationCreateRequest("namespace", expectedIamRoles);
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.createNamespaceIamRoleAuthorization(expectedRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"At least 1 IAM roles must be specified", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void createNamespaceIamRoleAuthorizationAssertErrorWhenNamespaceIsBlank() {
        IamRole expectedIamRole1 = new IamRole("iamRoleName1", "iamRoleDescription1");
        IamRole expectedIamRole2 = new IamRole("iamRoleName2", " ");
        List<IamRole> expectedIamRoles = Arrays.asList(expectedIamRole1, expectedIamRole2);
        NamespaceIamRoleAuthorizationCreateRequest expectedRequest = new NamespaceIamRoleAuthorizationCreateRequest(" ", expectedIamRoles);
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.createNamespaceIamRoleAuthorization(expectedRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"Namespace must be specified", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void createNamespaceIamRoleAuthorizationAssertInputsTrimmed() {
        IamRole expectedIamRole1 = new IamRole(" iamRoleName1 ", " iamRoleDescription1 ");
        IamRole expectedIamRole2 = new IamRole(" iamRoleName2 ", " ");
        List<IamRole> expectedIamRoles = Arrays.asList(expectedIamRole1, expectedIamRole2);
        NamespaceIamRoleAuthorizationCreateRequest expectedRequest = new NamespaceIamRoleAuthorizationCreateRequest(" namespace ", expectedIamRoles);
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(Collections.emptyList());
        NamespaceIamRoleAuthorization response = this.namespaceIamRoleAuthorizationServiceImpl.createNamespaceIamRoleAuthorization(expectedRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)expectedNamespaceEntity.getCode(), (Object)response.getNamespace());
        Assert.assertNotNull((Object)response.getIamRoles());
        Assert.assertEquals((long)expectedIamRoles.size(), (long)response.getIamRoles().size());
        IamRole iamRole = (IamRole)response.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)expectedIamRole1.getIamRoleName().trim(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)expectedIamRole1.getIamRoleDescription().trim(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)response.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)expectedIamRole2.getIamRoleName().trim(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals(null, (Object)iamRole.getIamRoleDescription());
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedRequest.getNamespace().trim());
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).saveAndRefresh((Object)this.namespaceIamRoleAuthorizationEntityEq(expectedNamespaceEntity.getCode(), expectedIamRole1.getIamRoleName().trim(), expectedIamRole1.getIamRoleDescription().trim()));
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).saveAndRefresh((Object)this.namespaceIamRoleAuthorizationEntityEq(expectedNamespaceEntity.getCode(), expectedIamRole2.getIamRoleName().trim(), null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void getNamespaceIamRoleAuthorizationAssertDependenciesCalledAndResultExpected() {
        String expectedNamespace = "namespace";
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setNamespace(expectedNamespaceEntity);
        namespaceIamRoleAuthorizationEntity1.setIamRoleName("iamRoleName1");
        namespaceIamRoleAuthorizationEntity1.setDescription("description1");
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setNamespace(expectedNamespaceEntity);
        namespaceIamRoleAuthorizationEntity2.setIamRoleName("iamRoleName2");
        namespaceIamRoleAuthorizationEntity2.setDescription("description2");
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        NamespaceIamRoleAuthorization namespaceIamRoleAuthorization = this.namespaceIamRoleAuthorizationServiceImpl.getNamespaceIamRoleAuthorization(expectedNamespace);
        Assert.assertNotNull((Object)namespaceIamRoleAuthorization);
        Assert.assertEquals((Object)expectedNamespaceEntity.getCode(), (Object)namespaceIamRoleAuthorization.getNamespace());
        Assert.assertNotNull((Object)namespaceIamRoleAuthorization.getIamRoles());
        Assert.assertEquals((long)2L, (long)namespaceIamRoleAuthorization.getIamRoles().size());
        IamRole iamRole = (IamRole)namespaceIamRoleAuthorization.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getDescription(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)namespaceIamRoleAuthorization.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getDescription(), (Object)iamRole.getIamRoleDescription());
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void getNamespaceIamRoleAuthorizationAssertInputsTrimmed() {
        String expectedNamespace = " namespace ";
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setNamespace(expectedNamespaceEntity);
        namespaceIamRoleAuthorizationEntity1.setIamRoleName("iamRoleName1");
        namespaceIamRoleAuthorizationEntity1.setDescription("description1");
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setNamespace(expectedNamespaceEntity);
        namespaceIamRoleAuthorizationEntity2.setIamRoleName("iamRoleName2");
        namespaceIamRoleAuthorizationEntity2.setDescription("description2");
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        NamespaceIamRoleAuthorization namespaceIamRoleAuthorization = this.namespaceIamRoleAuthorizationServiceImpl.getNamespaceIamRoleAuthorization(expectedNamespace);
        Assert.assertNotNull((Object)namespaceIamRoleAuthorization);
        Assert.assertEquals((Object)expectedNamespaceEntity.getCode(), (Object)namespaceIamRoleAuthorization.getNamespace());
        Assert.assertNotNull((Object)namespaceIamRoleAuthorization.getIamRoles());
        Assert.assertEquals((long)2L, (long)namespaceIamRoleAuthorization.getIamRoles().size());
        IamRole iamRole = (IamRole)namespaceIamRoleAuthorization.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getDescription(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)namespaceIamRoleAuthorization.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getDescription(), (Object)iamRole.getIamRoleDescription());
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace.trim());
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void getNamespaceIamRoleAuthorizationAssertErrorWhenNoEntitiesFound() {
        String expectedNamespace = "namespace";
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        List namespaceIamRoleAuthorizationEntities = Collections.emptyList();
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.getNamespaceIamRoleAuthorization(expectedNamespace);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((Object)String.format("Namespace IAM role authorizations for namespace \"%s\" do not exist", expectedNamespaceEntity.getCode()), (Object)e.getMessage());
        }
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void getNamespaceIamRoleAuthorizationAssertErrorWhenNamespaceIsBlank() {
        String expectedNamespace = " ";
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.getNamespaceIamRoleAuthorization(expectedNamespace);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"Namespace must be specified", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void getNamespaceIamRoleAuthorizationsAssertCallsDependenciesAndResultExpected() {
        NamespaceEntity namespaceEntity1 = new NamespaceEntity();
        namespaceEntity1.setCode("namespace1");
        NamespaceEntity namespaceEntity2 = new NamespaceEntity();
        namespaceEntity2.setCode("namespace2");
        ArrayList<NamespaceIamRoleAuthorizationEntity> expectedNamespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setNamespace(namespaceEntity1);
        namespaceIamRoleAuthorizationEntity1.setIamRoleName("iamRoleName1");
        namespaceIamRoleAuthorizationEntity1.setDescription("description1");
        expectedNamespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setNamespace(namespaceEntity1);
        namespaceIamRoleAuthorizationEntity2.setIamRoleName("iamRoleName2");
        namespaceIamRoleAuthorizationEntity2.setDescription("description2");
        expectedNamespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity3 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity3.setNamespace(namespaceEntity2);
        namespaceIamRoleAuthorizationEntity3.setIamRoleName("iamRoleName3");
        namespaceIamRoleAuthorizationEntity3.setDescription("description3");
        expectedNamespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity3);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity4 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity4.setNamespace(namespaceEntity2);
        namespaceIamRoleAuthorizationEntity4.setIamRoleName("iamRoleName4");
        namespaceIamRoleAuthorizationEntity4.setDescription("description4");
        expectedNamespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity4);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(expectedNamespaceIamRoleAuthorizationEntities);
        NamespaceIamRoleAuthorizations result = this.namespaceIamRoleAuthorizationServiceImpl.getNamespaceIamRoleAuthorizations();
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getNamespaceIamRoleAuthorizations());
        Assert.assertEquals((long)2L, (long)result.getNamespaceIamRoleAuthorizations().size());
        NamespaceIamRoleAuthorization namespaceIamRoleAuthorization = (NamespaceIamRoleAuthorization)result.getNamespaceIamRoleAuthorizations().get(0);
        Assert.assertNotNull((Object)namespaceIamRoleAuthorization);
        Assert.assertEquals((Object)namespaceEntity1.getCode(), (Object)namespaceIamRoleAuthorization.getNamespace());
        Assert.assertNotNull((Object)namespaceIamRoleAuthorization.getIamRoles());
        Assert.assertEquals((long)2L, (long)namespaceIamRoleAuthorization.getIamRoles().size());
        IamRole iamRole = (IamRole)namespaceIamRoleAuthorization.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getDescription(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)namespaceIamRoleAuthorization.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getDescription(), (Object)iamRole.getIamRoleDescription());
        namespaceIamRoleAuthorization = (NamespaceIamRoleAuthorization)result.getNamespaceIamRoleAuthorizations().get(1);
        Assert.assertNotNull((Object)namespaceIamRoleAuthorization);
        Assert.assertEquals((Object)namespaceEntity2.getCode(), (Object)namespaceIamRoleAuthorization.getNamespace());
        Assert.assertNotNull((Object)namespaceIamRoleAuthorization.getIamRoles());
        Assert.assertEquals((long)2L, (long)namespaceIamRoleAuthorization.getIamRoles().size());
        iamRole = (IamRole)namespaceIamRoleAuthorization.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity3.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity3.getDescription(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)namespaceIamRoleAuthorization.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity4.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity4.getDescription(), (Object)iamRole.getIamRoleDescription());
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void getNamespaceIamRoleAuthorizationsAssertResultEmptyWhenDaoReturnsEmpty() {
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(Collections.emptyList());
        NamespaceIamRoleAuthorizations result = this.namespaceIamRoleAuthorizationServiceImpl.getNamespaceIamRoleAuthorizations();
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getNamespaceIamRoleAuthorizations());
        Assert.assertEquals((long)0L, (long)result.getNamespaceIamRoleAuthorizations().size());
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void updateNamespaceIamRoleAuthorizationAssertCallsDependenciesAndResultExpected() {
        String expectedNamespace = "namespace";
        ArrayList<IamRole> iamRoles = new ArrayList<IamRole>();
        IamRole iamRole1 = new IamRole("iamRoleName1", "iamRoleDescription1");
        iamRoles.add(iamRole1);
        IamRole iamRole2 = new IamRole("iamRoleName2", " ");
        iamRoles.add(iamRole2);
        NamespaceIamRoleAuthorizationUpdateRequest expectedNamespaceIamRoleAuthorizationUpdateRequest = new NamespaceIamRoleAuthorizationUpdateRequest(iamRoles);
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        NamespaceIamRoleAuthorization result = this.namespaceIamRoleAuthorizationServiceImpl.updateNamespaceIamRoleAuthorization(expectedNamespace, expectedNamespaceIamRoleAuthorizationUpdateRequest);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)expectedNamespaceEntity.getCode(), (Object)result.getNamespace());
        Assert.assertNotNull((Object)result.getIamRoles());
        Assert.assertEquals((long)2L, (long)result.getIamRoles().size());
        IamRole iamRole = (IamRole)result.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)iamRole1.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)iamRole1.getIamRoleDescription(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)result.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)iamRole2.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals(null, (Object)iamRole.getIamRoleDescription());
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).delete((Object)namespaceIamRoleAuthorizationEntity);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).saveAndRefresh((Object)this.namespaceIamRoleAuthorizationEntityEq(expectedNamespaceEntity.getCode(), iamRole1.getIamRoleName(), iamRole1.getIamRoleDescription()));
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).saveAndRefresh((Object)this.namespaceIamRoleAuthorizationEntityEq(expectedNamespaceEntity.getCode(), iamRole2.getIamRoleName(), null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void updateNamespaceIamRoleAuthorizationAssertInputsTrimmed() {
        String expectedNamespace = " namespace ";
        ArrayList<IamRole> iamRoles = new ArrayList<IamRole>();
        IamRole iamRole1 = new IamRole(" iamRoleName1 ", " iamRoleDescription1 ");
        iamRoles.add(iamRole1);
        IamRole iamRole2 = new IamRole(" iamRoleName2 ", " ");
        iamRoles.add(iamRole2);
        NamespaceIamRoleAuthorizationUpdateRequest expectedNamespaceIamRoleAuthorizationUpdateRequest = new NamespaceIamRoleAuthorizationUpdateRequest(iamRoles);
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        NamespaceIamRoleAuthorization result = this.namespaceIamRoleAuthorizationServiceImpl.updateNamespaceIamRoleAuthorization(expectedNamespace, expectedNamespaceIamRoleAuthorizationUpdateRequest);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)expectedNamespaceEntity.getCode(), (Object)result.getNamespace());
        Assert.assertNotNull((Object)result.getIamRoles());
        Assert.assertEquals((long)2L, (long)result.getIamRoles().size());
        IamRole iamRole = (IamRole)result.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)iamRole1.getIamRoleName().trim(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)iamRole1.getIamRoleDescription().trim(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)result.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)iamRole2.getIamRoleName().trim(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals(null, (Object)iamRole.getIamRoleDescription());
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace.trim());
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).delete((Object)namespaceIamRoleAuthorizationEntity);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).saveAndRefresh((Object)this.namespaceIamRoleAuthorizationEntityEq(expectedNamespaceEntity.getCode(), iamRole1.getIamRoleName().trim(), iamRole1.getIamRoleDescription().trim()));
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).saveAndRefresh((Object)this.namespaceIamRoleAuthorizationEntityEq(expectedNamespaceEntity.getCode(), iamRole2.getIamRoleName().trim(), null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void updateNamespaceIamRoleAuthorizationAssertErrorWhenDaoReturnsEmpty() {
        String expectedNamespace = "namespace";
        ArrayList<IamRole> iamRoles = new ArrayList<IamRole>();
        IamRole iamRole1 = new IamRole("iamRoleName1", "iamRoleDescription1");
        iamRoles.add(iamRole1);
        IamRole iamRole2 = new IamRole("iamRoleName2", " ");
        iamRoles.add(iamRole2);
        NamespaceIamRoleAuthorizationUpdateRequest expectedNamespaceIamRoleAuthorizationUpdateRequest = new NamespaceIamRoleAuthorizationUpdateRequest(iamRoles);
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(Collections.emptyList());
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.updateNamespaceIamRoleAuthorization(expectedNamespace, expectedNamespaceIamRoleAuthorizationUpdateRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((Object)String.format("Namespace IAM role authorizations for namespace \"%s\" do not exist", expectedNamespaceEntity.getCode()), (Object)e.getMessage());
        }
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void updateNamespaceIamRoleAuthorizationAssertErrorWhenRoleNameIsBlank() {
        String expectedNamespace = "namespace";
        ArrayList<IamRole> iamRoles = new ArrayList<IamRole>();
        IamRole iamRole1 = new IamRole(" ", "iamRoleDescription1");
        iamRoles.add(iamRole1);
        IamRole iamRole2 = new IamRole(" ", " ");
        iamRoles.add(iamRole2);
        NamespaceIamRoleAuthorizationUpdateRequest expectedNamespaceIamRoleAuthorizationUpdateRequest = new NamespaceIamRoleAuthorizationUpdateRequest(iamRoles);
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.updateNamespaceIamRoleAuthorization(expectedNamespace, expectedNamespaceIamRoleAuthorizationUpdateRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"IAM role name must be specified", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void updateNamespaceIamRoleAuthorizationAssertErrorWhenIamRolesEmpty() {
        String expectedNamespace = "namespace";
        NamespaceIamRoleAuthorizationUpdateRequest expectedNamespaceIamRoleAuthorizationUpdateRequest = new NamespaceIamRoleAuthorizationUpdateRequest(Collections.emptyList());
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.updateNamespaceIamRoleAuthorization(expectedNamespace, expectedNamespaceIamRoleAuthorizationUpdateRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"At least 1 IAM roles must be specified", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void updateNamespaceIamRoleAuthorizationAssertErrorWhenNamespaceIsBlank() {
        String expectedNamespace = " ";
        ArrayList<IamRole> iamRoles = new ArrayList<IamRole>();
        IamRole iamRole1 = new IamRole("iamRoleName1", "iamRoleDescription1");
        iamRoles.add(iamRole1);
        IamRole iamRole2 = new IamRole("iamRoleName2", " ");
        iamRoles.add(iamRole2);
        NamespaceIamRoleAuthorizationUpdateRequest expectedNamespaceIamRoleAuthorizationUpdateRequest = new NamespaceIamRoleAuthorizationUpdateRequest(iamRoles);
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.updateNamespaceIamRoleAuthorization(expectedNamespace, expectedNamespaceIamRoleAuthorizationUpdateRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"Namespace must be specified", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void deleteNamespaceIamRoleAuthorizationAssertCallsDependenciesAndResultExpected() {
        String expectedNamespace = "namespace";
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        ArrayList<NamespaceIamRoleAuthorizationEntity> expectedNamespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setNamespace(expectedNamespaceEntity);
        namespaceIamRoleAuthorizationEntity1.setIamRoleName("iamRoleName1");
        namespaceIamRoleAuthorizationEntity1.setDescription("description1");
        expectedNamespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setNamespace(expectedNamespaceEntity);
        namespaceIamRoleAuthorizationEntity2.setIamRoleName("iamRoleName2");
        namespaceIamRoleAuthorizationEntity2.setDescription("description2");
        expectedNamespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(expectedNamespaceIamRoleAuthorizationEntities);
        NamespaceIamRoleAuthorization result = this.namespaceIamRoleAuthorizationServiceImpl.deleteNamespaceIamRoleAuthorization(expectedNamespace);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)expectedNamespaceEntity.getCode(), (Object)result.getNamespace());
        Assert.assertNotNull((Object)result.getIamRoles());
        Assert.assertEquals((long)2L, (long)result.getIamRoles().size());
        IamRole iamRole = (IamRole)result.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getDescription(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)result.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getDescription(), (Object)iamRole.getIamRoleDescription());
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).delete((Object)namespaceIamRoleAuthorizationEntity1);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).delete((Object)namespaceIamRoleAuthorizationEntity2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void deleteNamespaceIamRoleAuthorizationAssertInputsAreTrimmed() {
        String expectedNamespace = " namespace ";
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        ArrayList<NamespaceIamRoleAuthorizationEntity> expectedNamespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setNamespace(expectedNamespaceEntity);
        namespaceIamRoleAuthorizationEntity1.setIamRoleName("iamRoleName1");
        namespaceIamRoleAuthorizationEntity1.setDescription("description1");
        expectedNamespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setNamespace(expectedNamespaceEntity);
        namespaceIamRoleAuthorizationEntity2.setIamRoleName("iamRoleName2");
        namespaceIamRoleAuthorizationEntity2.setDescription("description2");
        expectedNamespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(expectedNamespaceIamRoleAuthorizationEntities);
        NamespaceIamRoleAuthorization result = this.namespaceIamRoleAuthorizationServiceImpl.deleteNamespaceIamRoleAuthorization(expectedNamespace);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)expectedNamespaceEntity.getCode(), (Object)result.getNamespace());
        Assert.assertNotNull((Object)result.getIamRoles());
        Assert.assertEquals((long)2L, (long)result.getIamRoles().size());
        IamRole iamRole = (IamRole)result.getIamRoles().get(0);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity1.getDescription(), (Object)iamRole.getIamRoleDescription());
        iamRole = (IamRole)result.getIamRoles().get(1);
        Assert.assertNotNull((Object)iamRole);
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getIamRoleName(), (Object)iamRole.getIamRoleName());
        Assert.assertEquals((Object)namespaceIamRoleAuthorizationEntity2.getDescription(), (Object)iamRole.getIamRoleDescription());
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace.trim());
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).delete((Object)namespaceIamRoleAuthorizationEntity1);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).delete((Object)namespaceIamRoleAuthorizationEntity2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void deleteNamespaceIamRoleAuthorizationAssertErrorWhenDaoReturnsEmpty() {
        String expectedNamespace = "namespace";
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("NAMESPACE");
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity((String)Matchers.any())).thenReturn((Object)expectedNamespaceEntity);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(Collections.emptyList());
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.deleteNamespaceIamRoleAuthorization(expectedNamespace);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((Object)String.format("Namespace IAM role authorizations for namespace \"%s\" do not exist", expectedNamespaceEntity.getCode()), (Object)e.getMessage());
        }
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(expectedNamespace);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void deleteNamespaceIamRoleAuthorizationAssertErrorWhenNamespaceIsBlank() {
        String expectedNamespace = " ";
        try {
            this.namespaceIamRoleAuthorizationServiceImpl.deleteNamespaceIamRoleAuthorization(expectedNamespace);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"Namespace must be specified", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.namespaceDaoHelper, this.namespaceIamRoleAuthorizationDao});
    }

    private NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntityEq(final String expectedNamespace, final String expectedIamRoleName, final String expectedDescription) {
        return (NamespaceIamRoleAuthorizationEntity)Matchers.argThat((Matcher)new ArgumentMatcher<NamespaceIamRoleAuthorizationEntity>(){

            public boolean matches(Object argument) {
                NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity = (NamespaceIamRoleAuthorizationEntity)argument;
                String namespace = namespaceIamRoleAuthorizationEntity.getNamespace().getCode();
                String iamRoleName = namespaceIamRoleAuthorizationEntity.getIamRoleName();
                String description = namespaceIamRoleAuthorizationEntity.getDescription();
                return Objects.equal((Object)namespace, (Object)expectedNamespace) && Objects.equal((Object)iamRoleName, (Object)expectedIamRoleName) && Objects.equal((Object)description, (Object)expectedDescription);
            }
        });
    }
}

