/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.NotificationRegistrationKey;
import org.finra.herd.model.api.xml.NotificationRegistrationStatusUpdateRequest;
import org.finra.herd.model.api.xml.NotificationRegistrationStatusUpdateResponse;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class NotificationRegistrationStatusServiceTest
extends AbstractServiceTest {
    @Test
    public void testUpdateNotificationRegistrationStatusAssertUpdateSuccess() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        NotificationRegistrationStatusUpdateResponse response = this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(NAMESPACE, NOTIFICATION_NAME, new NotificationRegistrationStatusUpdateRequest("DISABLED"));
        Assert.assertEquals((Object)new NotificationRegistrationStatusUpdateResponse(notificationRegistrationKey, "DISABLED"), (Object)response);
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertUpdateSuccessCaseInsensitive() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        NotificationRegistrationStatusUpdateResponse response = this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(NAMESPACE, NOTIFICATION_NAME, new NotificationRegistrationStatusUpdateRequest("DISABLED".toLowerCase()));
        Assert.assertEquals((Object)new NotificationRegistrationStatusUpdateResponse(notificationRegistrationKey, "DISABLED"), (Object)response);
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertUpdateSuccessTrim() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        NotificationRegistrationStatusUpdateResponse response = this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME), new NotificationRegistrationStatusUpdateRequest(this.addWhitespace("DISABLED")));
        Assert.assertEquals((Object)new NotificationRegistrationStatusUpdateResponse(notificationRegistrationKey, "DISABLED"), (Object)response);
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertThrowWhenNamespaceNull() {
        try {
            this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(null, NOTIFICATION_NAME, new NotificationRegistrationStatusUpdateRequest("DISABLED"));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"The namespace must be specified", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertThrowWhenNamespaceBlank() {
        try {
            this.notificationRegistrationStatusService.updateNotificationRegistrationStatus("      \t\t ", NOTIFICATION_NAME, new NotificationRegistrationStatusUpdateRequest("DISABLED"));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"The namespace must be specified", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertThrowWhenNameNull() {
        try {
            this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(NAMESPACE, null, new NotificationRegistrationStatusUpdateRequest("DISABLED"));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"The notification name must be specified", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertThrowWhenNameBlank() {
        try {
            this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(NAMESPACE, "      \t\t ", new NotificationRegistrationStatusUpdateRequest("DISABLED"));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"The notification name must be specified", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertThrowWhenStatusNull() {
        try {
            this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(NAMESPACE, NOTIFICATION_NAME, new NotificationRegistrationStatusUpdateRequest(null));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"The notification registration status must be specified", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertThrowWhenStatusBlank() {
        try {
            this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(NAMESPACE, NOTIFICATION_NAME, new NotificationRegistrationStatusUpdateRequest("      \t\t "));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"The notification registration status must be specified", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateNotificationRegistrationStatusAssertThrowNotificationNotFound() {
        try {
            this.notificationRegistrationStatusService.updateNotificationRegistrationStatus(NAMESPACE, "DOES_NOT_EXIST", new NotificationRegistrationStatusUpdateRequest("DISABLED"));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((Object)("The notification registration with namespace \"" + NAMESPACE + "\" and name \"DOES_NOT_EXIST\" was not found."), (Object)e.getMessage());
        }
    }
}

