/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.finra.herd.core.Command;
import org.finra.herd.model.dto.S3FileCopyRequestParamsDto;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.S3FileTransferResultsDto;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.S3ServiceImpl;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class S3ServiceTest
extends AbstractServiceTest {
    private Path localTempPath;

    @Before
    public void setupEnv() throws IOException {
        this.localTempPath = Files.createTempDirectory(null, new FileAttribute[0]);
    }

    @After
    public void cleanEnv() throws IOException {
        FileUtils.deleteDirectory((File)this.localTempPath.toFile());
        for (S3FileTransferRequestParamsDto params : Arrays.asList(this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto(), S3FileTransferRequestParamsDto.builder().s3BucketName(this.storageDaoTestHelper.getS3LoadingDockBucketName()).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build(), S3FileTransferRequestParamsDto.builder().s3BucketName(this.storageDaoTestHelper.getS3ExternalBucketName()).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build())) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    @Test
    public void testUploadFile() throws IOException, InterruptedException {
        File targetFile = S3ServiceTest.createLocalFile((String)this.localTempPath.toString(), (String)"foo.dat", (long)1024L);
        Assert.assertTrue((boolean)targetFile.isFile());
        Assert.assertTrue((targetFile.length() == 1024L ? 1 : 0) != 0);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3KeyPrefix(TARGET_S3_KEY);
        s3FileTransferRequestParamsDto.setLocalPath(targetFile.getPath());
        S3FileTransferResultsDto results = this.s3Service.uploadFile(s3FileTransferRequestParamsDto);
        Assert.assertTrue((results.getTotalFilesTransferred() == 1L ? 1 : 0) != 0);
        this.s3DaoTestHelper.validateS3FileUpload(s3FileTransferRequestParamsDto, Arrays.asList(TARGET_S3_KEY));
    }

    @Test
    public void testUploadFileList() throws IOException, InterruptedException {
        for (String file : LOCAL_FILES) {
            S3ServiceTest.createLocalFile((String)this.localTempPath.toString(), (String)file, (long)1024L);
        }
        ArrayList<File> requestFileList = new ArrayList<File>();
        ArrayList<String> expectedKeys = new ArrayList<String>();
        for (String file : LOCAL_FILES_SUBSET) {
            requestFileList.add(Paths.get(this.localTempPath.toString(), file).toFile());
            expectedKeys.add(TEST_S3_KEY_PREFIX + "/" + file.replaceAll("\\\\", "/"));
        }
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3KeyPrefix(TEST_S3_KEY_PREFIX);
        s3FileTransferRequestParamsDto.setLocalPath(this.localTempPath.toString());
        s3FileTransferRequestParamsDto.setFiles(requestFileList);
        S3FileTransferResultsDto results = this.s3Service.uploadFileList(s3FileTransferRequestParamsDto);
        Assert.assertTrue((results.getTotalFilesTransferred() == (long)LOCAL_FILES_SUBSET.size() ? 1 : 0) != 0);
        this.s3DaoTestHelper.validateS3FileUpload(s3FileTransferRequestParamsDto, expectedKeys);
    }

    @Test
    public void testCopyFile() throws InterruptedException {
        this.s3Operations.putObject(new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
        S3FileCopyRequestParamsDto params = new S3FileCopyRequestParamsDto();
        params.setKmsKeyId("AWS_KMS_EXTERNAL_KEY_ID");
        params.setSourceBucketName(this.storageDaoTestHelper.getS3LoadingDockBucketName());
        params.setTargetBucketName(this.storageDaoTestHelper.getS3ExternalBucketName());
        params.setSourceObjectKey(TARGET_S3_KEY);
        params.setTargetObjectKey(TARGET_S3_KEY);
        S3FileTransferResultsDto results = this.s3Service.copyFile(params);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((Object)1L, (Object)results.getTotalFilesTransferred());
        Assert.assertEquals((Object)1024L, (Object)results.getTotalBytesTransferred());
    }

    @Test
    public void testUploadDirectory() throws IOException, InterruptedException {
        for (String file : LOCAL_FILES) {
            S3ServiceTest.createLocalFile((String)this.localTempPath.toString(), (String)file, (long)1024L);
        }
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3KeyPrefix(TEST_S3_KEY_PREFIX);
        s3FileTransferRequestParamsDto.setLocalPath(this.localTempPath.toString());
        s3FileTransferRequestParamsDto.setRecursive(Boolean.valueOf(true));
        S3FileTransferResultsDto results = this.s3Service.uploadDirectory(s3FileTransferRequestParamsDto);
        Assert.assertTrue((results.getTotalFilesTransferred() == (long)LOCAL_FILES.size() ? 1 : 0) != 0);
        ArrayList<String> expectedKeys = new ArrayList<String>();
        for (String file : LOCAL_FILES) {
            expectedKeys.add(TEST_S3_KEY_PREFIX + "/" + file.replaceAll("\\\\", "/"));
        }
        this.s3DaoTestHelper.validateS3FileUpload(s3FileTransferRequestParamsDto, expectedKeys);
    }

    @Test
    public void testDeleteDirectory() throws Exception {
        this.testUploadDirectory();
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3KeyPrefix(TEST_S3_KEY_PREFIX + "/");
        this.s3Service.deleteDirectory(s3FileTransferRequestParamsDto);
        Assert.assertEquals((long)0L, (long)this.s3Service.listDirectory(s3FileTransferRequestParamsDto).size());
    }

    @Test
    public void testDeleteDirectoryIgnoreException() throws Exception {
        this.testUploadDirectory();
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3KeyPrefix(TEST_S3_KEY_PREFIX + "/");
        this.s3Service.deleteDirectoryIgnoreException(s3FileTransferRequestParamsDto);
        Assert.assertEquals((long)0L, (long)this.s3Service.listDirectory(s3FileTransferRequestParamsDto).size());
    }

    @Test
    public void testDeleteDirectoryIgnoreExceptionWithException() throws Exception {
        final S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3BucketName("INVALID_BUCKET_NAME");
        this.executeWithoutLogging(S3ServiceImpl.class, new Command(){

            public void execute() throws Exception {
                S3ServiceTest.this.s3Service.deleteDirectoryIgnoreException(s3FileTransferRequestParamsDto);
            }
        });
    }

    @Test
    public void testDownloadFile() throws IOException, InterruptedException {
        this.testUploadFile();
        FileUtils.deleteDirectory((File)this.localTempPath.toFile());
        Assert.assertTrue((boolean)this.localTempPath.toFile().mkdir());
        File destinationLocalFile = Paths.get(this.localTempPath.toString(), "foo.dat").toFile();
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3KeyPrefix(TARGET_S3_KEY);
        s3FileTransferRequestParamsDto.setLocalPath(destinationLocalFile.getPath());
        S3FileTransferResultsDto results = this.s3Service.downloadFile(s3FileTransferRequestParamsDto);
        Assert.assertTrue((results.getTotalFilesTransferred() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)destinationLocalFile.isFile());
    }

    @Test
    public void testDownloadDirectory() throws IOException, InterruptedException {
        this.testUploadDirectory();
        FileUtils.deleteDirectory((File)this.localTempPath.toFile());
        Assert.assertTrue((boolean)this.localTempPath.toFile().mkdir());
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setS3KeyPrefix(TEST_S3_KEY_PREFIX);
        s3FileTransferRequestParamsDto.setLocalPath(this.localTempPath.toString());
        s3FileTransferRequestParamsDto.setRecursive(Boolean.valueOf(true));
        S3FileTransferResultsDto results = this.s3Service.downloadDirectory(s3FileTransferRequestParamsDto);
        Assert.assertTrue((results.getTotalFilesTransferred() == (long)LOCAL_FILES.size() ? 1 : 0) != 0);
        for (String file : LOCAL_FILES) {
            Assert.assertTrue((boolean)Paths.get(this.localTempPath.toString(), TEST_S3_KEY_PREFIX, file).toFile().isFile());
        }
    }
}

