/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.AttributeDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.JmsMessage;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.SqsNotificationEventServiceImpl;
import org.junit.Assert;
import org.junit.Test;

public class SqsNotificationEventServiceTest
extends AbstractServiceTest {
    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEvent() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        JmsMessage jmsMessage = this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessage(jmsMessage.getMessageText(), businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", Arrays.asList(new Attribute("Attribute Name 3", "Attribute Value 3")));
    }

    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEventNoOldStatus() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        JmsMessage jmsMessage = this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", null);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessage(jmsMessage.getMessageText(), businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", null, NO_ATTRIBUTES);
    }

    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEventNoBusinessObjectDataAttributeDefinitions() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        JmsMessage jmsMessage = this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessage(jmsMessage.getMessageText(), businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", NO_ATTRIBUTES);
    }

    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEventNoBusinessObjectDataAttributes() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        JmsMessage jmsMessage = this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessage(jmsMessage.getMessageText(), businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", NO_ATTRIBUTES);
    }

    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEventAttributeDefinitionCaseInsensitivity() throws Exception {
        List<AttributeDefinition> testAttributeDefinitions = Arrays.asList(new AttributeDefinition("Attribute Name 1".toUpperCase(), PUBLISH_ATTRIBUTE), new AttributeDefinition("Attribute Name 2".toLowerCase(), PUBLISH_ATTRIBUTE));
        List<Attribute> testAttributes = Arrays.asList(new Attribute("Attribute Name 1", "Attribute Name 1"), new Attribute("Attribute Name 2", "Attribute Name 2"));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, testAttributeDefinitions, testAttributes);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        JmsMessage jmsMessage = this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessage(jmsMessage.getMessageText(), businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", testAttributes);
    }

    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEventBusinessObjectDataAttributeNullValue() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, Arrays.asList(new AttributeDefinition("Attribute Name 1", PUBLISH_ATTRIBUTE)), Arrays.asList(new Attribute("Attribute Name 1", null)));
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        JmsMessage jmsMessage = this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessage(jmsMessage.getMessageText(), businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", Arrays.asList(new Attribute("Attribute Name 1", null)));
    }

    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEventBusinessObjectDataAttributeSpecialValues() throws Exception {
        List<Attribute> testAttributes = Arrays.asList(new Attribute("Attribute Name 1", "      \t\t "), new Attribute("Attribute Name 2", ""));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, Arrays.asList(new AttributeDefinition("Attribute Name 1", PUBLISH_ATTRIBUTE), new AttributeDefinition("Attribute Name 2", PUBLISH_ATTRIBUTE)), testAttributes);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        JmsMessage jmsMessage = this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessage(jmsMessage.getMessageText(), businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", testAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEventHerdSqsNotificationNotEnabled() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        HashMap<String, Boolean> overrideMap = new HashMap<String, Boolean>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_ENABLED.getKey(), false);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertNull((Object)this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "UPLOADING"));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSqsBusinessObjectDataStatusChangeNotificationEventSqsQueueNotDefined() throws Exception {
        this.setLogLevel(SqsNotificationEventServiceImpl.class, LogLevel.OFF);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_OUTGOING_QUEUE_NAME.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.sqsNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "UPLOADING");
            Assert.fail((String)"Suppose to throw IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)String.format("SQS queue name not found. Ensure the \"%s\" configuration entry is configured.", ConfigurationValue.HERD_NOTIFICATION_SQS_OUTGOING_QUEUE_NAME.getKey()), (Object)ex.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessSystemMonitorNotificationEvent() throws Exception {
        JmsMessage jmsMessage = this.sqsNotificationEventService.processSystemMonitorNotificationEvent(this.getTestSystemMonitorIncomingMessage());
        Assert.assertNotNull((Object)jmsMessage);
        Assert.assertNotNull((Object)jmsMessage.getMessageText());
        this.validateSystemMonitorResponse(jmsMessage.getMessageText());
    }

    @Test
    public void testProcessSystemMonitorNotificationEventHerdSqsNotificationNotEnabled() throws Exception {
        HashMap<String, Boolean> overrideMap = new HashMap<String, Boolean>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_ENABLED.getKey(), false);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertNull((Object)this.sqsNotificationEventService.processSystemMonitorNotificationEvent(this.getTestSystemMonitorIncomingMessage()));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessSystemMonitorNotificationEventSqsQueueNotDefined() throws Exception {
        this.setLogLevel(SqsNotificationEventServiceImpl.class, LogLevel.OFF);
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_OUTGOING_QUEUE_NAME.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.sqsNotificationEventService.processSystemMonitorNotificationEvent(this.getTestSystemMonitorIncomingMessage());
            Assert.fail((String)"Suppose to throw IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)String.format("SQS queue name not found. Ensure the \"%s\" configuration entry is configured.", ConfigurationValue.HERD_NOTIFICATION_SQS_OUTGOING_QUEUE_NAME.getKey()), (Object)ex.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessSystemMonitorNotificationEventNoMessageReturned() throws Exception {
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertNull((Object)this.sqsNotificationEventService.processSystemMonitorNotificationEvent(this.getTestSystemMonitorIncomingMessage()));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }
}

