/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.StoragePolicySelection;
import org.finra.herd.model.dto.StoragePolicyTransitionParamsDto;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.StoragePolicyProcessorHelperService;
import org.finra.herd.service.impl.StoragePolicyProcessorHelperServiceImpl;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class StoragePolicyProcessorHelperServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="storagePolicyProcessorHelperServiceImpl")
    private StoragePolicyProcessorHelperService storagePolicyProcessorHelperServiceImpl;

    @Test
    public void testInitiateStoragePolicyTransition() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        String expectedS3KeyPrefix = StoragePolicyProcessorHelperServiceTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, expectedS3KeyPrefix + "/" + "foo.dat", Long.valueOf(1024L), Long.valueOf(1000L));
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
    }

    @Test
    public void testInitiateStoragePolicyTransitionDestinationStorageUnitDisabled() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        String expectedS3KeyPrefix = StoragePolicyProcessorHelperServiceTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, expectedS3KeyPrefix + "/" + "foo.dat", Long.valueOf(1024L), Long.valueOf(1000L));
        StorageUnitEntity destinationStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDao.getStorageByName(STORAGE_NAME_2), sourceStorageUnitEntity.getBusinessObjectData(), "DISABLED", NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
        Assert.assertEquals((Object)"ARCHIVING", (Object)destinationStorageUnitEntity.getStatus().getCode());
    }

    @Test
    public void testInitiateStoragePolicyTransitionInvalidParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(null);
            Assert.fail((String)"Should throw an IllegalArgumentException when when storage policy selection message is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy selection must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(null, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when when business object data key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data key must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(new BusinessObjectDataKey(NO_BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when when business object definition namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, null, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when when storage policy key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy key must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, new StoragePolicyKey(null, STORAGE_POLICY_NAME), INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when when storage policy namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, null), INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when when storage policy name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), null));
            Assert.fail((String)"Should throw an IllegalArgumentException when when storage policy version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy version must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionBusinessObjectDataNoExists() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionBusinessObjectDataStatusNotSupported() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data status is not supported by the storage policy feature.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data status \"%s\" is not supported by the storage policy feature. Business object data: {%s}", BDATA_STATUS, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionStoragePolicyNoExists() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when storage policy does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy with name \"%s\" and version \"%d\" does not exist for \"%s\" namespace.", storagePolicyKey.getStoragePolicyName(), INITIAL_VERSION, storagePolicyKey.getNamespace()), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionStoragePolicyFilterStorageInvalidStoragePlatform() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, STORAGE_PLATFORM_CODE);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when using non-S3 storage platform for storage policy filter storage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage platform for storage policy filter storage with name \"%s\" is not \"%s\". Storage policy: {%s}", STORAGE_NAME, "S3", this.storagePolicyServiceTestHelper.getExpectedStoragePolicyKeyAndVersionAsString(storagePolicyKey, INITIAL_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionStoragePolicyFilterStoragePathPrefixValidationNotEnabled() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.TRUE.toString()));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.FALSE.toString()));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", attributes);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 path prefix validation enabled.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Path prefix validation must be enabled on \"%s\" storage. Storage policy: {%s}", STORAGE_NAME, this.storagePolicyServiceTestHelper.getExpectedStoragePolicyKeyAndVersionAsString(storagePolicyKey, INITIAL_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionStoragePolicyFilterStorageFileExistenceValidationNotEnabled() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.FALSE.toString()));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.TRUE.toString()));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", attributes);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 file existence validation enabled.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("File existence validation must be enabled on \"%s\" storage. Storage policy: {%s}", STORAGE_NAME, this.storagePolicyServiceTestHelper.getExpectedStoragePolicyKeyAndVersionAsString(storagePolicyKey, INITIAL_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionStoragePolicyFilterStorageBucketNameNotConfigured() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.TRUE.toString()));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.TRUE.toString()));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", attributes);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 bucket name attribute configured.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionDestinationStorageInvalidStoragePlatform() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when using non-GLACIER storage platform for storage policy transition destination storage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage platform for storage policy transition destination storage with name \"%s\" is not \"%s\". Storage policy: {%s}", STORAGE_NAME, "GLACIER", this.storagePolicyServiceTestHelper.getExpectedStoragePolicyKeyAndVersionAsString(storagePolicyKey, INITIAL_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionDestinationStorageVaultNameNotConfigured() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), new ArrayList<String>());
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "GLACIER");
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalStateException when storage policy transition destination storage has no Glacier vault name attribute configured.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), STORAGE_NAME_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionSourceStorageUnitNoExists() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when source storage unit does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"%s\" storage for the business object data {%s}.", STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionSourceStorageUnitNotEnabled() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when source storage unit does not have ENABLED status.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Source storage unit status is \"%s\", but must be \"%s\" for storage policy transition to proceed. Storage: {%s}, business object data: {%s}", STORAGE_UNIT_STATUS, "ENABLED", STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionDestinationStorageUnitNotDisabled() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDao.getStorageByName(STORAGE_NAME_2), sourceStorageUnitEntity.getBusinessObjectData(), STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an AlreadyExistsException when destination storage unit exists and does not have DISABLED status.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Destination storage unit already exists and has \"%s\" status. Storage: {%s}, business object data: {%s}", STORAGE_UNIT_STATUS, STORAGE_NAME_2, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionDestinationStorageFileExist() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        StorageUnitEntity destinationStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDao.getStorageByName(STORAGE_NAME_2), sourceStorageUnitEntity.getBusinessObjectData(), "DISABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(destinationStorageUnitEntity, FILE_NAME, FILE_SIZE, ROW_COUNT);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalStateException when destination storage unit contains any storage files.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Destination storage unit already exists and has 1 storage file(s), but must have no storage files. Storage: {%s}, business object data: {%s}", STORAGE_NAME_2, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionSubpartitionValuesWithoutFormatSchema() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when sub-partition values are used and format has no schema.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Schema must be defined when using subpartition values for business object format {%s}.", this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatKeyAsString(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionStorageFilesNoExists() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when source storage unit has no storage files registered.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no storage files registered in \"%s\" storage. Business object data: {%s}", STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitiateStoragePolicyTransitionStorageFilesSizeGreaterThanThreshold() throws Exception {
        HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
        overrideMap.put(ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_SIZE_THRESHOLD_GB.getKey(), 0);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
            BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
            StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
            String expectedS3KeyPrefix = StoragePolicyProcessorHelperServiceTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
            this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, expectedS3KeyPrefix + "/" + "foo.dat", Long.valueOf(1024L), Long.valueOf(1000L));
            StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
            this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
            try {
                this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
                Assert.fail((String)"Should throw an IllegalArgumentException when source storage unit has no storage files registered.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)String.format("Total size of storage files (%d bytes) for business object data in \"%s\" storage is greater than the configured threshold of 0 GB (0 bytes) as per \"%s\" configuration entry. Business object data: {%s}", 1024L, STORAGE_NAME, ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_SIZE_THRESHOLD_GB.getKey(), this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
            }
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionStorageFileDoesNotMatchS3KeyPrefix() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        String expectedS3KeyPrefix = StoragePolicyProcessorHelperServiceTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        StorageFileEntity storageFileEntity = this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, STORAGE_DIRECTORY_PATH + "/" + "foo.dat", Long.valueOf(1024L), Long.valueOf(1000L));
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when source storage unit has a storage file that is not matching the expected S3 key prefix.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage file \"%s\" registered with business object data {%s} in \"%s\" storage does not match the expected S3 key prefix \"%s\".", storageFileEntity.getPath(), this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey), STORAGE_NAME, expectedS3KeyPrefix), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateStoragePolicyTransitionOtherBusinessObjectDataHasStorageFilesMatchingS3KeyPrefix() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        List<BusinessObjectDataKey> businessObjectDataKeys = Arrays.asList(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataKey(BDEF_NAMESPACE_2, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION));
        List<StorageUnitEntity> sourceStorageUnitEntities = Arrays.asList(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKeys.get(0), LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH), this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKeys.get(1), LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH));
        String expectedS3KeyPrefix = StoragePolicyProcessorHelperServiceTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        List<StorageFileEntity> storageFileEntities = Arrays.asList(this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntities.get(0), expectedS3KeyPrefix + "/" + (String)LOCAL_FILES.get(0), Long.valueOf(1024L), Long.valueOf(1000L)), this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntities.get(1), expectedS3KeyPrefix + "/" + (String)LOCAL_FILES.get(1), Long.valueOf(1024L), Long.valueOf(1000L)));
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyProcessorHelperService.initiateStoragePolicyTransition(new StoragePolicySelection(businessObjectDataKeys.get(0), storagePolicyKey, INITIAL_VERSION));
            Assert.fail((String)"Should throw an IllegalStateException when source storage has other business object data storage files matching the expected S3 key prefix.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Found %d registered storage file(s) matching business object data S3 key prefix in the storage that is not equal to the number of storage files (%d) registered with the business object data in that storage. Storage: {%s}, s3KeyPrefix {%s}, business object data: {%s}", storageFileEntities.size(), 1, STORAGE_NAME, expectedS3KeyPrefix, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKeys.get(0))), (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteStoragePolicyTransition() {
        this.runExecuteStoragePolicyTransitionTest();
    }

    @Test
    public void testExecuteStoragePolicyTransitionWithInfoLoggingEnabled() {
        LogLevel origLogLevel = this.getLogLevel(StoragePolicyProcessorHelperServiceImpl.class);
        this.setLogLevel(StoragePolicyProcessorHelperServiceImpl.class, LogLevel.INFO);
        try {
            this.runExecuteStoragePolicyTransitionTest();
        }
        finally {
            this.setLogLevel(StoragePolicyProcessorHelperServiceImpl.class, origLogLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExecuteStoragePolicyTransitionTest() {
        S3FileTransferRequestParamsDto sourceS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto destinationS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_2).s3KeyPrefix(S3_BUCKET_NAME + "/" + TEST_S3_KEY_PREFIX + "/").build();
        ArrayList<StorageFile> sourceStorageFiles = new ArrayList<StorageFile>();
        for (String file : LOCAL_FILES) {
            sourceStorageFiles.add(new StorageFile(String.format(String.format("%s/%s", TEST_S3_KEY_PREFIX, file), new Object[0]), Long.valueOf(1024L), ROW_COUNT));
        }
        try {
            for (StorageFile storageFile : sourceStorageFiles) {
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFile.getFilePath(), (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
            }
            this.storagePolicyProcessorHelperService.executeStoragePolicyTransition(new StoragePolicyTransitionParamsDto(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, sourceStorageFiles, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS));
            Assert.assertEquals((long)sourceStorageFiles.size(), (long)this.s3Dao.listDirectory(sourceS3FileTransferRequestParamsDto).size());
            Assert.assertEquals((long)sourceStorageFiles.size(), (long)this.s3Dao.listDirectory(destinationS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteStoragePolicyTransitionArchiveBucketPrefixNotEmpty() {
        S3FileTransferRequestParamsDto sourceS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto destinationS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_2).s3KeyPrefix(S3_BUCKET_NAME + "/" + TEST_S3_KEY_PREFIX + "/").build();
        List<StorageFile> sourceStorageFiles = Arrays.asList(new StorageFile(String.format(String.format("%s/%s", TEST_S3_KEY_PREFIX, "foo.dat"), new Object[0]), Long.valueOf(1024L), ROW_COUNT));
        this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, sourceStorageFiles.get(0).getFilePath(), (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
        try {
            this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME_2, S3_BUCKET_NAME + "/" + sourceStorageFiles.get(0).getFilePath(), (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
            this.storagePolicyProcessorHelperService.executeStoragePolicyTransition(new StoragePolicyTransitionParamsDto(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, sourceStorageFiles, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS));
            Assert.fail((String)"Should throw an IllegalStateException when destination S3 key prefix is not empty.");
        }
        catch (IllegalStateException e) {
            try {
                Assert.assertEquals((Object)String.format("The destination S3 key prefix is not empty. S3 bucket name: {%s}, S3 key prefix: {%s/%s/}", S3_BUCKET_NAME_2, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX), (Object)e.getMessage());
                Assert.assertEquals((long)sourceStorageFiles.size(), (long)this.s3Dao.listDirectory(sourceS3FileTransferRequestParamsDto).size());
                Assert.assertEquals((long)1L, (long)this.s3Dao.listDirectory(destinationS3FileTransferRequestParamsDto).size());
            }
            catch (Throwable throwable) {
                for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
                    if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                    this.s3Dao.deleteDirectory(params);
                }
                this.s3Operations.rollback();
                throw throwable;
            }
            for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteStoragePolicyTransitionS3CopyFails() {
        S3FileTransferRequestParamsDto sourceS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME).s3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build();
        S3FileTransferRequestParamsDto destinationS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_2).s3KeyPrefix(S3_BUCKET_NAME + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<StorageFile> sourceStorageFiles = Arrays.asList(new StorageFile(String.format(String.format("%s/%s", TEST_S3_KEY_PREFIX, "mock_s3_file_name_service_exception"), new Object[0]), Long.valueOf(1024L), ROW_COUNT));
        try {
            this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, sourceStorageFiles.get(0).getFilePath(), (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
            this.storagePolicyProcessorHelperService.executeStoragePolicyTransition(new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, sourceStorageFiles, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS));
            Assert.fail((String)"Should throw an IllegalStateException when an S3 file copy fails.");
        }
        catch (IllegalStateException e) {
            try {
                Assert.assertEquals((Object)String.format("Failed to copy S3 file. Source storage: {%s}, source S3 bucket name: {%s}, source S3 object key: {%s}, target storage: {%s}, target S3 bucket name: {%s}, target S3 object key: {%s/%s/%s}, business object data: {%s}", STORAGE_NAME, S3_BUCKET_NAME, sourceStorageFiles.get(0).getFilePath(), STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, "mock_s3_file_name_service_exception", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
                Assert.assertEquals((long)sourceStorageFiles.size(), (long)this.s3Dao.listDirectory(sourceS3FileTransferRequestParamsDto).size());
                Assert.assertTrue((boolean)this.s3Dao.listDirectory(destinationS3FileTransferRequestParamsDto).isEmpty());
            }
            catch (Throwable throwable) {
                for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
                    if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                    this.s3Dao.deleteDirectory(params);
                }
                this.s3Operations.rollback();
                throw throwable;
            }
            for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    @Test
    public void testCompleteStoragePolicyTransition() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        StorageUnitEntity destinationStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDao.getStorageByName(STORAGE_NAME_2), sourceStorageUnitEntity.getBusinessObjectData(), "ARCHIVING", NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, NO_STORAGE_FILES, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS);
        this.storagePolicyProcessorHelperService.completeStoragePolicyTransition(storagePolicyTransitionParamsDto);
        Assert.assertEquals((Object)"DISABLED", (Object)sourceStorageUnitEntity.getStatus().getCode());
        Assert.assertEquals((Object)"ENABLED", (Object)destinationStorageUnitEntity.getStatus().getCode());
        Assert.assertEquals((long)0L, (long)destinationStorageUnitEntity.getStorageFiles().size());
    }

    @Test
    public void testCompleteStoragePolicyTransitionBusinessObjectDataNoExists() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, NO_STORAGE_FILES, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS);
        try {
            this.storagePolicyProcessorHelperService.completeStoragePolicyTransition(storagePolicyTransitionParamsDto);
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testCompleteStoragePolicyTransitionBusinessObjectDataStatusNotSupported() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, NO_STORAGE_FILES, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS);
        try {
            this.storagePolicyProcessorHelperService.completeStoragePolicyTransition(storagePolicyTransitionParamsDto);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data status is not supported by the storage policy feature.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data status \"%s\" is not supported by the storage policy feature. Business object data: {%s}", BDATA_STATUS, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCompleteStoragePolicyTransitionSourceStorageUnitNoExists() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, NO_STORAGE_FILES, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS);
        try {
            this.storagePolicyProcessorHelperService.completeStoragePolicyTransition(storagePolicyTransitionParamsDto);
            Assert.fail((String)"Should throw an ObjectNotFoundException when source storage unit does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"%s\" storage for the business object data {%s}.", STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCompleteStoragePolicyTransitionSourceStorageUnitNotEnabled() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, NO_STORAGE_FILES, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS);
        try {
            this.storagePolicyProcessorHelperService.completeStoragePolicyTransition(storagePolicyTransitionParamsDto);
            Assert.fail((String)"Should throw an IllegalArgumentException when source storage unit does not have ENABLED status.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Source storage unit status is \"%s\", but must be \"%s\" for storage policy transition to proceed. Storage: {%s}, business object data: {%s}", STORAGE_UNIT_STATUS, "ENABLED", STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCompleteStoragePolicyTransitionDestinationStorageUnitNoExists() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, NO_STORAGE_FILES, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS);
        try {
            this.storagePolicyProcessorHelperService.completeStoragePolicyTransition(storagePolicyTransitionParamsDto);
            Assert.fail((String)"Should throw an IllegalArgumentException when destination storage unit does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"%s\" storage for the business object data {%s}.", STORAGE_NAME_2, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCompleteStoragePolicyTransitionDestinationStorageUnitNotInArchivingState() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDao.getStorageByName(STORAGE_NAME_2), sourceStorageUnitEntity.getBusinessObjectData(), STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, NO_STORAGE_FILES, STORAGE_NAME_2, S3_BUCKET_NAME_2, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS);
        try {
            this.storagePolicyProcessorHelperService.completeStoragePolicyTransition(storagePolicyTransitionParamsDto);
            Assert.fail((String)"Should throw an IllegalArgumentException when destination storage unit does not have ARCHIVING status.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Destination storage unit status is \"%s\", but must be \"%s\" for storage policy transition to proceed. Storage: {%s}, business object data: {%s}", STORAGE_UNIT_STATUS, "ARCHIVING", STORAGE_NAME_2, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testStoragePolicyProcessorHelperServiceMethodsNewTx() {
        try {
            this.storagePolicyProcessorHelperServiceImpl.initiateStoragePolicyTransition(null);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy selection must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperServiceImpl.executeStoragePolicyTransition(null);
            Assert.fail((String)"Should throw an NullPointerException.");
        }
        catch (NullPointerException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperServiceImpl.completeStoragePolicyTransition(null);
            Assert.fail((String)"Should throw an NullPointerException.");
        }
        catch (NullPointerException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        try {
            this.storagePolicyProcessorHelperServiceImpl.executeStoragePolicyTransitionAfterStep(null);
            Assert.fail((String)"Should throw an NullPointerException.");
        }
        catch (NullPointerException e) {
            Assert.assertNull((Object)e.getMessage());
        }
    }
}

