/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.dto.StoragePolicySelection;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class StoragePolicySelectorServiceTest
extends AbstractServiceTest {
    @Test
    public void testExecute() throws Exception {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        List resultStoragePolicySelections = this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue());
        Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)resultStoragePolicySelections);
    }

    @Test
    public void testExecuteWithInvalidSqsQueueName() throws Exception {
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        try {
            this.storagePolicySelectorService.execute("mock_sqs_queue_not_found_name", MAX_RESULT.intValue());
            Assert.fail((String)"Should throw an IllegalStateException when invalid SQS queue name is specified.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("AWS SQS queue with \"%s\" name not found.", "mock_sqs_queue_not_found_name"), (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteWithInvalidStoragePolicyRuleType() throws Exception {
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), STORAGE_POLICY_RULE_TYPE, BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        try {
            this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue());
            Assert.fail((String)"Should throw an IllegalStateException when a storage policy has an invalid storage policy rule type.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Storage policy type \"%s\" is not supported.", STORAGE_POLICY_RULE_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteBusinessObjectDataNotOldEnough() {
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), -2L);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
    }

    @Test
    public void testExecuteBusinessObjectDataNotSelectedDueToHigherPriorityLevelStoragePolicy() {
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD_2, STORAGE_POLICY_NAME_2), "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, NO_BDEF_NAMESPACE, NO_BDEF_NAME, NO_FORMAT_USAGE_CODE, NO_FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataEntity businessObjectDataEntity = storageUnitEntity.getBusinessObjectData();
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(businessObjectDataEntity, (long)(BDATA_AGE_IN_DAYS + 1));
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD_2, STORAGE_POLICY_NAME), "DAYS_SINCE_BDATA_REGISTERED", Integer.valueOf(BDATA_AGE_IN_DAYS + 2), NO_BDEF_NAMESPACE, NO_BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(businessObjectDataEntity, 2L);
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME_2), "DAYS_SINCE_BDATA_REGISTERED", Integer.valueOf(BDATA_AGE_IN_DAYS + 4), BDEF_NAMESPACE, BDEF_NAME, NO_FORMAT_USAGE_CODE, NO_FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(businessObjectDataEntity, 2L);
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), "DAYS_SINCE_BDATA_REGISTERED", Integer.valueOf(BDATA_AGE_IN_DAYS + 6), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(businessObjectDataEntity, 2L);
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, MAX_RESULT.intValue()).size());
    }

    @Test
    public void testExecuteTestingMaxResult() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity1 = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity1.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        StorageUnitEntity storageUnitEntity2 = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity2.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 2));
        List resultStoragePolicySelections = this.storagePolicySelectorService.execute(SQS_QUEUE_NAME, 1);
        Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)resultStoragePolicySelections);
    }
}

