/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import javax.persistence.PersistenceException;
import org.finra.herd.core.Command;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.api.xml.StorageCreateRequest;
import org.finra.herd.model.api.xml.StorageKey;
import org.finra.herd.model.api.xml.StorageKeys;
import org.finra.herd.model.api.xml.StorageUpdateRequest;
import org.finra.herd.model.dto.StorageAlternateKeyDto;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class StorageServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateStorage() throws Exception {
        StorageCreateRequest storageCreateRequest = this.getNewStorageCreateRequest();
        Storage storage = this.storageService.createStorage(storageCreateRequest);
        Assert.assertNotNull((Object)storage);
        Assert.assertTrue((boolean)storage.getName().equals(storageCreateRequest.getName()));
        this.businessObjectDefinitionServiceTestHelper.validateAttributes(storageCreateRequest.getAttributes(), storage.getAttributes());
    }

    @Test
    public void testCreateStorageMissingOptionalParameters() throws Exception {
        StorageCreateRequest request = this.getNewStorageCreateRequest();
        request.setAttributes(null);
        Storage storage = this.storageService.createStorage(request);
        Assert.assertNotNull((Object)storage);
        Assert.assertTrue((boolean)storage.getName().equals(request.getName()));
        Assert.assertTrue((boolean)storage.getAttributes().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateStorageNoName() throws Exception {
        StorageCreateRequest storageCreateRequest = this.getNewStorageCreateRequest();
        storageCreateRequest.setName(null);
        this.storageService.createStorage(storageCreateRequest);
    }

    @Test
    public void testCreateStorageInvalidParameters() {
        try {
            this.storageService.createStorage(new StorageCreateRequest(STORAGE_NAME, this.addSlash(STORAGE_PLATFORM_CODE), NO_ATTRIBUTES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage platform name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage platform name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.storageService.createStorage(new StorageCreateRequest(this.addSlash(DATA_PROVIDER_NAME), STORAGE_PLATFORM_CODE, NO_ATTRIBUTES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test(expected=AlreadyExistsException.class)
    public void testCreateStorageAlreadyExists() throws Exception {
        StorageCreateRequest storageCreateRequest = this.getNewStorageCreateRequest();
        this.storageService.createStorage(storageCreateRequest);
        this.storageService.createStorage(storageCreateRequest);
    }

    @Test
    public void testUpdateStorage() throws Exception {
        StorageCreateRequest storageCreateRequest = this.getNewStorageCreateRequest();
        this.storageService.createStorage(storageCreateRequest);
        StorageUpdateRequest storageUpdateRequest = new StorageUpdateRequest();
        StorageAlternateKeyDto alternateKey = StorageAlternateKeyDto.builder().storageName(storageCreateRequest.getName()).build();
        this.storageService.updateStorage(alternateKey, storageUpdateRequest);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testUpdateStorageNoExists() throws Exception {
        StorageCreateRequest storageCreateRequest = this.getNewStorageCreateRequest();
        StorageAlternateKeyDto alternateKey = StorageAlternateKeyDto.builder().storageName(storageCreateRequest.getName()).build();
        this.storageService.updateStorage(alternateKey, new StorageUpdateRequest());
    }

    @Test
    public void testGetStorage() throws Exception {
        StorageCreateRequest storageCreateRequest = this.getNewStorageCreateRequest();
        String name = storageCreateRequest.getName();
        Storage storage = this.storageService.createStorage(storageCreateRequest);
        StorageAlternateKeyDto alternateKey = StorageAlternateKeyDto.builder().storageName(storage.getName()).build();
        storage = this.storageService.getStorage(alternateKey);
        Assert.assertNotNull((Object)storage);
        Assert.assertTrue((boolean)storage.getName().equals(name));
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testGetStorageInvalidName() throws Exception {
        StorageAlternateKeyDto alternateKey = StorageAlternateKeyDto.builder().storageName("invalid" + StorageServiceTest.getRandomSuffix()).build();
        this.storageService.getStorage(alternateKey);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testDeleteStorage() throws Exception {
        StorageCreateRequest storageCreateRequest = this.getNewStorageCreateRequest();
        String name = storageCreateRequest.getName();
        Storage storage = this.storageService.createStorage(storageCreateRequest);
        StorageAlternateKeyDto alternateKey = StorageAlternateKeyDto.builder().storageName(storage.getName()).build();
        storage = this.storageService.deleteStorage(alternateKey);
        Assert.assertNotNull((Object)storage);
        Assert.assertTrue((boolean)storage.getName().equals(name));
        this.storageService.getStorage(alternateKey);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testDeleteStorageInvalidName() throws Exception {
        StorageAlternateKeyDto alternateKey = StorageAlternateKeyDto.builder().storageName(this.getNewStorageCreateRequest().getName()).build();
        this.storageService.deleteStorage(alternateKey);
    }

    @Ignore
    @Test(expected=PersistenceException.class)
    public void testDeleteStorageConstraintViolation() throws Exception {
        final StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, BDATA_STATUS, STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        this.executeWithoutLogging(SqlExceptionHelper.class, new Command(){

            public void execute() {
                StorageAlternateKeyDto alternateKey = StorageAlternateKeyDto.builder().storageName(storageUnitEntity.getStorage().getName()).build();
                StorageServiceTest.this.storageService.deleteStorage(alternateKey);
            }
        });
    }

    @Test
    public void testGetStorages() throws Exception {
        for (StorageKey key : this.storageDaoTestHelper.getTestStorageKeys()) {
            this.storageDaoTestHelper.createStorageEntity(key.getStorageName());
        }
        StorageKeys resultStorageKeys = this.storageService.getStorages();
        Assert.assertNotNull((Object)resultStorageKeys);
        Assert.assertTrue((boolean)resultStorageKeys.getStorageKeys().containsAll(this.storageDaoTestHelper.getTestStorageKeys()));
    }

    private StorageCreateRequest getNewStorageCreateRequest() {
        String name = "StorageTest" + StorageServiceTest.getRandomSuffix();
        StorageCreateRequest storageRequest = new StorageCreateRequest();
        storageRequest.setStoragePlatformName("S3");
        storageRequest.setName(name);
        storageRequest.setAttributes(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        return storageRequest;
    }
}

