/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Tag;
import org.finra.herd.model.api.xml.TagChild;
import org.finra.herd.model.api.xml.TagCreateRequest;
import org.finra.herd.model.api.xml.TagKey;
import org.finra.herd.model.api.xml.TagListResponse;
import org.finra.herd.model.api.xml.TagUpdateRequest;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.model.jpa.TagTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class TagServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateTag() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
        Assert.assertEquals((Object)new Tag(tag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, tag.getUserId(), tag.getUpdatedTime(), null), (Object)tag);
    }

    @Test
    public void testCreateTagOnlyRequiredParams() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, null, null));
        Assert.assertEquals((Object)new Tag(tag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, null, tag.getUserId(), tag.getUpdatedTime(), null), (Object)tag);
    }

    @Test
    public void testCreateTagMissingRequiredParams() {
        try {
            this.tagService.createTag(new TagCreateRequest(null, TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag key must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(null, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, null), TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), null, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A display name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagMissingOptionalParametersPassedAsWhitespace() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, "      \t\t ", null));
        Assert.assertEquals((Object)new Tag(tag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, "      \t\t ", tag.getUserId(), tag.getUpdatedTime(), null), (Object)tag);
    }

    @Test
    public void testCreateTagMissingOptionalParametersPassedAsNulls() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, null, null));
        Assert.assertEquals((Object)new Tag(tag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, null, tag.getUserId(), tag.getUpdatedTime(), null), (Object)tag);
    }

    @Test
    public void testCreateTagTrimParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)), this.addWhitespace(TAG_DISPLAY_NAME), this.addWhitespace(TAG_DESCRIPTION), null));
        Assert.assertEquals((Object)new Tag(tag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, this.addWhitespace(TAG_DESCRIPTION), tag.getUserId(), tag.getUpdatedTime(), null), (Object)tag);
    }

    @Test
    public void testCreateTagUpperCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        Tag resultTag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()), TAG_DISPLAY_NAME.toUpperCase(), TAG_DESCRIPTION.toUpperCase(), null));
        Assert.assertEquals((Object)new Tag(resultTag.getId(), new TagKey(TAG_TYPE, TAG_CODE.toUpperCase()), TAG_DISPLAY_NAME.toUpperCase(), TAG_DESCRIPTION.toUpperCase(), resultTag.getUserId(), resultTag.getUpdatedTime(), null), (Object)resultTag);
    }

    @Test
    public void testCreateTagLowerCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        Tag resultTag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()), TAG_DISPLAY_NAME.toLowerCase(), TAG_DESCRIPTION.toLowerCase(), null));
        Assert.assertEquals((Object)new Tag(resultTag.getId(), new TagKey(TAG_TYPE, TAG_CODE.toLowerCase()), TAG_DISPLAY_NAME.toLowerCase(), TAG_DESCRIPTION.toLowerCase(), resultTag.getUserId(), resultTag.getUpdatedTime(), null), (Object)resultTag);
    }

    @Test
    public void testCreateTagInvalidParameters() {
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(this.addSlash(TAG_TYPE), TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag type code can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, this.addSlash(TAG_CODE)), TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag code can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTagTypeNoExists() {
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTagCodeAlreadyExists() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE.toLowerCase()), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create tag with tag type code \"%s\" and tag code \"%s\" because it already exists.", TAG_TYPE, TAG_CODE.toLowerCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagDisplayNameAlreadyExists() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME.toLowerCase(), TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Display name \"%s\" already exists for a tag with tag type \"%s\" and tag code \"%s\".", TAG_DISPLAY_NAME.toLowerCase(), TAG_TYPE, TAG_CODE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTag() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag resultTag = this.tagService.getTag(new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertEquals((Object)new Tag(resultTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, resultTag.getUserId(), resultTag.getUpdatedTime(), null), (Object)resultTag);
    }

    @Test
    public void testGetTagMissingRequiredParameters() {
        try {
            this.tagService.getTag(new TagKey("      \t\t ", TAG_CODE));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.getTag(new TagKey(TAG_TYPE, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagTrimParameters() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag resultTag = this.tagService.getTag(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)));
        Assert.assertEquals((Object)new Tag(resultTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, resultTag.getUserId(), resultTag.getUpdatedTime(), null), (Object)resultTag);
    }

    @Test
    public void testGetTagUpperCaseParameters() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag resultTag = this.tagService.getTag(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()));
        Assert.assertEquals((Object)new Tag(resultTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, resultTag.getUserId(), resultTag.getUpdatedTime(), null), (Object)resultTag);
    }

    @Test
    public void testGetTagLowerCaseParameters() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag resultTag = this.tagService.getTag(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()));
        Assert.assertEquals((Object)new Tag(resultTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, resultTag.getUserId(), resultTag.getUpdatedTime(), null), (Object)resultTag);
    }

    @Test
    public void testGetTagTagNoExists() {
        try {
            this.tagService.getTag(new TagKey(TAG_TYPE, TAG_CODE));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTag() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, null));
        Assert.assertEquals((Object)new Tag(tagEntity.getId().intValue(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, updatedTag.getUserId(), updatedTag.getUpdatedTime(), null), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagMissingRequiredParameters() {
        try {
            this.tagService.updateTag(new TagKey("      \t\t ", TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, "      \t\t "), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest("      \t\t ", TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A display name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagTrimParameters() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)), new TagUpdateRequest(this.addWhitespace(TAG_DISPLAY_NAME_2), this.addWhitespace(TAG_DESCRIPTION_2), null));
        Assert.assertEquals((Object)new Tag(updatedTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME_2, this.addWhitespace(TAG_DESCRIPTION_2), updatedTag.getUserId(), updatedTag.getUpdatedTime(), null), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagUpperCaseParameters() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()), new TagUpdateRequest(TAG_DISPLAY_NAME_2.toUpperCase(), TAG_DESCRIPTION_2.toUpperCase(), null));
        Assert.assertEquals((Object)new Tag(updatedTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME_2.toUpperCase(), TAG_DESCRIPTION_2.toUpperCase(), updatedTag.getUserId(), updatedTag.getUpdatedTime(), null), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagLowerCaseParameters() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()), new TagUpdateRequest(TAG_DISPLAY_NAME_2.toLowerCase(), TAG_DESCRIPTION_2.toLowerCase(), null));
        Assert.assertEquals((Object)new Tag(updatedTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME_2.toLowerCase(), TAG_DESCRIPTION_2.toLowerCase(), updatedTag.getUserId(), updatedTag.getUpdatedTime(), null), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagTagNoExists() {
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagDisplayNameAlreadyExistsForThisTagType() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION);
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2.toLowerCase(), TAG_DESCRIPTION, null));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Display name \"%s\" already exists for a tag with tag type \"%s\" and tag code \"%s\".", TAG_DISPLAY_NAME_2.toLowerCase(), TAG_TYPE, TAG_CODE_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagDisplayNameAlreadyExistsForOtherTagType() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE_2, TAG_CODE_2, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, null));
        Assert.assertEquals((Object)new Tag(updatedTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, updatedTag.getUserId(), updatedTag.getUpdatedTime(), null), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagNoChangesToDisplayName() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_DESCRIPTION_2, null));
        Assert.assertEquals((Object)new Tag(updatedTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION_2, updatedTag.getUserId(), updatedTag.getUpdatedTime(), null), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagNoChangesToDisplayNameExceptForCase() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME.toLowerCase(), TAG_DESCRIPTION_2, null));
        Assert.assertEquals((Object)new Tag(updatedTag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME.toLowerCase(), TAG_DESCRIPTION_2, updatedTag.getUserId(), updatedTag.getUpdatedTime(), null), (Object)updatedTag);
    }

    @Test
    public void testDeleteTag() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Assert.assertNotNull((Object)this.tagDao.getTagByKey(tagKey));
        Tag deletedTag = this.tagService.deleteTag(new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertEquals((Object)new Tag(deletedTag.getId(), tagKey, TAG_DISPLAY_NAME, TAG_DESCRIPTION, deletedTag.getUserId(), deletedTag.getUpdatedTime(), null), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(tagKey));
    }

    @Test
    public void testDeleteTagMissingRequiredParameters() {
        try {
            this.tagService.deleteTag(new TagKey("      \t\t ", TAG_CODE));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.deleteTag(new TagKey(TAG_TYPE, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteTagTrimParameters() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Assert.assertNotNull((Object)this.tagDao.getTagByKey(tagKey));
        Tag deletedTag = this.tagService.deleteTag(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)));
        Assert.assertEquals((Object)new Tag(deletedTag.getId(), tagKey, TAG_DISPLAY_NAME, TAG_DESCRIPTION, deletedTag.getUserId(), deletedTag.getUpdatedTime(), null), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(tagKey));
    }

    @Test
    public void testDeleteTagUpperCaseParameters() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Assert.assertNotNull((Object)this.tagDao.getTagByKey(tagKey));
        Tag deletedTag = this.tagService.deleteTag(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()));
        Assert.assertEquals((Object)new Tag(deletedTag.getId(), tagKey, TAG_DISPLAY_NAME, TAG_DESCRIPTION, deletedTag.getUserId(), deletedTag.getUpdatedTime(), null), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(tagKey));
    }

    @Test
    public void testDeleteTagLowerCaseParameters() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Assert.assertNotNull((Object)this.tagDao.getTagByKey(tagKey));
        Tag deletedTag = this.tagService.deleteTag(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()));
        Assert.assertEquals((Object)new Tag(deletedTag.getId(), tagKey, TAG_DISPLAY_NAME, TAG_DESCRIPTION, deletedTag.getUserId(), deletedTag.getUpdatedTime(), null), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(tagKey));
    }

    @Test
    public void testDeleteTagTagNoExists() {
        try {
            this.tagService.deleteTag(new TagKey(TAG_TYPE, TAG_CODE));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTags() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_DESCRIPTION);
        TagListResponse resultTagKeys = this.tagService.getTags(TAG_TYPE, null);
        Assert.assertNotNull((Object)resultTagKeys);
    }

    @Test
    public void testGetTagsMissingRequiredParameters() {
        try {
            this.tagService.getTags("      \t\t ", null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagsTrimParameters() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        TagListResponse resultTagKeys = this.tagService.getTags(this.addWhitespace(TAG_TYPE), null);
        Assert.assertNotNull((Object)resultTagKeys);
        ArrayList<TagChild> tagChildren = new ArrayList<TagChild>();
        tagChildren.add(new TagChild(new TagKey(TAG_TYPE, TAG_CODE), false));
        tagChildren.add(new TagChild(new TagKey(TAG_TYPE, TAG_CODE_2), false));
        Assert.assertEquals(tagChildren, (Object)resultTagKeys.getTagChildren());
    }

    @Test
    public void testGetTagsUpperCaseParameters() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_DESCRIPTION);
        TagListResponse resultTagKeys = this.tagService.getTags(this.addWhitespace(TAG_TYPE), null);
        ArrayList<TagChild> tagChildren = new ArrayList<TagChild>();
        tagChildren.add(new TagChild(new TagKey(TAG_TYPE, TAG_CODE), false));
        tagChildren.add(new TagChild(new TagKey(TAG_TYPE, TAG_CODE_2), false));
        Assert.assertNotNull((Object)resultTagKeys);
        Assert.assertEquals(tagChildren, (Object)resultTagKeys.getTagChildren());
    }

    @Test
    public void testGetTagsLowerCaseParameters() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_DESCRIPTION);
        TagListResponse resultTagKeys = this.tagService.getTags(this.addWhitespace(TAG_TYPE), null);
        ArrayList<TagChild> tagChildren = new ArrayList<TagChild>();
        tagChildren.add(new TagChild(new TagKey(TAG_TYPE, TAG_CODE), false));
        tagChildren.add(new TagChild(new TagKey(TAG_TYPE, TAG_CODE_2), false));
        Assert.assertNotNull((Object)resultTagKeys);
        Assert.assertEquals(tagChildren, (Object)resultTagKeys.getTagChildren());
    }

    @Test
    public void testGetTagsTagTypeNoExists() {
        try {
            this.tagService.getTags(TAG_TYPE, null);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagsTagsNoExist() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        TagListResponse resultTagKeys = this.tagService.getTags(TAG_TYPE, null);
        Assert.assertNotNull((Object)resultTagKeys);
        Assert.assertEquals((long)0L, (long)resultTagKeys.getTagChildren().size());
    }

    @Test
    public void testCreateTagWithParent() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, null));
        Assert.assertEquals((Object)new Tag(tag.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, tag.getUserId(), tag.getUpdatedTime(), null), (Object)tag);
        Tag childTag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, new TagKey(TAG_TYPE, TAG_CODE)));
        Assert.assertEquals((Object)new Tag(childTag.getId(), new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, childTag.getUserId(), childTag.getUpdatedTime(), new TagKey(TAG_TYPE, TAG_CODE)), (Object)childTag);
    }

    @Test
    public void testCreateTagWithParentValidationError() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        TagKey parentTagKey = new TagKey();
        parentTagKey.setTagTypeCode(TAG_TYPE_2);
        parentTagKey.setTagCode("NOT Matter");
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, parentTagKey));
            Assert.fail((String)"should throw IllegalArgumentException, but it did not");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            parentTagKey.setTagTypeCode(TAG_TYPE);
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION, parentTagKey));
            Assert.fail((String)"should throw Object not found exception, but it did not");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateTagWithParent() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity tagEntity2 = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2, TAG_DISPLAY_NAME + "x", TAG_DESCRIPTION_2 + "x");
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, new TagKey(TAG_TYPE.toLowerCase() + " ", TAG_CODE_2.toLowerCase() + " ")));
        Assert.assertEquals((Object)new Tag(tagEntity.getId().intValue(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, updatedTag.getUserId(), updatedTag.getUpdatedTime(), new TagKey(TAG_TYPE, TAG_CODE_2)), (Object)updatedTag);
        updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, null));
        Assert.assertEquals((Object)new Tag(tagEntity.getId().intValue(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, updatedTag.getUserId(), updatedTag.getUpdatedTime(), null), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagWithParentValidationError() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE_2, TAG_CODE_2, TAG_DISPLAY_NAME + "x", TAG_DESCRIPTION_2 + "x");
        try {
            Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, new TagKey(TAG_TYPE_2, TAG_CODE_2)));
            Assert.fail((String)"Update should fail because parent type key is different");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateTagWithParentValidationError2() {
        TagEntity root = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE_2, TAG_CODE_2, TAG_DISPLAY_NAME + "x", TAG_DESCRIPTION_2 + "x", root);
        try {
            Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, new TagKey(TAG_TYPE_2, TAG_CODE_2)));
            Assert.fail((String)"Update should fail because parent type key is different");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateTagWithParentValidationErrorLooping() {
        TagEntity root = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity child = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2, TAG_DISPLAY_NAME + "x", TAG_DESCRIPTION_2 + "x", root);
        TagEntity grandChild = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2 + "y", TAG_DISPLAY_NAME_2 + "y", TAG_DESCRIPTION_2 + "y", child);
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, new TagKey(TAG_TYPE, TAG_CODE_2)));
            Assert.fail((String)"Update should fail, can not set itself as parent");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2, new TagKey(TAG_TYPE, TAG_CODE_2 + "y")));
            Assert.fail((String)"Update should fail, can not set itself as parent");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
    }

    @Test
    public void getTagsWithParent() {
        TagEntity root = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity child = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2, TAG_DISPLAY_NAME + "x", TAG_DESCRIPTION_2 + "x", root);
        TagEntity grandChild = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2 + "y", TAG_DISPLAY_NAME_2 + "y", TAG_DESCRIPTION_2 + "y", child);
        TagListResponse resultTagKeys = this.tagService.getTags(TAG_TYPE, null);
        Assert.assertNull((Object)resultTagKeys.getParentTagKey());
        Assert.assertNull((Object)resultTagKeys.getTagKey());
        Assert.assertEquals((long)resultTagKeys.getTagChildren().size(), (long)1L);
        resultTagKeys = this.tagService.getTags(TAG_TYPE, TAG_CODE);
        Assert.assertNull((Object)resultTagKeys.getParentTagKey());
        Assert.assertEquals((long)resultTagKeys.getTagChildren().size(), (long)1L);
        Assert.assertEquals((Object)resultTagKeys.getTagKey(), (Object)new TagKey(TAG_TYPE, TAG_CODE));
        resultTagKeys = this.tagService.getTags(TAG_TYPE, TAG_CODE.toLowerCase() + " ");
        Assert.assertNull((Object)resultTagKeys.getParentTagKey());
        Assert.assertEquals((long)resultTagKeys.getTagChildren().size(), (long)1L);
        Assert.assertEquals((Object)resultTagKeys.getTagKey(), (Object)new TagKey(TAG_TYPE, TAG_CODE));
        resultTagKeys = this.tagService.getTags(TAG_TYPE, TAG_CODE_2.toLowerCase() + " ");
        Assert.assertNotNull((Object)resultTagKeys.getParentTagKey());
        Assert.assertEquals((Object)resultTagKeys.getParentTagKey(), (Object)new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertEquals((long)resultTagKeys.getTagChildren().size(), (long)1L);
        Assert.assertEquals((Object)resultTagKeys.getTagKey(), (Object)new TagKey(TAG_TYPE, TAG_CODE_2));
    }
}

