/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.TagType;
import org.finra.herd.model.api.xml.TagTypeCreateRequest;
import org.finra.herd.model.api.xml.TagTypeKey;
import org.finra.herd.model.api.xml.TagTypeKeys;
import org.finra.herd.model.api.xml.TagTypeUpdateRequest;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class TagTypeServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateTagType() throws Exception {
        TagType resultTagType = this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, 1), (Object)resultTagType);
    }

    @Test
    public void testCreateTagTypeMissingRequiredParameters() {
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey("      \t\t "), TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1)));
            Assert.fail((String)"Should throw an IllegalArgumentException when tag type code is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE), "      \t\t ", Integer.valueOf(1)));
            Assert.fail((String)"Should throw an IllegalArgumentException when display name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A display name must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, null));
            Assert.fail((String)"Should throw an IllegalArgumentException when tag type order is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type order must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTypeTrimParameters() throws Exception {
        TagType resultTagType = this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(this.addWhitespace(TAG_TYPE)), this.addWhitespace(TAG_TYPE_DISPLAY_NAME), Integer.valueOf(1)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, 1), (Object)resultTagType);
    }

    @Test
    public void testCreateTagTypeInvalidParameters() {
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(this.addSlash(TAG_TYPE)), TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1)));
            Assert.fail((String)"Should throw an IllegalArgumentException when tag type code contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag type code can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTypeTagTypeAlreadyExists() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME_2, Integer.valueOf(2)));
            Assert.fail((String)"Should throw an AlreadyExistsException when tag type already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create tag type with code \"%s\" because it already exists.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTypeDisplayNameAlreadyExists() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE_2), TAG_TYPE_DISPLAY_NAME, Integer.valueOf(2)));
            Assert.fail((String)"Should throw an AlreadyExistsException when display name already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Display name \"%s\" already exists for tag type \"%s\".", TAG_TYPE_DISPLAY_NAME, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagType() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.getTagType(new TagTypeKey(TAG_TYPE));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, 1), (Object)resultTagType);
    }

    @Test
    public void testGetTagTypeMissingRequiredParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        try {
            this.tagTypeService.getTagType(new TagTypeKey("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when tag type code is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagTypeTrimParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.getTagType(new TagTypeKey(this.addWhitespace(TAG_TYPE)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, 1), (Object)resultTagType);
    }

    @Test
    public void testGetTagTypeUpperCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE.toLowerCase(), TAG_TYPE_DISPLAY_NAME.toLowerCase(), Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.getTagType(new TagTypeKey(TAG_TYPE.toUpperCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE.toLowerCase()), TAG_TYPE_DISPLAY_NAME.toLowerCase(), 1), (Object)resultTagType);
    }

    @Test
    public void testGetTagTypeLowerCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE.toUpperCase(), TAG_TYPE_DISPLAY_NAME.toUpperCase(), Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.getTagType(new TagTypeKey(TAG_TYPE.toLowerCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE.toUpperCase()), TAG_TYPE_DISPLAY_NAME.toUpperCase(), 1), (Object)resultTagType);
    }

    @Test
    public void testGetTagTypeTagTypeNotExists() {
        try {
            this.tagTypeService.getTagType(new TagTypeKey(TAG_TYPE));
            Assert.fail((String)"Should throw an ObjectNotFoundException when tag type code does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagTypes() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE_2, TAG_TYPE_DISPLAY_NAME_2, Integer.valueOf(2));
        TagTypeKeys resultTagTypeKeys = this.tagTypeService.getTagTypes();
        Assert.assertEquals((long)2L, (long)resultTagTypeKeys.getTagTypeKeys().size());
        Assert.assertEquals((Object)new TagTypeKey(TAG_TYPE), resultTagTypeKeys.getTagTypeKeys().get(0));
        Assert.assertEquals((Object)new TagTypeKey(TAG_TYPE_2), resultTagTypeKeys.getTagTypeKeys().get(1));
    }

    @Test
    public void testGetTagTypesTagTypeNotExists() {
        TagTypeKeys resultTagTypeKeys = this.tagTypeService.getTagTypes();
        Assert.assertEquals((long)0L, (long)resultTagTypeKeys.getTagTypeKeys().size());
    }

    @Test
    public void testUpdateTagType() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2, Integer.valueOf(2)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME_2, 2), (Object)resultTagType);
    }

    @Test
    public void testUpdateTagTypeMissingRequiredParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        try {
            this.tagTypeService.updateTagType(new TagTypeKey("      \t\t "), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2, Integer.valueOf(2)));
            Assert.fail((String)"Should throw an IllegalArgumentException when tag type code is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest("      \t\t ", Integer.valueOf(2)));
            Assert.fail((String)"Should throw an IllegalArgumentException when display name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A display name must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2, null));
            Assert.fail((String)"Should throw an IllegalArgumentException when tag type order is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type order must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagTypeTrimParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.updateTagType(new TagTypeKey(this.addWhitespace(TAG_TYPE)), new TagTypeUpdateRequest(this.addWhitespace(TAG_TYPE_DISPLAY_NAME_2), Integer.valueOf(2)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME_2, 2), (Object)resultTagType);
    }

    @Test
    public void testUpdateTagTypeUpperCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE.toLowerCase(), TAG_TYPE_DISPLAY_NAME.toLowerCase(), Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE.toUpperCase()), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2.toUpperCase(), Integer.valueOf(2)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE.toLowerCase()), TAG_TYPE_DISPLAY_NAME_2.toUpperCase(), 2), (Object)resultTagType);
    }

    @Test
    public void testUpdateTagTypeLowerCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE.toUpperCase(), TAG_TYPE_DISPLAY_NAME.toUpperCase(), Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE.toLowerCase()), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2.toLowerCase(), Integer.valueOf(2)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE.toUpperCase()), TAG_TYPE_DISPLAY_NAME_2.toLowerCase(), 2), (Object)resultTagType);
    }

    @Test
    public void testUpdateTagTypeDisplayNameAlreadyExists() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE_2, TAG_TYPE_DISPLAY_NAME_2, Integer.valueOf(2));
        try {
            this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2, Integer.valueOf(3)));
            Assert.fail((String)"Should throw an AlreadyExistsException when display name already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Display name \"%s\" already exists for tag type \"%s\".", TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagTypeNoChangesToDisplayName() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        TagType updatedTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE_2));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE_2.intValue()), (Object)updatedTagType);
    }

    @Test
    public void testUpdateTagTypeNoChangesToDisplayNameExceptForCase() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE);
        TagType updatedTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME.toLowerCase(), INTEGER_VALUE_2));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME.toLowerCase(), INTEGER_VALUE_2.intValue()), (Object)updatedTagType);
    }

    @Test
    public void testUpdateTagTypeTagTypeNotExists() {
        try {
            this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1)));
            Assert.fail((String)"Should throw an ObjectNotFoundException when tag type code does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteTagType() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.deleteTagType(new TagTypeKey(TAG_TYPE));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, 1), (Object)resultTagType);
        Assert.assertNull((Object)this.tagTypeDao.getTagTypeByKey(resultTagType.getTagTypeKey()));
    }

    @Test
    public void testDeleteTagTypeMissingRequiredParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        try {
            this.tagTypeService.deleteTagType(new TagTypeKey("      \t\t "));
            Assert.fail((String)"Should throw an ObjectNotFoundException when tag type code is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteTagTypeTrimParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.deleteTagType(new TagTypeKey(this.addWhitespace(TAG_TYPE)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, 1), (Object)resultTagType);
        Assert.assertNull((Object)this.tagTypeDao.getTagTypeByKey(resultTagType.getTagTypeKey()));
    }

    @Test
    public void testDeleteTagTypeUpperCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE.toLowerCase(), TAG_TYPE_DISPLAY_NAME.toLowerCase(), Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.deleteTagType(new TagTypeKey(TAG_TYPE.toUpperCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE.toLowerCase()), TAG_TYPE_DISPLAY_NAME.toLowerCase(), 1), (Object)resultTagType);
        Assert.assertNull((Object)this.tagTypeDao.getTagTypeByKey(resultTagType.getTagTypeKey()));
    }

    @Test
    public void testDeleteTagTypeLowerCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE.toUpperCase(), TAG_TYPE_DISPLAY_NAME.toUpperCase(), Integer.valueOf(1));
        TagType resultTagType = this.tagTypeService.deleteTagType(new TagTypeKey(TAG_TYPE.toLowerCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE.toUpperCase()), TAG_TYPE_DISPLAY_NAME.toUpperCase(), 1), (Object)resultTagType);
        Assert.assertNull((Object)this.tagTypeDao.getTagTypeByKey(resultTagType.getTagTypeKey()));
    }

    @Test
    public void testDeleteTagTypeTagTypeNotExists() {
        try {
            this.tagTypeService.deleteTagType(new TagTypeKey(TAG_TYPE));
            Assert.fail((String)"Should throw an ObjectNotFoundException when tag type code does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }
}

