/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.api.xml.UserNamespaceAuthorization;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizationCreateRequest;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizationKey;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizationUpdateRequest;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizations;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.UserNamespaceAuthorizationEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class UserNamespaceAuthorizationServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateUserNamespaceAuthorization() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        this.namespaceDaoTestHelper.createNamespaceEntity(key.getNamespace());
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT)));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(resultUserNamespaceAuthorization.getId(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testCreateUserNamespaceAuthorizationMissingRequiredParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(null, SUPPORTED_NAMESPACE_PERMISSIONS));
            Assert.fail((String)"Should throw an IllegalArgumentException when user namespace authorization key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user namespace authorization key must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey("      \t\t ", NAMESPACE), SUPPORTED_NAMESPACE_PERMISSIONS));
            Assert.fail((String)"Should throw an IllegalArgumentException when user id is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user id must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey(USER_ID, "      \t\t "), SUPPORTED_NAMESPACE_PERMISSIONS));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(key, null));
            Assert.fail((String)"Should throw an IllegalArgumentException when permissions are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace permissions must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(key, Arrays.asList(new NamespacePermissionEnum[0])));
            Assert.fail((String)"Should throw an IllegalArgumentException when permissions are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace permissions must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateUserNamespaceAuthorizationTrimParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        this.namespaceDaoTestHelper.createNamespaceEntity(key.getNamespace());
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey(this.addWhitespace(key.getUserId()), this.addWhitespace(key.getNamespace())), SUPPORTED_NAMESPACE_PERMISSIONS));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(resultUserNamespaceAuthorization.getId(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testCreateUserNamespaceAuthorizationUpperCaseParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        this.namespaceDaoTestHelper.createNamespaceEntity(key.getNamespace());
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey(key.getUserId().toUpperCase(), key.getNamespace().toUpperCase()), SUPPORTED_NAMESPACE_PERMISSIONS));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(resultUserNamespaceAuthorization.getId(), new UserNamespaceAuthorizationKey(key.getUserId().toUpperCase(), key.getNamespace()), SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testCreateUserNamespaceAuthorizationLowerCaseParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        this.namespaceDaoTestHelper.createNamespaceEntity(key.getNamespace());
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey(key.getUserId().toLowerCase(), key.getNamespace().toLowerCase()), SUPPORTED_NAMESPACE_PERMISSIONS));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(resultUserNamespaceAuthorization.getId(), new UserNamespaceAuthorizationKey(key.getUserId().toLowerCase(), key.getNamespace()), SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testCreateUserNamespaceAuthorizationInvalidParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationCreateRequest request = new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey(this.addSlash(key.getUserId()), key.getNamespace()), Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when user id contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"User id can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey(key.getUserId(), "I_DO_NOT_EXIST"), Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing user namespace authorization namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", request.getUserNamespaceAuthorizationKey().getNamespace()), (Object)e.getMessage());
        }
        request = new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey(key.getUserId(), this.addSlash(key.getNamespace())), Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateUserNamespaceAuthorizationDuplicatePermissions() {
        UserNamespaceAuthorizationCreateRequest request = new UserNamespaceAuthorizationCreateRequest(new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE), Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.READ));
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using duplicate permission values.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate namespace permission \"%s\" is found.", NamespacePermissionEnum.READ.value()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateUserNamespaceAuthorizationAlreadyExists() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        try {
            this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(new UserNamespaceAuthorizationCreateRequest(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT)));
            Assert.fail((String)"Should throw an AlreadyExistsException when user namespace authorization already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create user namespace authorization with user id \"%s\" and namespace \"%s\" because it already exists.", key.getUserId(), key.getNamespace()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateUserNamespaceAuthorization() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(key, new UserNamespaceAuthorizationUpdateRequest(Arrays.asList(NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT)));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, Arrays.asList(NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT)), (Object)resultUserNamespaceAuthorization);
        resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(key, new UserNamespaceAuthorizationUpdateRequest(Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE)));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE)), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testUpdateUserNamespaceAuthorizationMissingRequiredParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        try {
            this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(null, new UserNamespaceAuthorizationUpdateRequest(SUPPORTED_NAMESPACE_PERMISSIONS));
            Assert.fail((String)"Should throw an IllegalArgumentException when user namespace authorization key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user namespace authorization key must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(new UserNamespaceAuthorizationKey("      \t\t ", NAMESPACE), new UserNamespaceAuthorizationUpdateRequest(SUPPORTED_NAMESPACE_PERMISSIONS));
            Assert.fail((String)"Should throw an IllegalArgumentException when user id is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user id must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(USER_ID, "      \t\t "), new UserNamespaceAuthorizationUpdateRequest(SUPPORTED_NAMESPACE_PERMISSIONS));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(key, new UserNamespaceAuthorizationUpdateRequest(null));
            Assert.fail((String)"Should throw an IllegalArgumentException when permissions are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace permissions must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(key, new UserNamespaceAuthorizationUpdateRequest(new ArrayList()));
            Assert.fail((String)"Should throw an IllegalArgumentException when permissions are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace permissions must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateUserNamespaceAuthorizationTrimParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(this.addWhitespace(key.getUserId()), this.addWhitespace(key.getNamespace())), new UserNamespaceAuthorizationUpdateRequest(SUPPORTED_NAMESPACE_PERMISSIONS));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testUpdateUserNamespaceAuthorizationUpperCaseParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(key.getUserId().toUpperCase(), key.getNamespace().toUpperCase()), new UserNamespaceAuthorizationUpdateRequest(SUPPORTED_NAMESPACE_PERMISSIONS));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testUpdateUserNamespaceAuthorizationLowerCaseParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(key.getUserId().toLowerCase(), key.getNamespace().toLowerCase()), new UserNamespaceAuthorizationUpdateRequest(SUPPORTED_NAMESPACE_PERMISSIONS));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testUpdateUserNamespaceAuthorizationDuplicatePermissions() {
        UserNamespaceAuthorizationUpdateRequest request = new UserNamespaceAuthorizationUpdateRequest(Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.READ));
        try {
            this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE), request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using duplicate permission values.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate namespace permission \"%s\" is found.", NamespacePermissionEnum.READ.value()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateUserNamespaceAuthorizationNoExists() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        try {
            this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(key, new UserNamespaceAuthorizationUpdateRequest(Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT)));
            Assert.fail((String)"Should throw an ObjectNotFoundException when user namespace authorization does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("User namespace authorization with user id \"%s\" and namespace \"%s\" doesn't exist.", key.getUserId(), key.getNamespace()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserNamespaceAuthorization() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.getUserNamespaceAuthorization(key);
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testGetUserNamespaceAuthorizationMissingRequiredParameters() {
        try {
            this.userNamespaceAuthorizationService.getUserNamespaceAuthorization(null);
            Assert.fail((String)"Should throw an IllegalArgumentException when user namespace authorization key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user namespace authorization key must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.getUserNamespaceAuthorization(new UserNamespaceAuthorizationKey("      \t\t ", NAMESPACE));
            Assert.fail((String)"Should throw an IllegalArgumentException when user id is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user id must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.getUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(USER_ID, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserNamespaceAuthorizationTrimParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.getUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(this.addWhitespace(key.getUserId()), this.addWhitespace(key.getNamespace())));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testGetUserNamespaceAuthorizationUpperCaseParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(key.getNamespace());
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.getUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(key.getUserId().toUpperCase(), key.getNamespace().toUpperCase()));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testGetUserNamespaceAuthorizationLowerCaseParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(key.getNamespace());
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.getUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(key.getUserId().toLowerCase(), key.getNamespace().toLowerCase()));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
    }

    @Test
    public void testGetUserNamespaceAuthorizationNoExists() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        try {
            this.userNamespaceAuthorizationService.getUserNamespaceAuthorization(key);
            Assert.fail((String)"Should throw an ObjectNotFoundException when user namespace authorization does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("User namespace authorization with user id \"%s\" and namespace \"%s\" doesn't exist.", key.getUserId(), key.getNamespace()), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteUserNamespaceAuthorization() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        Assert.assertNotNull((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(key));
        UserNamespaceAuthorization deletedUserNamespaceAuthorization = this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(key);
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)deletedUserNamespaceAuthorization);
        Assert.assertNull((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(key));
    }

    @Test
    public void testDeleteUserNamespaceAuthorizationMissingRequiredParameters() {
        try {
            this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(null);
            Assert.fail((String)"Should throw an IllegalArgumentException when user namespace authorization key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user namespace authorization key must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(new UserNamespaceAuthorizationKey("      \t\t ", NAMESPACE));
            Assert.fail((String)"Should throw an IllegalArgumentException when user id is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user id must be specified.", (Object)e.getMessage());
        }
        try {
            this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(USER_ID, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteUserNamespaceAuthorizationTrimParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        Assert.assertNotNull((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(key));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(this.addWhitespace(key.getUserId()), this.addWhitespace(key.getNamespace())));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
        Assert.assertNull((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(key));
    }

    @Test
    public void testDeleteUserNamespaceAuthorizationUpperCaseParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        Assert.assertNotNull((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(key));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(key.getUserId().toUpperCase(), key.getNamespace().toUpperCase()));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
        Assert.assertNull((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(key));
    }

    @Test
    public void testDeleteUserNamespaceAuthorizationLowerCaseParameters() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE, NamespacePermissionEnum.EXECUTE, NamespacePermissionEnum.GRANT));
        Assert.assertNotNull((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(key));
        UserNamespaceAuthorization resultUserNamespaceAuthorization = this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(new UserNamespaceAuthorizationKey(key.getUserId().toLowerCase(), key.getNamespace().toLowerCase()));
        Assert.assertEquals((Object)new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS), (Object)resultUserNamespaceAuthorization);
        Assert.assertNull((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(key));
    }

    @Test
    public void testDeleteUserNamespaceAuthorizationNoExists() {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        try {
            this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(key);
            Assert.fail((String)"Should throw an ObjectNotFoundException when user namespace authorization does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("User namespace authorization with user id \"%s\" and namespace \"%s\" doesn't exist.", key.getUserId(), key.getNamespace()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByUserId() throws Exception {
        List<UserNamespaceAuthorizationKey> keys = Arrays.asList(new UserNamespaceAuthorizationKey(USER_ID_2, NAMESPACE_2), new UserNamespaceAuthorizationKey(USER_ID_2, NAMESPACE), new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE_2), new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE));
        for (UserNamespaceAuthorizationKey key : keys) {
            this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        }
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByUserId(USER_ID);
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(Arrays.asList(new UserNamespaceAuthorization(((UserNamespaceAuthorization)resultUserNamespaceAuthorizations.getUserNamespaceAuthorizations().get(0)).getId(), keys.get(3), SUPPORTED_NAMESPACE_PERMISSIONS), new UserNamespaceAuthorization(((UserNamespaceAuthorization)resultUserNamespaceAuthorizations.getUserNamespaceAuthorizations().get(1)).getId(), keys.get(2), SUPPORTED_NAMESPACE_PERMISSIONS))), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByUserIdMissingRequiredParameters() {
        try {
            this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByUserId("      \t\t ");
            Assert.fail((String)"Should throw an IllegalArgumentException when user id is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user id must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByUserIdTrimParameters() throws Exception {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByUserId(this.addWhitespace(key.getUserId()));
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(Arrays.asList(new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS))), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByUserIdUpperCaseParameters() throws Exception {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByUserId(key.getUserId().toUpperCase());
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(Arrays.asList(new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS))), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByUserIdLowerCaseParameters() throws Exception {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByUserId(key.getUserId().toLowerCase());
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(Arrays.asList(new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS))), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByUserIdEmptyList() throws Exception {
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByUserId("I_DO_NOT_EXIST");
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByNamespace() throws Exception {
        List<UserNamespaceAuthorizationKey> keys = Arrays.asList(new UserNamespaceAuthorizationKey(USER_ID_2, NAMESPACE_2), new UserNamespaceAuthorizationKey(USER_ID_2, NAMESPACE), new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE_2), new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE));
        for (UserNamespaceAuthorizationKey key : keys) {
            this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        }
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByNamespace(NAMESPACE);
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(Arrays.asList(new UserNamespaceAuthorization(((UserNamespaceAuthorization)resultUserNamespaceAuthorizations.getUserNamespaceAuthorizations().get(0)).getId(), keys.get(3), SUPPORTED_NAMESPACE_PERMISSIONS), new UserNamespaceAuthorization(((UserNamespaceAuthorization)resultUserNamespaceAuthorizations.getUserNamespaceAuthorizations().get(1)).getId(), keys.get(1), SUPPORTED_NAMESPACE_PERMISSIONS))), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByNamespaceMissingRequiredParameters() {
        try {
            this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByNamespace("      \t\t ");
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByNamespaceTrimParameters() throws Exception {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByNamespace(this.addWhitespace(key.getNamespace()));
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(Arrays.asList(new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS))), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByNamespaceUpperCaseParameters() throws Exception {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByNamespace(key.getNamespace().toUpperCase());
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(Arrays.asList(new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS))), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByNamespaceLowerCaseParameters() throws Exception {
        UserNamespaceAuthorizationKey key = new UserNamespaceAuthorizationKey(USER_ID, NAMESPACE);
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(key, SUPPORTED_NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByNamespace(key.getNamespace().toLowerCase());
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(Arrays.asList(new UserNamespaceAuthorization(userNamespaceAuthorizationEntity.getId().intValue(), key, SUPPORTED_NAMESPACE_PERMISSIONS))), (Object)resultUserNamespaceAuthorizations);
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByNamespaceNamespaceNoExists() throws Exception {
        try {
            this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByNamespace("I_DO_NOT_EXIST");
            Assert.fail((String)"Should throw an ObjectNotFoundException when namespace does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)"Namespace \"I_DO_NOT_EXIST\" doesn't exist.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserNamespaceAuthorizationsByNamespaceEmptyList() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        UserNamespaceAuthorizations resultUserNamespaceAuthorizations = this.userNamespaceAuthorizationService.getUserNamespaceAuthorizationsByNamespace(NAMESPACE);
        Assert.assertEquals((Object)new UserNamespaceAuthorizations(), (Object)resultUserNamespaceAuthorizations);
    }
}

