/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.jobexecutor.TimerExecuteNestedActivityJobHandler;
import org.activiti.engine.runtime.ProcessInstance;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.JobDefinition;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.jpa.JobDefinitionEntity;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.BaseJavaDelegate;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.finra.herd.service.activiti.task.MockJavaDelegate;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ActivitiDelegateTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testTimerJob() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/testHerdTimerWorkflow.bpmn20.xml");
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        Assert.assertNotNull((Object)job);
        org.activiti.engine.runtime.Job timer = (org.activiti.engine.runtime.Job)this.activitiManagementService.createJobQuery().processInstanceId(job.getId()).timers().singleResult();
        if (timer != null) {
            this.activitiManagementService.executeJob(timer.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void testTimerJobLowLevelActiviti() throws Exception {
        try {
            this.activitiRepositoryService.createDeployment().addClasspathResource("org/finra/herd/service/testHerdTimerWorkflow.bpmn20.xml").deploy();
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("key1", "value1");
            ProcessInstance processInstance = this.activitiRuntimeService.startProcessInstanceByKey("testNamespace.testHerdWorkflow", variables);
            this.waitUntilAllProcessCompleted();
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).singleResult();
            Assert.assertNotNull((Object)historicProcessInstance);
            Assert.assertNotNull((Object)historicProcessInstance.getEndTime());
        }
        finally {
            this.deleteActivitiDeployments();
        }
    }

    @Test(expected=ActivitiException.class)
    public void testActivitiReportableError() throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("classpath:org/finra/herd/service/testHerdTimerWorkflow.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement("servicetask1");
        FieldExtension exceptionField = new FieldExtension();
        exceptionField.setFieldName("exceptionToThrow");
        exceptionField.setExpression("${exceptionToThrow}");
        serviceTask.getFieldExtensions().add(exceptionField);
        this.jobDefinitionServiceTestHelper.createJobDefinitionForActivitiXml(this.getActivitiXmlFromBpmnModel(bpmnModel));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("exceptionToThrow", MockJavaDelegate.EXCEPTION_BPMN_ERROR);
        parameters.add(parameter);
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow", parameters));
        org.activiti.engine.runtime.Job timer = (org.activiti.engine.runtime.Job)this.activitiManagementService.createJobQuery().processInstanceId(job.getId()).timers().singleResult();
        if (timer != null) {
            this.executeWithoutLogging(Arrays.asList(ActivitiRuntimeHelper.class, TimerExecuteNestedActivityJobHandler.class), () -> this.activitiManagementService.executeJob(timer.getId()));
        }
    }

    @Test(expected=ActivitiException.class)
    public void testActivitiUnReportableError() throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("classpath:org/finra/herd/service/testHerdTimerWorkflow.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement("servicetask1");
        serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
        serviceTask.setImplementation("${BeanNotAvailable}");
        this.jobDefinitionServiceTestHelper.createJobDefinitionForActivitiXml(this.getActivitiXmlFromBpmnModel(bpmnModel));
        Job job = this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow", null));
        org.activiti.engine.runtime.Job timer = (org.activiti.engine.runtime.Job)this.activitiManagementService.createJobQuery().processInstanceId(job.getId()).timers().singleResult();
        if (timer != null) {
            this.executeWithoutLogging(TimerExecuteNestedActivityJobHandler.class, () -> this.activitiManagementService.executeJob(timer.getId()));
        }
    }

    @Test
    public void testDelegateSpringBeansNotPopulatedAgain() throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("org/finra/herd/service/testHerdWorkflow.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement("servicetask1");
        serviceTask.setImplementation(MockJavaDelegate.class.getCanonicalName());
        serviceTask.getFieldExtensions().clear();
        this.jobDefinitionServiceTestHelper.createJobDefinitionForActivitiXml(this.getActivitiXmlFromBpmnModel(bpmnModel));
        this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
        this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
    }

    @Test
    public void testDelegateRuntimeError() throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("org/finra/herd/service/testHerdWorkflow.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement("servicetask1");
        serviceTask.setImplementation(MockJavaDelegate.class.getCanonicalName());
        FieldExtension exceptionField = new FieldExtension();
        exceptionField.setFieldName("exceptionToThrow");
        exceptionField.setExpression("${exceptionToThrow}");
        serviceTask.getFieldExtensions().clear();
        serviceTask.getFieldExtensions().add(exceptionField);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("exceptionToThrow", MockJavaDelegate.EXCEPTION_RUNTIME);
        parameters.add(parameter);
        this.executeWithoutLogging(Arrays.asList(ActivitiRuntimeHelper.class, BaseJavaDelegate.class), () -> this.jobServiceTestHelper.createJobFromActivitiXml(this.getActivitiXmlFromBpmnModel(bpmnModel), parameters));
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testCreateProcessCommandProcessNotDefined() throws Exception {
        this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "test_process_not_defined"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProcessCommandProcessSuspended() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("org/finra/herd/service/testHerdWorkflow.bpmn20.xml");
        JobDefinitionEntity jobDefinitionEntity = this.jobDefinitionDao.getJobDefinitionByAltKey(jobDefinition.getNamespace(), jobDefinition.getJobName());
        this.activitiRepositoryService.suspendProcessDefinitionById(jobDefinitionEntity.getActivitiId());
        this.jobService.createAndStartJob(this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow"));
    }

    @Test
    public void testDelegateWrongClass() throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("org/finra/herd/service/testHerdWorkflow.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement("servicetask1");
        serviceTask.setImplementation("ClassDoesNotExist");
        serviceTask.getFieldExtensions().clear();
        try {
            this.jobServiceTestHelper.createJobFromActivitiXml(this.getActivitiXmlFromBpmnModel(bpmnModel), null);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(ActivitiException.class, e.getClass());
            Assert.assertEquals((Object)"couldn't instantiate class ClassDoesNotExist", (Object)e.getMessage());
        }
    }
}

