/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti;

import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.ProcessInstance;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class HerdCommandInvokerTest
extends HerdActivitiServiceTaskTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void testAssertAsynchronousTaskErrorWrittenToJobEntity() throws Exception {
        BpmnModel bpmnModel = new BpmnModel();
        Process process = new Process();
        process.setId("test");
        StartEvent element = new StartEvent();
        element.setId("start");
        process.addFlowElement((FlowElement)element);
        element = new ScriptTask();
        element.setId("script1");
        element.setScriptFormat("js");
        element.setAsynchronous(true);
        element.setScript("execution.setVariable('foo', 'bar');");
        process.addFlowElement((FlowElement)element);
        element = new ScriptTask();
        element.setId("script2");
        element.setScriptFormat("js");
        element.setScript("throw new Error()");
        process.addFlowElement((FlowElement)element);
        element = new EndEvent();
        element.setId("end");
        process.addFlowElement((FlowElement)element);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "script1"));
        process.addFlowElement((FlowElement)new SequenceFlow("script1", "script2"));
        process.addFlowElement((FlowElement)new SequenceFlow("script2", "end"));
        bpmnModel.addProcess(process);
        this.activitiRepositoryService.createDeployment().addBpmnModel("bpmn20.xml", bpmnModel).deploy();
        ProcessInstance processInstance = this.activitiRuntimeService.startProcessInstanceByKey("test");
        try {
            long startTime = System.currentTimeMillis();
            HistoricVariableInstance persistedVariable = null;
            while (persistedVariable == null) {
                persistedVariable = (HistoricVariableInstance)this.activitiHistoryService.createHistoricVariableInstanceQuery().variableName("foo").singleResult();
                Thread.sleep(10L);
                if (System.currentTimeMillis() - startTime <= 10000L) continue;
                Assert.fail((String)"workflow did not reach the desired state within a reasonable time");
            }
            Assert.assertEquals((Object)"bar", (Object)persistedVariable.getValue());
            Assert.assertEquals((Object)"ActivitiException: problem evaluating script: Error in <eval> at line number 1 at column number 0", (Object)((Job)this.activitiManagementService.createJobQuery().executionId(processInstance.getProcessInstanceId()).singleResult()).getExceptionMessage());
        }
        finally {
            this.deleteActivitiDeployments();
        }
    }
}

