/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.junit.Assert;
import org.junit.Test;

public class AddEmrMasterSecurityGroupTest
extends AbstractServiceTest {
    @Test
    public void testAddSecurityGroup() throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("clusterName", "testCluster1");
        parameters.add(parameter);
        parameter = new Parameter("securityGroupIds", "sg-12345|sg-54321");
        parameters.add(parameter);
        Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowAddEmrMasterSecurityGroup.bpmn20.xml", parameters);
        Assert.assertNotNull((Object)job);
    }

    @Test
    public void testAddSecurityGroupNoGroups() throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("clusterName", "testCluster1");
        parameters.add(parameter);
        parameter = new Parameter("securityGroupIds", "");
        parameters.add(parameter);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowAddEmrMasterSecurityGroup.bpmn20.xml", parameters);
            HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
            Map variables = hisInstance.getProcessVariables();
            String securityGroupTaskStatus = (String)variables.get("addSecurityGroupServiceTask_taskStatus");
            Assert.assertEquals((Object)securityGroupTaskStatus, (Object)"ERROR");
        });
    }
}

