/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.history.HistoricProcessInstance;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.AddEmrHadoopJarStep;
import org.finra.herd.service.activiti.task.AddEmrHiveStep;
import org.finra.herd.service.activiti.task.AddEmrOozieStep;
import org.finra.herd.service.activiti.task.AddEmrPigStep;
import org.finra.herd.service.activiti.task.AddEmrShellStep;
import org.junit.Assert;
import org.junit.Test;

public class AddEmrStepsTest
extends AbstractServiceTest {
    @Test
    public void testAddShellStep() throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getCommonParameters("Shell Step"));
        Parameter parameter = new Parameter("scriptLocation", "s3://test-bucket-managed/app-a/test/test_script.sh");
        parameters.add(parameter);
        parameter = new Parameter("scriptArguments", "arg1|arg/|withpipe|arg2|arg3");
        parameters.add(parameter);
        this.testActivitiAddEmrStepSuccess(AddEmrShellStep.class.getCanonicalName(), this.getScriptStepsFieldExtension(), parameters);
    }

    @Test
    public void testAddHiveStep() throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getCommonParameters("Hive Step"));
        Parameter parameter = new Parameter("scriptLocation", "s3://test-bucket-managed/app-a/test/test_hive.hql");
        parameters.add(parameter);
        parameter = new Parameter("scriptArguments", "arg1|arg/|withpipe|arg2|arg3");
        parameters.add(parameter);
        this.testActivitiAddEmrStepSuccess(AddEmrHiveStep.class.getCanonicalName(), this.getScriptStepsFieldExtension(), parameters);
    }

    @Test
    public void testAddPigStep() throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getCommonParameters("Pig Step"));
        Parameter parameter = new Parameter("scriptLocation", "s3://test-bucket-managed/app-a/test/test_pig.pig");
        parameters.add(parameter);
        parameter = new Parameter("scriptArguments", "arg1|arg/|withpipe|arg2|arg3");
        parameters.add(parameter);
        this.testActivitiAddEmrStepSuccess(AddEmrPigStep.class.getCanonicalName(), this.getScriptStepsFieldExtension(), parameters);
    }

    @Test
    public void testAddOozieStep() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        FieldExtension exceptionField = new FieldExtension();
        exceptionField.setFieldName("workflowXmlLocation");
        exceptionField.setExpression("${workflowXmlLocation}");
        fieldExtensionList.add(exceptionField);
        exceptionField = new FieldExtension();
        exceptionField.setFieldName("ooziePropertiesFileLocation");
        exceptionField.setExpression("${ooziePropertiesFileLocation}");
        fieldExtensionList.add(exceptionField);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getCommonParameters("Oozie Step"));
        Parameter parameter = new Parameter("workflowXmlLocation", "s3://test-bucket-managed/app-a/test/workflow.xml");
        parameters.add(parameter);
        parameter = new Parameter("ooziePropertiesFileLocation", "s3://test-bucket-managed/app-a/test/job.properties");
        parameters.add(parameter);
        this.testActivitiAddEmrStepSuccess(AddEmrOozieStep.class.getCanonicalName(), fieldExtensionList, parameters);
    }

    @Test
    public void testAddHadoopJarStep() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        FieldExtension exceptionField = new FieldExtension();
        exceptionField.setFieldName("jarLocation");
        exceptionField.setExpression("${jarLocation}");
        fieldExtensionList.add(exceptionField);
        exceptionField = new FieldExtension();
        exceptionField.setFieldName("mainClass");
        exceptionField.setExpression("${mainClass}");
        fieldExtensionList.add(exceptionField);
        exceptionField = new FieldExtension();
        exceptionField.setFieldName("scriptArguments");
        exceptionField.setExpression("${scriptArguments}");
        fieldExtensionList.add(exceptionField);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getCommonParameters("Hadoop jar Step"));
        Parameter parameter = new Parameter("jarLocation", "s3://test-bucket-managed/app-a/test/hadoop-mapreduce-examples-2.4.0.jar");
        parameters.add(parameter);
        parameter = new Parameter("mainClass", "wordcount");
        parameters.add(parameter);
        parameter = new Parameter("scriptArguments", "arg1|arg/|withpipe|arg2|arg3");
        parameters.add(parameter);
        this.testActivitiAddEmrStepSuccess(AddEmrHadoopJarStep.class.getCanonicalName(), fieldExtensionList, parameters);
    }

    @Test
    public void testAddShellStepNoStepName() throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("clusterName", "testCluster1");
        parameters.add(parameter);
        parameter = new Parameter("continueOnError", "");
        parameters.add(parameter);
        parameter = new Parameter("stepName", "");
        parameters.add(parameter);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiAddEmrStepFailure(AddEmrShellStep.class.getCanonicalName(), new ArrayList<FieldExtension>(), parameters));
    }

    @Test
    public void testAddShellStepNoScriptLocation() throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("clusterName", "testCluster1");
        parameters.add(parameter);
        parameter = new Parameter("stepName", "Shell Step");
        parameters.add(parameter);
        parameter = new Parameter("continueOnError", "");
        parameters.add(parameter);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiAddEmrStepFailure(AddEmrShellStep.class.getCanonicalName(), new ArrayList<FieldExtension>(), parameters));
    }

    @Test
    public void testAddShellStepWrongContinueOnError() throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("clusterName", "testCluster1");
        parameters.add(parameter);
        parameter = new Parameter("stepName", "Shell Step");
        parameters.add(parameter);
        parameter = new Parameter("continueOnError", "sfsdfsd");
        parameters.add(parameter);
        parameter = new Parameter("scriptLocation", "A_SCRIPT_LOCATION");
        parameters.add(parameter);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiAddEmrStepFailure(AddEmrShellStep.class.getCanonicalName(), this.getScriptStepsFieldExtension(), parameters));
    }

    @Test
    public void testAddOozieStepNoWorkflowXml() throws Exception {
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiAddEmrStepFailure(AddEmrOozieStep.class.getCanonicalName(), new ArrayList<FieldExtension>(), this.getCommonParameters("Oozie Step")));
    }

    @Test
    public void testAddOozieStepNoOoziePropertiesLocation() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        FieldExtension exceptionField = new FieldExtension();
        exceptionField.setFieldName("workflowXmlLocation");
        exceptionField.setExpression("${workflowXmlLocation}");
        fieldExtensionList.add(exceptionField);
        List<Parameter> parameters = this.getCommonParameters("Oozie Step");
        Parameter parameter = new Parameter("workflowXmlLocation", "workflow_xml_location");
        parameters.add(parameter);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiAddEmrStepFailure(AddEmrOozieStep.class.getCanonicalName(), fieldExtensionList, parameters));
    }

    @Test
    public void testAddHadoopJarStepNoJar() throws Exception {
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiAddEmrStepFailure(AddEmrHadoopJarStep.class.getCanonicalName(), new ArrayList<FieldExtension>(), this.getCommonParameters("Hadoop jar Step")));
    }

    private void testActivitiAddEmrStepSuccess(String implementation, List<FieldExtension> fieldExtensionList, List<Parameter> parameters) throws Exception {
        String activitiXml = this.buildActivitiXml(implementation, fieldExtensionList);
        this.createJobAndCheckStepStatusSuccess(activitiXml, parameters);
    }

    private String buildActivitiXml(String implementation, List<FieldExtension> fieldExtensionList) throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("classpath:org/finra/herd/service/activitiWorkflowAddEmrStep.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement("addStepServiceTask");
        serviceTask.setImplementation(implementation);
        serviceTask.getFieldExtensions().addAll(fieldExtensionList);
        return this.getActivitiXmlFromBpmnModel(bpmnModel);
    }

    private void createJobAndCheckStepStatusSuccess(String activitiXml, List<Parameter> parameters) throws Exception {
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(activitiXml, parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String addStepServiceTaskStatus = (String)variables.get("addStepServiceTask_taskStatus");
        Assert.assertEquals((Object)"SUCCESS", (Object)addStepServiceTaskStatus);
        String addStepId = (String)variables.get("addStepServiceTask_emrStepId");
        Assert.assertNotNull((Object)addStepId);
    }

    private void testActivitiAddEmrStepFailure(String implementation, List<FieldExtension> fieldExtensionList, List<Parameter> parameters) throws Exception {
        String activitiXml = this.buildActivitiXml(implementation, fieldExtensionList);
        this.createJobAndCheckStepStatusFailure(activitiXml, parameters);
    }

    private void createJobAndCheckStepStatusFailure(String activitiXml, List<Parameter> parameters) throws Exception {
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(activitiXml, parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String addStepServiceTaskStatus = (String)variables.get("addStepServiceTask_taskStatus");
        Assert.assertEquals((Object)"ERROR", (Object)addStepServiceTaskStatus);
    }

    private List<Parameter> getCommonParameters(String stepName) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("clusterName", "testCluster1");
        parameters.add(parameter);
        parameter = new Parameter("stepName", stepName);
        parameters.add(parameter);
        parameter = new Parameter("continueOnError", "true");
        parameters.add(parameter);
        return parameters;
    }

    private List<FieldExtension> getScriptStepsFieldExtension() {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        FieldExtension exceptionField = new FieldExtension();
        exceptionField.setFieldName("scriptLocation");
        exceptionField.setExpression("${scriptLocation}");
        fieldExtensionList.add(exceptionField);
        exceptionField = new FieldExtension();
        exceptionField.setFieldName("scriptArguments");
        exceptionField.setExpression("${scriptArguments}");
        fieldExtensionList.add(exceptionField);
        return fieldExtensionList;
    }
}

