/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.finra.herd.service.activiti.ActivitiHelper;
import org.finra.herd.service.activiti.task.BaseAddEmrStep;
import org.finra.herd.service.helper.EmrStepHelper;
import org.finra.herd.service.helper.EmrStepHelperFactory;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BaseAddEmrStepTest {
    @InjectMocks
    private BaseAddEmrStep baseAddEmrStep;
    @Mock
    private EmrStepHelperFactory emrStepHelperFactory;
    @Mock
    private ActivitiHelper activitiHelper;
    @Mock
    private Expression namespace;
    @Mock
    private Expression emrClusterDefinitionName;
    @Mock
    private Expression emrClusterName;
    @Mock
    private Expression stepName;
    @Mock
    private Expression continueOnError;
    @Mock
    private Expression scriptLocation;
    @Mock
    private Expression scriptArguments;
    @Mock
    private Expression emrClusterId;

    @Before
    public void before() {
        this.baseAddEmrStep = new BaseAddEmrStep(){

            public void executeImpl(DelegateExecution execution) throws Exception {
            }
        };
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void populateCommonParamsAssertEmrStepHelperPopulatedCorrectly() {
        String request = "request";
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        EmrStepHelper emrStepHelper = (EmrStepHelper)Mockito.mock(EmrStepHelper.class);
        Mockito.when((Object)this.emrStepHelperFactory.getStepHelper((String)Matchers.any())).thenReturn((Object)emrStepHelper);
        String namespaceString = "namespaceString";
        Mockito.when((Object)this.activitiHelper.getExpressionVariableAsString((Expression)Matchers.same((Object)this.namespace), (DelegateExecution)Matchers.any())).thenReturn((Object)namespaceString);
        String stepNameString = "stepNameString";
        Mockito.when((Object)this.activitiHelper.getExpressionVariableAsString((Expression)Matchers.same((Object)this.stepName), (DelegateExecution)Matchers.any())).thenReturn((Object)stepNameString);
        Boolean continueOnErrorBoolean = false;
        Mockito.when((Object)this.activitiHelper.getExpressionVariableAsBoolean((Expression)Matchers.same((Object)this.continueOnError), (DelegateExecution)Matchers.any(), (String)Matchers.any(), Matchers.anyBoolean(), (Boolean)Matchers.any())).thenReturn((Object)continueOnErrorBoolean);
        String emrClusterDefinitionNameString = "emrClusterDefinitionNameString";
        Mockito.when((Object)this.activitiHelper.getExpressionVariableAsString((Expression)Matchers.same((Object)this.emrClusterDefinitionName), (DelegateExecution)Matchers.any())).thenReturn((Object)emrClusterDefinitionNameString);
        String emrClusterNameString = "emrClusterNameString";
        Mockito.when((Object)this.activitiHelper.getExpressionVariableAsString((Expression)Matchers.same((Object)this.emrClusterName), (DelegateExecution)Matchers.any())).thenReturn((Object)emrClusterNameString);
        String emrClusterIdString = "emrClusterIdString";
        Mockito.when((Object)this.activitiHelper.getExpressionVariableAsString((Expression)Matchers.same((Object)this.emrClusterId), (DelegateExecution)Matchers.any())).thenReturn((Object)emrClusterIdString);
        this.baseAddEmrStep.populateCommonParams((Object)request, execution);
        ((EmrStepHelper)Mockito.verify((Object)emrStepHelper)).setRequestStepName((Object)request, stepNameString);
        ((EmrStepHelper)Mockito.verify((Object)emrStepHelper)).setRequestContinueOnError((Object)request, continueOnErrorBoolean);
        ((EmrStepHelper)Mockito.verify((Object)emrStepHelper)).setRequestNamespace((Object)request, namespaceString);
        ((EmrStepHelper)Mockito.verify((Object)emrStepHelper)).setRequestEmrClusterDefinitionName((Object)request, emrClusterDefinitionNameString);
        ((EmrStepHelper)Mockito.verify((Object)emrStepHelper)).setRequestEmrClusterName((Object)request, emrClusterNameString);
        ((EmrStepHelper)Mockito.verify((Object)emrStepHelper)).setRequestEmrClusterId((Object)request, emrClusterIdString);
    }
}

