/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import com.google.common.base.Objects;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.repository.ProcessDefinition;
import org.finra.herd.dao.JobDefinitionDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.dto.ApplicationUser;
import org.finra.herd.model.dto.SecurityUserWrapper;
import org.finra.herd.model.jpa.JobDefinitionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.ActivitiService;
import org.finra.herd.service.activiti.ActivitiHelper;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.MockJavaDelegate;
import org.finra.herd.service.helper.ConfigurationDaoHelper;
import org.finra.herd.service.helper.HerdErrorInformationExceptionHandler;
import org.finra.herd.service.helper.JobDefinitionDaoHelper;
import org.finra.herd.service.helper.UserNamespaceAuthorizationHelper;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class BaseJavaDelegateTest
extends AbstractServiceTest {
    @Mock
    private ActivitiHelper activitiHelper;
    @Mock
    private ActivitiRuntimeHelper activitiRuntimeHelper;
    @Mock
    private ActivitiService activitiService;
    @Autowired
    @InjectMocks
    private MockJavaDelegate baseJavaDelegate;
    @Mock
    private ConfigurationDaoHelper configurationDaoHelper;
    @Mock
    private DelegateExecution delegateExecution;
    @Mock
    private HerdErrorInformationExceptionHandler errorInformationExceptionHandler;
    @Mock
    private JobDefinitionDao jobDefinitionDao;
    @Mock
    private JobDefinitionDaoHelper jobDefinitionDaoHelper;
    @Mock
    private UserNamespaceAuthorizationHelper userNamespaceAuthorizationHelper;

    @Override
    @After
    public void after() {
        SecurityContextHolder.clearContext();
    }

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testExecute() throws Exception {
        String jobDefinitionNamespace = "jobDefinitionNamespace";
        String jobDefinitionName = "jobDefinitionName";
        String processDefinitionId = "processDefinitionId";
        String processDefinitionKey = String.format("%s.%s", jobDefinitionNamespace, jobDefinitionName);
        String updatedBy = "updatedBy";
        JobDefinitionEntity jobDefinitionEntity = new JobDefinitionEntity();
        jobDefinitionEntity.setUpdatedBy(updatedBy);
        Mockito.when((Object)this.delegateExecution.getProcessDefinitionId()).thenReturn((Object)processDefinitionId);
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinition.getKey()).thenReturn((Object)processDefinitionKey);
        Mockito.when((Object)this.activitiService.getProcessDefinitionById((String)Matchers.any())).thenReturn((Object)processDefinition);
        Mockito.when((Object)this.jobDefinitionDaoHelper.getJobDefinitionEntity((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)jobDefinitionEntity);
        this.baseJavaDelegate.execute(this.delegateExecution);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.configurationDaoHelper, this.activitiService, this.jobDefinitionDaoHelper, this.userNamespaceAuthorizationHelper, this.activitiRuntimeHelper});
        ((ConfigurationDaoHelper)inOrder.verify((Object)this.configurationDaoHelper)).checkNotAllowedMethod(((Object)((Object)this.baseJavaDelegate)).getClass().getCanonicalName());
        ((ActivitiService)inOrder.verify((Object)this.activitiService)).getProcessDefinitionById(processDefinitionId);
        ((JobDefinitionDaoHelper)inOrder.verify((Object)this.jobDefinitionDaoHelper)).getJobDefinitionEntity(jobDefinitionNamespace, jobDefinitionName);
        ((UserNamespaceAuthorizationHelper)inOrder.verify((Object)this.userNamespaceAuthorizationHelper)).buildNamespaceAuthorizations(this.applicationUserUserIdEq(updatedBy));
        ((ActivitiRuntimeHelper)inOrder.verify((Object)this.activitiRuntimeHelper)).setTaskSuccessInWorkflow(this.delegateExecution);
        inOrder.verifyNoMoreInteractions();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationDaoHelper, this.activitiService, this.jobDefinitionDaoHelper, this.userNamespaceAuthorizationHelper, this.activitiRuntimeHelper});
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testSetSecurityContext() throws Exception {
        String jobDefinitionNamespace = "jobDefinitionNamespace";
        String jobDefinitionName = "jobDefinitionName";
        String processDefinitionId = "processDefinitionId";
        String processDefinitionKey = String.format("%s.%s", jobDefinitionNamespace, jobDefinitionName);
        String updatedBy = "updatedBy";
        JobDefinitionEntity jobDefinitionEntity = new JobDefinitionEntity();
        jobDefinitionEntity.setUpdatedBy(updatedBy);
        Mockito.when((Object)this.delegateExecution.getProcessDefinitionId()).thenReturn((Object)processDefinitionId);
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinition.getKey()).thenReturn((Object)processDefinitionKey);
        Mockito.when((Object)this.activitiService.getProcessDefinitionById((String)Matchers.any())).thenReturn((Object)processDefinition);
        Mockito.when((Object)this.jobDefinitionDaoHelper.getJobDefinitionEntity((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)jobDefinitionEntity);
        SecurityContextHolder.clearContext();
        this.baseJavaDelegate.setSecurityContext(this.delegateExecution);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activitiService, this.jobDefinitionDaoHelper, this.userNamespaceAuthorizationHelper});
        ((ActivitiService)inOrder.verify((Object)this.activitiService)).getProcessDefinitionById(processDefinitionId);
        ((JobDefinitionDaoHelper)inOrder.verify((Object)this.jobDefinitionDaoHelper)).getJobDefinitionEntity(jobDefinitionNamespace, jobDefinitionName);
        ((UserNamespaceAuthorizationHelper)inOrder.verify((Object)this.userNamespaceAuthorizationHelper)).buildNamespaceAuthorizations(this.applicationUserUserIdEq(updatedBy));
        inOrder.verifyNoMoreInteractions();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.activitiService, this.jobDefinitionDaoHelper, this.userNamespaceAuthorizationHelper});
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.assertAuthenticationUserIdEquals(updatedBy, authentication);
    }

    @Test
    public void testSetSecurityContextProcessDefinitionNoExists() throws Exception {
        String processDefinitionId = "processDefinitionId";
        Mockito.when((Object)this.delegateExecution.getProcessDefinitionId()).thenReturn((Object)processDefinitionId);
        Mockito.when((Object)this.activitiService.getProcessDefinitionById((String)Matchers.any())).thenReturn(null);
        SecurityContextHolder.clearContext();
        try {
            this.baseJavaDelegate.setSecurityContext(this.delegateExecution);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Failed to find Activiti process definition for processDefinitionId=\"%s\".", processDefinitionId), (Object)e.getMessage());
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activitiService});
        ((ActivitiService)inOrder.verify((Object)this.activitiService)).getProcessDefinitionById(processDefinitionId);
        inOrder.verifyNoMoreInteractions();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.activitiService});
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    private ApplicationUser applicationUserUserIdEq(final String userId) {
        return (ApplicationUser)Matchers.argThat((Matcher)new ArgumentMatcher<ApplicationUser>(){

            public boolean matches(Object argument) {
                ApplicationUser applicationUser = (ApplicationUser)argument;
                return Objects.equal((Object)userId, (Object)applicationUser.getUserId());
            }
        });
    }

    private void assertAuthenticationUserIdEquals(String expectedUserId, Authentication actualAuthentication) {
        Assert.assertNotNull((Object)actualAuthentication);
        Assert.assertEquals(PreAuthenticatedAuthenticationToken.class, actualAuthentication.getClass());
        PreAuthenticatedAuthenticationToken preAuthenticatedAuthenticationToken = (PreAuthenticatedAuthenticationToken)actualAuthentication;
        Object principal = preAuthenticatedAuthenticationToken.getPrincipal();
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals(SecurityUserWrapper.class, principal.getClass());
        SecurityUserWrapper securityUserWrapper = (SecurityUserWrapper)principal;
        Assert.assertEquals((Object)expectedUserId, (Object)securityUserWrapper.getUsername());
        Assert.assertNotNull((Object)securityUserWrapper.getApplicationUser());
        Assert.assertEquals((Object)expectedUserId, (Object)securityUserWrapper.getApplicationUser().getUserId());
    }
}

