/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityCollectionRequest;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.CheckBusinessObjectDataAvailabilityCollection;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class CheckBusinessObjectDataAvailabilityCollectionTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testCheckBusinessObjectDataAvailabilityCollectionXml() throws Exception {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityCollectionTesting();
        BusinessObjectDataAvailabilityCollectionRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityCollectionRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAvailabilityCollectionRequest", "${businessObjectDataAvailabilityCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataAvailabilityCollectionRequest", this.xmlHelper.objectToXml((Object)request)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("isAllDataAvailable", true);
        variableValuesToValidate.put("isAllDataNotAvailable", false);
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataAvailabilityCollectionResponse()));
        this.testActivitiServiceTaskSuccess(CheckBusinessObjectDataAvailabilityCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityCollectionJson() throws Exception {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityCollectionTesting();
        BusinessObjectDataAvailabilityCollectionRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityCollectionRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAvailabilityCollectionRequest", "${businessObjectDataAvailabilityCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataAvailabilityCollectionRequest", this.jsonHelper.objectToJson((Object)request)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("isAllDataAvailable", true);
        variableValuesToValidate.put("isAllDataNotAvailable", false);
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataAvailabilityCollectionResponse()));
        this.testActivitiServiceTaskSuccess(CheckBusinessObjectDataAvailabilityCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityCollectionWrongContentType() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAvailabilityCollectionRequest", "${businessObjectDataAvailabilityCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "wrong_content_type"));
        parameters.add(this.buildParameter("businessObjectDataAvailabilityCollectionRequest", "some_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"ContentType\" must be a valid value of either \"xml\" or \"json\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CheckBusinessObjectDataAvailabilityCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityCollectionNoRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAvailabilityCollectionRequest", "${businessObjectDataAvailabilityCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataAvailabilityCollectionRequest", "      \t\t "));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataAvailabilityCollectionRequest\" must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CheckBusinessObjectDataAvailabilityCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityCollectionWrongXmlRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAvailabilityCollectionRequest", "${businessObjectDataAvailabilityCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataAvailabilityCollectionRequest", "wrong_xml_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataAvailabilityCollectionRequest\" must be valid xml string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CheckBusinessObjectDataAvailabilityCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityCollectionWrongJsonRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAvailabilityCollectionRequest", "${businessObjectDataAvailabilityCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataAvailabilityCollectionRequest", "wrong_json_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataAvailabilityCollectionRequest\" must be valid json string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CheckBusinessObjectDataAvailabilityCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }
}

